/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.AbstractFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ExcludePatternDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.IncludePatternDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.IssueFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ModuleDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ProductionCodeFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.RootDirectoryDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.WorkspaceFilterDiff;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IComponentFilter;
import com.hello2morrow.sonargraph.integration.access.model.IFilter;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IRootDirectory;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.IWildcardPattern;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public final class G
extends com.hello2morrow.sonargraph.core.controller.system.diff.a {
    public G(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, SoftwareSystem currentSystem) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
    }

    @Override
    public void a(NamedElement parent) {
        Workspace currentWorkspace = this.c().getUniqueExistingChild(Workspace.class);
        this.a(parent, currentWorkspace);
        this.b(parent, currentWorkspace);
    }

    private void a(NamedElement parent, Workspace currentWorkspace) {
        Optional workspaceFilterOpt = this.a().getWorkspaceFilter();
        assert (workspaceFilterOpt.isPresent()) : "Missing workspace filter!";
        IFilter baselineWorkspaceFilter = (IFilter)workspaceFilterOpt.get();
        WorkspaceFilter currentWorkspaceFilter = currentWorkspace.getUniqueExistingChild(WorkspaceFilter.class);
        WorkspaceFilterDiff workspaceFilterDiff = new WorkspaceFilterDiff(parent, baselineWorkspaceFilter, currentWorkspaceFilter);
        this.a(baselineWorkspaceFilter, currentWorkspaceFilter, workspaceFilterDiff);
        this.b(baselineWorkspaceFilter, currentWorkspaceFilter, workspaceFilterDiff);
        parent.addChild(workspaceFilterDiff);
        Optional productionCodeFilterOpt = this.a().getProductionCodeFilter();
        assert (productionCodeFilterOpt.isPresent()) : "Missing production code filter!";
        IComponentFilter baselineProductionCodeFilter = (IComponentFilter)productionCodeFilterOpt.get();
        ProductionCodeFilter currentProductionCodeFilter = currentWorkspace.getUniqueExistingChild(ProductionCodeFilter.class);
        ProductionCodeFilterDiff productionCodeFilterDiff = new ProductionCodeFilterDiff(parent, (IFilter)baselineProductionCodeFilter, currentProductionCodeFilter);
        this.a((IFilter)baselineProductionCodeFilter, currentProductionCodeFilter, productionCodeFilterDiff);
        this.b((IFilter)baselineProductionCodeFilter, currentProductionCodeFilter, productionCodeFilterDiff);
        parent.addChild(productionCodeFilterDiff);
        Optional baselineIssueFilterOpt = this.a().getIssueFilter();
        assert (baselineIssueFilterOpt.isPresent()) : "Missing issue filter!";
        IComponentFilter baselineIssueFilter = (IComponentFilter)baselineIssueFilterOpt.get();
        IssueFilter currentIssueFilter = currentWorkspace.getUniqueExistingChild(IssueFilter.class);
        IssueFilterDiff issueFilterDiff = new IssueFilterDiff(parent, (IFilter)baselineIssueFilter, currentIssueFilter);
        this.a((IFilter)baselineIssueFilter, currentIssueFilter, issueFilterDiff);
        this.b((IFilter)baselineIssueFilter, currentIssueFilter, issueFilterDiff);
        parent.addChild(issueFilterDiff);
    }

    private void a(IFilter baselineFilter, Filter currentFilter, AbstractFilterDiff<?> filterDiff) {
        IncludePatternDiff includeDiff;
        assert (baselineFilter != null) : "Parameter 'baselineFilter' of method 'processIncludes' must not be null";
        assert (currentFilter != null) : "Parameter 'currentFilter' of method 'processIncludes' must not be null";
        assert (filterDiff != null) : "Parameter 'filterDiff' of method 'processIncludes' must not be null";
        Map<String, WildcardPatternInclude> currentIncludePatterns = this.a(currentFilter, WildcardPatternInclude.class);
        Map<String, IWildcardPattern> baselineIncludePatterns = this.a(baselineFilter, true);
        for (Map.Entry<String, WildcardPatternInclude> currentInclude : currentIncludePatterns.entrySet()) {
            IWildcardPattern baselineIncludePattern = baselineIncludePatterns.remove(currentInclude.getKey());
            includeDiff = baselineIncludePattern != null ? new IncludePatternDiff((NamedElement)filterDiff, baselineIncludePattern, currentInclude.getValue(), IDiffElement.Change.UNMODIFIED) : new IncludePatternDiff((NamedElement)filterDiff, null, currentInclude.getValue(), IDiffElement.Change.ADDED);
            filterDiff.addChild(includeDiff);
        }
        for (IWildcardPattern nextBaseline : baselineIncludePatterns.values()) {
            includeDiff = new IncludePatternDiff(filterDiff, nextBaseline, null, IDiffElement.Change.REMOVED);
            filterDiff.addChild(includeDiff);
        }
    }

    private void b(IFilter baselineFilter, Filter currentFilter, AbstractFilterDiff<?> filterDiff) {
        assert (baselineFilter != null) : "Parameter 'baselineFilter' of method 'processExcludes' must not be null";
        assert (currentFilter != null) : "Parameter 'currentFilter' of method 'processExcludes' must not be null";
        assert (filterDiff != null) : "Parameter 'filterDiff' of method 'processExcludes' must not be null";
        Map<String, WildcardPatternExclude> currentExcludePatterns = this.a(currentFilter, WildcardPatternExclude.class);
        Map<String, IWildcardPattern> baselineExcludePatterns = this.a(baselineFilter, false);
        for (Map.Entry<String, WildcardPatternExclude> currentExclude : currentExcludePatterns.entrySet()) {
            IWildcardPattern baselineExcludePattern = baselineExcludePatterns.remove(currentExclude.getKey());
            ExcludePatternDiff excludeDiff = baselineExcludePattern != null ? new ExcludePatternDiff((NamedElement)filterDiff, baselineExcludePattern, currentExclude.getValue(), IDiffElement.Change.UNMODIFIED) : new ExcludePatternDiff((NamedElement)filterDiff, null, currentExclude.getValue(), IDiffElement.Change.ADDED);
            filterDiff.addChild(excludeDiff);
        }
        for (IWildcardPattern nextBaseline : baselineExcludePatterns.values()) {
            ExcludePatternDiff excludeDiff = new ExcludePatternDiff(filterDiff, nextBaseline, null, IDiffElement.Change.REMOVED);
            filterDiff.addChild(excludeDiff);
        }
    }

    private <T extends WildcardPattern> Map<String, T> a(Filter currentFilter, Class<T> clazz) {
        assert (currentFilter != null) : "Parameter 'currentFilter' of method 'collectCurrentPatterns' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'collectCurrentPatterns' must not be null";
        LinkedHashMap currentPatterns = new LinkedHashMap();
        currentFilter.getChildren(clazz).forEach(pattern -> {
            WildcardPattern wildcardPattern = currentPatterns.put(pattern.getName(), pattern);
        });
        return currentPatterns;
    }

    private Map<String, IWildcardPattern> a(IFilter baselineFilter, boolean isInclude) {
        assert (baselineFilter != null) : "Parameter 'baselineFilter' of method 'collectBaselinePatterns' must not be null";
        LinkedHashMap<String, IWildcardPattern> baselinePatterns = new LinkedHashMap<String, IWildcardPattern>();
        List patterns = isInclude ? baselineFilter.getIncludePatterns() : baselineFilter.getExcludePatterns();
        patterns.forEach(pattern -> {
            IWildcardPattern iWildcardPattern = baselinePatterns.put(pattern.getPattern(), (IWildcardPattern)pattern);
        });
        return baselinePatterns;
    }

    private void b(NamedElement parent, Workspace currentWorkspace) {
        assert (parent != null) : "Parameter 'parent' of method 'processModules' must not be null";
        assert (currentWorkspace != null) : "Parameter 'currentWorkspace' of method 'processModules' must not be null";
        Map<String, StrictPair<IModule, Integer>> baselineModules = this.a(this.a());
        Map<String, StrictPair<Module, Integer>> currentModules = this.a(currentWorkspace);
        for (Map.Entry<String, StrictPair<Module, Integer>> entry : currentModules.entrySet()) {
            ModuleDiff moduleDiff;
            Module currentModule = (Module)entry.getValue().getFirst();
            int currentPosition = (Integer)entry.getValue().getSecond();
            StrictPair<IModule, Integer> baselineModuleAndPosition = baselineModules.remove(entry.getKey());
            if (baselineModuleAndPosition != null) {
                StringJoiner changeDescription = new StringJoiner(". ", "", ".");
                IModule baselineModule = (IModule)baselineModuleAndPosition.getFirst();
                int baselinePosition = (Integer)baselineModuleAndPosition.getSecond();
                if (!baselineModule.getDescription().equals(currentModule.getDescription())) {
                    changeDescription.add("Description: " + baselineModule.getDescription() + " -> " + currentModule.getDescription());
                }
                if (currentPosition != baselinePosition) {
                    changeDescription.add("Position: " + baselinePosition + " -> " + currentPosition);
                }
                moduleDiff = changeDescription.length() == 1 ? new ModuleDiff(parent, baselineModule, currentModule, IDiffElement.Change.UNMODIFIED) : new ModuleDiff(parent, baselineModule, currentModule, IDiffElement.Change.MODIFIED, changeDescription.toString());
            } else {
                moduleDiff = new ModuleDiff(parent, null, currentModule, IDiffElement.Change.ADDED);
            }
            this.a(moduleDiff);
            parent.addChild(moduleDiff);
        }
        for (StrictPair strictPair : baselineModules.values()) {
            ModuleDiff moduleDiff = new ModuleDiff(parent, (IModule)strictPair.getFirst(), null, IDiffElement.Change.REMOVED);
            parent.addChild(moduleDiff);
            this.a(moduleDiff);
        }
    }

    private Map<String, StrictPair<Module, Integer>> a(Workspace currentWorkspace) {
        assert (currentWorkspace != null) : "Parameter 'currentWorkspace' of method 'collectCurrentModules' must not be null";
        LinkedHashMap<String, StrictPair<Module, Integer>> currentModules = new LinkedHashMap<String, StrictPair<Module, Integer>>();
        int i2 = 1;
        for (Module nextCurrent : currentWorkspace.getChildren(Module.class)) {
            currentModules.put(nextCurrent.getName(), (StrictPair<Module, Integer>)new StrictPair((Object)nextCurrent, (Object)i2));
            ++i2;
        }
        return currentModules;
    }

    private Map<String, StrictPair<IModule, Integer>> a(ISoftwareSystem baselineSoftwareSystem) {
        assert (baselineSoftwareSystem != null) : "Parameter 'baselineSoftwareSystem' of method 'collectBaselineModules' must not be null";
        LinkedHashMap<String, StrictPair<IModule, Integer>> baselineModules = new LinkedHashMap<String, StrictPair<IModule, Integer>>();
        int i2 = 1;
        for (Map.Entry nextBaselineEntry : baselineSoftwareSystem.getModules().entrySet()) {
            baselineModules.put((String)nextBaselineEntry.getKey(), (StrictPair<IModule, Integer>)new StrictPair((Object)((IModule)nextBaselineEntry.getValue()), (Object)i2));
            ++i2;
        }
        return baselineModules;
    }

    private void a(ModuleDiff moduleDiff) {
        assert (moduleDiff != null) : "Parameter 'moduleDiff' of method 'processRootDirectories' must not be null";
        Map<String, StrictPair<RootDirectoryPath, a>> currentRootsMap = this.a((Module)moduleDiff.getCurrent());
        Map<String, StrictPair<IRootDirectory, a>> baselineRootsMap = this.a((IModule)moduleDiff.getBaseline());
        for (Map.Entry<String, StrictPair<RootDirectoryPath, a>> entry : currentRootsMap.entrySet()) {
            String path = entry.getKey();
            RootDirectoryPath currentRoot = (RootDirectoryPath)entry.getValue().getFirst();
            a currentDto = (a)entry.getValue().getSecond();
            StrictPair<IRootDirectory, a> baseline = baselineRootsMap.remove(path);
            if (baseline != null) {
                StringJoiner changeDescription = new StringJoiner(". ", "", ".");
                IRootDirectory baselineRoot = (IRootDirectory)baseline.getFirst();
                a baselineDto = (a)baseline.getSecond();
                if (!currentDto.a().equals(baselineDto.a())) {
                    changeDescription.add("Type: " + baselineDto.a() + " -> " + currentDto.a());
                }
                if (currentDto.b() != baselineDto.b()) {
                    changeDescription.add("Position: " + baselineDto.b() + " -> " + currentDto.b());
                }
                RootDirectoryDiff rootDiff = changeDescription.length() == 1 ? new RootDirectoryDiff((NamedElement)moduleDiff, baselineRoot, currentRoot, IDiffElement.Change.UNMODIFIED) : new RootDirectoryDiff((NamedElement)moduleDiff, baselineRoot, currentRoot, IDiffElement.Change.MODIFIED, changeDescription.toString());
                moduleDiff.addChild(rootDiff);
                continue;
            }
            String changeMessage = "Added at position " + currentDto.b();
            RootDirectoryDiff rootDiff = new RootDirectoryDiff((NamedElement)moduleDiff, null, currentRoot, IDiffElement.Change.ADDED, changeMessage);
            moduleDiff.addChild(rootDiff);
        }
        for (StrictPair strictPair : baselineRootsMap.values()) {
            RootDirectoryDiff rootDiff = new RootDirectoryDiff((NamedElement)moduleDiff, (IRootDirectory)strictPair.getFirst(), null, IDiffElement.Change.REMOVED);
            moduleDiff.addChild(rootDiff);
        }
    }

    private Map<String, StrictPair<IRootDirectory, a>> a(IModule baselineModule) {
        if (baselineModule == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, StrictPair<IRootDirectory, a>> baselineRoots = new LinkedHashMap<String, StrictPair<IRootDirectory, a>>();
        int index = 1;
        for (IRootDirectory nextRoot : baselineModule.getRootDirectories()) {
            a dto = new a(nextRoot.getPresentationKind(), index++);
            baselineRoots.put(nextRoot.getName(), (StrictPair<IRootDirectory, a>)new StrictPair((Object)nextRoot, (Object)dto));
        }
        return baselineRoots;
    }

    private Map<String, StrictPair<RootDirectoryPath, a>> a(Module currentModule) {
        if (currentModule == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, StrictPair<RootDirectoryPath, a>> currentRoots = new LinkedHashMap<String, StrictPair<RootDirectoryPath, a>>();
        int index = 1;
        for (RootDirectoryPath nextRoot : currentModule.getChildren(RootDirectoryPath.class)) {
            a dto = new a(nextRoot.getPresentationKind(), index++);
            currentRoots.put(nextRoot.getName(), (StrictPair<RootDirectoryPath, a>)new StrictPair((Object)nextRoot, (Object)dto));
        }
        return currentRoots;
    }

    private static class a {
        private final int b;
        private final String c;

        public a(String kind, int position) {
            assert (kind != null) : "Parameter 'kind' of method 'RootDirectoryDto' must not be null";
            this.b = position;
            this.c = kind;
        }

        public String a() {
            return this.c;
        }

        public int b() {
            return this.b;
        }
    }
}

