/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.controller.system.diff.r;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssueDiff;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

abstract class D<B extends IIssue, C extends Issue> {
    private final r<B, C> a;

    public D(r<B, C> resolutionChangeProvider) {
        assert (resolutionChangeProvider != null) : "Parameter 'resolutionChangeProvider' of method 'SimpleIssueMatcher' must not be null";
        this.a = resolutionChangeProvider;
    }

    public final void a(NamedElement parent, List<B> baselineIssues, List<C> currentIssues) {
        assert (parent != null) : "Parameter 'parent' of method 'matchIssues' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'matchIssues' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'matchIssues' must not be null";
        LinkedHashSet<B> baselineNamedElementIssues = new LinkedHashSet<B>(baselineIssues);
        LinkedHashSet<C> currentNamedElementIssues = new LinkedHashSet<C>(currentIssues);
        this.a(parent, baselineIssues, baselineNamedElementIssues, currentNamedElementIssues);
        baselineNamedElementIssues.forEach(baselineIssue -> {
            IssueDiff<IIssue, Object> diff = this.a(parent, baselineIssue, null, IDiffElement.Change.REMOVED, null);
            parent.addChild(diff);
        });
        currentNamedElementIssues.forEach(currentIssue -> {
            IssueDiff<Object, Issue> diff = this.a(parent, null, currentIssue, IDiffElement.Change.ADDED, null);
            parent.addChild(diff);
        });
    }

    protected void a(NamedElement parent, List<B> baselineIssues, Set<B> baselineNamedElementIssues, Set<C> currentNamedElementIssues) {
        for (IIssue nextBaselineIssue : baselineIssues) {
            a<IIssue, C> matchResult = this.a(nextBaselineIssue, currentNamedElementIssues);
            if (matchResult == null) continue;
            this.a(parent, baselineNamedElementIssues, currentNamedElementIssues, matchResult);
        }
    }

    protected void a(NamedElement parent, Set<B> baselineNamedElementIssues, Set<C> currentNamedElementIssues, a<B, C> matchResult) {
        IDiffElement.Change resultingChange;
        assert (parent != null) : "Parameter 'parent' of method 'handleMatch' must not be null";
        assert (baselineNamedElementIssues != null) : "Parameter 'baselineNamedElementIssues' of method 'handleMatch' must not be null";
        assert (currentNamedElementIssues != null) : "Parameter 'currentNamedElementIssues' of method 'handleMatch' must not be null";
        assert (matchResult != null) : "Parameter 'matchResult' of method 'handleMatch' must not be null";
        Pair<IDiffElement.Change, String> resolutionChange = this.a.a((IIssue)matchResult.a(), (Issue)matchResult.b());
        StringBuilder changeDescription = new StringBuilder();
        if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
            resultingChange = (IDiffElement.Change)((Object)resolutionChange.getFirst());
            changeDescription.append((String)resolutionChange.getSecond());
        } else {
            resultingChange = matchResult.d();
        }
        if (matchResult.d() != IDiffElement.Change.UNMODIFIED) {
            if (changeDescription.length() > 0) {
                changeDescription.append(". ");
            }
            changeDescription.append(matchResult.e());
        }
        IssueDiff<IIssue, Issue> diff = this.a(parent, (IIssue)matchResult.a(), (Issue)matchResult.b(), resultingChange, changeDescription.toString());
        parent.addChild(diff);
        currentNamedElementIssues.remove(matchResult.b());
        baselineNamedElementIssues.remove(matchResult.a());
    }

    protected abstract IssueDiff<B, C> a(NamedElement var1, B var2, C var3, IDiffElement.Change var4, String var5);

    protected abstract a<B, C> a(B var1, Set<C> var2);

    public static final class a<B, C> {
        private final B b;
        private final C c;
        private final double d;
        private final IDiffElement.Change e;
        private final String f;

        public a(B baselineIssue, C currentIssue, double similarity, IDiffElement.Change change, String changeDescription) {
            assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'MatchResult' must not be null";
            assert (currentIssue != null) : "Parameter 'currentIssue' of method 'MatchResult' must not be null";
            assert (change != null) : "Parameter 'change' of method 'MatchResult' must not be null";
            assert (changeDescription != null) : "Parameter 'changeDescription' of method 'MatchResult' must not be null";
            this.b = baselineIssue;
            this.c = currentIssue;
            this.d = similarity;
            this.e = change;
            this.f = changeDescription;
        }

        public B a() {
            return this.b;
        }

        public C b() {
            return this.c;
        }

        public double c() {
            return this.d;
        }

        public IDiffElement.Change d() {
            return this.e;
        }

        public String e() {
            return this.f;
        }
    }
}

