/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.D;
import com.hello2morrow.sonargraph.core.controller.system.diff.b;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssueDiff;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class C<B extends IIssue, C extends Issue>
extends b<B, C> {
    protected C(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache, Class<B> baselineIssueClass, Class<C> currentIssueClass) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, currentSystem, allCurrentIssues, namedElementToFqNameCache, baselineIssueClass, currentIssueClass);
    }

    protected abstract String a(C var1);

    protected abstract D<B, C> h();

    @Override
    protected Set<IssueCategory> f() {
        return EnumSet.of(IssueCategory.DUPLICATE_CODE, IssueCategory.CYCLE_GROUP, IssueCategory.THRESHOLD_VIOLATION);
    }

    @Override
    protected final void a(NamedElement parent, List<B> baselineIssues, List<C> currentIssues) {
        Map<String, Map<String, List<B>>> baselineIssueMap = this.a(baselineIssues);
        Map<String, Map<String, List<C>>> currentIssueMap = this.b(currentIssues);
        this.a(parent, baselineIssueMap, currentIssueMap);
    }

    private Map<String, Map<String, List<B>>> a(List<B> baselineIssues) {
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'collectBaselineIssues' must not be null";
        HashMap<String, Map<String, List<B>>> baselineIssuesMap = new HashMap<String, Map<String, List<B>>>();
        for (IIssue next : baselineIssues) {
            assert (next.getAffectedNamedElements().size() == 1) : "Unexpected composite issue '" + next + "'";
            INamedElement affectedElement = (INamedElement)next.getAffectedNamedElements().get(0);
            String affectedElementFqName = this.a((C)affectedElement);
            Map issueTypeToIssue = baselineIssuesMap.computeIfAbsent(affectedElementFqName, name -> new HashMap());
            List issuesOfType = issueTypeToIssue.computeIfAbsent(next.getIssueType().getName(), name -> new ArrayList(2));
            issuesOfType.add(next);
        }
        for (Map issueTypeToIssue : baselineIssuesMap.values()) {
            for (List issuesOfType : issueTypeToIssue.values()) {
                issuesOfType.sort(new g.a());
            }
        }
        return baselineIssuesMap;
    }

    private Map<String, Map<String, List<C>>> b(List<C> currentIssues) {
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'collectCurrentSimpleIssues' must not be null";
        HashMap<String, Map<String, List<C>>> currentIssuesMap = new HashMap<String, Map<String, List<C>>>();
        for (Issue next : currentIssues) {
            String affectedElementFqName = this.a(next);
            Map issueTypeToIssue = currentIssuesMap.computeIfAbsent(affectedElementFqName, name -> new HashMap());
            List issuesOfType = issueTypeToIssue.computeIfAbsent(next.getId().getStandardName(), name -> new ArrayList(2));
            issuesOfType.add(next);
        }
        for (Map issueTypeToIssue : currentIssuesMap.values()) {
            for (List issuesOfType : issueTypeToIssue.values()) {
                issuesOfType.sort(new b.a());
            }
        }
        return currentIssuesMap;
    }

    protected void a(NamedElement parent, Map<String, Map<String, List<B>>> baselineIssueMap, Map<String, Map<String, List<C>>> currentIssueMap) {
        assert (parent != null) : "Parameter 'parent' of method 'computeIssueDiffs' must not be null";
        assert (baselineIssueMap != null) : "Parameter 'baselineIssueMap' of method 'computeIssueDiffs' must not be null";
        assert (currentIssueMap != null) : "Parameter 'currentIssueMap' of method 'computeIssueDiffs' must not be null";
        D<B, C> issueMatcher = this.h();
        for (Map.Entry<String, Map<String, List<B>>> entry : baselineIssueMap.entrySet()) {
            String baselineFqName = entry.getKey();
            Map<String, List<B>> baselineIssueTypeToIssuesMap = entry.getValue();
            Map<String, List<C>> currentIssueTypeToIssuesMap = currentIssueMap.remove(baselineFqName);
            if (currentIssueTypeToIssuesMap != null) {
                for (Map.Entry entry2 : baselineIssueTypeToIssuesMap.entrySet()) {
                    String issueType = (String)entry2.getKey();
                    List baselineIssues = (List)entry2.getValue();
                    List<C> currentIssues = currentIssueTypeToIssuesMap.remove(issueType);
                    if (currentIssues != null && !currentIssues.isEmpty()) {
                        issueMatcher.a(parent, baselineIssues, currentIssues);
                        continue;
                    }
                    this.a(parent, baselineIssues, issueMatcher);
                }
                for (Map.Entry entry3 : currentIssueTypeToIssuesMap.entrySet()) {
                    for (Issue nextCurrentIssue : (List)entry3.getValue()) {
                        IssueDiff<Object, Issue> diff = issueMatcher.a(parent, null, nextCurrentIssue, IDiffElement.Change.ADDED, null);
                        parent.addChild(diff);
                    }
                }
                continue;
            }
            for (List list : baselineIssueTypeToIssuesMap.values()) {
                this.a(parent, list, issueMatcher);
            }
        }
        for (Map map : currentIssueMap.values()) {
            for (List nextCurrentIssues : map.values()) {
                for (Issue nextCurrentIssue : nextCurrentIssues) {
                    IssueDiff<Object, Issue> diff = issueMatcher.a(parent, null, nextCurrentIssue, IDiffElement.Change.ADDED, null);
                    parent.addChild(diff);
                }
            }
        }
    }

    private void a(NamedElement parent, List<B> baselineIssues, D<B, C> issueMatcher) {
        assert (parent != null) : "Parameter 'parent' of method 'handleRemovedIssues' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'handleRemovedIssues' must not be null";
        assert (issueMatcher != null) : "Parameter 'issueMatcher' of method 'handleRemovedIssues' must not be null";
        for (IIssue nextBaseline : baselineIssues) {
            IssueDiff<IIssue, Object> diff = issueMatcher.a(parent, nextBaseline, null, IDiffElement.Change.REMOVED, null);
            parent.addChild(diff);
        }
    }
}

