/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.controller.system.diff.a;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurations;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimplePropertyDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginConfigurationDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginConfigurationsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginsDiff;
import com.hello2morrow.sonargraph.integration.access.controller.g;
import com.hello2morrow.sonargraph.integration.access.model.IPlugin;
import com.hello2morrow.sonargraph.integration.access.model.IPluginConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphFloatPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class A
extends a {
    private final IReport c;

    public A(ISoftwareSystem baselineSystem, g baselineSystemInfoProcessor, SoftwareSystem currentSystem, IReport currentSystemReport) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
        this.c = currentSystemReport;
    }

    @Override
    public void a(NamedElement parent) {
        this.a(parent, this.c);
        this.b(parent, this.c);
    }

    private void a(NamedElement basicInfoDiff, IReport currentSystemReport) {
        assert (basicInfoDiff != null) : "Parameter 'basicInfoDiff' of method 'addPluginsDiff' must not be null";
        assert (currentSystemReport != null) : "Parameter 'currentSystemReport' of method 'addPluginsDiff' must not be null";
        PluginConfigurations pluginConfigurations = this.c().getUniqueExistingChild(Files.class).getSystemDirectory().getUniqueExistingChild(PluginConfigurations.class);
        PluginsDiff pluginsDiff = new PluginsDiff(basicInfoDiff, pluginConfigurations);
        ArrayList<PluginDiff> children = new ArrayList<PluginDiff>();
        Map<String, IPlugin> baselinePlugins = this.b().h().stream().collect(Collectors.toMap(p2 -> p2.getName(), p2 -> p2));
        this.a(currentSystemReport.getModelPlugins(), baselinePlugins, children, pluginsDiff);
        List<SonargraphPlugin> analyzerPlugins = currentSystemReport.getAnalyzerPlugins().stream().map(p2 -> (SonargraphPlugin)p2.getFirst()).collect(Collectors.toList());
        this.a(analyzerPlugins, baselinePlugins, children, pluginsDiff);
        children.forEach(child -> {
            Object v2 = baselinePlugins.remove(child.getName());
        });
        for (IPlugin plugin : baselinePlugins.values()) {
            PluginDiff Diff2 = new PluginDiff((NamedElement)pluginsDiff, plugin, null, IDiffElement.Change.REMOVED);
            children.add(Diff2);
        }
        children.sort(Comparator.comparing(NamedElement::getName));
        for (PluginDiff nextDiff : children) {
            pluginsDiff.addChild(nextDiff);
        }
        basicInfoDiff.addChild(pluginsDiff);
    }

    private void a(Collection<SonargraphPlugin> plugins, Map<String, IPlugin> baselinePlugins, List<PluginDiff> children, PluginsDiff pluginsDiff) {
        for (SonargraphPlugin next : plugins) {
            IPlugin baselinePlugin = baselinePlugins.get(next.getId());
            if (baselinePlugin != null) {
                IDiffElement.Change change;
                if (next.isEnabled() && baselinePlugin.isEnabled() || !next.isEnabled() && !baselinePlugin.isEnabled()) {
                    change = IDiffElement.Change.UNMODIFIED;
                } else if (!baselinePlugin.isEnabled() && next.isEnabled()) {
                    change = IDiffElement.Change.ADDED;
                } else {
                    assert (baselinePlugin.isEnabled() && !next.isEnabled()) : "Unexpected state '" + baselinePlugin.isEnabled() + "', '" + next.isEnabled() + "'";
                    change = IDiffElement.Change.REMOVED;
                }
                PluginDiff Diff2 = new PluginDiff((NamedElement)pluginsDiff, baselinePlugin, next, change);
                children.add(Diff2);
                continue;
            }
            if (!next.isEnabled()) continue;
            PluginDiff Diff3 = new PluginDiff((NamedElement)pluginsDiff, baselinePlugin, next, IDiffElement.Change.ADDED);
            children.add(Diff3);
        }
    }

    private void b(NamedElement basicInfoDiff, IReport currentSystemReport) {
        PluginConfigurationDiff configurationDiff;
        assert (basicInfoDiff != null) : "Parameter 'basicInfoDiff' of method 'addPluginsConfigurationDiff' must not be null";
        assert (currentSystemReport != null) : "Parameter 'currentSystemReport' of method 'addPluginsConfigurationDiff' must not be null";
        HashMap<String, Pair> currentPluginConfigurations = new HashMap<String, Pair>();
        for (Map.Entry<SonargraphPlugin, Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>> nextCurrent : currentSystemReport.getPluginConfigurations().entrySet()) {
            currentPluginConfigurations.put(((PluginConfigurationFile)nextCurrent.getValue().getFirst()).getPath(), new Pair((Object)nextCurrent.getKey(), nextCurrent.getValue()));
        }
        PluginConfigurations pluginConfigurations = this.c().getUniqueExistingChild(Files.class).getSystemDirectory().getUniqueExistingChild(PluginConfigurations.class);
        PluginConfigurationsDiff configurationsDiff = new PluginConfigurationsDiff(basicInfoDiff, pluginConfigurations);
        for (Map.Entry baselinePluginConfigEntry : this.b().i().entrySet()) {
            Pair currentEntry = (Pair)currentPluginConfigurations.remove(baselinePluginConfigEntry.getKey());
            if (currentEntry != null) {
                PluginConfigurationFile currentConfiguration = (PluginConfigurationFile)((Pair)currentEntry.getSecond()).getFirst();
                List attributesAndValues = (List)((Pair)currentEntry.getSecond()).getSecond();
                PluginConfigurationDiff configurationDiff2 = new PluginConfigurationDiff(configurationsDiff, currentConfiguration, currentConfiguration.getName(), currentConfiguration.getPresentationName(false));
                this.a(configurationDiff2, (IPluginConfiguration)baselinePluginConfigEntry.getValue(), attributesAndValues);
                configurationsDiff.addChild(configurationDiff2);
                continue;
            }
            IPluginConfiguration baselinePluginConfiguration = (IPluginConfiguration)baselinePluginConfigEntry.getValue();
            configurationDiff = new PluginConfigurationDiff(configurationsDiff, null, baselinePluginConfiguration.getName(), baselinePluginConfiguration.getPresentationName(), IDiffElement.Change.REMOVED);
            this.a(configurationDiff, baselinePluginConfiguration, Collections.emptyList());
            configurationsDiff.addChild(configurationDiff);
        }
        for (Pair nextAdded : currentPluginConfigurations.values()) {
            PluginConfigurationFile addedPluginConfiguration = (PluginConfigurationFile)((Pair)nextAdded.getSecond()).getFirst();
            List attributeDefinitionsAndValues = (List)((Pair)nextAdded.getSecond()).getSecond();
            configurationDiff = new PluginConfigurationDiff(configurationsDiff, addedPluginConfiguration, addedPluginConfiguration.getName(), addedPluginConfiguration.getPresentationName(false), IDiffElement.Change.ADDED);
            this.a(configurationDiff, null, attributeDefinitionsAndValues);
            configurationsDiff.addChild(configurationDiff);
        }
        basicInfoDiff.addChild(configurationsDiff);
    }

    private void a(PluginConfigurationDiff configurationDiff, IPluginConfiguration baselineConfiguration, List<Pair<SonargraphPluginAttribute, String>> attributesAndValues) {
        assert (configurationDiff != null) : "Parameter 'configurationDiff' of method 'addPluginConfigurationEntriesDiff' must not be null";
        assert (attributesAndValues != null) : "Parameter 'attributesAndValues' of method 'addPluginConfigurationEntriesDiff' must not be null";
        ArrayList<Pair<SonargraphPluginAttribute, String>> currentAttributesAndValues = new ArrayList<Pair<SonargraphPluginAttribute, String>>(attributesAndValues);
        HashMap baseLineConfigurationValues = baselineConfiguration != null ? new HashMap(baselineConfiguration.getConfigurationValues()) : Collections.emptyMap();
        for (Pair pair : currentAttributesAndValues) {
            SimplePropertyDiff attributeDiff;
            SonargraphPluginAttribute definition = (SonargraphPluginAttribute)pair.getFirst();
            String attributeName = definition.getName();
            String currentValue = (String)pair.getSecond();
            if (baselineConfiguration != null && baseLineConfigurationValues.remove(attributeName) != null) {
                IDiffElement.Change change;
                if (definition instanceof SonargraphStringPluginAttribute) {
                    String baselineStringValue = baselineConfiguration.getStringConfigurationValue(attributeName);
                    if (baselineStringValue != null) {
                        IDiffElement.Change change2 = currentValue.equals(baselineStringValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, baselineStringValue, currentValue, change2);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                } else if (definition instanceof SonargraphIntPluginAttribute) {
                    Integer baselineIntValue = baselineConfiguration.getIntConfigurationValue(attributeName);
                    if (baselineIntValue != null) {
                        Integer currentIntValue = Integer.parseInt(currentValue);
                        change = currentIntValue.equals(baselineIntValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, "" + baselineIntValue, currentValue, change);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                } else if (definition instanceof SonargraphFloatPluginAttribute) {
                    Float baselineFloatValue = baselineConfiguration.getFloatConfigurationValue(attributeName);
                    if (baselineFloatValue != null) {
                        Float currentFloatValue = Float.valueOf(Float.parseFloat(currentValue));
                        change = currentFloatValue.equals(baselineFloatValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, "" + baselineFloatValue, currentValue, change);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                } else {
                    assert (definition != null && definition instanceof SonargraphBooleanPluginAttribute) : "Unexpected class in method 'addPluginConfigurationEntriesDiff': " + definition;
                    Boolean baselineBooleanValue = baselineConfiguration.getBooleanConfigurationValue(attributeName);
                    if (baselineBooleanValue != null) {
                        Boolean currentBooleanValue = Boolean.parseBoolean(currentValue);
                        change = currentBooleanValue.equals(baselineBooleanValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, "" + baselineBooleanValue, currentValue, change);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                }
                configurationDiff.addChild(attributeDiff);
                continue;
            }
            attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
            configurationDiff.addChild(attributeDiff);
        }
        for (Map.Entry entry : baseLineConfigurationValues.entrySet()) {
            SimplePropertyDiff attributeDiff = new SimplePropertyDiff(configurationDiff, (String)entry.getKey(), entry.getValue().toString(), null, IDiffElement.Change.REMOVED);
            configurationDiff.addChild(attributeDiff);
        }
    }
}

