/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.d;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.TFileBasedXmlElementAttributesExtractor;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class c {
    private static final Logger a = LoggerFactory.getLogger(c.class);
    private final CoreFileType c;
    private final String d;
    private final boolean e;
    private final boolean f;

    protected c(CoreFileType fileTypeToMigrate, String rootElementName, boolean writeToDisk, boolean migrateVersion) {
        assert (fileTypeToMigrate != null) : "Parameter 'fileTypeToMigrate' of method 'RegexBasedFileMigration' must not be null";
        assert (rootElementName != null && rootElementName.length() > 0) : "Parameter 'rootElementName' of method 'RegexBasedFileMigration' must not be empty";
        this.c = fileTypeToMigrate;
        this.d = rootElementName;
        this.e = writeToDisk;
        this.f = migrateVersion;
    }

    public void a(String currentVersion, TFile directory, OperationResult result) {
        assert (directory != null) : "Parameter 'directory' of method 'migrate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'migrate' must not be null";
        if (!directory.exists()) {
            return;
        }
        if (!directory.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION, "Migration of " + this.c.getPresentationName() + "' files requires read permission.", new Object[0]);
            return;
        }
        TFile[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(c.this.c.getDefaultExtension());
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        int successfullyMigrated = 0;
        int failedMigrations = 0;
        TFile[] tFileArray = files;
        int n2 = files.length;
        int n3 = 0;
        while (n3 < n2) {
            TFile next = tFileArray[n3];
            try {
                Map attributes = TFileBasedXmlElementAttributesExtractor.process((TFile)next, (String)this.d);
                if (attributes == null) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Not an XML file '" + next.getAbsolutePath() + "'.", new Object[0]);
                    ++failedMigrations;
                } else {
                    String version = (String)attributes.get("version");
                    if (version == null || version.isEmpty()) {
                        result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "No 'version' info found in XML file '" + next.getAbsolutePath() + "'.", new Object[0]);
                        ++failedMigrations;
                    } else if (this.a(version)) {
                        String originalContent = FileUtility.getFileContent((TFile)next);
                        String migrated = this.f ? this.a(version, currentVersion, originalContent) : originalContent;
                        migrated = this.a(migrated, result);
                        if (this.e) {
                            FileUtility.writeFileContent((String)migrated.trim(), (TFile)next);
                        }
                        ++successfullyMigrated;
                    }
                }
            }
            catch (IOException e2) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e2);
                ++failedMigrations;
            }
            ++n3;
        }
        if (failedMigrations == 0 && successfullyMigrated > 0) {
            a.debug("Successfully migrated {} of {} {} files.", new Object[]{successfullyMigrated, files.length, this.c.getPresentationName()});
        } else if (failedMigrations > 0) {
            a.error("Migration of {} files: {} successful, {} failed of a total of {} files", new Object[]{this.c.getPresentationName(), successfullyMigrated, failedMigrations, files.length});
        }
    }

    protected abstract boolean a(String var1);

    protected abstract String a(String var1, OperationResult var2);

    protected String a(String oldVersion, String currentVersion) {
        assert (oldVersion != null && oldVersion.length() > 0) : "Parameter 'oldVersion' of method 'migrateVersion' must not be empty";
        assert (currentVersion != null && currentVersion.length() > 0) : "Parameter 'currentVersion' of method 'migrateVersion' must not be empty";
        return "";
    }

    private String a(String oldVersion, String currentVersion, String content) {
        assert (oldVersion != null && oldVersion.length() > 0) : "Parameter 'oldVersion' of method 'migrateVersion' must not be empty";
        assert (currentVersion != null && currentVersion.length() > 0) : "Parameter 'currentVersion' of method 'migrateVersion' must not be empty";
        assert (content != null && content.length() > 0) : "Parameter 'content' of method 'migrateVersion' must not be empty";
        String vmElement = "(<" + this.d + " version=\")" + oldVersion.replace(".", "\\.") + "\">";
        String vmElementReplacement = "$1" + currentVersion + "\"" + this.a(oldVersion, currentVersion) + ">";
        String replace = content.replaceFirst(vmElement, vmElementReplacement);
        return replace;
    }
}

