/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.j;
import com.hello2morrow.sonargraph.core.controllerinterface.system.I;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.FilterModification;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfileProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfileModuleRef;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfilePatternModification;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfileRootPathMapping;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfiles;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.WorkspaceProfilePersistence;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public final class bj
extends Extension
implements j,
I,
IModifiableFileDeltaKey {
    private static final String b = "~_-_-_-_-_~";
    private final Installation c;
    private final SoftwareSystem d;
    private final g e;
    private final WorkspaceProfiles f;
    private WorkspaceProfile g;

    public bj(Installation installation, SoftwareSystem softwareSystem, g finishModelProcessor) {
        assert (installation != null) : "Parameter 'installation' of method 'WorkspaceProfileExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'WorkspaceProfileExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'WorkspaceProfileExtension' must not be null";
        this.c = installation;
        this.d = softwareSystem;
        this.e = finishModelProcessor;
        this.f = softwareSystem.getUniqueExistingChild(Files.class).getWorkspaceProfilesDirectory();
    }

    @Override
    public WorkspaceProfile getWorkspaceProfile() {
        return this.g;
    }

    public void a(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        if (!this.f.correspondingFileExists()) {
            TFile directory = this.f.getFile();
            assert (directory != null) : "'directory' of method 'checkOutOfSync' must not be null";
            if (!directory.exists() || !directory.isDirectory()) {
                if (!directory.mkdir()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, "Failed to create workspaceProfile directory '" + this.f.getIdentifyingPath() + "'", new Object[0]);
                    return;
                }
                this.f.checkExistence();
            }
        }
        if (this.f.isOutOfSync(new String[][]{CoreFileType.WORKSPACE_PROFILE.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        this.f.checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return bj.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!a && modifiableFile == null) {
                    throw new AssertionError((Object)"Parameter 'modifiableFile' of method 'exists' must not be null");
                }
                return modifiableFile instanceof WorkspaceProfile;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return bj.this.f;
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.WORKSPACE_PROFILE);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return WorkspaceProfile.class.getSimpleName();
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return bj.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!(a || modified != null && modified instanceof WorkspaceProfile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + modified));
                }
                bj.this.a(modified.getFile(), (WorkspaceProfile)modified);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!(a || deleted != null && deleted instanceof WorkspaceProfile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + deleted));
                }
                WorkspaceProfile toBeRemoved = (WorkspaceProfile)deleted;
                toBeRemoved.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!a && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                result.addMessagesFrom(bj.this.a(file, null));
            }
        }, true);
    }

    WorkspaceProfilePersistence a() {
        return new WorkspaceProfilePersistence(this.c.getVersion(), this.d);
    }

    private OperationResult a(TFile file, WorkspaceProfile profile) {
        OperationResultWithOutcome<WorkspaceProfile> loadResult;
        assert (file != null) : "Parameter 'file' of method 'addWorkspaceProfile' must not be null";
        Files files = this.d.getUniqueChild(Files.class);
        WorkspaceProfiles workspaceProfiles = files.getWorkspaceProfilesDirectory();
        WorkspaceProfilePersistence persistence = this.a();
        if (profile != null) {
            profile.removeChildren(WorkspaceProfileModuleRef.class);
            profile.removeChildren(WorkspaceProfilePattern.class);
            loadResult = persistence.load(profile, profile.getFile());
        } else {
            loadResult = persistence.load(null, file);
            if (loadResult.isSuccess()) {
                workspaceProfiles.addChild((NamedElement)loadResult.getOutcome());
            }
        }
        return loadResult;
    }

    WorkspaceProfile a(IWorkerContext workerContext, String profileName, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'changeCurrentProfile' must not be null";
        assert (profileName != null && profileName.length() > 0) : "Parameter 'profileName' of method 'changeCurrentProfile' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'apply' must not be null";
        assert (!this.d.isClearable()) : "System must not be clearable";
        WorkspaceProfile profile = this.a(profileName);
        if (profile == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Workspace profile: ", new Object[]{profileName});
            return null;
        }
        LinkedHashMap<String, String> resolutionMappings = new LinkedHashMap<String, String>();
        Workspace workspace = this.d.getUniqueExistingChild(Workspace.class);
        ArrayList<RootDirectoryPath> rootDirectoriesToRemove = new ArrayList<RootDirectoryPath>();
        LinkedHashMap<String, RootDirectoryPath> rootDirectoriesToAdd = new LinkedHashMap<String, RootDirectoryPath>();
        List<IWorkspaceProfilePattern> patterns = profile.getChildren(IWorkspaceProfilePattern.class);
        for (Module module : workspace.getChildren(Module.class)) {
            if (!module.supportsWorkspaceProfiles()) continue;
            for (RootDirectoryPath rootDirectoryPath : module.getChildren(module.getRootDirectoryPathClass())) {
                String identifyingPath = rootDirectoryPath.getIdentifyingPath();
                OperationResult translationResult = new OperationResult("Translate '" + identifyingPath + "'");
                String translatedPath = this.a(patterns, module.getShortName(), identifyingPath, translationResult);
                if (translationResult.isSuccess()) {
                    if (translatedPath.trim().isEmpty()) {
                        result.addError((OperationResult.IMessageCause)IWorkspaceProfileProvider.PatternCause.INVALID_PATTERN, "Empty replacement of path '" + identifyingPath + "' is not valid." + StringUtility.LINE_SEPARATOR + "Workspace profile '" + profileName + "' cannot be applied.", new Object[0]);
                        continue;
                    }
                    RootDirectoryPath newPath = module.createRootDirectoryPath(this.d, module, new TFile(translatedPath));
                    String newFullyQualifiedName = newPath.getFullyQualifiedName();
                    resolutionMappings.put(rootDirectoryPath.getFullyQualifiedName(), newFullyQualifiedName);
                    rootDirectoriesToRemove.add(rootDirectoryPath);
                    if (rootDirectoriesToAdd.containsKey(newFullyQualifiedName)) continue;
                    rootDirectoriesToAdd.put(newFullyQualifiedName, newPath);
                    continue;
                }
                result.addMessagesFrom(translationResult);
            }
        }
        if (result.isFailure()) {
            return null;
        }
        for (RootDirectoryPath rootDirectoryPath : rootDirectoriesToRemove) {
            rootDirectoryPath.remove();
        }
        for (Map.Entry entry : rootDirectoriesToAdd.entrySet()) {
            RootDirectoryPath rootDirectoryPath = (RootDirectoryPath)entry.getValue();
            rootDirectoryPath.getParent().addChild(rootDirectoryPath);
        }
        profile.setResolutionMappings(resolutionMappings);
        this.g = profile;
        if (!profile.overrideWorkspaceFilter()) {
            return profile;
        }
        ProductionCodeFilter productionCodeFilter = profile.getUniqueExistingChild(ProductionCodeFilter.class);
        if (productionCodeFilter.getNumberOfChildren() > 0) {
            ProductionCodeFilter workspaceFilter = workspace.getProductionCodeFilter();
            workspaceFilter.removeChildren(WildcardPattern.class);
            productionCodeFilter.getChildren(WildcardPatternInclude.class).stream().forEach(i2 -> workspaceFilter.addChild(new WildcardPatternInclude(workspaceFilter, i2.getName())));
            productionCodeFilter.getChildren(WildcardPatternExclude.class).stream().forEach(e2 -> workspaceFilter.addChild(new WildcardPatternExclude(workspaceFilter, e2.getName())));
        }
        return profile;
    }

    private String a(List<IWorkspaceProfilePattern> patterns, String moduleShortName, String identifyingPath, OperationResult translationResult) {
        assert (patterns != null) : "Parameter 'profile' of method 'translatePath' must not be null";
        assert (moduleShortName != null && moduleShortName.length() > 0) : "Parameter 'moduleShortName' of method 'translatePath' must not be empty";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'translatePath' must not be empty";
        assert (translationResult != null) : "Parameter 'translationResult' of method 'translatePath' must not be null";
        String result = identifyingPath;
        String input = identifyingPath;
        boolean atLeastOnePatternMatched = false;
        for (IWorkspaceProfilePattern pattern : patterns) {
            try {
                String cleanedPath;
                if (!moduleShortName.matches(pattern.getModuleMatcher()) || !result.matches(pattern.getRootPathMatcher())) continue;
                input = String.valueOf(moduleShortName) + b + result;
                String regexp = String.valueOf(pattern.getModuleMatcher()) + b + pattern.getRootPathMatcher();
                String replacedPath = input.replaceFirst(regexp, pattern.getRootPathReplacement());
                result = cleanedPath = replacedPath.replace(b, "");
                atLeastOnePatternMatched = true;
            }
            catch (IndexOutOfBoundsException | PatternSyntaxException ex) {
                translationResult.addError((OperationResult.IMessageCause)IWorkspaceProfileProvider.PatternCause.INVALID_PATTERN, "Failed to apply pattern '" + pattern + "'", new Object[]{ex});
                return "";
            }
        }
        return atLeastOnePatternMatched ? result.trim() : "";
    }

    private WorkspaceProfile a(final String profileName) {
        assert (profileName != null && profileName.length() > 0) : "Parameter 'profileName' of method 'getProfile' must not be empty";
        return this.f.getUniqueChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (namedElement instanceof WorkspaceProfile) {
                    WorkspaceProfile profile = (WorkspaceProfile)namedElement;
                    return profile.getFile().getName().equals(profileName);
                }
                return false;
            }
        }, WorkspaceProfile.class);
    }

    @Override
    public OperationResultWithOutcome<WorkspaceProfile> a(IWorkerContext workerContext, String name, String description, List<IWorkspaceProfilePattern> patterns, FilterModification filters) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createProfile' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createProfile' must not be empty";
        assert (this.getNameValidator().isValid(null, name).isSuccess()) : "Parameter 'name' of method 'createProfile' must not be empty";
        assert (patterns != null) : "Parameter 'patterns' of method 'createProfile' must not be null";
        assert (filters != null) : "Parameter 'filters' of method 'create' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Workspace Profile");
        this.a((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile file = new TFile((File)this.f.getFile(), String.valueOf(name) + CoreFileType.WORKSPACE_PROFILE.getDefaultExtension());
        WorkspaceProfile profile = new WorkspaceProfile((NamedElement)this.f, file, this.d.getUniqueExistingChild(Files.class));
        profile.setDescription(description);
        for (IWorkspaceProfilePattern next : patterns) {
            WorkspaceProfilePattern pattern = new WorkspaceProfilePattern(profile, next.getModuleMatcher(), next.getRootPathMatcher(), next.getRootPathReplacement());
            profile.addChild(pattern);
        }
        ProductionCodeFilter filter = new ProductionCodeFilter(profile);
        profile.addChild(filter);
        profile.setOverrideWorkspaceFilter(filters.overrideWorkspaceFilter());
        if (profile.overrideWorkspaceFilter() && filters.isModified() && !filters.isEmpty()) {
            filters.getPatterns().stream().forEach(i2 -> {
                i2.setParent(filter);
                filter.addChild((NamedElement)i2);
            });
        }
        OperationResultWithOutcome createResult = new OperationResultWithOutcome("Create pattern-based profile '" + name + "'");
        OperationResult saveResult = this.a().save(profile);
        createResult.addMessagesFrom(saveResult);
        if (saveResult.isSuccess()) {
            this.f.addChild(profile);
            profile.setExistsOnDisk(true);
            profile.resetTimestamp();
            createResult.setOutcome((Object)profile);
        }
        this.e.a(workerContext, this.d, EnumSet.noneOf(Modification.class), (OperationResult)createResult);
        return createResult;
    }

    @Override
    public ITextValidator getNameValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                } else {
                    result.addError("Input not valid");
                }
                if (!FileUtility.isValidName((String)newInput)) {
                    result.addError("Input not valid");
                } else if (newInput.endsWith(CoreFileType.WORKSPACE_PROFILE.getDefaultExtension())) {
                    result.addError("Extension will be added automatically");
                } else if (result.inputModified()) {
                    String newInputWithExtension = String.valueOf(newInput) + CoreFileType.WORKSPACE_PROFILE.getDefaultExtension();
                    for (WorkspaceProfile next : bj.this.f.getChildren(WorkspaceProfile.class)) {
                        if (!next.getShortName().equalsIgnoreCase(newInputWithExtension)) continue;
                        result.addError("Profile with name '" + newInput + "' already exists");
                        break;
                    }
                }
                return result;
            }
        };
    }

    @Override
    public ITextValidator getMatchPatternValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                } else {
                    result.addError("Input not valid");
                }
                if (newInput.isEmpty()) {
                    result.addError("Must not be empty");
                }
                try {
                    "Test".replaceFirst(newInput, "");
                }
                catch (PatternSyntaxException ex) {
                    result.addError(ex.getMessage());
                }
                return result;
            }
        };
    }

    @Override
    public ITextValidator getReplacementPatternValidator(final IWorkspaceProfileProvider.MatcherPair matchers) {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Input not valid");
                    return result;
                }
                String trimmedInput = newInput.trim();
                if (trimmedInput.length() == 0) {
                    result.addError("Replacement pattern must not be empty");
                    return result;
                }
                if (matchers.getModuleMatcher() == null || matchers.getModuleMatcher().trim().length() == 0) {
                    result.addError("Module matcher must not be empty");
                    return result;
                }
                if (matchers.getRootPathMatcher() == null || matchers.getRootPathMatcher().trim().length() == 0) {
                    result.addError("Root path matcher must not be empty");
                    return result;
                }
                String input = "_______________~_-_-_-_-_~=====================";
                String regexp = String.valueOf(matchers.getModuleMatcher().trim()) + bj.b + matchers.getRootPathMatcher().trim();
                try {
                    "_______________~_-_-_-_-_~=====================".replaceFirst(regexp, trimmedInput);
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                    result.addError(String.valueOf(ex.getMessage()) + " (regular expression error)");
                }
                return result;
            }
        };
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, List<WorkspaceProfile> profiles) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteWorkspaceProfile' must not be null";
        assert (profiles != null && !profiles.isEmpty()) : "Parameter 'profiles' of method 'delete' must not be empty";
        OperationResult result = new OperationResult("Delete " + profiles.size() + " workspace profile(s)");
        this.a(result);
        if (result.isFailure()) {
            return result;
        }
        for (WorkspaceProfile next : profiles) {
            SoftwareSystemFilesDirectory.removeFile(next.getFile(), false, result);
            next.remove();
        }
        this.e.a(workerContext, this.d, EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, WorkspaceProfile profile, String newNameWithoutExtension, String newDescription, List<IWorkspaceProfilePattern> newPatterns, FilterModification filterModification) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'modifyProfile' must not be null";
        assert (profile != null) : "Parameter 'profile' of method 'modifyProfile' must not be null";
        assert (newNameWithoutExtension != null && newNameWithoutExtension.length() > 0) : "Parameter 'newNameWithoutExtension' of method 'modifyProfile' must not be empty";
        assert (newPatterns != null) : "Parameter 'newPatterns' of method 'modifyProfile' must not be null";
        assert (filterModification != null) : "Parameter 'filterModification' of method 'modify' must not be null";
        OperationResult result = new OperationResult("Modify profile '" + profile.getName() + "'");
        this.a(result);
        if (result.isFailure()) {
            return result;
        }
        String newName = String.valueOf(newNameWithoutExtension) + CoreFileType.WORKSPACE_PROFILE.getDefaultExtension();
        boolean nameChanged = !profile.getFile().getName().equals(newName);
        profile.setNeedsSave(true);
        if (nameChanged) {
            TFile targetFile = new TFile((File)this.f.getFile(), newName);
            try {
                profile.getFile().mv((File)targetFile);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            profile.setPath(targetFile);
        }
        profile.setDescription(newDescription);
        profile.removeChildren(WorkspaceProfilePattern.class);
        for (IWorkspaceProfilePattern next : newPatterns) {
            WorkspaceProfilePattern pattern = new WorkspaceProfilePattern(profile, next.getModuleMatcher(), next.getRootPathMatcher(), next.getRootPathReplacement());
            profile.addChild(pattern);
        }
        ProductionCodeFilter filter = profile.getUniqueChild(ProductionCodeFilter.class);
        filter.removeChildren(WildcardPattern.class);
        profile.setOverrideWorkspaceFilter(filterModification.overrideWorkspaceFilter());
        if (filterModification.overrideWorkspaceFilter() && filterModification.isModified() && !filterModification.isEmpty()) {
            filterModification.getPatterns().stream().forEach(i2 -> {
                i2.setParent(filter);
                filter.addChild((NamedElement)i2);
            });
        }
        if (nameChanged) {
            OperationResult saveResult = this.a(profile);
            result.addMessagesFrom(saveResult);
        }
        this.e.a(workerContext, this.d, EnumSet.noneOf(Modification.class), result);
        return result;
    }

    public OperationResult a(WorkspaceProfile profile) {
        assert (profile != null) : "Parameter 'profile' of method 'save' must not be null";
        assert (profile.needsSave()) : "Does not need save: " + profile.getName();
        OperationResult saveResult = this.a().save(profile);
        if (saveResult.isSuccess()) {
            profile.setNeedsSave(false);
            profile.resetTimestamp();
        }
        return saveResult;
    }

    @Override
    public List<IWorkspaceProfilePattern> getPatterns(WorkspaceProfile profile) {
        assert (profile != null) : "Parameter 'profile' of method 'getProfilePatterns' must not be null";
        return profile.getChildren(WorkspaceProfilePattern.class).stream().map(p2 -> new WorkspaceProfilePatternModification(p2.getModuleMatcher(), p2.getRootPathMatcher(), p2.getRootPathReplacement())).collect(Collectors.toList());
    }

    @Override
    public boolean isPossibleDirectory(DirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'isWorkspaceProfileDirectory' must not be null";
        return path == this.f;
    }

    @Override
    public boolean hasChanged(WorkspaceProfile profile, String name, String description, List<IWorkspaceProfilePattern> patterns, FilterModification filterModifications) {
        assert (profile != null) : "Parameter 'profile' of method 'hasProfileChanged' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'hasProfileChanged' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'hasProfileChanged' must not be null";
        assert (patterns != null) : "Parameter 'patterns' of method 'hasChanged' must not be null";
        assert (filterModifications != null) : "Parameter 'filterModifications' of method 'hasChanged' must not be null";
        if (!FileUtility.getFileNameWithoutExtension((TFile)profile.getFile()).equals(name)) {
            return true;
        }
        if (!profile.getDescription().equals(description)) {
            return true;
        }
        return !this.getPatterns(profile).equals(patterns) || filterModifications.isModified();
    }

    @Override
    public boolean isCreationPossible() {
        return this.d.getUniqueExistingChild(Workspace.class).getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(namedElement instanceof Module)) {
                    return false;
                }
                Module module = (Module)namedElement;
                return module.supportsWorkspaceProfiles();
            }
        }, Module.class).size() > 0;
    }

    @Override
    public WorkspaceProfileRootPathMapping getRootDirectoryPathMapping(List<IWorkspaceProfilePattern> patterns) {
        assert (patterns != null) : "Parameter 'patterns' of method 'getRootDirectoryMapping' must not be null";
        WorkspaceProfileRootPathMapping mapping = new WorkspaceProfileRootPathMapping(patterns);
        Workspace workspace = this.d.getUniqueExistingChild(Workspace.class);
        ITextValidator pathValidator = this.a(this.d.getDirectoryFile());
        for (Module nextModule : workspace.getChildren(Module.class)) {
            if (!nextModule.supportsWorkspaceProfiles()) continue;
            for (RootDirectoryPath rootDirectoryPath : nextModule.getChildren(nextModule.getRootDirectoryPathClass())) {
                String identifyingPath = rootDirectoryPath.getIdentifyingPath();
                OperationResult translationResult = new OperationResult("Translate '" + identifyingPath + "'");
                String translatedPath = this.a(patterns, nextModule.getShortName(), identifyingPath, translationResult);
                if (translationResult.isFailure()) {
                    ValidationResult result = new ValidationResult(false);
                    result.addError("Invalid pattern");
                    mapping.addMapping(nextModule, rootDirectoryPath, "", result);
                    continue;
                }
                mapping.addMapping(nextModule, rootDirectoryPath, translatedPath, pathValidator.isValid(identifyingPath, translatedPath));
            }
        }
        return mapping;
    }

    private ITextValidator a(final TFile baseDirectory) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'getMappingValidator' must not be null";
        assert (baseDirectory.exists() && baseDirectory.isDirectory()) : "baseDirectory must be an existing directory";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.trim().isEmpty()) {
                    result.addError("Translated path must not be empty");
                } else if (!result.inputModified()) {
                    result.addWarning("Path is not translated");
                } else {
                    TFile path = FileUtility.isAbsolutePath((String)newInput) ? new TFile(newInput) : new TFile((File)baseDirectory, newInput);
                    try {
                        if (!path.exists() || !path.isDirectory()) {
                            result.addWarning("Path '" + newInput + "' does not exist");
                        }
                    }
                    catch (InvalidPathException ex) {
                        result.addError("Invalid path: " + ex.getLocalizedMessage());
                    }
                    TrueZipFacade.clear((TFile)path);
                }
                return result;
            }
        };
    }
}

