/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.U;
import com.hello2morrow.sonargraph.core.controller.system.aI;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.h;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.l;
import com.hello2morrow.sonargraph.core.controller.system.base.m;
import com.hello2morrow.sonargraph.core.controller.system.bc;
import com.hello2morrow.sonargraph.core.controllerinterface.system.F;
import com.hello2morrow.sonargraph.core.foundation.common.history.FileHistoryOperation;
import com.hello2morrow.sonargraph.core.foundation.common.history.IFileHistoryEntry;
import com.hello2morrow.sonargraph.core.foundation.common.history.ModifiableFileHistory;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.UndoRedoAvailabilityEvent;
import com.hello2morrow.sonargraph.core.model.history.GlobalHistory;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.core.model.transaction.IUndoRedoProvider;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionContext;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionType;
import com.hello2morrow.sonargraph.core.model.transaction.UndoRedoMessageCause;
import com.hello2morrow.sonargraph.core.persistence.history.HistoryStateFilePersistence;
import com.hello2morrow.sonargraph.core.persistence.history.HistoryTablePersistence;
import com.hello2morrow.sonargraph.integration.access.foundation.a;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class bd
extends OptionalExtension
implements m,
F {
    private static final Logger b = LoggerFactory.getLogger(bd.class);
    private static final String c = "history";
    private static final String e = "_";
    private final Map<Class<? extends IModifiableFile>, IUndoRedoProvider> f = new THashMap();
    private final Map<String, ModifiableFileHistory> g = new THashMap();
    private final GlobalHistory h = new GlobalHistory();
    private final g i;
    private final Installation j;
    private final SoftwareSystem k;
    private final l l;
    private final h m;
    private HistoryStateFilePersistence n;
    private TFile o;
    private HistoryTablePersistence p;

    public bd(Installation installation, SoftwareSystem system, l snapshotController, h analyzerExecutionController, g finishModelProcessor, boolean enabled) {
        super(enabled);
        assert (installation != null) : "Parameter 'installation' of method 'UndoRedoFunctionalExtension' must not be null";
        assert (system != null) : "Parameter 'system' of method 'UndoRedoExtension' must not be null";
        assert (snapshotController != null) : "Parameter 'snapshotController' of method 'UndoRedoExtension' must not be null";
        assert (analyzerExecutionController != null) : "Parameter 'analyzerExecutionController' of method 'UndoRedoExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'UndoRedoExtension' must not be null";
        this.j = installation;
        this.k = system;
        this.m = analyzerExecutionController;
        this.l = snapshotController;
        this.i = finishModelProcessor;
        if (this.isEnabled()) {
            this.i.a(this);
        }
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        if (this.isEnabled()) {
            TFile hiddenDataDirectory = this.k.getUniqueExistingChild(Files.class).getHiddenDataDirectory();
            TFile historyDir = new TFile((File)hiddenDataDirectory, c);
            if (historyDir.exists() && historyDir.isDirectory()) {
                try {
                    historyDir.rm_r();
                }
                catch (IOException ex) {
                    b.error("Failed to delete history directory '" + historyDir.getAbsolutePath() + "'");
                }
            }
            this.o = FileUtility.getOrCreateDirectory((TFile)historyDir, (OperationResult)result);
            if (!result.isFailure()) {
                this.n = new HistoryStateFilePersistence(this.o);
                if (b.isDebugEnabled()) {
                    this.p = new HistoryTablePersistence(this.o, this.j.getVersion(), new a(Arrays.asList(this.getClass().getClassLoader())));
                }
            } else {
                b.error("Unable to create history directory: " + result.toString());
            }
        }
    }

    void a(IUndoRedoProvider provider) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (provider != null) : "Parameter 'provider' of method 'addUndoRedoProvider' must not be null";
        for (Class<? extends IModifiableFile> next : provider.getModifiableFileClasses()) {
            IUndoRedoProvider previous = this.f.put(next, provider);
            assert (previous == null) : "'previous' of method 'addUndoRedoProvider' must  be null";
        }
    }

    public IUndoRedoProvider a(Class<? extends IModifiableFile> clazz) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (clazz != null) : "Parameter 'clazz' of method 'getUndoRedoProvider' must not be null";
        return this.f.get(clazz);
    }

    private void a(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'saveState' must not be null";
        assert (result != null) : "Parameter 'result' of method 'saveState' must not be null";
        this.a(result, context.getDeletedFiles());
        this.a(context.getCreatedFiles(), context, result);
        if (context.getTransactionType() == TransactionType.UNDOABLE) {
            for (IModifiableFile nextFile : context.getModifiedFiles()) {
                IUndoRedoProvider undoRedoProvider = this.f.get(nextFile.getClass());
                if (undoRedoProvider == null) {
                    b.debug(String.format("No UndoRedoProvider defined for class '%s'", nextFile.getClass().getCanonicalName()));
                    continue;
                }
                ModifiableFileHistory fileHistory = this.g.get(nextFile.getFileId());
                assert (fileHistory != null) : "History for file '" + nextFile.getAbsolutePath() + "' with fileId '" + nextFile.getFileId() + "' must exist";
                List<GlobalHistory.Entry> obsoleteEntries = this.h.addEntry(new GlobalHistory.Entry(nextFile, context.getName(), context.getId(), context.getModifications()));
                this.a(obsoleteEntries, result);
                GlobalHistory.Entry addedEntry = (GlobalHistory.Entry)this.h.getLastAddedEntry();
                addedEntry.setNavigationState(context.getNavigationState());
                if (fileHistory.getSize() > 0) {
                    undoRedoProvider.updatePreviousEntry(fileHistory, nextFile);
                }
                String entryName = this.a(nextFile, context.getId());
                List<ModifiableFileHistory.FileHistoryEntry> removedEntries = this.a(context, result, nextFile, undoRedoProvider, fileHistory, entryName, true);
                this.a(removedEntries, fileHistory);
            }
        } else if (context.getTransactionType() == TransactionType.SAVE) {
            for (IModifiableFile nextFile : context.getModifiedFiles()) {
                IUndoRedoProvider undoRedoProvider = this.f.get(nextFile.getClass());
                if (undoRedoProvider == null) {
                    b.debug(String.format("No UndoRedoProvider defined for class '%s'", nextFile.getClass().getCanonicalName()));
                    continue;
                }
                ModifiableFileHistory fileHistory = this.g.get(nextFile.getFileId());
                assert (fileHistory != null) : "History for file '" + nextFile.getAbsolutePath() + "' with fileId '" + nextFile.getFileId() + "' must exist";
                if (fileHistory.getSize() > 0) {
                    undoRedoProvider.updatePreviousEntry(fileHistory, nextFile);
                }
                String entryName = this.a(nextFile, context.getId());
                List<ModifiableFileHistory.FileHistoryEntry> removedEntries = this.a(context, result, nextFile, undoRedoProvider, fileHistory, entryName, true);
                this.a(removedEntries, fileHistory);
            }
        } else {
            this.c(context, result);
        }
        this.a(result, context.getReloadedFiles());
        this.a(context.getReloadedFiles(), context, result);
        this.d(context, result);
        SoftwareSystemFile systemFile = this.k.getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        if (context.getTransactionType() != TransactionType.UNDOABLE && context.getTransactionType() != TransactionType.SAVE || !context.getCreatedFiles().contains(systemFile) && !context.getModifiedFiles().contains(systemFile) && !context.getSavedFiles().contains(systemFile) && !context.getReloadedFiles().contains(systemFile)) {
            this.b(context);
        }
        this.a(context);
        this.k();
    }

    private void b(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'finishRestore' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishRestore' must not be null";
        Set<IModifiableFile> created = context.getCreatedFiles();
        if (!created.isEmpty()) {
            this.a(created, context, result);
        }
    }

    private void b(TransactionContext context) {
        assert (this.isEnabled()) : "Extension not enabled";
        SoftwareSystemFile systemFile = this.k.getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        IUndoRedoProvider undoRedoProvider = this.f.get(SoftwareSystemFile.class);
        ModifiableFileHistory fileHistory = this.g.get(systemFile.getFileId());
        ModifiableFileHistory.FileHistoryEntry entry = (ModifiableFileHistory.FileHistoryEntry)fileHistory.getLastAddedEntry();
        undoRedoProvider.updateState(systemFile, entry, context.invalidatesParserModel());
    }

    private List<ModifiableFileHistory.FileHistoryEntry> a(TransactionContext context, OperationResult result, IModifiableFile modifiableFile, IUndoRedoProvider undoRedoProvider, ModifiableFileHistory fileHistory, String entryName, boolean needsSave) {
        assert (this.isEnabled()) : "Extension not enabled";
        ArrayList<ModifiableFileHistory.FileHistoryEntry> removedEntries = new ArrayList();
        OperationResultWithOutcome<TFile> saveStateResult = this.n.saveState(modifiableFile, entryName, undoRedoProvider);
        if (saveStateResult.isSuccess()) {
            removedEntries = undoRedoProvider.createEntry(context, modifiableFile, fileHistory, needsSave, (TFile)saveStateResult.getOutcome());
            if (b.isDebugEnabled()) {
                result.addMessagesFrom(this.p.persist(this.h));
            }
            return removedEntries;
        }
        b.error(String.format("Failed to save state for '%s', command '%s'", modifiableFile.getAbsolutePath(), context.getName()));
        result.addMessagesFrom(saveStateResult);
        return removedEntries;
    }

    private void a(Collection<IModifiableFile> modifiableFiles, TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'createInitialFileHistoryEntries' must not be null";
        assert (context != null) : "Parameter 'context' of method 'createInitialFileHistoryEntries' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createInitialFileHistoryEntries' must not be null";
        for (IModifiableFile nextFile : modifiableFiles) {
            IUndoRedoProvider undoRedoProvider = this.f.get(nextFile.getClass());
            if (undoRedoProvider == null) continue;
            assert (!this.g.containsKey(nextFile.getFileId())) : "Added file '" + nextFile.getIdentifyingPath() + "' must not be present in file history.";
            ModifiableFileHistory fileHistory = undoRedoProvider.createFileHistory(nextFile.getFile().getName(), nextFile.getFileId());
            ModifiableFileHistory previousHistory = this.g.put(nextFile.getFileId(), fileHistory);
            assert (previousHistory == null) : "No history expected for created file " + nextFile.getIdentifyingPath();
            String entryName = this.a(nextFile, context.getId());
            this.a(context, result, nextFile, undoRedoProvider, fileHistory, entryName, false);
        }
    }

    private void a(OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        TransactionContext context = this.i.e();
        context.setNeedsReparseFlagModification(this.k.consumeNeedsReparseModification());
        this.a(this.k.getUniqueExistingChild(Files.class).getModifiableFiles(), context, result);
    }

    private void a(OperationResult result, Collection<IModifiableFile> toDelete) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (result != null) : "Parameter 'result' of method 'removeHistoryEntries' must not be null";
        assert (toDelete != null) : "Parameter 'toDelete' of method 'removeHistoryEntries' must not be null";
        for (IModifiableFile nextToDelete : toDelete) {
            IUndoRedoProvider undoRedoProvider = this.f.get(nextToDelete.getClass());
            if (undoRedoProvider == null) continue;
            String fileId = nextToDelete.getFileId();
            ModifiableFileHistory fileHistory = this.g.remove(fileId);
            assert (fileHistory != null) : "fileHistory for file '" + nextToDelete.getAbsolutePath() + "', id=" + nextToDelete.getFileId() + " must exist";
            ArrayList<GlobalHistory.Entry> toRemove = new ArrayList<GlobalHistory.Entry>();
            for (GlobalHistory.Entry entry : this.h.getEntries()) {
                if (!entry.getFileId().equals(fileId)) continue;
                toRemove.add(entry);
            }
            for (GlobalHistory.Entry entry : toRemove) {
                boolean removed = this.h.removeEntry(entry);
                assert (removed) : "Entry '" + entry.toString() + "' already removed";
            }
            for (ModifiableFileHistory.FileHistoryEntry fileHistoryEntry : fileHistory.getEntries()) {
                TFile stateFile = new TFile(fileHistoryEntry.getPath());
                if (!stateFile.exists()) continue;
                try {
                    stateFile.rm();
                }
                catch (IOException ex) {
                    result.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, "Failed to delete history state file '" + fileHistoryEntry.getPath() + "'", new Object[0]);
                }
            }
            this.a(fileHistory, result);
            fileHistory.clear();
        }
    }

    private void a(ModifiableFileHistory fileHistory, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (fileHistory != null) : "Parameter 'fileHistory' of method 'removeExplicitlyAddedLastSavedStateIfExists' must not be null";
        assert (result != null) : "Parameter 'result' of method 'removeExplicitlyAddedLastSavedStateIfExists' must not be null";
        ModifiableFileHistory.FileHistoryEntry explicitlyAddedLastSavedEntry = fileHistory.invalidateExplicitlyAddedLastSavedEntry();
        if (explicitlyAddedLastSavedEntry != null) {
            try {
                TFile file = new TFile(explicitlyAddedLastSavedEntry.getPath());
                if (file.exists()) {
                    TFile.rm((File)file);
                }
            }
            catch (IOException e2) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)e2);
            }
        }
    }

    private String a(IModifiableFile file, long txId) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (file != null) : "Parameter 'file' of method 'createStateFileName' must not be null";
        return String.format("%06d", txId) + e + file.getFileId();
    }

    private void c(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'resetHistoryForModifiedFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'resetHistoryForModifiedFiles' must not be null";
        Set<IModifiableFile> modifiedFiles = context.getModifiedFiles();
        if (modifiedFiles.isEmpty()) {
            return;
        }
        for (IModifiableFile nextFile : modifiedFiles) {
            IUndoRedoProvider undoRedoProvider = this.f.get(nextFile.getClass());
            if (undoRedoProvider == null) continue;
            String fileId = nextFile.getFileId();
            ModifiableFileHistory fileHistory = this.g.get(fileId);
            assert (fileHistory != null) : "fileHistory for file '" + nextFile.getAbsolutePath() + "', id=" + nextFile.getFileId() + " must exist";
            ArrayList<GlobalHistory.Entry> toRemove = new ArrayList<GlobalHistory.Entry>();
            for (GlobalHistory.Entry entry : this.h.getEntries()) {
                if (!entry.getFileId().equals(fileId)) continue;
                toRemove.add(entry);
            }
            for (GlobalHistory.Entry entry : toRemove) {
                boolean removed = this.h.removeEntry(entry);
                assert (removed) : "Entry '" + entry.toString() + "' already removed";
            }
            boolean keepLastSavedState = nextFile.needsSave();
            for (ModifiableFileHistory.FileHistoryEntry entry : fileHistory.getEntries()) {
                if (keepLastSavedState && !entry.needsSave()) {
                    fileHistory.setExplicitlyAddedLastSavedEntry(entry);
                    continue;
                }
                TFile stateFile = new TFile(entry.getPath());
                if (!stateFile.exists()) continue;
                try {
                    stateFile.rm();
                }
                catch (IOException ex) {
                    result.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, "Failed to delete history state file '" + entry.getPath() + "'", new Object[0]);
                }
            }
            if (!keepLastSavedState) {
                this.a(fileHistory, result);
            }
            fileHistory.clear();
            String entryName = this.a(nextFile, context.getId());
            this.a(context, result, nextFile, undoRedoProvider, fileHistory, entryName, false);
        }
    }

    private OperationResult d(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'updateLastStateForSavedFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateLastStateForSavedFiles' must not be null";
        for (IModifiableFile nextFile : context.getSavedFiles()) {
            b.debug("Update history state for " + nextFile.getAbsolutePath());
            IUndoRedoProvider undoRedoProvider = this.f.get(nextFile.getClass());
            assert (undoRedoProvider != null) : "'undoRedoProvider' must not be null";
            ModifiableFileHistory fileHistory = this.g.get(nextFile.getFileId());
            ModifiableFileHistory.FileHistoryEntry entry = (ModifiableFileHistory.FileHistoryEntry)fileHistory.getLastAddedEntry();
            if (entry != null) {
                undoRedoProvider.updateState(nextFile, entry, context.invalidatesParserModel());
            } else {
                b.warn("No last added entry found for: " + nextFile);
            }
            this.a(fileHistory, result);
        }
        return result;
    }

    public void a(TransactionContext context) {
        if (!b.isDebugEnabled()) {
            return;
        }
        if (!this.isEnabled()) {
            b.debug("**********************  No undo/redo history state for disabled extension ******************");
            return;
        }
        b.debug("**********************  Undo/redo history state ******************");
        b.debug(String.format("GlobalHistory[size=%d; nextPositionToAddEntry=%d]", this.h.getSize(), this.h.getUndoEntriesSize()));
        boolean index = false;
        ArrayList<GlobalHistory.Entry> currentEntries = new ArrayList<GlobalHistory.Entry>();
        GlobalHistory.Entry currentEntry = (GlobalHistory.Entry)this.h.getLastAddedEntry();
        b.debug("  Entries for undo:");
        if (currentEntry != null) {
            for (GlobalHistory.Entry nextEntry : this.h.getUndoEntries()) {
                if (nextEntry.getTransactionId() < currentEntry.getTransactionId()) {
                    b.debug("    " + this.a(context, 0, nextEntry));
                    continue;
                }
                b.debug("last executed operation: " + this.a(context, 0, nextEntry));
                currentEntries.add(nextEntry);
            }
        }
        b.debug("  Entries for redo:");
        for (GlobalHistory.Entry nextEntry : this.h.getRedoEntries()) {
            b.debug("    " + this.a(context, 0, nextEntry));
        }
        b.debug("");
        for (GlobalHistory.Entry nextCurrentEntry : currentEntries) {
            ModifiableFileHistory fileHistory = this.g.get(nextCurrentEntry.getFileId());
            b.debug("  File history for files involved in last operation: " + fileHistory.toString());
            int currentPos = fileHistory.getUndoEntriesSize();
            b.debug(String.format("     %d Entries for undo: ", currentPos - 1));
            int i2 = 0;
            for (IFileHistoryEntry nextEntry : fileHistory.getUndoEntries()) {
                b.debug("       " + this.a(i2++, nextEntry));
                if (i2 == fileHistory.getUndoEntriesSize() - 1) break;
            }
            b.debug("       Last operation:" + this.a(currentPos, (IFileHistoryEntry)fileHistory.getLastAddedEntry()));
            b.debug(String.format("     %d Entries for redo: ", fileHistory.getRedoEntriesSize()));
            i2 = 0;
            for (IFileHistoryEntry nextEntry : fileHistory.getRedoEntries()) {
                b.debug("       " + this.a(i2++, nextEntry));
            }
        }
        b.debug("*************************************************************");
    }

    private String a(int i2, IFileHistoryEntry entry) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entry != null) : "Parameter 'entry' of method 'logFileEntry' must not be null";
        return String.format("[%02d] command '%s'", i2, entry.toString());
    }

    private String a(TransactionContext context, int index, GlobalHistory.Entry entry) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entry != null) : "Parameter 'entry' of method 'logGlobalEntry' must not be null";
        assert (index >= 0) : "Parameter 'index' of method 'logGlobalEntry' must be >= 0";
        return String.format("[%02d] Transaction '%d', command '%s', modifications '%s', file '%s'", index, context != null ? context.getId() : entry.getTransactionId(), entry.getCommandName(), entry.getModifications(), entry.getPath());
    }

    private void a(List<GlobalHistory.Entry> obsoleteEntries, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (obsoleteEntries != null) : "Parameter 'obsoleteEntries' of method 'removeObsoleteEntries' must not be null";
        assert (result != null) : "Parameter 'result' of method 'removeObsoleteEntries' must not be null";
        if (obsoleteEntries.isEmpty()) {
            return;
        }
        for (GlobalHistory.Entry nextEntry : obsoleteEntries) {
            ModifiableFileHistory fileHistory = this.g.get(nextEntry.getFileId());
            ModifiableFileHistory.FileHistoryEntry toRemoveState = fileHistory.removeEntry(nextEntry.getTransactionId());
            if (toRemoveState == null) continue;
            result.addMessagesFrom(this.a(toRemoveState, fileHistory));
        }
    }

    private OperationResult a(ModifiableFileHistory.FileHistoryEntry toRemoveState, ModifiableFileHistory history) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (toRemoveState != null) : "Parameter 'toRemoveState' of method 'deleteHistoryStateFile' must not be null";
        assert (history != null) : "Parameter 'history' of method 'deleteHistoryStateFile' must not be null";
        OperationResult result = new OperationResult("Remove obsolete history state file");
        String toRemovePath = toRemoveState.getPath();
        if (!toRemoveState.needsSave()) {
            history.setExplicitlyAddedLastSavedEntry(toRemoveState);
        } else {
            TFile file = new TFile(toRemovePath);
            if (!file.exists()) {
                return result;
            }
            try {
                file.rm();
            }
            catch (IOException ex) {
                b.error(String.format("Failed to delete state file '%s'", file.getAbsolutePath()), (Throwable)ex);
            }
        }
        return result;
    }

    private void a(List<ModifiableFileHistory.FileHistoryEntry> removedEntries, ModifiableFileHistory fileHistory) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (removedEntries != null) : "Parameter 'removedEntries' of method 'removeObsoleteFileHistoryEntries' must not be null";
        if (removedEntries.size() == 0) {
            return;
        }
        ArrayList<Long> transactionIds = new ArrayList<Long>();
        for (ModifiableFileHistory.FileHistoryEntry next : removedEntries) {
            transactionIds.add(next.getTransactionId());
            this.a(next, fileHistory);
        }
        this.h.removeTransactions(transactionIds);
    }

    private OperationResult j() {
        assert (this.isEnabled()) : "Extension not enabled";
        OperationResult result = new OperationResult("Delete history directory '" + this.o.getAbsolutePath() + "'");
        this.h.clear();
        this.g.clear();
        try {
            this.o.rm_r();
            this.o.mkdir();
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex);
        }
        return result;
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'initialized' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initialized' must not be null";
        assert (result != null) : "Parameter 'result' of method 'initialized' must not be null";
        this.a(result);
    }

    @Override
    public void a(SoftwareSystem softwareSystem, TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'transactionFinished' must not be null";
        assert (context != null) : "Parameter 'context' of method 'transactionFinished' must not be null";
        assert (result != null) : "Parameter 'result' of method 'transactionFinished' must not be null";
        if (context.getTransactionType() == TransactionType.RESTORE) {
            this.b(context, result);
        } else if (!context.isEmpty()) {
            this.a(context, result);
        }
    }

    @Override
    public void a(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, TFile oldSystemDirectory, OperationResult result, boolean baseDirectoryChanged) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'savedAs' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'savedAs' must not be null";
        assert (oldSystemDirectory != null) : "Parameter 'oldSystemDirectory' of method 'savedAs' must not be null";
        assert (result != null) : "Parameter 'result' of method 'savedAs' must not be null";
        OperationResult clearAndInitializeResult = this.j();
        this.a(clearAndInitializeResult);
        result.addMessagesFromMaintainingCurrentOutcome(clearAndInitializeResult);
        eventsToDispatch.add(new UndoRedoAvailabilityEvent(this.k.getExtension(ISoftwareSystemProvider.class), false, false));
    }

    @Override
    public void a(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'released' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'released' must not be null";
        OperationResult clearResult = this.j();
        result.addMessagesFromMaintainingCurrentOutcome(clearResult);
        eventsToDispatch.add(new UndoRedoAvailabilityEvent(this.k.getExtension(ISoftwareSystemProvider.class), false, false));
    }

    @Override
    public int a() {
        return this.h.getNumberOfStoredTransactions();
    }

    private Collection<AnalyzerGroup> a(List<? extends U> restoreInfos) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (restoreInfos != null) : "Parameter 'restoreInfos' of method 'cancelAnalyzers' must not be null";
        HashSet<AnalyzerGroup> analyzerGroups = new HashSet<AnalyzerGroup>();
        boolean reRunAllAnalyzers = false;
        for (U u2 : restoreInfos) {
            IUndoRedoProvider nextUndoRedoProvider = u2.a();
            AnalyzerExecutionInfo executionInfo = nextUndoRedoProvider.getAnalyzerExecutionInfo(u2.b(), u2.c());
            switch (executionInfo.getMode()) {
                case ALL: {
                    reRunAllAnalyzers = true;
                    break;
                }
                case GROUPS: {
                    analyzerGroups.addAll(executionInfo.getGroups());
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled mode: " + (Object)((Object)executionInfo.getMode());
                    break;
                }
            }
            if (reRunAllAnalyzers) break;
        }
        if (reRunAllAnalyzers) {
            this.m.a(ResetMode.ALL);
            return null;
        }
        if (!analyzerGroups.isEmpty()) {
            return this.m.a(analyzerGroups, ResetMode.ALL);
        }
        return analyzerGroups;
    }

    private void a(Collection<AnalyzerGroup> groups) {
        assert (this.isEnabled()) : "Extension not enabled";
        if (groups == null) {
            this.m.b((IWorkerContext)null);
        } else if (!groups.isEmpty()) {
            this.m.a(groups);
        }
    }

    private List<bc> a(List<GlobalHistory.Entry> entries, FileHistoryOperation operation) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entries != null) : "Parameter 'entries' of method 'createUndoRedoData' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'createUndoRedoData' must not be null";
        ArrayList<bc> data = new ArrayList<bc>(entries.size());
        for (GlobalHistory.Entry entry : entries) {
            IUndoRedoProvider undoRedoProvider = this.f.get(entry.getClazz());
            assert (undoRedoProvider != null) : "'nextUndoRedoProvider' of method 'createUndoRedoData' must not be null";
            ModifiableFileHistory fileHistory = this.g.get(entry.getFileId());
            RestoreStateDto dto = this.a(entry, operation, fileHistory, false);
            if (dto == null) continue;
            data.add(new bc(undoRedoProvider, entry, dto));
        }
        return data;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'redo' must not be null";
        if (!this.c()) {
            return new OperationResult("No redo available");
        }
        this.l.d();
        OperationResult result = null;
        INavigationState navigationState = null;
        EnumSet<Modification> determinedModifications = EnumSet.noneOf(Modification.class);
        List<GlobalHistory.Entry> entries = this.h.redo();
        ArrayList<IModifiableFile> restoredFiles = new ArrayList<IModifiableFile>();
        List<bc> restoreInfos = this.a(entries, FileHistoryOperation.REDO);
        Collection<AnalyzerGroup> groups = this.a(restoreInfos);
        for (bc next : restoreInfos) {
            if (result == null) {
                result = new OperationResult(String.format("Redo operation '%s'", next.d().getCommandName()));
            }
            workerContext.working(String.format("Redo operation '%s'", next.d().getCommandName()), true);
            List<String> otherEntriesOfTx = entries.stream().filter(e2 -> e2 != next.d()).map(e2 -> e2.getFileId()).collect(Collectors.toList());
            OperationResultWithOutcome<? extends IModifiableFile> restoreStateResult = this.a(next, otherEntriesOfTx, FileHistoryOperation.REDO, determinedModifications);
            if (restoreStateResult.getErrorCauses().contains((Object)UndoRedoMessageCause.RESTORE_ABORTED)) {
                this.h.undo();
                return result;
            }
            result.addMessagesFrom(restoreStateResult);
            if (restoreStateResult.getOutcome() != null) {
                restoredFiles.add((IModifiableFile)restoreStateResult.getOutcome());
            }
            this.a((TransactionContext)null);
            navigationState = next.d().getNavigationState();
        }
        this.i.a((IWorkerContext)DefaultWorkerContext.INSTANCE, this.k, determinedModifications, restoredFiles, navigationState, result);
        this.a(groups);
        this.k();
        return result;
    }

    @Override
    public OperationResult b(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'undo' must not be null";
        if (!this.b()) {
            return new OperationResult("No undo available");
        }
        this.l.d();
        GlobalHistory.Entry entry = (GlobalHistory.Entry)this.h.getNextEntryForUndo();
        OperationResult result = new OperationResult(String.format("Undo operation '%s'", entry.getCommandName()));
        workerContext.working(result.getDescription(), true);
        List<GlobalHistory.Entry> entries = this.h.undo();
        EnumSet<Modification> determinedModifications = EnumSet.noneOf(Modification.class);
        ArrayList<IModifiableFile> restoredFiles = new ArrayList<IModifiableFile>();
        INavigationState restoreNavigationState = null;
        List<bc> restoreInfos = this.a(entries, FileHistoryOperation.UNDO);
        Collection<AnalyzerGroup> groups = this.a(restoreInfos);
        for (bc next : restoreInfos) {
            List<String> otherEntriesOfTx;
            OperationResultWithOutcome<? extends IModifiableFile> restoreStateResult = this.a(next, otherEntriesOfTx = entries.stream().filter(e2 -> e2 != next.d()).map(e2 -> e2.getFileId()).collect(Collectors.toList()), FileHistoryOperation.UNDO, determinedModifications);
            if (restoreStateResult.getErrorCauses().contains((Object)UndoRedoMessageCause.RESTORE_ABORTED)) {
                this.h.redo();
                result.addMessagesFrom(restoreStateResult);
                return result;
            }
            result.addMessagesFrom(restoreStateResult);
            if (restoreStateResult.getOutcome() != null) {
                restoredFiles.add((IModifiableFile)restoreStateResult.getOutcome());
            }
            this.a((TransactionContext)null);
            restoreNavigationState = entry.getNavigationState();
        }
        this.i.a((IWorkerContext)DefaultWorkerContext.INSTANCE, this.k, determinedModifications, restoredFiles, restoreNavigationState, result);
        this.a(groups);
        this.k();
        return result;
    }

    @Override
    public String a(FileHistoryOperation operation) {
        assert (this.isEnabled()) : "Extension not enabled";
        GlobalHistory.Entry entryForRestore = null;
        entryForRestore = operation == FileHistoryOperation.UNDO ? this.d() : this.e();
        assert (entryForRestore != null) : "no history available";
        IUndoRedoProvider undoRedoProvider = this.f.get(entryForRestore.getClazz());
        assert (undoRedoProvider != null) : "'undoRedoProvider' of method 'getConfirmationMessageForNextRestore' must not be null";
        ModifiableFileHistory fileHistory = this.g.get(entryForRestore.getFileId());
        RestoreStateDto dto = this.a(entryForRestore, operation, fileHistory, true);
        return undoRedoProvider.getConfirmationMessageForNextRestore(dto);
    }

    private OperationResultWithOutcome<? extends IModifiableFile> a(bc undoRedoData, List<String> otherEntriesOfTx, FileHistoryOperation operation, EnumSet<Modification> determinedModifications) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (undoRedoData != null) : "Parameter 'undoRedoData' of method 'restoreState' must not be null";
        assert (otherEntriesOfTx != null) : "Parameter 'otherEntriesOfTx' of method 'restoreState' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'restoreState' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreState' must not be null";
        IUndoRedoProvider undoRedoProvider = undoRedoData.a();
        GlobalHistory.Entry entry = undoRedoData.d();
        RestoreStateDto dto = undoRedoData.c();
        ModifiableFileHistory fileHistory = this.g.get(entry.getFileId());
        OperationResultWithOutcome<? extends IModifiableFile> result = this.n.restoreState(undoRedoProvider, dto, determinedModifications, otherEntriesOfTx);
        determinedModifications.addAll(entry.getModifications());
        assert (result != null) : "Returned result must not be null";
        IModifiableFile restoredFile = (IModifiableFile)result.getOutcome();
        if (restoredFile == null || result.isFailure()) {
            if (operation == FileHistoryOperation.UNDO) {
                fileHistory.redoIt();
            } else if (operation == FileHistoryOperation.REDO) {
                fileHistory.undoIt();
            } else assert (false) : "Unsupported operation: " + operation.name();
            b.error(String.format("%s operation not successful for '%s'", operation.name(), dto.getCurrentStateFileEntry().toString()));
        } else {
            if (operation == FileHistoryOperation.UNDO && !entry.getIdentifyingPath().equals(restoredFile.getIdentifyingPath()) || operation == FileHistoryOperation.REDO && !fileHistory.getNextEntryForUndo().getIdentifyingPath().equals(restoredFile.getIdentifyingPath())) {
                dto.getCurrentStateFileEntry().setNeedsSave(false, true);
            } else {
                restoredFile.setNeedsSave(dto.getCurrentStateFileEntry().needsSave());
            }
            if (restoredFile.getTimestamp() != restoredFile.getFile().lastModified()) {
                b.error("Timestamps don't match for file '" + restoredFile.getIdentifyingPath() + "'");
            }
        }
        return result;
    }

    private RestoreStateDto a(GlobalHistory.Entry entry, FileHistoryOperation operation, ModifiableFileHistory fileHistory, boolean peekOnly) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entry != null) : "Parameter 'entry' of method 'initializeRestoreDto' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'initializeRestoreDto' must not be null";
        assert (fileHistory != null) : "File history must exist for '" + entry.getClazz().getCanonicalName() + "', name '" + entry.getIdentifyingPath() + "'";
        if (operation == FileHistoryOperation.UNDO && !fileHistory.isUndoPossible()) {
            return null;
        }
        if (operation == FileHistoryOperation.REDO && !fileHistory.isRedoPossible()) {
            return null;
        }
        RestoreStateDto dto = new RestoreStateDto(operation);
        dto.setModifiableFileId(entry.getFileId());
        dto.setModifiableFilePath(entry.getPath());
        ModifiableFileHistory.FileHistoryEntry currentEntry = null;
        currentEntry = operation == FileHistoryOperation.UNDO ? (peekOnly ? fileHistory.getNextEntryForUndo() : fileHistory.undoIt()) : (peekOnly ? (ModifiableFileHistory.FileHistoryEntry)fileHistory.getNextEntryForRedo() : fileHistory.redoIt());
        dto.setCurrentStateFileEntry(currentEntry);
        return dto;
    }

    @Override
    public boolean b() {
        return this.isEnabled() && this.h.isUndoPossible();
    }

    @Override
    public boolean c() {
        return this.isEnabled() && this.h.isRedoPossible();
    }

    private void k() {
        assert (this.isEnabled()) : "Extension not enabled";
        UndoRedoAvailabilityEvent event = new UndoRedoAvailabilityEvent(this.k.getExtension(ISoftwareSystemProvider.class), this.b(), this.c());
        EventManager.getInstance().dispatch((Object)this, (Event)event);
    }

    public GlobalHistory.Entry d() {
        return !this.b() ? null : ((GlobalHistory.Entry)this.h.getLastAddedEntry()).copy();
    }

    public GlobalHistory.Entry e() {
        return !this.c() ? null : ((GlobalHistory.Entry)this.h.getNextEntryForRedo()).copy();
    }

    @Override
    public int a(IModifiableFile file) {
        ModifiableFileHistory history = this.g.get(file.getFileId());
        if (history != null) {
            return history.getSize() - 1;
        }
        return -1;
    }

    private List<aI> b(List<IModifiableFile> files) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'createRevertData' must not be empty";
        ArrayList<aI> data = new ArrayList<aI>(files.size());
        for (IModifiableFile nextFile : files) {
            IUndoRedoProvider undoRedoProvider = this.f.get(nextFile.getClass());
            assert (undoRedoProvider != null) : "Parameter 'undoRedoProvider' of method 'createRevertData' must not be null";
            ModifiableFileHistory history = this.g.get(nextFile.getFileId());
            assert (history != null) : "history for file " + nextFile.getIdentifyingPath() + " must not be null";
            RestoreStateDto dto = undoRedoProvider.startRevertOperation(history, nextFile);
            assert (dto.getCurrentStateFileEntry().getPath() != null && dto.getCurrentStateFileEntry().getPath().length() > 0) : "Path of entry to history state file must not be empty";
            data.add(new aI(undoRedoProvider, nextFile, history, dto));
        }
        return data;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, List<IModifiableFile> files) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'revert' must not be null";
        assert (files != null && !files.isEmpty()) : "Parameter 'file' of method 'revert' must not be null or empty";
        this.l.d();
        OperationResult overallResult = new OperationResult("Revert");
        List<aI> revertData = this.b(files);
        Collection<AnalyzerGroup> groups = this.a(revertData);
        EnumSet<Modification> determinedModifications = EnumSet.noneOf(Modification.class);
        HashSet<Long> toBeRemovedTxIds = new HashSet<Long>();
        for (aI next : revertData) {
            RestoreStateDto dto;
            IModifiableFile file = next.d();
            IUndoRedoProvider undoRedoProvider = next.a();
            OperationResultWithOutcome<? extends IModifiableFile> result = this.n.restoreState(undoRedoProvider, dto = next.c(), determinedModifications, Collections.emptyList());
            if (result.isSuccess()) {
                file.setNeedsSave(true);
                file.setNeedsSave(false);
                for (ModifiableFileHistory.FileHistoryEntry historyEntry : undoRedoProvider.finishRevertOperation(next.e(), dto)) {
                    toBeRemovedTxIds.add(historyEntry.getTransactionId());
                    this.a(historyEntry, next.e());
                }
            }
            overallResult.addMessagesFrom(result);
        }
        this.h.removeTransactions(toBeRemovedTxIds);
        this.i.a(workerContext, this.k, determinedModifications, overallResult);
        this.a(groups);
        return overallResult;
    }

    @Override
    public boolean f() {
        return this.isEnabled() && !this.k.getUniqueExistingChild(Files.class).getModifiableFilesNeedingSave().isEmpty();
    }

    public ModifiableFileHistory.FileHistoryEntry a(String fileId) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (fileId != null && fileId.length() > 0) : "Parameter 'fileId' of method 'getLastAddedHistoryEntry' must not be empty";
        assert (this.g.containsKey(fileId)) : "No history available for file '" + fileId + "'";
        ModifiableFileHistory history = this.g.get(fileId);
        assert (history != null) : "Parameter 'history' of method 'getLastAddedHistoryEntry' must not be null";
        return (ModifiableFileHistory.FileHistoryEntry)history.getLastAddedEntry();
    }

    @Override
    public /* synthetic */ IUndoRedoEntry g() {
        return this.d();
    }

    @Override
    public /* synthetic */ IUndoRedoEntry h() {
        return this.e();
    }
}

