/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.foundation.text.IntBasedHash;
import com.hello2morrow.foundation.text.Levenshtein;
import com.hello2morrow.sonargraph.core.controller.system.base.a;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import java.util.List;
import java.util.Set;

final class d
extends a<DuplicateCodeBlock, DuplicateCodeBlockIssue, IntBasedHash> {
    public d(double similarityThreshold) {
        super(similarityThreshold);
    }

    @Override
    public double a(Set<IntBasedHash> referenceHashs, Set<IntBasedHash> occurrenceHashs) {
        assert (referenceHashs != null) : "Parameter 'referenceHashs' of method 'getSimilarity' must not be null";
        assert (occurrenceHashs != null) : "Parameter 'occurrenceHashs' of method 'getSimilarity' must not be null";
        double highestSimilarity = -1.0;
        for (IntBasedHash nextHash : occurrenceHashs) {
            double similarity = this.a(nextHash, referenceHashs);
            if (Double.compare(similarity, highestSimilarity) > 0) {
                this.a(nextHash, referenceHashs);
                highestSimilarity = similarity;
            }
            if (Double.compare(similarity, 1.0) == 0) break;
        }
        return highestSimilarity;
    }

    private double a(IntBasedHash occurrenceHashs, Set<IntBasedHash> referenceHashs) {
        double highestSimilarity = -1.0;
        for (IntBasedHash next : referenceHashs) {
            double similarity = (Double)Levenshtein.similarity((IntBasedHash)next, (IntBasedHash)occurrenceHashs).getFirst();
            if (Double.compare(similarity, highestSimilarity) > 0) {
                highestSimilarity = similarity;
            }
            if (Double.compare(similarity, 1.0) == 0) break;
        }
        return highestSimilarity;
    }

    @Override
    protected DuplicateCodeBlock a(DuplicateCodeBlockIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getAffectedElement' must not be null";
        NamedElement affected = issue.getAffectedElement();
        assert (affected instanceof DuplicateCodeBlock) : "Unexpected affected element: " + affected;
        return (DuplicateCodeBlock)affected;
    }

    @Override
    protected void a(DuplicateCodeBlock duplicate, Matching matchingInfo) {
        assert (duplicate != null) : "Parameter 'duplicate' of method 'updateMatchingInfo' must not be null";
        assert (matchingInfo != null) : "Parameter 'matchingInfo' of method 'updateMatchingInfo' must not be null";
        if (matchingInfo.getHashs().isEmpty()) {
            matchingInfo.setElementFqNamesAndHashes(duplicate.getOccurrenceNamesAndHashs());
        }
    }

    @Override
    protected Set<IntBasedHash> a(DuplicateCodeBlock duplicate) {
        assert (duplicate != null) : "Parameter 'duplicate' of method 'getElementsForSimilarityMatch' must not be null";
        return duplicate.getOccurrenceHashs();
    }

    @Override
    protected Set<IntBasedHash> a(Matching matching) {
        assert (matching != null) : "Parameter 'matching' of method 'getReferenceElementsForSimilarityMatch' must not be null";
        return matching.getHashs();
    }

    protected DuplicateCodeBlockIssue b(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getIssueFromResolution' must not be null";
        List<IIssue> issues = resolution.getAssociatedIssues();
        if (issues.size() > 0) {
            assert (issues.size() == 1) : "Only a single duplicate code block issue can be matched by a resolution. But resolution " + resolution + " matches " + issues.size();
            IIssue previousIssue = issues.get(0);
            assert (previousIssue instanceof DuplicateCodeBlockIssue) : "Unexpected issue type " + previousIssue.getClass().getCanonicalName();
            return (DuplicateCodeBlockIssue)previousIssue;
        }
        return null;
    }

    @Override
    protected /* synthetic */ NamedElementIssue a(Resolution resolution) {
        return this.b(resolution);
    }
}

