/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.pattern.SimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.resolution.GeneratedIssueBasedTaskDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class a<T extends NamedElement, I extends NamedElementIssue, S> {
    private static final Logger b = LoggerFactory.getLogger(a.class);
    private final double c;

    public a(double similarityThreshold) {
        this.c = similarityThreshold;
    }

    protected abstract T a(I var1);

    protected abstract Set<S> a(T var1);

    protected abstract Set<S> a(Matching var1);

    protected abstract I a(Resolution var1);

    protected void a(T element, Matching matching) {
        assert (element != null) : "Parameter 'element' of method 'migrateMatchingInfo' must not be null";
        assert (matching != null) : "Parameter 'matching' of method 'migrateMatchingInfo' must not be null";
    }

    public final boolean a(List<Resolution> resolutions, I issue, Set<Issue> collector) {
        assert (resolutions != null && resolutions.size() > 0) : "Parameter 'resolutions' of method 'matchResolution' must not be empty";
        assert (issue != null) : "Parameter 'issue' of method 'matchResolution' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'matchResolution' must not be null";
        boolean matched = false;
        T affectedElement = this.a(issue);
        String fqName = ((NamedElement)affectedElement).getFullyQualifiedName();
        NamedElementIssue previouslyMatchedIssue = null;
        StrictPair bestMatch = null;
        for (Resolution nextResolution : resolutions) {
            SimilarityMatchPattern previousPattern;
            assert (!(nextResolution instanceof GeneratedIssueBasedTaskDefinition)) : "'GeneratedIssueBasedTaskDefinition' not expected: " + nextResolution.getClass().getName();
            if (!nextResolution.getIssueType().matches(((Issue)issue).getKey())) continue;
            SimilarityMatchPattern pattern = nextResolution.getUniqueExistingChild(SimilarityMatchPattern.class);
            double similarityOfPreviousMatch = pattern.getSimilarityOfMatch();
            if (nextResolution.getAssociatedIssues().size() > 0 && Double.compare(similarityOfPreviousMatch, 1.0) == 0) continue;
            if (pattern.matches(fqName)) {
                if (nextResolution.getAssociatedIssues().size() > 0 && Double.compare(similarityOfPreviousMatch, 0.0) > 0) {
                    assert (Double.compare(1.0, similarityOfPreviousMatch) > 0 && pattern.getMatchedFqName() != null && !pattern.getMatchedFqName().equals(fqName)) : "There cannot be two exact matches of " + ((Issue)issue).getKey() + " issues for resolution " + nextResolution;
                    previouslyMatchedIssue = this.a(nextResolution);
                    if (previouslyMatchedIssue != null) {
                        nextResolution.reset(previouslyMatchedIssue);
                    }
                }
                ((Issue)issue).setResolution(nextResolution);
                Matching matching = nextResolution.getUniqueExistingChild(Matching.class);
                this.a(affectedElement, matching);
                pattern.setSimilarityOfMatch(1.0, fqName);
                if (b.isTraceEnabled()) {
                    b.trace("Exact match of {} found for resolution {}", (Object)((Element)affectedElement).getPresentationName(true), (Object)nextResolution.getPresentationName(true));
                }
                matched = true;
                break;
            }
            Set<S> elementsToCompare = this.a(affectedElement);
            if (elementsToCompare.isEmpty()) {
                b.warn("No fuzzy matching, because necessary information is missing for {}. Probably loaded analysis results from an old snapshot.", (Object)((Element)affectedElement).getPresentationName(true));
                continue;
            }
            Matching matching = nextResolution.getUniqueExistingChild(Matching.class);
            Set<S> referenceElements = this.a(matching);
            double similarity = this.a(referenceElements, elementsToCompare);
            if (Double.compare(similarity, this.c) < 0) continue;
            if (bestMatch == null) {
                if (Double.compare(similarity, similarityOfPreviousMatch) <= 0) continue;
                bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)nextResolution, (Object)pattern));
                continue;
            }
            int compare = Double.compare(similarity, (Double)bestMatch.getFirst());
            if (compare <= 0 || Double.compare(similarity, (previousPattern = (SimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond()).getSimilarityOfMatch()) <= 0) continue;
            bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)nextResolution, (Object)pattern));
        }
        if (!matched && bestMatch != null) {
            Resolution resolution = (Resolution)((StrictPair)bestMatch.getSecond()).getFirst();
            SimilarityMatchPattern pattern = (SimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond();
            double similarityOfPreviousMatch = pattern.getSimilarityOfMatch();
            if (resolution.getAssociatedIssues().size() > 0 && Double.compare((Double)bestMatch.getFirst(), similarityOfPreviousMatch) > 0 && pattern.getMatchedFqName() != null && !pattern.getMatchedFqName().equals(fqName) && (previouslyMatchedIssue = this.a(resolution)) != null) {
                resolution.reset(previouslyMatchedIssue);
            }
            ((Issue)issue).setResolution(resolution);
            pattern.setSimilarityOfMatch((Double)bestMatch.getFirst(), fqName);
            if (b.isDebugEnabled()) {
                b.debug("Best matching resolution ({}) found with similarity {} for {}", new Object[]{resolution.getPresentationName(true), (double)((Double)bestMatch.getFirst()), ((Element)affectedElement).getPresentationName(true)});
            }
            matched = true;
        }
        if (previouslyMatchedIssue != null) {
            collector.remove(previouslyMatchedIssue);
            if (this.a(resolutions, previouslyMatchedIssue, collector)) {
                if (b.isDebugEnabled()) {
                    b.debug("Found another resolution for previously matched issue '{}'", previouslyMatchedIssue);
                }
            } else if (b.isDebugEnabled()) {
                b.debug("Failed to find another resolution for previously matched issue '{}'", (Object)previouslyMatchedIssue.getAffectedElement());
            }
        }
        return matched;
    }

    protected abstract double a(Set<S> var1, Set<S> var2);
}

