/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.foundation.text.IntBasedHash;
import com.hello2morrow.foundation.text.Levenshtein;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IIssueWithLineContext;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.pattern.LineBasedContextSimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.SimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.resolution.GeneratedIssueBasedTaskDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceLineMatcher {
    public static final double a = 0.6;
    public static final double b = 0.4;
    private static final Logger d = LoggerFactory.getLogger(SourceLineMatcher.class);
    private final double e;

    public SourceLineMatcher(double similarityThreshold) {
        assert (0.0 <= similarityThreshold && similarityThreshold <= 1.0) : "Invalid threshold value: " + similarityThreshold;
        this.e = similarityThreshold;
    }

    public void a(List<Resolution> resolutions, Map<ElementWithIssues, List<Issue>> elementToIssues, Set<Issue> matchedCollector) {
        assert (resolutions != null && !resolutions.isEmpty()) : "Parameter 'resolutions' of method 'matchResolution' must not be empty";
        assert (elementToIssues != null && !elementToIssues.isEmpty()) : "Parameter 'elementToIssues' of method 'matchResolution' must not be empty";
        assert (matchedCollector != null) : "Parameter 'matchedCollector' of method 'matchResolution' must not be null";
        long start = System.currentTimeMillis();
        Map<String, List<LineBasedContextSimilarityMatchPattern>> originalSourceFileToPatternMap = this.a(resolutions);
        LinkedHashMap<Issue, Pair<String, String>> unmatchedIssueToPatternMap = new LinkedHashMap<Issue, Pair<String, String>>();
        HashMap<Issue, String> unmatchedIssueToFqNameMap = new HashMap<Issue, String>();
        Set issuesToMatch = elementToIssues.entrySet().stream().map(entry -> (List)entry.getValue()).flatMap(issues -> issues.stream()).collect(Collectors.toSet());
        for (Map.Entry<ElementWithIssues, List<Issue>> entry2 : elementToIssues.entrySet()) {
            ElementWithIssues nextSource = entry2.getKey();
            assert (nextSource != null && nextSource instanceof SourceFile) : "Unexpected class in method 'matchResolution': " + nextSource;
            SourceFile sourceFile = (SourceFile)nextSource;
            String originalFqName = sourceFile.getOriginalFullyQualifiedName();
            List<LineBasedContextSimilarityMatchPattern> similarityMatchPatterns = originalSourceFileToPatternMap.get(originalFqName);
            if (similarityMatchPatterns == null || similarityMatchPatterns.isEmpty()) {
                d.trace("No matching patterns for source '{}'", (Object)originalFqName);
                issuesToMatch.removeAll((Collection)entry2.getValue());
                continue;
            }
            for (Issue nextIssue : entry2.getValue()) {
                assert (nextIssue != null && nextIssue instanceof IIssueWithLineContext) : "Unexpected class in method 'matchResolution': " + nextIssue;
                IIssueWithLineContext issue = (IIssueWithLineContext)((Object)nextIssue);
                Pair<String, String> patternsFromIssue = this.a(sourceFile, issue);
                Resolution exactMatch = this.a(sourceFile, issue, similarityMatchPatterns, (String)patternsFromIssue.getFirst(), (String)patternsFromIssue.getSecond());
                if (exactMatch != null) {
                    issuesToMatch.remove(nextIssue);
                    matchedCollector.add(nextIssue);
                    continue;
                }
                unmatchedIssueToPatternMap.put(nextIssue, patternsFromIssue);
                unmatchedIssueToFqNameMap.put(nextIssue, originalFqName);
            }
        }
        for (Map.Entry<ElementWithIssues, List<Issue>> entry3 : unmatchedIssueToPatternMap.entrySet()) {
            Pair patternsFromIssue;
            Resolution resolution;
            Issue issue = (Issue)((Object)entry3.getKey());
            String originalFqName = (String)unmatchedIssueToFqNameMap.get(issue);
            List<LineBasedContextSimilarityMatchPattern> similarityPatterns = originalSourceFileToPatternMap.get(originalFqName);
            if (similarityPatterns == null || (resolution = this.a((IIssueWithLineContext)((Object)issue), similarityPatterns, (String)(patternsFromIssue = (Pair)entry3.getValue()).getFirst(), (String)patternsFromIssue.getSecond(), matchedCollector)) == null) continue;
            issuesToMatch.remove(issue);
        }
        d.debug("Needed {} ms for matching. Result: {} issues matched, {} issues unmatched to {} resolutions", new Object[]{System.currentTimeMillis() - start, matchedCollector.size(), issuesToMatch.size(), resolutions.size()});
    }

    private Resolution a(IIssueWithLineContext issue, List<LineBasedContextSimilarityMatchPattern> similarityPatterns, String originalFqNamePattern, String fqNamePattern, Set<Issue> issueCollector) {
        double similarity;
        StrictPair bestMatch = null;
        for (LineBasedContextSimilarityMatchPattern nextPattern : similarityPatterns) {
            StrictPair<Double, Set<TextModification>> similarityAndModifications;
            double similarityOfPreviousMatch = nextPattern.getSimilarityOfMatch();
            if (Double.compare(similarityOfPreviousMatch, 1.0) == 0 || Double.compare(similarity = ((Double)(similarityAndModifications = this.a(nextPattern, issue)).getFirst()).doubleValue(), this.e) < 0) continue;
            if (bestMatch == null) {
                if (Double.compare(similarity, similarityOfPreviousMatch) <= 0) continue;
                bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)nextPattern.getParent(Resolution.class, new Class[0]), (Object)nextPattern));
                continue;
            }
            int compare = Double.compare(similarity, (Double)bestMatch.getFirst());
            if (compare > 0) {
                LineBasedContextSimilarityMatchPattern previousPattern = (LineBasedContextSimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond();
                if (Double.compare(similarity, previousPattern.getSimilarityOfMatch()) <= 0) continue;
                bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)nextPattern.getParent(Resolution.class, new Class[0]), (Object)nextPattern));
                continue;
            }
            d.trace("Skipping matched pattern {}, because similarity {} was lower than that of previous best match {}", new Object[]{nextPattern, similarity, (double)((Double)bestMatch.getFirst())});
        }
        IIssueWithLineContext previouslyMatchedIssue = null;
        if (bestMatch != null) {
            Resolution resolution = (Resolution)((StrictPair)bestMatch.getSecond()).getFirst();
            LineBasedContextSimilarityMatchPattern pattern = (LineBasedContextSimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond();
            double similarityOfPreviousMatch = pattern.getSimilarityOfMatch();
            similarity = (Double)bestMatch.getFirst();
            if (Double.compare(similarity, similarityOfPreviousMatch) > 0) {
                if (pattern.getMatchedFqName() != null && !pattern.getMatchedFqName().equals(originalFqNamePattern) && !pattern.getMatchedFqName().equals(fqNamePattern) && (previouslyMatchedIssue = this.a(resolution, pattern.getMatchedFqName())) != null) {
                    d.debug("Reset resolution for issue '{}' \n\t(file {}, line {}, similarity {}) and replace it with issue \n\t'{}' (file {}, line '{}', similarity {}).", new Object[]{previouslyMatchedIssue, ((NamedElement)previouslyMatchedIssue.getAffectedElement()).getFullyQualifiedName(), previouslyMatchedIssue.getLineNumber(), similarityOfPreviousMatch, issue, ((NamedElement)issue.getAffectedElement()).getFullyQualifiedName(), issue.getLineNumber(), bestMatch.getFirst()});
                    resolution.reset(previouslyMatchedIssue);
                }
                Issue standardIssue = (Issue)((Object)issue);
                standardIssue.setResolution(resolution);
                pattern.setSimilarityOfMatch(similarity, originalFqNamePattern);
                d.debug("Best matching resolution ({}) found with similarity {} for {}", new Object[]{resolution.getPresentationName(true), (double)((Double)bestMatch.getFirst()), standardIssue.getAffectedElement().getPresentationName(true)});
            }
        }
        if (previouslyMatchedIssue != null) {
            Issue previousStandardIssue = (Issue)((Object)previouslyMatchedIssue);
            issueCollector.remove(previousStandardIssue);
            d.info("Try to find another resolution for issue {}", previouslyMatchedIssue);
            if (this.a(previouslyMatchedIssue, similarityPatterns, originalFqNamePattern, fqNamePattern, issueCollector) != null) {
                d.info("Found another resolution for previously matched issue '{}'", previouslyMatchedIssue);
            } else {
                d.warn("Failed to find another resolution for previously matched issue '{}'", previouslyMatchedIssue);
            }
        }
        if (d.isTraceEnabled()) {
            if (bestMatch == null) {
                d.trace("No resolution found for issue {}", (Object)issue);
            } else {
                d.trace("Resolution found for issue {} with similarity {}", (Object)issue, (Object)((Double)bestMatch.getFirst()));
            }
            d.trace("---");
        }
        return bestMatch == null ? null : (Resolution)((StrictPair)bestMatch.getSecond()).getFirst();
    }

    private Resolution a(SourceFile sourceFile, IIssueWithLineContext issue, List<LineBasedContextSimilarityMatchPattern> similarityPatterns, String originalFqNamePattern, String fqNamePattern) {
        assert (sourceFile != null) : "Parameter 'issue' of method 'findExactMatch' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'findExactMatch' must not be null";
        assert (similarityPatterns != null) : "Parameter 'similarityPatterns' of method 'findExactMatch' must not be null";
        assert (originalFqNamePattern != null && originalFqNamePattern.length() > 0) : "Parameter 'originalFqNamePattern' of method 'findExactMatch' must not be empty";
        NamedElement match = null;
        int index = -1;
        for (LineBasedContextSimilarityMatchPattern nextPattern : similarityPatterns) {
            double similarityOfPreviousMatch = nextPattern.getSimilarityOfMatch();
            ++index;
            if (Double.compare(similarityOfPreviousMatch, 1.0) == 0 || !nextPattern.matches(originalFqNamePattern) && (fqNamePattern == null || !nextPattern.matches(fqNamePattern))) continue;
            match = nextPattern;
            break;
        }
        if (match != null) {
            Resolution resolution = match.getParent(Resolution.class, new Class[0]);
            ((Issue)((Object)issue)).setResolution(resolution);
            ((SimilarityMatchPattern)match).setSimilarityOfMatch(1.0, originalFqNamePattern);
            similarityPatterns.remove(index);
            return resolution;
        }
        return null;
    }

    private Map<String, List<LineBasedContextSimilarityMatchPattern>> a(List<Resolution> resolutions) {
        assert (resolutions != null) : "Parameter 'resolutions' of method 'createSourceFileToPatternMap' must not be null";
        HashMap<String, List<LineBasedContextSimilarityMatchPattern>> result = new HashMap<String, List<LineBasedContextSimilarityMatchPattern>>();
        for (Resolution next : resolutions) {
            for (LineBasedContextSimilarityMatchPattern nextPattern : next.getChildren(LineBasedContextSimilarityMatchPattern.class)) {
                String originalSourceFqName = nextPattern.getSourceFileOriginalFqName();
                List patternsPerSource = result.computeIfAbsent(originalSourceFqName, name -> new ArrayList(1));
                patternsPerSource.add(nextPattern);
            }
        }
        return result;
    }

    private Pair<String, String> a(SourceFile sourceFile, IIssueWithLineContext issue) {
        String fqName;
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'createPatternsForIssue' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'createPatternsForIssue' must not be null";
        String originalFqName = sourceFile.getOriginalFullyQualifiedName();
        if (originalFqName.equals(fqName = sourceFile.getFullyQualifiedName())) {
            fqName = null;
        }
        String originalFqNamePattern = LineBasedContextSimilarityMatchPattern.createPattern(originalFqName, issue.getLineNumber(), issue.getLineText(), issue.getPrefixHashs(), issue.getPostfixHashs());
        String fqNamePattern = null;
        if (fqName != null) {
            fqNamePattern = LineBasedContextSimilarityMatchPattern.createPattern(fqName, issue.getLineNumber(), issue.getLineText(), issue.getPrefixHashs(), issue.getPostfixHashs());
        }
        return new Pair((Object)originalFqNamePattern, fqNamePattern);
    }

    public boolean a(List<Resolution> resolutions, IIssueWithLineContext issue, Set<Issue> collector) {
        assert (resolutions != null) : "Parameter 'resolutions' of method 'matchResolution' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'matchResolution' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'matchResolution' must not be null";
        if (d.isTraceEnabled()) {
            d.trace("---");
            d.trace("Find matching resolution for issue {}", (Object)issue);
        }
        boolean matched = false;
        SourceFile affectedElement = this.a(issue);
        Pair<String, String> patterns = this.a(affectedElement, issue);
        String originalFqNamePattern = (String)patterns.getFirst();
        String fqNamePattern = (String)patterns.getSecond();
        Issue standardIssue = (Issue)((Object)issue);
        Pair<Resolution, IIssueWithLineContext> exactMatchResult = this.a(resolutions, issue, originalFqNamePattern, fqNamePattern);
        if (exactMatchResult != null) {
            collector.add(standardIssue);
            IIssueWithLineContext issueNeedingMatch = (IIssueWithLineContext)exactMatchResult.getSecond();
            if (issueNeedingMatch != null) {
                Issue standardIssueNeedingMatch = (Issue)((Object)issueNeedingMatch);
                collector.remove(standardIssueNeedingMatch);
                ArrayList<Resolution> reduced = new ArrayList<Resolution>(resolutions);
                reduced.remove(exactMatchResult.getFirst());
                this.a(reduced, issueNeedingMatch, collector);
            }
            return true;
        }
        double similarity = -1.0;
        IIssueWithLineContext previouslyMatchedIssue = null;
        StrictPair bestMatch = null;
        for (Resolution nextResolution : resolutions) {
            assert (!(nextResolution instanceof GeneratedIssueBasedTaskDefinition)) : "'GeneratedIssueBasedTaskDefinition' not expected: " + nextResolution.getClass().getName();
            if (!nextResolution.getIssueType().matches(issue.getKey())) continue;
            for (LineBasedContextSimilarityMatchPattern nextPattern : nextResolution.getChildren(LineBasedContextSimilarityMatchPattern.class)) {
                StrictPair<Double, Set<TextModification>> similarityAndModifications;
                double similarityOfPreviousMatch = nextPattern.getSimilarityOfMatch();
                if (nextResolution.getAssociatedIssues().size() > 0 && Double.compare(similarityOfPreviousMatch, 1.0) == 0 || Double.compare(similarity = ((Double)(similarityAndModifications = this.a(nextPattern, issue)).getFirst()).doubleValue(), this.e) < 0) continue;
                if (bestMatch == null) {
                    if (Double.compare(similarity, similarityOfPreviousMatch) <= 0) continue;
                    bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)nextResolution, (Object)nextPattern));
                    continue;
                }
                int compare = Double.compare(similarity, (Double)bestMatch.getFirst());
                if (compare > 0) {
                    LineBasedContextSimilarityMatchPattern previousPattern = (LineBasedContextSimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond();
                    if (Double.compare(similarity, previousPattern.getSimilarityOfMatch()) <= 0) continue;
                    bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)nextResolution, (Object)nextPattern));
                    continue;
                }
                d.trace("Skipping matched resolution {}, because similarity {} was lower than that of best match {}", new Object[]{nextResolution, similarity, (double)((Double)bestMatch.getFirst())});
            }
        }
        if (!matched && bestMatch != null) {
            Resolution resolution = (Resolution)((StrictPair)bestMatch.getSecond()).getFirst();
            LineBasedContextSimilarityMatchPattern pattern = (LineBasedContextSimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond();
            double similarityOfPreviousMatch = pattern.getSimilarityOfMatch();
            similarity = (Double)bestMatch.getFirst();
            if (Double.compare(similarity, similarityOfPreviousMatch) > 0) {
                if (pattern.getMatchedFqName() != null && !pattern.getMatchedFqName().equals(originalFqNamePattern) && !pattern.getMatchedFqName().equals(fqNamePattern) && (previouslyMatchedIssue = this.a(resolution, pattern.getMatchedFqName())) != null) {
                    d.debug("Reset resolution for issue '{}' \n\t(file {}, line {}, similarity {}) and replace it with issue \n\t'{}' (file {}, line '{}', similarity {}).", new Object[]{previouslyMatchedIssue, ((NamedElement)previouslyMatchedIssue.getAffectedElement()).getFullyQualifiedName(), previouslyMatchedIssue.getLineNumber(), similarityOfPreviousMatch, issue, ((NamedElement)issue.getAffectedElement()).getFullyQualifiedName(), issue.getLineNumber(), bestMatch.getFirst()});
                    resolution.reset(previouslyMatchedIssue);
                }
                standardIssue.setResolution(resolution);
                pattern.setSimilarityOfMatch(similarity, originalFqNamePattern);
                d.debug("Best matching resolution ({}) found with similarity {} for {}", new Object[]{resolution.getPresentationName(true), (double)((Double)bestMatch.getFirst()), affectedElement.getPresentationName(true)});
                matched = true;
            }
        }
        if (previouslyMatchedIssue != null) {
            Issue previousStandardIssue = (Issue)((Object)previouslyMatchedIssue);
            collector.remove(previousStandardIssue);
            d.info("Try to find another resolution for issue {}", previouslyMatchedIssue);
            if (this.a(resolutions, previouslyMatchedIssue, collector)) {
                d.info("Found another resolution for previously matched issue '{}'", previouslyMatchedIssue);
            } else {
                d.warn("Failed to find another resolution for previously matched issue '{}'", previouslyMatchedIssue);
            }
        }
        if (d.isTraceEnabled()) {
            if (!matched) {
                d.trace("No resolution found for issue {}", (Object)issue);
            } else {
                d.trace("Resolution found for issue {} with similarity {}", (Object)issue, (Object)similarity);
            }
            d.trace("---");
        }
        return matched;
    }

    private Pair<Resolution, IIssueWithLineContext> a(List<Resolution> resolutions, IIssueWithLineContext issue, String originalFqNamePattern, String fqNamePattern) {
        assert (resolutions != null) : "Parameter 'resolutions' of method 'findExactMatch' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'findExactMatch' must not be null";
        assert (originalFqNamePattern != null) : "Parameter 'originalFqNamePattern' of method 'findExactMatch' must not be null";
        for (Resolution nextResolution : resolutions) {
            assert (!(nextResolution instanceof GeneratedIssueBasedTaskDefinition)) : "'GeneratedIssueBasedTaskDefinition' not expected: " + nextResolution.getClass().getName();
            if (!nextResolution.getIssueType().matches(issue.getKey())) continue;
            for (LineBasedContextSimilarityMatchPattern nextPattern : nextResolution.getChildren(LineBasedContextSimilarityMatchPattern.class)) {
                double similarityOfPreviousMatch = nextPattern.getSimilarityOfMatch();
                if (nextResolution.getAssociatedIssues().size() > 0 && Double.compare(similarityOfPreviousMatch, 1.0) == 0 || !nextPattern.matches(originalFqNamePattern) && (fqNamePattern == null || !nextPattern.matches(originalFqNamePattern))) continue;
                IIssueWithLineContext previouslyMatchedIssue = null;
                if (nextResolution.getAssociatedIssues().size() > 0 && Double.compare(similarityOfPreviousMatch, 0.0) > 0) {
                    assert (Double.compare(1.0, similarityOfPreviousMatch) > 0 && nextPattern.getMatchedFqName() != null && !nextPattern.getMatchedFqName().equals(fqNamePattern) && !nextPattern.getMatchedFqName().equals(originalFqNamePattern)) : "There cannot be two exact matches of " + issue.getKey() + " issues for resolution " + nextResolution;
                    previouslyMatchedIssue = this.a(nextResolution, nextPattern.getMatchedFqName());
                    if (previouslyMatchedIssue != null) {
                        nextResolution.reset(previouslyMatchedIssue);
                    }
                }
                ((Issue)((Object)issue)).setResolution(nextResolution);
                nextPattern.setSimilarityOfMatch(1.0, originalFqNamePattern);
                return new Pair((Object)nextResolution, (Object)previouslyMatchedIssue);
            }
        }
        return null;
    }

    private StrictPair<Double, Set<TextModification>> a(LineBasedContextSimilarityMatchPattern pattern, IIssueWithLineContext issue) {
        assert (pattern != null) : "Parameter 'pattern' of method 'getSimilarity' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'getSimilarity' must not be null";
        return SourceLineMatcher.a(issue, pattern.getSourceFileOriginalFqName(), pattern.getLine(), pattern.getLineNumber(), pattern.getPrefixHashs(), pattern.getPostfixHashs());
    }

    public static StrictPair<Double, Set<TextModification>> a(IIssueWithLineContext issue, String fqName, String lineText, int lineNumber, IntBasedHash prefixHashs, IntBasedHash postfixHashs) {
        double postfixSimilarity;
        double prefixSimilarity;
        int diffLineNumbers;
        double lineNumberSimilarity;
        assert (issue != null) : "Parameter 'issue' of method 'getSimilarity' must not be null";
        assert (fqName != null) : "Parameter 'fqName' of method 'getSimilarity' must not be null";
        assert (lineText != null) : "Parameter 'lineText' of method 'getSimilarity' must not be null";
        assert (prefixHashs != null) : "Parameter 'prefixHashs' of method 'getSimilarity' must not be null";
        assert (postfixHashs != null) : "Parameter 'postfixHashs' of method 'getSimilarity' must not be null";
        String textFromIssue = issue.getLineText();
        NamedElement affectedElement = (NamedElement)issue.getAffectedElement();
        String originalFqName = affectedElement.getOriginalFullyQualifiedName();
        if (!originalFqName.equals(fqName)) {
            return new StrictPair((Object)-1.0, EnumSet.of(TextModification.FILE));
        }
        StrictPair lineSimilarityAndDistance = Levenshtein.similarity((String)lineText.trim().toLowerCase(), (String)textFromIssue.trim().toLowerCase(), (double)0.4);
        if (lineSimilarityAndDistance == null) {
            return new StrictPair((Object)-1.0, EnumSet.of(TextModification.LINE_TEXT));
        }
        double lineSimilarity = (Double)lineSimilarityAndDistance.getFirst();
        LinkedHashSet<TextModification> modifications = new LinkedHashSet<TextModification>();
        if (SourceLineMatcher.a(lineSimilarity)) {
            modifications.add(TextModification.LINE_TEXT);
        }
        if (SourceLineMatcher.a(lineNumberSimilarity = 1.0 - (double)(diffLineNumbers = Math.abs(lineNumber - issue.getLineNumber())) * 1.0 / (double)(lineNumber + issue.getLineNumber()))) {
            modifications.add(TextModification.LINE_NUMBER);
        }
        if (SourceLineMatcher.a(prefixSimilarity = ((Double)Levenshtein.similarity((IntBasedHash)prefixHashs, (IntBasedHash)issue.getPrefixHashs()).getFirst()).doubleValue())) {
            modifications.add(TextModification.CONTEXT);
        }
        if (SourceLineMatcher.a(postfixSimilarity = ((Double)Levenshtein.similarity((IntBasedHash)postfixHashs, (IntBasedHash)issue.getPostfixHashs()).getFirst()).doubleValue())) {
            modifications.add(TextModification.CONTEXT);
        }
        int lineTextWeight = 15;
        boolean lineNumberWeight = true;
        int prefixSimilarityWeight = 6;
        int postfixSimlarityWeight = 8;
        double numerator = lineSimilarity * 15.0 + lineNumberSimilarity * 1.0 + prefixSimilarity * 6.0 + postfixSimilarity * 8.0;
        int denominator = 30;
        double similarity = numerator / 30.0;
        if (d.isTraceEnabled()) {
            d.trace("Calculated similarity {} between pattern fqName '{}', line {}, text '{}' and issue fqName '{}', line {}, text '{}'", new Object[]{similarity, fqName, lineNumber, lineText.trim(), originalFqName, issue.getLineNumber(), textFromIssue.trim()});
        }
        if (modifications.isEmpty()) {
            modifications.add(TextModification.UNMODIFIED);
        }
        return new StrictPair((Object)similarity, modifications);
    }

    private static boolean a(double similarity) {
        return Double.compare(similarity, 1.0) < 0;
    }

    private IIssueWithLineContext a(Resolution resolution, String matchedFqName) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getIssueFromResolution' must not be null";
        assert (matchedFqName != null && matchedFqName.length() > 0) : "Parameter 'matchedFqName' of method 'getIssueFromResolution' must not be empty";
        IIssueWithLineContext match = null;
        for (IIssue nextIssue : resolution.getAssociatedIssues()) {
            assert (nextIssue instanceof IIssueWithLineContext) : "Unexpected class for issue: " + nextIssue;
            IIssueWithLineContext issue = (IIssueWithLineContext)nextIssue;
            SourceFile file = this.a(issue);
            String fqNamePattern = LineBasedContextSimilarityMatchPattern.createPattern(file.getFullyQualifiedName(), issue.getLineNumber(), issue.getLineText(), issue.getPrefixHashs(), issue.getPostfixHashs());
            if (matchedFqName.equals(fqNamePattern)) {
                match = issue;
                break;
            }
            String originalFqNamePattern = LineBasedContextSimilarityMatchPattern.createPattern(file.getOriginalFullyQualifiedName(), issue.getLineNumber(), issue.getLineText(), issue.getPrefixHashs(), issue.getPostfixHashs());
            if (!matchedFqName.equals(originalFqNamePattern)) continue;
            match = issue;
            break;
        }
        return match;
    }

    private SourceFile a(IIssueWithLineContext issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getAffectedElement' must not be null";
        Element affectedElement = issue.getAffectedElement();
        assert (affectedElement != null && affectedElement instanceof SourceFile) : "Unexpected class in method 'getAffectedElement': " + affectedElement;
        return (SourceFile)affectedElement;
    }

    public static final class TextModification
    extends Enum<TextModification>
    implements IStandardEnumeration {
        public static final /* enum */ TextModification UNMODIFIED = new TextModification("Unmodified");
        public static final /* enum */ TextModification LINE_TEXT = new TextModification("Text");
        public static final /* enum */ TextModification LINE_NUMBER = new TextModification("Line");
        public static final /* enum */ TextModification FILE = new TextModification("Different File");
        public static final /* enum */ TextModification CONTEXT = new TextModification("Context");
        private String m_presentationName;
        private static final /* synthetic */ TextModification[] ENUM$VALUES;

        static {
            ENUM$VALUES = new TextModification[]{UNMODIFIED, LINE_TEXT, LINE_NUMBER, FILE, CONTEXT};
        }

        private TextModification(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentation' of method 'TextModification' must not be empty";
            this.m_presentationName = presentationName;
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public static TextModification[] values() {
            TextModification[] textModificationArray = ENUM$VALUES;
            int n2 = textModificationArray.length;
            TextModification[] textModificationArray2 = new TextModification[n2];
            System.arraycopy(ENUM$VALUES, 0, textModificationArray2, 0, n2);
            return textModificationArray2;
        }

        public static TextModification valueOf(String string) {
            return Enum.valueOf(TextModification.class, string);
        }
    }
}

