/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.a;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.core.model.transaction.UndoRedoMessageCause;
import com.hello2morrow.sonargraph.core.persistence.system.settings.AnalyzerConfigurationPersistence;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class b
extends com.hello2morrow.sonargraph.core.controller.system.base.b {
    private final Installation c;
    private final SoftwareSystem d;

    public b(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'AnalyzerConfigurationUndoRedoProvider' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'AnalyzerConfigurationUndoRedoProvider' must not be null";
        this.c = installation;
        this.d = softwareSystem;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(AnalyzerConfigurationFile.class);
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be empty";
        a analyzerAdapter = this.d.getExtension(c.class).a(identifyingPath);
        assert (analyzerAdapter != null) : "Parameter 'analyzerAdapter' of method 'getAnalyzerExecutionInfo' must not be null";
        return AnalyzerExecutionInfo.groups(analyzerAdapter.n().getAffectedGroups());
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeModifiableFileToStream' must not be null";
        assert (file instanceof AnalyzerConfigurationFile) : "Unexpected class: " + file.getClass().getName();
        assert (outputStream != null) : "Parameter 'outputStream' of method 'writeModifiableFileToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        c analyzerExtension = this.d.getExtension(c.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = (AnalyzerConfigurationFile)file;
        IAnalyzerId analyzerId = analyzerConfigurationFile.getAnalyzerId();
        assert (analyzerExtension.e(analyzerId)) : "Analyzer not licensed: " + analyzerId;
        AnalyzerConfiguration configuration = analyzerExtension.b(analyzerId);
        assert (configuration != null) : "Missing configuration for analyzer: " + analyzerId;
        new AnalyzerConfigurationPersistence(analyzerConfigurationFile).save(this.c.getVersion(), configuration, outputStream, result);
    }

    @Override
    public OperationResultWithOutcome<? extends IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, final RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        c analyzerExtension = this.d.getExtension(c.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = this.d.getUniqueExistingChild(Files.class).getAnalyzers().getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof AnalyzerConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + namedElement));
                }
                return ((AnalyzerConfigurationFile)namedElement).getFileId().equals(dto.getModifiableFileId());
            }
        }, AnalyzerConfigurationFile.class);
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restoring configuration for analyzer '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "'");
        if (analyzerConfigurationFile == null) {
            result.addError((OperationResult.IMessageCause)UndoRedoMessageCause.ELEMENT_TO_RESTORE_MISSING);
            return result;
        }
        result.setOutcome((Object)analyzerConfigurationFile);
        AnalyzerConfiguration configuration = analyzerExtension.b(analyzerConfigurationFile.getAnalyzerId());
        configuration.reset();
        result.addMessagesFrom(new AnalyzerConfigurationPersistence(analyzerConfigurationFile).load(configuration, inputStream));
        analyzerExtension.a_((IWorkerContext)DefaultWorkerContext.INSTANCE, AnalyzerConfigurationChangeMode.RESTORE, configuration, null, (OperationResult)result);
        return result;
    }
}

