/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.file.DirectoryScanner;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aT;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controllerinterface.system.s;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.QualityModelFileDescriptor;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.persistence.base.XmlRootElementDetector;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.QualityGatePersistence;
import com.hello2morrow.sonargraph.core.persistence.script.ScriptPersistence;
import com.hello2morrow.sonargraph.core.persistence.system.settings.AnalyzerConfigurationPersistence;
import com.hello2morrow.sonargraph.core.persistence.system.settings.PluginConfigurationPersistence;
import com.hello2morrow.sonargraph.core.persistence.treemap.TreeMapPersistence;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlElementContentExtractor;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class az
extends Extension
implements s {
    private static final Logger a = LoggerFactory.getLogger(az.class);
    private final aa c;

    @Override
    public final IPathValidator c() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                for (QualityModelFileDescriptor nextQualityModelFileDescriptor : az.this.d()) {
                    if (newInput == null || !newInput.getAbsolutePath().equals(nextQualityModelFileDescriptor.getSymbolicFile().getAbsolutePath())) continue;
                    return result;
                }
                if (newInput != null && newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput == null || !newInput.exists()) {
                    result.addError("Invalid path");
                } else if (!newInput.isArchive() || !FileUtility.getExtension((TFile)newInput).equals(CoreFileType.QUALITY_MODEL.getDefaultExtension())) {
                    result.addError("Not a valid quality model file");
                }
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.FILE;
            }
        };
    }

    public az(aa languageProviderAccessor) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'QualityModelImportExtension' must not be null";
        this.c = languageProviderAccessor;
    }

    protected final void a(TFile filePath, final ImportQualityModel importQualityModel) {
        assert (filePath != null) : "Parameter 'filePath' of method 'createQualityModel' must not be null";
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'collectCandidates' must not be null";
        DirectoryScanner rootsScanner = new DirectoryScanner(Collections.emptyList(), true);
        rootsScanner.scan(filePath, new DirectoryScanner.IFileConsumer(){

            public IFileType accepts(TFile file) {
                if (!b && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'accepts' must not be null");
                }
                return az.this.b(file);
            }

            public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
                int pos;
                if (!b && rootPathBeingScanned == null) {
                    throw new AssertionError((Object)"Parameter 'rootPathBeingScanned' of method 'consume' must not be null");
                }
                if (!b && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'consume' must not be null");
                }
                if (!b && fileType == null) {
                    throw new AssertionError((Object)"Parameter 'fileType' of method 'consume' must not be null");
                }
                String identifyingPath = FileUtility.calculateRelativePath((TFile)file, (TFile)rootPathBeingScanned);
                if (identifyingPath.startsWith("./") && (pos = (identifyingPath = identifyingPath.substring("./".length())).indexOf(47)) != -1 && !(identifyingPath = identifyingPath.substring(pos + 1)).isEmpty()) {
                    identifyingPath = "./" + identifyingPath;
                    ModifiableFileCandidate fileCandidate = new ModifiableFileCandidate(identifyingPath, file, fileType, fileType.getImageResourceName());
                    String description = az.this.a(file, fileType);
                    importQualityModel.addCandidate(fileCandidate, description);
                    return;
                }
            }

            public boolean continueScanning(TFile rootPathBeingScanned, TFile path) {
                return true;
            }
        });
    }

    protected final String a(TFile file, IFileType type) {
        assert (file != null) : "Parameter 'file' of method 'determineDescription' must not be null";
        assert (type != null) : "Parameter 'type' of method 'determineDescription' must not be null";
        if (!(type instanceof CoreFileType)) {
            return null;
        }
        CoreFileType coreType = (CoreFileType)type;
        switch (coreType) {
            case ARCHITECTURE: 
            case ANALYZER_CONFIGURATION: 
            case WORKSPACE_PROFILE: 
            case SOFTWARE_SYSTEM_SETTINGS: {
                return null;
            }
            case GROOVY_SCRIPT: 
            case RUN_CONFIGURATION: 
            case MODEL: 
            case ARCHITECTURAL_VIEW: 
            case PLUGIN_CONFIGURATION: 
            case TREEMAP: 
            case QUALITY_GATE: {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedInputStream in = new BufferedInputStream((InputStream)new TFileInputStream((File)file));){
                        return XmlElementContentExtractor.process((InputStream)in, (String)"description");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    a.error("Failed to determine description of " + file.getAbsolutePath(), (Throwable)e2);
                    break;
                }
            }
            default: {
                assert (false) : "Unsupported file type: " + type;
                break;
            }
        }
        return null;
    }

    @Override
    public ImportQualityModel a(TFile filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'createQualityModel' must not be null";
        ImportQualityModel importQualityModel = new ImportQualityModel();
        this.a(filePath, importQualityModel);
        return importQualityModel;
    }

    @Override
    public List<QualityModelFileDescriptor> d() {
        ArrayList<QualityModelFileDescriptor> qualityModelDescriptors = new ArrayList<QualityModelFileDescriptor>();
        String coreQMName = "Default" + CoreFileType.QUALITY_MODEL.getDefaultExtension();
        qualityModelDescriptors.add(new QualityModelFileDescriptor("com.hello2morrow.sonargraph.core", coreQMName, "Core/" + coreQMName, null));
        ArrayList<QualityModelFileDescriptor> qualityModelLanguageSpecificDescriptors = new ArrayList<QualityModelFileDescriptor>();
        for (Z nextLanguageProvider : this.c.d()) {
            qualityModelLanguageSpecificDescriptors.add(nextLanguageProvider.p());
        }
        Collections.sort(qualityModelLanguageSpecificDescriptors, new Comparator<QualityModelFileDescriptor>(){

            public int a(QualityModelFileDescriptor descriptor1, QualityModelFileDescriptor descriptor2) {
                if (!b && descriptor1 == null) {
                    throw new AssertionError((Object)"Parameter 'descriptor1' of method 'compare' must not be null");
                }
                if (!b && descriptor2 == null) {
                    throw new AssertionError((Object)"Parameter 'descriptor2' of method 'compare' must not be null");
                }
                return descriptor1.getFileName().compareTo(descriptor2.getFileName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((QualityModelFileDescriptor)object, (QualityModelFileDescriptor)object2);
            }
        });
        qualityModelDescriptors.addAll(qualityModelLanguageSpecificDescriptors);
        return qualityModelDescriptors;
    }

    private final IFileType b(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'determineFileType' must not be null";
        String fileName = file.getName();
        if (CoreFileType.ARCHITECTURE.endsWith(fileName)) {
            return CoreFileType.ARCHITECTURE;
        }
        if (CoreFileType.RUN_CONFIGURATION.endsWith(fileName)) {
            return CoreFileType.RUN_CONFIGURATION;
        }
        String extension = FileUtility.getExtension((String)fileName);
        if (".xml".equals(extension)) {
            String rootElement = XmlRootElementDetector.process(file);
            if (rootElement == null || rootElement.trim().isEmpty()) {
                a.error("No root element determined of XML file '" + file.getAbsolutePath() + "'");
                return null;
            }
            if (AnalyzerConfigurationPersistence.isValidRootElement(rootElement)) {
                return CoreFileType.ANALYZER_CONFIGURATION;
            }
            if (PluginConfigurationPersistence.isValidRootElement(rootElement)) {
                return CoreFileType.PLUGIN_CONFIGURATION;
            }
            if (ScriptPersistence.isValidRootElement(rootElement)) {
                return CoreFileType.GROOVY_SCRIPT;
            }
            if (aT.a(rootElement)) {
                return CoreFileType.SOFTWARE_SYSTEM_SETTINGS;
            }
            if (QualityGatePersistence.isValidRootElement(rootElement)) {
                return CoreFileType.QUALITY_GATE;
            }
            if (TreeMapPersistence.isValidRootElement(rootElement)) {
                return CoreFileType.TREEMAP;
            }
        }
        if (CoreFileType.GROOVY_SCRIPT.endsWith(fileName)) {
            return CoreFileType.GROOVY_SCRIPT;
        }
        return null;
    }
}

