/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.controller.system.QualityModelMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.S;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.h;
import com.hello2morrow.sonargraph.core.controller.system.az;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.bi;
import com.hello2morrow.sonargraph.core.controllerinterface.system.r;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.ExportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class ay
extends az
implements r {
    private final g c;
    private final SoftwareSystem d;

    public ay(aa languageProviderAccessor, SoftwareSystem softwareSystem, g finishModelProcessor) {
        super(languageProviderAccessor);
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'QualityModelExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'QualityModelExtension' must not be null";
        this.c = finishModelProcessor;
        this.d = softwareSystem;
    }

    @Override
    public IPathValidator a() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput != null && newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput == null || !newInput.exists()) {
                    result.addError("Invalid path");
                } else if (!newInput.isDirectory()) {
                    result.addError("Is not a directory");
                } else if (!newInput.canWrite()) {
                    result.addError("No write permission");
                }
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    @Override
    public ExportQualityModel b() {
        ArrayList<IModifiableFile> availableFiles = new ArrayList<IModifiableFile>();
        for (S nextProvider : this.d.getExtensions(S.class)) {
            availableFiles.addAll(nextProvider.e());
        }
        ExportQualityModel model = new ExportQualityModel(availableFiles);
        for (IModifiableFile next : availableFiles) {
            model.addCandidate(next, this.a(next.getFile(), next.getFileType()));
        }
        return model;
    }

    OperationResult a(IWorkerContext workerContext, ImportQualityModel importModel, EnumSet<Modification> modifications) {
        assert (workerContext != null) : "Parameter 'context' of method 'importQualityModel' must not be null";
        assert (importModel != null) : "Parameter 'importModel' of method 'enclosing_method' must not be null";
        OperationResult result = new OperationResult("Import quality model");
        List<S> providers = this.d.getExtensions(S.class);
        for (S nextProvider : providers) {
            nextProvider.a(result);
        }
        if (result.isFailure()) {
            return result;
        }
        if (modifications != null) {
            this.d.getExtension(h.class).a(ResetMode.ALL);
        }
        if (importModel.discardCurrentContent()) {
            workerContext.working("Remove existing system files", true);
            for (S nextProvider : providers) {
                nextProvider.a(workerContext, modifications, result);
            }
        }
        workerContext.working("Import system files", true);
        for (S nextProvider : providers) {
            nextProvider.a(workerContext, importModel, modifications, result);
        }
        for (S nextProvider : providers) {
            nextProvider.b(workerContext, modifications, result);
        }
        if (modifications != null) {
            if (modifications.contains((Object)Modification.WORKSPACE_MODIFIED) || modifications.contains((Object)Modification.WORKSPACE_SETUP_MODIFIED)) {
                bi.a(this.d, result);
            }
            this.c.a(workerContext, this.d, modifications, result);
            this.d.getExtension(h.class).b(workerContext);
        }
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext context, ImportQualityModel importModel) {
        return this.a(context, importModel, EnumSet.noneOf(Modification.class));
    }

    @Override
    public OperationResult a(ExportQualityModel exportModel) {
        assert (exportModel != null && exportModel.isValid()) : "Parameter 'exportModel' of method 'exportQualityModel' must not be null and must contain some elements to export";
        OperationResult result = new OperationResult("Export quality model");
        try {
            TFile qualityModelFile = new TFile(exportModel.getFilePath()).getCanonicalFile();
            if (qualityModelFile.exists()) {
                qualityModelFile.rm_r();
            }
            block2: for (ExportQualityModel.ExportQualityModelCandidate nextCandidate : exportModel.getCandidates()) {
                if (!nextCandidate.isIncluded()) continue;
                for (S nextProvider : this.d.getExtensions(S.class)) {
                    IModifiableFile nextModifiableFile;
                    if (!nextProvider.a(nextModifiableFile = nextCandidate.getModifiableFile())) continue;
                    TFile nextExportFile = new TFile((File)qualityModelFile, String.valueOf(nextProvider.f()) + "/" + nextModifiableFile.getIdentifyingPath()).getNormalizedFile();
                    nextExportFile.getParentFile().mkdirs();
                    nextProvider.a(nextCandidate.getModifiableFile(), nextExportFile, result);
                    continue block2;
                }
            }
            TrueZipFacade.clear((TFile)qualityModelFile);
            result.addInfo((OperationResult.IMessageCause)QualityModelMessageCause.QUALITY_MODEL_EXPORTED_TO_FILE, "File: " + FileUtility.getIdentifyingPath((TFile)qualityModelFile));
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
        }
        return result;
    }

    @Override
    public ImportQualityModel a(TFile filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'createQualityModel' must not be null";
        ArrayList<IModifiableFile> availableFiles = new ArrayList<IModifiableFile>();
        for (S nextProvider : this.d.getExtensions(S.class)) {
            availableFiles.addAll(nextProvider.e());
        }
        ImportQualityModel importQualityModel = new ImportQualityModel(availableFiles);
        this.a(filePath, importQualityModel);
        return importQualityModel;
    }

    @Override
    public boolean isExportPossible() {
        for (S nextProvider : this.d.getExtensions(S.class)) {
            if (nextProvider.e().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

