/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.S;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.c;
import com.hello2morrow.sonargraph.core.controller.system.aw;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.j;
import com.hello2morrow.sonargraph.core.controller.system.base.m;
import com.hello2morrow.sonargraph.core.controller.system.d.a;
import com.hello2morrow.sonargraph.core.controller.system.d.b;
import com.hello2morrow.sonargraph.core.controllerinterface.system.q;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.QualityGateCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElementInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilterInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateCheckConfigurationInconsistent;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.QualityGatePersistence;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class av
extends aw
implements S,
c,
j,
m,
q,
IModifiableFileDeltaKey {
    private final g c;

    public av(Installation installation, SoftwareSystem softwareSystem, g finishModelProcessor) {
        super(installation, softwareSystem);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'QualityGateExtension' must not be null";
        this.c = finishModelProcessor;
        this.c.a(this);
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        Files files = this.d().getUniqueExistingChild(Files.class);
        QualityGates qualityGates = files.getQualityGatesDirectory();
        TFile directory = qualityGates.getDirectoryFile();
        String currentVersion = this.g().getVersion().toString();
        boolean writeToDisk = this.d().getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT;
        new a(writeToDisk, false).a(currentVersion, directory, result);
        new b(writeToDisk, true).a(currentVersion, directory, result);
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        this.b(softwareSystem);
    }

    private void b(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'checkQualityGateCheckConfiguration' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = softwareSystem.getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = analyzerExtension.a(CoreAnalyzerId.QUALITY_GATES);
        if (analyzerConfigurationFile != null) {
            analyzerConfigurationFile.removeIssues();
            AnalyzerConfiguration configuration = analyzerExtension.b(CoreAnalyzerId.QUALITY_GATES);
            if (configuration != null) {
                Map<String, QualityGate> identifyingPathToQualityGate = this.c().getChildren(QualityGate.class).stream().collect(Collectors.toMap(ModifiableFile::getIdentifyingPath, qg -> qg));
                assert (configuration instanceof QualityGateCheckConfiguration) : "Unexpected class in method 'initialized': " + configuration;
                QualityGateCheckConfiguration qualityGateCheckConfiguration = (QualityGateCheckConfiguration)configuration;
                qualityGateCheckConfiguration.resetWarnings();
                for (String nextIdentifyingPath : qualityGateCheckConfiguration.getIdentifyingPaths()) {
                    QualityGate qualityGate = identifyingPathToQualityGate.remove(nextIdentifyingPath);
                    if (qualityGate == null) {
                        analyzerConfigurationFile.addIssue(new QualityGateCheckConfigurationInconsistent(analyzerConfigurationFile, "Quality Gate file '" + nextIdentifyingPath + "' not found."));
                        qualityGateCheckConfiguration.setWarning(nextIdentifyingPath, "Quality Gate file not found.");
                        continue;
                    }
                    qualityGate.setChecked(true);
                }
                for (QualityGate nextToSetUnchecked : identifyingPathToQualityGate.values()) {
                    nextToSetUnchecked.setChecked(false);
                }
            }
        }
    }

    @Override
    public void a(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationChanged' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'configurationChanged' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationChanged' must not be null";
        if (mode != AnalyzerConfigurationChangeMode.OPEN && configuration.affects(CoreAnalyzerId.QUALITY_GATES)) {
            if (modifications != null) {
                modifications.add(Modification.QUALITY_GATES_MODIFIED);
            }
            this.b(this.d());
        }
    }

    @Override
    public void a(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        this.c().enforceExistence(result);
        if (result.isSuccess() && (SoftwareSystemFilesDirectory.isOutOfSync(this.b()) || this.c().isOutOfSync(new String[][]{CoreFileType.QUALITY_GATE.getExtensions()}))) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
        if (this.c().isOutOfSync(new String[][]{CoreFileType.QUALITY_GATE.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        this.c().checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return av.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!a && modifiableFile == null) {
                    throw new AssertionError((Object)"Parameter 'modifiableFile' of method 'exists' must not be null");
                }
                return modifiableFile instanceof QualityGate;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return av.this.c();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.QUALITY_GATE);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return QualityGate.class.getSimpleName();
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return av.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!(a || modified != null && modified instanceof QualityGate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + modified));
                }
                av.this.a(modified.getFile(), modified.getFile(), (QualityGate)modified, false);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!(a || deleted != null && deleted instanceof QualityGate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + deleted));
                }
                QualityGate toBeRemoved = (QualityGate)deleted;
                toBeRemoved.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!a && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                result.addMessagesFrom(av.this.a(file, file, null, false));
            }
        }, true);
    }

    QualityGatePersistence a() {
        Files files = this.d().getUniqueExistingChild(Files.class);
        return new QualityGatePersistence(this, this.g().getVersion(), files.getQualityGatesDirectory(), this.d().getUniqueExistingChild(Files.class));
    }

    private OperationResult a(TFile contentFile, TFile modelFile, QualityGate qualityGate, boolean saveToDisk) {
        OperationResultWithOutcome<QualityGate> loadResult;
        assert (contentFile != null) : "Parameter 'contentFile' of method 'addQualityGate' must not be null";
        assert (modelFile != null) : "Parameter 'modelFile' of method 'addQualityGate' must not be null";
        QualityGates qualityGates = this.c();
        QualityGatePersistence persistence = this.a();
        if (qualityGate == null) {
            qualityGate = new QualityGate(qualityGates, new TFile((File)qualityGates.getFile(), contentFile.getName()), contentFile.lastModified(), "", this.d().getUniqueExistingChild(Files.class));
            loadResult = persistence.load(contentFile, qualityGate);
            if (loadResult.isSuccess()) {
                qualityGates.addChild(qualityGate);
            }
        } else {
            qualityGate.removeChildren(CurrentSystemConditions.class);
            qualityGate.removeChildren(DiffAgainstBaselineConditions.class);
            loadResult = persistence.load(qualityGate.getFile(), qualityGate);
            qualityGate.reloaded(contentFile.lastModified(), false);
        }
        if (saveToDisk && loadResult.isSuccess()) {
            OperationResult saveResult = persistence.save(qualityGate, modelFile);
            loadResult.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                qualityGate.setExistsOnDisk(true);
                qualityGate.resetTimestamp();
            }
            TrueZipFacade.clear((TFile)modelFile);
        }
        return loadResult;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, List<QualityGate> qualityGates) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'delete' must not be null";
        assert (qualityGates != null && !qualityGates.isEmpty()) : "Parameter 'qualityGates' of method 'delete' must not be empty";
        OperationResult result = new OperationResult("Delete " + qualityGates.size() + " quality gate(s)");
        this.a(result);
        if (result.isFailure()) {
            return result;
        }
        QualityGateCheckConfiguration configuration = this.a(false);
        ArrayList<String> identifyingPathsToRemove = new ArrayList<String>();
        for (QualityGate next : qualityGates) {
            String identifyingPath = next.getIdentifyingPath();
            if (configuration.isChecked(identifyingPath)) {
                identifyingPathsToRemove.add(identifyingPath);
            }
            SoftwareSystemFilesDirectory.removeFile(next.getFile(), false, result);
            next.remove();
        }
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        for (String next : identifyingPathsToRemove) {
            configuration.removeValue(next);
        }
        this.c(workerContext, modifications, result);
        result.setIsSuccess(true);
        return result;
    }

    @Override
    public AnalyzerConfigurationFile b() {
        return this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class).a(CoreAnalyzerId.QUALITY_GATES);
    }

    private void c(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishWithQualityGateCheckConfigurationUpdate' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishWithQualityGateCheckConfigurationUpdate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishWithQualityGateCheckConfigurationUpdate' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        AnalyzerConfigurationFile configuration = this.b();
        if (configuration != null) {
            configuration.setNeedsSave(true);
            result.addMessagesFrom(analyzerExtension.a(configuration));
        }
        this.c.a(workerContext, this.d(), modifications, result);
        analyzerExtension.a(restartGroups);
    }

    public OperationResult a(QualityGate qualityGate) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'save' must not be null";
        assert (qualityGate.needsSave()) : "Does not need save: " + qualityGate.getName();
        OperationResult saveResult = this.a().save(qualityGate, qualityGate.getFile());
        if (saveResult.isSuccess()) {
            qualityGate.setNeedsSave(false);
            qualityGate.resetTimestamp();
        }
        return saveResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGate> a(IWorkerContext workerContext, String name, String description) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createQualityGate' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createQualityGate' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'createQualityGate' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Creating quality gate");
        this.a((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile file = new TFile((File)this.c().getFile(), String.valueOf(name) + CoreFileType.QUALITY_GATE.getDefaultExtension());
        QualityGate qualityGate = new QualityGate(this.c(), file, file.lastModified(), description, this.d().getUniqueExistingChild(Files.class));
        CurrentSystemConditions currentSystemConditions = new CurrentSystemConditions(qualityGate);
        qualityGate.addChild(currentSystemConditions);
        DiffAgainstBaselineConditions baselineConditions = new DiffAgainstBaselineConditions(qualityGate);
        qualityGate.addChild(baselineConditions);
        OperationResult saveResult = this.a().save(qualityGate, file);
        if (saveResult.isSuccess()) {
            this.c().addChild(qualityGate);
            qualityGate.setExistsOnDisk(true);
            qualityGate.resetTimestamp();
            result.setOutcome((Object)qualityGate);
            QualityGateCheckConfiguration configuration = this.a(false);
            if (configuration != null && configuration.isChecked(qualityGate.getIdentifyingPath())) {
                com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
                Set<AnalyzerGroup> restartGroups = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
                qualityGate.setChecked(true);
                this.b(this.d());
                this.c.a(workerContext, this.d(), EnumSet.of(Modification.QUALITY_GATES_MODIFIED), (OperationResult)result);
                analyzerExtension.a(restartGroups);
            } else {
                this.c.a(workerContext, this.d(), EnumSet.noneOf(Modification.class), (OperationResult)result);
            }
        } else {
            result.addMessagesFrom(saveResult);
        }
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, QualityGate qualityGate, String name, String description) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'editCoreInfo' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'editCoreInfo' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'editCoreInfo' must not be null";
        String newName = String.valueOf(name) + CoreFileType.QUALITY_GATE.getDefaultExtension();
        boolean nameChanged = !newName.equals(qualityGate.getFile().getName());
        OperationResult result = new OperationResult("Editing core info of quality gate");
        this.a(result);
        if (result.isFailure()) {
            return result;
        }
        String previousIdentifyingPath = qualityGate.getIdentifyingPath();
        qualityGate.setNeedsSave(true);
        if (nameChanged) {
            TFile targetFile = new TFile((File)this.c().getFile(), newName);
            try {
                qualityGate.getFile().mv((File)targetFile);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            qualityGate.setPath(targetFile);
        }
        qualityGate.setDescription(description);
        if (nameChanged) {
            OperationResult saveResult = this.a(qualityGate);
            result.addMessagesFrom(saveResult);
            QualityGateCheckConfiguration configuration = this.a(true);
            if (configuration != null) {
                configuration.replaceIfPresent(previousIdentifyingPath, qualityGate.getIdentifyingPath());
                result.addMessagesFrom(this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class).a(workerContext, configuration));
                return result;
            }
        }
        this.c(workerContext, EnumSet.noneOf(Modification.class), result);
        return result;
    }

    boolean a(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'isChecked' must not be empty";
        QualityGateCheckConfiguration configuration = this.a(false);
        return configuration != null && configuration.isChecked(identifyingPath);
    }

    @Override
    public OperationResultWithOutcome<IQualityGateCondition> a(IWorkerContext workerContext, QualityGate qualityGate, NamedElement parent, IQualityGateConditionInfo conditionInfo) {
        IQualityGateConditionInfo info;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createCondition' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'createCondition' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createCondition' must not be null";
        assert (conditionInfo != null) : "Parameter 'conditionInfo' of method 'createCondition' must not be null";
        OperationResultWithOutcome createResult = new OperationResultWithOutcome("Creating new quality gate condition");
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        AbstractQualityGateElement condition = null;
        if (conditionInfo instanceof AbstractCurrentIssueQualityGateConditionInfo) {
            assert (parent instanceof CurrentSystemConditions) : "Unexpected parent class " + parent.getClass().getCanonicalName();
            if (conditionInfo instanceof ThresholdIssueQualityGateConditionInfo) {
                info = (ThresholdIssueQualityGateConditionInfo)conditionInfo;
                condition = new ThresholdIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueQualityGateConditionInfo)info).getMetricId(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
            } else if (conditionInfo instanceof CurrentIssueQualityGateConditionInfo) {
                info = (CurrentIssueQualityGateConditionInfo)conditionInfo;
                condition = new CurrentIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
            } else assert (false) : "Unsupported condition info " + conditionInfo.getClass().getCanonicalName();
        } else if (conditionInfo instanceof AbstractIssueDiffAgainstBaselineConditionInfo) {
            assert (parent instanceof DiffAgainstBaselineConditions) : "Unexpected parent class " + parent.getClass().getCanonicalName();
            if (conditionInfo instanceof IssueDiffAgainstBaselineConditionInfo) {
                info = (IssueDiffAgainstBaselineConditionInfo)conditionInfo;
                condition = ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck() != null ? new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck()) : new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions());
            } else if (conditionInfo instanceof ThresholdIssueDiffAgainstBaselineConditionInfo) {
                info = (ThresholdIssueDiffAgainstBaselineConditionInfo)conditionInfo;
                condition = new ThresholdIssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getMetricId(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getOperator(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThreshold(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThresholdRelative(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck());
            }
        } else if (conditionInfo instanceof MetricValueDiffQualityGateConditionInfo) {
            assert (parent instanceof DiffAgainstBaselineConditions) : "Unexpected parent class " + parent.getClass().getCanonicalName();
            info = (MetricValueDiffQualityGateConditionInfo)conditionInfo;
            condition = new MetricValueDiffQualityGateCondition(parent, ((MetricValueDiffQualityGateConditionInfo)info).getMetricId(), ((MetricValueDiffQualityGateConditionInfo)info).getOperator(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThreshold(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThresholdRelative());
        } else assert (false) : "Unspported condition info type: " + conditionInfo.getClass().getCanonicalName();
        if (condition != null) {
            parent.addChild(condition);
            QualityGateExcludeFilter excludeFilter = parent.getFirstChild(QualityGateExcludeFilter.class);
            if (excludeFilter != null) {
                parent.moveChild(AbstractQualityGateElement.class, condition, parent.getIndexOf(AbstractQualityGateElement.class, excludeFilter));
            }
            createResult.setOutcome((Object)condition);
        }
        qualityGate.setNeedsSave(true);
        this.c.a(workerContext, this.d(), EnumSet.noneOf(Modification.class), (OperationResult)createResult);
        analyzerExtension.a(restartGroups);
        return createResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGateExcludeFilter> a(IWorkerContext workerContext, QualityGate qualityGate, NamedElement parent, QualityGateExcludeFilterInfo filterInfo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createExcludeFilter' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'createExcludeFilter' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createExcludeFilter' must not be null";
        assert (filterInfo != null) : "Parameter 'filterInfo' of method 'createExcludeFilter' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        OperationResultWithOutcome createResult = new OperationResultWithOutcome("Create new quality gate exclude filter");
        QualityGateExcludeFilter excludeFilter = filterInfo.getMetricId() != null && filterInfo.getMetricId().trim().length() > 0 ? new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getMetricId(), filterInfo.getSeverities(), filterInfo.getResolutions()) : new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getSeverities(), filterInfo.getResolutions());
        parent.addChild(excludeFilter);
        qualityGate.setNeedsSave(true);
        this.c.a(workerContext, this.d(), EnumSet.noneOf(Modification.class), (OperationResult)createResult);
        analyzerExtension.a(restartGroups);
        createResult.setOutcome((Object)excludeFilter);
        return createResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGate> a(IWorkerContext workerContext, QualityGate qualityGate, List<IQualityGateElement> elementsToDelete) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteQualityGateElements' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'deleteQualityGateElements' must not be null";
        assert (elementsToDelete != null) : "Parameter 'elementsToDelete' of method 'deleteQualityGateElements' must not be null";
        OperationResultWithOutcome deleteResult = new OperationResultWithOutcome("Deleting quality gate elements");
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        for (IQualityGateElement next : elementsToDelete) {
            assert (next != null) : "Parameter 'next' of method 'deleteQualityGateElements' must not be null";
            assert (next instanceof NamedElement) : "Unexpected class in method 'deleteQualityGateElements': " + next.getClass().getCanonicalName() + ", element: " + next;
            NamedElement nextElement = (NamedElement)((Object)next);
            nextElement.remove();
        }
        qualityGate.setNeedsSave(true);
        this.c.a(workerContext, this.d(), EnumSet.noneOf(Modification.class), (OperationResult)deleteResult);
        analyzerExtension.a(restartGroups);
        deleteResult.setOutcome((Object)qualityGate);
        return deleteResult;
    }

    @Override
    public OperationResultWithOutcome<IQualityGateCondition> a(IWorkerContext workerContext, QualityGate qualityGate, IQualityGateCondition conditionToEdit, IQualityGateConditionInfo conditionInfo) {
        AbstractQualityGateElement newCondition;
        IQualityGateConditionInfo info;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editCondition' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'editCondition' must not be null";
        assert (conditionToEdit != null) : "Parameter 'conditionToEdit' of method 'editCondition' must not be null";
        assert (conditionInfo != null) : "Parameter 'conditionInfo' of method 'editCondition' must not be null";
        OperationResultWithOutcome editResult = new OperationResultWithOutcome("Edit condition");
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        NamedElement condition = (NamedElement)((Object)conditionToEdit);
        NamedElement parent = condition.getParent();
        if (conditionInfo instanceof CurrentIssueQualityGateConditionInfo) {
            info = (CurrentIssueQualityGateConditionInfo)conditionInfo;
            newCondition = new CurrentIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
        } else if (conditionInfo instanceof ThresholdIssueQualityGateConditionInfo) {
            info = (ThresholdIssueQualityGateConditionInfo)conditionInfo;
            newCondition = new ThresholdIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueQualityGateConditionInfo)info).getMetricId(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
        } else if (conditionInfo instanceof IssueDiffAgainstBaselineConditionInfo) {
            info = (IssueDiffAgainstBaselineConditionInfo)conditionInfo;
            newCondition = ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck() != null ? new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck()) : new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions());
        } else if (conditionInfo instanceof ThresholdIssueDiffAgainstBaselineConditionInfo) {
            info = (ThresholdIssueDiffAgainstBaselineConditionInfo)conditionInfo;
            newCondition = new ThresholdIssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getMetricId(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getOperator(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThreshold(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThresholdRelative(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck());
        } else if (conditionInfo instanceof MetricValueDiffQualityGateConditionInfo) {
            info = (MetricValueDiffQualityGateConditionInfo)conditionInfo;
            newCondition = new MetricValueDiffQualityGateCondition(parent, ((MetricValueDiffQualityGateConditionInfo)info).getMetricId(), ((MetricValueDiffQualityGateConditionInfo)info).getOperator(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThreshold(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThresholdRelative());
        } else {
            assert (false) : "Unsupported condition info: " + conditionInfo.getClass().getCanonicalName();
            newCondition = null;
        }
        int index = parent.getIndexOf(IQualityGateCondition.class, condition);
        NamedElement addedCondition = newCondition;
        parent.addChild(addedCondition);
        parent.moveChild(IQualityGateCondition.class, addedCondition, index);
        condition.remove();
        qualityGate.setNeedsSave(true);
        this.c.a(workerContext, this.d(), EnumSet.noneOf(Modification.class), (OperationResult)editResult);
        analyzerExtension.a(restartGroups);
        editResult.setOutcome((Object)newCondition);
        return editResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGateExcludeFilter> a(IWorkerContext workerContext, QualityGate qualityGate, QualityGateExcludeFilter excludeFilterToEdit, QualityGateExcludeFilterInfo filterInfo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editExcludeFilter' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'editExcludeFilter' must not be null";
        assert (excludeFilterToEdit != null) : "Parameter 'excludeFilterToEdit' of method 'editExcludeFilter' must not be null";
        assert (filterInfo != null) : "Parameter 'filterInfo' of method 'editExcludeFilter' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        OperationResultWithOutcome editResult = new OperationResultWithOutcome("Edit exclude filter");
        NamedElement parent = excludeFilterToEdit.getParent();
        int index = parent.getIndexOf(QualityGateExcludeFilter.class, excludeFilterToEdit);
        QualityGateExcludeFilter newFilter = filterInfo.getMetricId() != null ? new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getMetricId(), filterInfo.getSeverities(), filterInfo.getResolutions()) : new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getSeverities(), filterInfo.getResolutions());
        parent.addChild(newFilter);
        parent.moveChild(QualityGateExcludeFilter.class, newFilter, index);
        excludeFilterToEdit.remove();
        qualityGate.setNeedsSave(true);
        this.c.a(workerContext, this.d(), EnumSet.noneOf(Modification.class), (OperationResult)editResult);
        analyzerExtension.a(restartGroups);
        editResult.setOutcome((Object)newFilter);
        return editResult;
    }

    @Override
    public QualityGate b(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getQualityGate' must not be empty";
        QualityGate qualityGate = !identifyingPath.startsWith("./") ? this.c().getUniqueChild(new NameFilter("./" + identifyingPath), QualityGate.class) : this.c().getUniqueChild(new NameFilter(identifyingPath), QualityGate.class);
        return qualityGate;
    }

    @Override
    public OperationResult b(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addToCheck' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'addToCheck' must not be null";
        OperationResult result = new OperationResult("Add to quality gate check");
        QualityGateCheckConfiguration configuration = this.a(true);
        for (Element next : elements) {
            assert (next != null && next instanceof QualityGate) : "Unexpected class in method 'addToCheck': " + next;
            QualityGate qualityGate = (QualityGate)next;
            configuration.addIdentifyingPath(qualityGate.getIdentifyingPath());
            qualityGate.setChecked(true);
        }
        result.addMessagesFrom(this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class).a(workerContext, configuration));
        this.c.a(this.d(), EnumSet.of(Modification.QUALITY_GATES_MODIFIED));
        return result;
    }

    @Override
    public OperationResult c(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'removeFromCheck' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'removeFromCheck' must not be null";
        OperationResult result = new OperationResult("Remove from quality gate check");
        QualityGateCheckConfiguration configuration = this.a(true);
        for (Element next : elements) {
            assert (next != null && next instanceof QualityGate) : "Unexpected class in method 'removeFromCheck': " + next;
            QualityGate qualityGate = (QualityGate)next;
            configuration.removeIdentifyingPath(qualityGate.getIdentifyingPath());
            qualityGate.setChecked(false);
        }
        result.addMessagesFrom(this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class).a(workerContext, configuration));
        this.c.a(this.d(), EnumSet.of(Modification.QUALITY_GATES_MODIFIED));
        return result;
    }

    protected QualityGateCheckConfiguration a(boolean forEdit) {
        AnalyzerConfiguration configuration;
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.d().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        AnalyzerConfiguration analyzerConfiguration = configuration = forEdit ? analyzerExtension.c(CoreAnalyzerId.QUALITY_GATES) : analyzerExtension.b(CoreAnalyzerId.QUALITY_GATES);
        assert (configuration != null && configuration instanceof QualityGateCheckConfiguration) : "Unexpected class in method 'getQualityGateCheckConfiguration': " + configuration;
        return (QualityGateCheckConfiguration)configuration;
    }

    public List<IModifiableFile> e() {
        ArrayList<IModifiableFile> result = new ArrayList<IModifiableFile>();
        result.addAll(this.getAvailableQualityGates());
        return result;
    }

    @Override
    public boolean a(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.QUALITY_GATE.equals(modifiableFile.getFileType());
    }

    @Override
    public String f() {
        return "QualityGates";
    }

    @Override
    public void a(IModifiableFile file, TFile targetFile, OperationResult result) {
        assert (file != null && file instanceof QualityGate) : "Unexpected class in method 'exportFile': " + file;
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        QualityGate qualityGate = (QualityGate)file;
        result.addMessagesFrom(this.a().save(qualityGate, targetFile));
    }

    @Override
    public void a(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modfications, OperationResult result) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.QUALITY_GATE);
        QualityGates qualityGatesDirectory = this.c();
        block0: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : candidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            String contentFileIdentifyingPath = nextImportQualityModelCandidate.getModifiableFile().getIdentifyingPath();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                TFile targetFile = new TFile((File)qualityGatesDirectory.getFile(), contentFileIdentifyingPath).getNormalizedFile();
                result.addMessagesFrom(this.a(contentFile, targetFile.getNormalizedFile(), null, true));
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            for (IModifiableFile nextAvailable : this.e()) {
                assert (nextAvailable != null && nextAvailable instanceof QualityGate) : "Unexpected class in method 'importFiles': " + nextAvailable;
                if (!nextAvailable.getIdentifyingPath().equals(contentFileIdentifyingPath)) continue;
                result.addMessagesFrom(this.a(contentFile, nextAvailable.getFile(), (QualityGate)nextAvailable, true));
                continue block0;
            }
        }
    }

    @Override
    public void a(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        this.c().removeAll(result);
    }

    @Override
    public void a(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        this.c().setPath(new TFile((File)qualityModel, "./QualityGates"));
    }

    @Override
    public void b(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result) {
        this.b(this.d());
    }
}

