/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.controller.system.R;
import com.hello2morrow.sonargraph.core.controller.system.S;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.j;
import com.hello2morrow.sonargraph.core.controllerinterface.system.o;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.SoftwareSystemDefinitionFileReadError;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurations;
import com.hello2morrow.sonargraph.core.model.plugin.PluginNotInstalledIssue;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.PluginMessageCause;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.system.settings.PluginConfigurationPersistence;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginConfiguration;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class as
extends Extension
implements R,
S,
j,
o,
IModifiableFileDeltaKey {
    private static final Logger b = LoggerFactory.getLogger(as.class);
    private final SoftwareSystem c;
    private final g d;
    private final c e;
    private final PluginConfigurationPersistence f;

    as(Version version, SoftwareSystem softwareSystem, g finishModelProcessor, c handler) {
        assert (version != null) : "Parameter 'version' of method 'PluginConfigurationExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'PluginConfigurationExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'PluginConfigurationExtension' must not be null";
        assert (handler != null) : "Parameter 'handler' of method 'PluginConfigurationExtension' must not be null";
        this.f = new PluginConfigurationPersistence(version);
        this.c = softwareSystem;
        this.d = finishModelProcessor;
        this.e = handler;
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        PluginConfigurations pluginConfigurations = this.a();
        Files files = this.c.getUniqueExistingChild(Files.class);
        for (SonargraphPlugin nextPlugin : this.e.getPlugins()) {
            String nextPluginId = nextPlugin.getId();
            PluginConfigurationFile pluginConfiguration = new PluginConfigurationFile(pluginConfigurations, new TFile((File)pluginConfigurations.getFile(), PluginConfigurationFile.getFileName(nextPluginId)), files, nextPluginId, nextPlugin.getConfiguration());
            pluginConfigurations.addChild(pluginConfiguration);
        }
    }

    @Override
    public PluginConfigurationFile getPluginConfigurationFile(String pluginId) {
        assert (pluginId != null) : "Parameter 'pluginId' of method 'getPluginConfigurationFile' must not be null";
        PluginConfigurations pluginConfigurationDirectory = this.a();
        PluginConfigurationFile pluginConfiguration = pluginConfigurationDirectory.getUniqueChild(new d(pluginId), PluginConfigurationFile.class);
        return pluginConfiguration;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, SonargraphPlugin plugin, Map<SonargraphPluginAttribute, Object> values) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurePlugin' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'configurePlugin' must not be null";
        assert (values != null) : "Parameter 'values' of method 'configurePlugin' must not be null";
        String pluginId = plugin.getId();
        OperationResult result = new OperationResult("Configure plugin '" + pluginId + "'");
        this.a(result);
        if (result.isFailure()) {
            return result;
        }
        PluginConfigurationFile pluginConfigurationFile = this.getPluginConfigurationFile(pluginId);
        assert (pluginConfigurationFile != null) : "'pluginConfigurationFile' of method 'configurePlugin' must not be null";
        assert (pluginConfigurationFile.getPluginConfiguration() != null) : "plugin configuration must not be null";
        b.debug("Configure plugin '" + pluginId + "'");
        b info = new b(true);
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        this.a(pluginId, pluginConfigurationFile.getPluginConfiguration(), values, modifications, info);
        if (result.isSuccess()) {
            pluginConfigurationFile.setNeedsSave(true);
        }
        this.e.a(workerContext, this.c, modifications, info, result);
        b.debug("Configure plugin '" + pluginId + "' - done");
        return result;
    }

    private com.hello2morrow.sonargraph.core.controller.system.plugin.d a(String pluginId, SonargraphPluginConfiguration configuration, Map<SonargraphPluginAttribute, Object> values) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'updateConfiguration' must not be empty";
        assert (values != null) : "Parameter 'values' of method 'updateConfiguration' must not be null";
        b.debug("Update configuration for plugin '" + pluginId + "'");
        boolean isEnabled = SonargraphPluginConfiguration.isEnabled((SonargraphPluginConfiguration)configuration, values);
        PluginConfigurationFile pluginConfigurationFile = this.getPluginConfigurationFile(pluginId);
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfigurationFile' of method 'updateConfiguration' must not be null";
        boolean wasEnabled = pluginConfigurationFile.getPluginConfiguration().isEnabled();
        if (!values.equals(pluginConfigurationFile.getPluginConfiguration().getValues())) {
            com.hello2morrow.sonargraph.core.controller.system.plugin.d updateInfo = new com.hello2morrow.sonargraph.core.controller.system.plugin.d(wasEnabled ^ isEnabled, isEnabled);
            SonargraphPlugin plugin = this.e.a(pluginId);
            if (plugin != null) {
                plugin.getConfiguration().updateValues(values);
            }
            return updateInfo;
        }
        return null;
    }

    private void a(String pluginId, SonargraphPluginConfiguration configuration, Map<SonargraphPluginAttribute, Object> values, EnumSet<Modification> modifications, b info) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'updateConfiguration' must not be empty";
        assert (values != null) : "Parameter 'values' of method 'updateConfiguration' must not be null";
        assert (info != null) : "Parameter 'info' of method 'updateConfiguration' must not be null";
        b.debug("Update configuration for plugin '" + pluginId + "'");
        com.hello2morrow.sonargraph.core.controller.system.plugin.d updateInfo = this.a(pluginId, configuration, values);
        if (updateInfo != null && modifications != null) {
            this.e.a(this.c, pluginId, modifications, info, updateInfo.a(), updateInfo.b());
        }
        b.debug("Update configuration for plugin '" + pluginId + "' - done");
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, final boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        this.a().checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return as.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!(a || modifiableFile != null && modifiableFile instanceof PluginConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'exists': " + modifiableFile));
                }
                return !onSystemOpen ? modifiableFile.existsOnDisk() : false;
            }

            @Override
            public boolean accept(TFile file) {
                if (!a && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                }
                return as.this.d.b().a(SonargraphFeature.PLUGINS);
            }

            @Override
            public boolean recursive() {
                return false;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return as.this.a();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.PLUGIN_CONFIGURATION);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return PluginConfigurationFile.class.getSimpleName();
            }
        });
        if (!onSystemOpen) {
            deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return as.this;
                }
            }, false);
        }
    }

    @Override
    public void refreshFiles(final IWorkerContext workerContext, ModifiableFileDelta delta, final EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        final b info = new b(false);
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return as.this;
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!a && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                b.debug("Added file: {}", (Object)added.getIdentifyingPath());
                as.this.a(workerContext, added, (EnumSet<Modification>)modifications, info, result);
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!(a || modified != null && modified instanceof PluginConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + modified));
                }
                b.debug("Modified file: {}", (Object)modified.getIdentifyingPath());
                as.this.a(workerContext, (PluginConfigurationFile)modified, (EnumSet<Modification>)modifications, info, result);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!(a || deleted != null && deleted instanceof PluginConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + deleted));
                }
                b.debug("Deleted plugin configuration file '" + deleted.getIdentifyingPath() + "'");
                PluginConfigurationFile pluginConfigurationFile = (PluginConfigurationFile)deleted;
                pluginConfigurationFile.removeIssues();
                SonargraphPlugin plugin = as.this.e.a(pluginConfigurationFile.getPluginId());
                if (plugin != null) {
                    as.this.e.a(workerContext, as.this.c, plugin, modifications, info);
                    pluginConfigurationFile.setExistsOnDisk(false);
                }
                b.debug("Deleted plugin configuration file '" + deleted.getIdentifyingPath() + "' - done");
            }
        }, true);
        if (modifications != null) {
            this.e.a(workerContext, this.c, modifications, info, result);
        }
    }

    private PluginConfigurations a() {
        return this.c.getUniqueExistingChild(Files.class).getPluginConfigurationDirectory();
    }

    public OperationResult a(PluginConfigurationFile pluginConfigurationFile) {
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfiguration' of method 'save' must not be null";
        assert (pluginConfigurationFile.needsSave()) : "Does not need save: " + pluginConfigurationFile.getName();
        assert (pluginConfigurationFile.getPluginConfiguration() != null) : "'plugin configuration' of method 'save' must not be null";
        OperationResult saveResult = this.f.save(pluginConfigurationFile.getFile(), pluginConfigurationFile.getPluginId(), pluginConfigurationFile.getPluginConfiguration().getAttributes());
        if (saveResult.isSuccess()) {
            pluginConfigurationFile.setNeedsSave(false);
            pluginConfigurationFile.reSync();
        }
        return saveResult;
    }

    boolean a(SonargraphPlugin plugin, OperationResult result) {
        assert (plugin != null) : "Parameter 'plugin' of method 'installPlugin' must not be null";
        assert (result != null) : "Parameter 'result' of method 'installPlugin' must not be null";
        String pluginId = plugin.getId();
        b.debug("Install plugin '" + pluginId + "'");
        PluginConfigurationFile pluginConfiguration = this.getPluginConfigurationFile(pluginId);
        if (pluginConfiguration == null) {
            PluginConfigurations directory = this.a();
            Files files = this.c.getUniqueExistingChild(Files.class);
            pluginConfiguration = new PluginConfigurationFile(directory, new TFile((File)directory.getFile(), PluginConfigurationFile.getFileName(pluginId)), files, pluginId, plugin.getConfiguration());
            directory.addChild(pluginConfiguration);
        }
        pluginConfiguration.reSync();
        if (pluginConfiguration.existsOnDisk()) {
            pluginConfiguration.removeIssues(CoreIssueId.PLUGIN_NOT_INSTALLED);
            this.a(pluginId, pluginConfiguration.getPluginConfiguration(), (Map<SonargraphPluginAttribute, Object>)pluginConfiguration.getPluginConfiguration().getValues());
        }
        b.debug("Install plugin '" + plugin.getId() + "' - done");
        return plugin.isEnabled();
    }

    void a(SonargraphPlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'pluginUninstalled' must not be null";
        PluginConfigurationFile pluginConfiguration = this.getPluginConfigurationFile(plugin.getId());
        assert (pluginConfiguration != null) : "'pluginConfiguration' of method 'pluginUninstalled' must not be null";
        if (pluginConfiguration.existsOnDisk()) {
            pluginConfiguration.addIssue(new PluginNotInstalledIssue(pluginConfiguration, "Plugin with plugin id '" + plugin.getId() + "' is not installed"));
        } else {
            pluginConfiguration.remove();
        }
    }

    public List<IModifiableFile> e() {
        return this.a().getChildren(PluginConfigurationFile.class).stream().filter(ModifiableFile::existsOnDisk).collect(Collectors.toList());
    }

    @Override
    public boolean a(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.PLUGIN_CONFIGURATION.equals(modifiableFile.getFileType());
    }

    @Override
    public String f() {
        return "Plugins";
    }

    private void a(TFile file, TFile targetDirectory, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'copy' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'copy' must not be null";
        assert (result != null) : "Parameter 'result' of method 'copy' must not be null";
        try {
            file.cp_p((File)new TFile((File)targetDirectory, file.getName()));
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void a(IModifiableFile modifiableFile, TFile targetFile, OperationResult result) {
        assert (modifiableFile != null && modifiableFile instanceof PluginConfigurationFile) : "Unexpected class in method 'exportFile': " + modifiableFile;
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        this.a(modifiableFile.getFile(), targetFile.getParentFile(), result);
    }

    @Override
    public void a(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        PluginConfigurations pluginConfigurationDirectory = this.a();
        pluginConfigurationDirectory.enforceExistence(result);
        if (result.isSuccess() && this.a().isOutOfSync(new String[][]{CoreFileType.PLUGIN_CONFIGURATION.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public void a(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importFiles' must not be null";
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        b info = new b(false);
        PluginConfigurations pluginConfigurationDirectory = this.a();
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.PLUGIN_CONFIGURATION);
        for (ImportQualityModel.ImportQualityModelCandidate candidate : candidates) {
            if (!candidate.isIncluded()) continue;
            TFile candidateFile = candidate.getModifiableFile().getFile();
            this.a(candidateFile, pluginConfigurationDirectory.getFile(), result);
            if (candidate.isAlreadyInModel()) {
                String pluginId = FileUtility.getFileNameWithoutExtension((TFile)candidateFile);
                PluginConfigurationFile existing = this.getPluginConfigurationFile(pluginId);
                assert (existing != null) : "'existing' of method 'importFiles' must not be null";
                this.a(workerContext, existing, modifications, info, result);
                continue;
            }
            this.a(workerContext, candidate.getModifiableFile(), modifications, info, result);
        }
        if (modifications != null) {
            this.e.a(workerContext, this.c, modifications, info, result);
        }
    }

    @Override
    public void a(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        PluginConfigurations pluginConfigurations = this.a();
        for (PluginConfigurationFile next : pluginConfigurations.getChildren(PluginConfigurationFile.class)) {
            TFile nextFile = next.getFile();
            if (!nextFile.exists()) continue;
            try {
                nextFile.rm();
                next.setExistsOnDisk(false);
                next.setNeedsSave(false);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)ex);
            }
        }
    }

    @Override
    public void a(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        PluginConfigurations pluginConfigurations = this.a();
        pluginConfigurations.setPath(new TFile((File)qualityModel, "./Plugins"));
    }

    private void a(IWorkerContext workerContext, IModifiableFile added, EnumSet<Modification> modfications, b info, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationFileAdded' must not be null";
        assert (added != null) : "Parameter 'added' of method 'configurationFileAdded' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationFileAdded' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationFileAdded' must not be null";
        TFile file = added.getFile();
        String fileName = file.getName();
        String pluginId = FileUtility.getFileNameWithoutExtension((TFile)file);
        SonargraphPlugin plugin = this.e.a(pluginId);
        PluginConfigurationFile pluginConfiguration = this.getPluginConfigurationFile(pluginId);
        if (pluginConfiguration == null) {
            PluginConfigurations parent = this.a();
            pluginConfiguration = new PluginConfigurationFile(parent, new TFile((File)parent.getFile(), fileName), this.c.getUniqueExistingChild(Files.class), pluginId, plugin != null ? plugin.getConfiguration() : null);
            parent.addChild(pluginConfiguration);
        }
        if (plugin == null) {
            result.addWarning((OperationResult.IMessageCause)PluginMessageCause.PLUGIN_NOT_INSTALLED, "Plugin '" + pluginId + "' is not installed.", new Object[0]);
            pluginConfiguration.addIssue(new PluginNotInstalledIssue(pluginConfiguration, "Plugin '" + pluginId + "' is not installed."));
        } else {
            OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> loadResult = this.f.load(file, pluginConfiguration.getIdentifyingPath(), pluginConfiguration.getPluginId(), (Map<String, SonargraphPluginAttribute>)pluginConfiguration.getPluginConfiguration().getAttributes());
            result.addMessagesFrom(loadResult);
            if (loadResult.isFailure()) {
                pluginConfiguration.addIssue(new SoftwareSystemDefinitionFileReadError(pluginConfiguration, loadResult.toString()));
            } else {
                this.a(pluginId, pluginConfiguration.getPluginConfiguration(), (Map)loadResult.getOutcome(), modfications, info);
                pluginConfiguration.reSync();
            }
        }
    }

    private void a(IWorkerContext workerContext, PluginConfigurationFile pluginConfigurationFile, EnumSet<Modification> modfications, b info, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationFileModified' must not be null";
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfigurationFile' of method 'configurationFileModified' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationFileModified' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationFileModified' must not be null";
        SonargraphPluginConfiguration pluginConfiguration = pluginConfigurationFile.getPluginConfiguration();
        if (pluginConfiguration != null) {
            pluginConfigurationFile.removeIssues();
            OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> loadResult = this.f.load(pluginConfigurationFile.getFile(), pluginConfigurationFile.getIdentifyingPath(), pluginConfigurationFile.getPluginId(), (Map<String, SonargraphPluginAttribute>)pluginConfiguration.getAttributes());
            result.addMessagesFrom(loadResult);
            if (loadResult.isFailure()) {
                pluginConfigurationFile.addIssue(new SoftwareSystemDefinitionFileReadError(pluginConfigurationFile, loadResult.toString()));
            } else {
                pluginConfigurationFile.reloaded(pluginConfigurationFile.getFile().lastModified(), false);
                this.a(pluginConfigurationFile.getPluginId(), pluginConfiguration, (Map)loadResult.getOutcome(), modfications, info);
                pluginConfigurationFile.reSync();
            }
        }
    }

    @Override
    public PluginConfigurationFile a(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'findByIdentifyingPath' must not be empty";
        for (PluginConfigurationFile next : this.a().getChildrenRecursively(PluginConfigurationFile.class, new Class[0])) {
            if (!next.getIdentifyingPath().equals(identifyingPath)) continue;
            return next;
        }
        return null;
    }

    @Override
    public void a(PluginConfigurationFile pluginConfigurationFile, OutputStream outputStream, OperationResult result) {
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfigurationFile' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        SonargraphPluginConfiguration pluginConfiguration = pluginConfigurationFile.getPluginConfiguration();
        if (pluginConfiguration != null) {
            this.f.save(pluginConfigurationFile.getPluginId(), pluginConfigurationFile.getPluginConfiguration().getAttributes(), outputStream, result);
        }
    }

    @Override
    public void a(PluginConfigurationFile pluginConfigurationFile, InputStream inputStream, EnumSet<Modification> determinedModifications, OperationResultWithOutcome<PluginConfigurationFile> result) {
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfiguration' of method 'restoreFile' must not be null";
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreFile' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'restoreFile' must not be null";
        assert (pluginConfigurationFile.getPluginConfiguration() != null) : "'plugin configuration' of method 'restoreFile' must not be null";
        OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> loadResult = this.f.load(inputStream, pluginConfigurationFile.getIdentifyingPath(), pluginConfigurationFile.getPluginId(), (Map<String, SonargraphPluginAttribute>)pluginConfigurationFile.getPluginConfiguration().getAttributes());
        result.addMessagesFrom(loadResult);
        if (!result.isFailure()) {
            b info = new b(false);
            this.a(pluginConfigurationFile.getPluginId(), pluginConfigurationFile.getPluginConfiguration(), (Map)loadResult.getOutcome(), determinedModifications, info);
            this.e.a((IWorkerContext)DefaultWorkerContext.INSTANCE, this.c, determinedModifications, info, (OperationResult)result);
            result.setOutcome((Object)pluginConfigurationFile);
        }
    }

    static final class a {
        private final Set<IAnalyzerId> b;

        a() {
            this.b = null;
        }

        a(Set<IAnalyzerId> restart) {
            assert (restart != null) : "Parameter 'restart' of method 'AnalyzerRestartInfo' must not be null";
            this.b = new THashSet(restart);
        }

        void a(IAnalyzerId remove) {
            assert (remove != null) : "Parameter 'remove' of method 'removeAnalyzerId' must not be null";
            assert (this.b != null) : "Parameter 'm_restart' of method 'removeAnalyzerId' must not be null";
            this.b.remove(remove);
        }

        boolean a() {
            return this.b == null;
        }

        Set<IAnalyzerId> b() {
            assert (this.b != null) : "'m_restart' of method 'getAnalyzersToRestart' must not be null";
            return Collections.unmodifiableSet(this.b);
        }

        public String toString() {
            return this.b == null ? "All" : Arrays.toString(this.b.toArray());
        }
    }

    static final class b {
        private final Set<StrictPair<SonargraphPlugin, IPluginModelContributor>> b = new THashSet();
        private final boolean c;
        private a d;

        b(boolean requiresAnalyzersRestart) {
            this.c = requiresAnalyzersRestart;
        }

        void a(a restartInfo) {
            this.d = restartInfo;
        }

        boolean a() {
            return this.c;
        }

        a b() {
            return this.d;
        }

        void a(StrictPair<SonargraphPlugin, IPluginModelContributor> affected) {
            assert (affected != null) : "Parameter 'affected' of method 'addAffectedModelContributorPlugin' must not be null";
            this.b.add(affected);
        }

        Set<StrictPair<SonargraphPlugin, IPluginModelContributor>> c() {
            return Collections.unmodifiableSet(this.b);
        }
    }

    public static interface c {
        public void a(SoftwareSystem var1, String var2, EnumSet<Modification> var3, b var4, boolean var5, boolean var6);

        public void a(IWorkerContext var1, SoftwareSystem var2, EnumSet<Modification> var3, b var4, OperationResult var5);

        public void a(IWorkerContext var1, SoftwareSystem var2, SonargraphPlugin var3, EnumSet<Modification> var4, b var5);

        public SonargraphPlugin a(String var1);

        public List<SonargraphPlugin> getPlugins();
    }

    private static final class d
    implements NamedElement.IFilter {
        private final String b;

        public d(String pluginId) {
            assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'PluginIdFilter' must not be empty";
            this.b = pluginId;
        }

        @Override
        public boolean accept(NamedElement namedElement) {
            if (namedElement instanceof PluginConfigurationFile) {
                PluginConfigurationFile pluginConfiguration = (PluginConfigurationFile)namedElement;
                return this.b.equals(pluginConfiguration.getPluginId());
            }
            return false;
        }
    }
}

