/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.foundation.utilities.ExceptionUtility;
import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Visitor;
import com.hello2morrow.sonargraph.core.controller.system.analysis.a;
import com.hello2morrow.sonargraph.core.controller.system.architecture.c;
import com.hello2morrow.sonargraph.core.controller.system.architecture.d;
import com.hello2morrow.sonargraph.core.controller.system.architecture.v;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFileIssue;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class h
implements v {
    private static final Logger b = LoggerFactory.getLogger(h.class);
    private final a c;
    private final Deque<ArchitectureFile> d = new ArrayDeque<ArchitectureFile>();

    public h(a access) {
        assert (access != null) : "Parameter 'access' of method 'ArchitectureFileLoader' must not be null";
        this.c = access;
    }

    public void a(final ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'readArchitectureFile' must not be null";
        c parser = new c(new com.hello2morrow.javapg.runtime.messaging.d(){

            public void a(int severity, Position pos, String msg) {
                b.debug("Syntax error in architecture file {} at line {} position {}", new Object[]{architectureFile, pos.getLine(), pos.getColumn()});
                architectureFile.addIssue(new ArchitectureFileIssue(architectureFile, msg, pos.getLine(), pos.getColumn()));
            }
        });
        d builder = new d(architectureFile, this, this.c);
        String fileContent = this.c.d(architectureFile.getIdentifyingPath());
        b.debug("readArchitectureFile {} with content", (Object)architectureFile.getIdentifyingPath());
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (StringReader reader = new StringReader(fileContent);){
                InnerNode ast = parser.parse(reader, architectureFile.getName());
                if (ast != null) {
                    ast.accept((Visitor)builder);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            assert (false) : "We are not reading from a file - should not happen: " + ExceptionUtility.collectAll((Throwable)e2);
        }
        catch (Throwable t2) {
            b.error("Exception while analyzing architecture file " + architectureFile.getIdentifyingPath(), t2);
            architectureFile.removeChildren(ArchitectureElement.class, ConnectionScheme.class);
            throw t2;
        }
        architectureFile.modelLoaded(true);
    }

    public void b(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'loadArchitectureFile' must not be null";
        this.d.push(architectureFile);
        this.a(architectureFile);
        this.d.pop();
    }

    @Override
    public ArchitectureFile a(String name, Consumer<String> errorMessageConsumer) {
        ArchitectureFile architectureFile;
        String identifyingPath;
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'loadArchitectureFile' must not be empty";
        assert (errorMessageConsumer != null) : "Parameter 'errorMessageConsumer' of method 'loadArchitectureFile' must not be null";
        String string = identifyingPath = !name.startsWith("./") ? "./" + name : name;
        if (!CoreFileType.ARCHITECTURE.endsWith(identifyingPath)) {
            identifyingPath = String.valueOf(identifyingPath) + CoreFileType.ARCHITECTURE.getDefaultExtension();
        }
        if ((architectureFile = this.c.getArchitectureFile(identifyingPath)) == null) {
            String fileName = name.endsWith(CoreFileType.ARCHITECTURE.getDefaultExtension()) ? name : String.valueOf(name) + CoreFileType.ARCHITECTURE.getDefaultExtension();
            String msg = String.format("Cannot locate architecture file '%s'", fileName);
            errorMessageConsumer.accept(msg);
            return null;
        }
        if (this.d.contains(architectureFile)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Recursive inclusion of architecture files: ");
            this.d.stream().forEach(af2 -> {
                StringBuilder stringBuilder2 = sb.append(af2.getShortName()).append("->");
            });
            sb.append(name);
            errorMessageConsumer.accept(sb.toString());
            return null;
        }
        if (!architectureFile.modelLoaded()) {
            this.b(architectureFile);
        }
        return architectureFile;
    }
}

