/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.messaging.d;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Node;
import com.hello2morrow.javapg.runtime.tree.Visitor;
import com.hello2morrow.sonargraph.core.controller.system.architecture.i;
import com.hello2morrow.sonargraph.core.controller.system.architecture.l;
import com.hello2morrow.sonargraph.core.controller.system.architecture.o;
import com.hello2morrow.sonargraph.core.controller.system.architecture.w;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class a
extends o {
    private static final Logger aa = LoggerFactory.getLogger(a.class);
    private final ArchitectureFile ab;
    private final List<Node> ac = new ArrayList<Node>();

    private a(ArchitectureFile file) {
        assert (file != null) : "Parameter 'file' of method 'ApplyAndRequireSupport' must not be null";
        this.ab = file;
    }

    @Override
    public void a(InnerNode arg) {
        this.X(arg);
    }

    @Override
    public void b(InnerNode arg) {
        this.X(arg);
    }

    private void X(InnerNode arg) {
        Node node = arg.getChild("STRING");
        assert (node != null);
        String fileName = node.getLexeme();
        assert (fileName != null && fileName.length() >= 2);
        fileName = fileName.substring(1, fileName.length() - 1);
        fileName = FileUtility.removeExtension((String)fileName);
        List<String> applyNames = this.ab.getApplyNames();
        if (applyNames.contains(fileName)) {
            this.ac.add(node);
        }
    }

    private List<Node> a() {
        return new ArrayList<Node>(this.ac);
    }

    private int b() {
        return this.ac.size();
    }

    private void c() {
        this.ac.clear();
    }

    private static String a(String content, List<Node> nodes, w replaceStrategy) {
        assert (content != null && content.length() > 0) : "Parameter 'content' of method 'replace' must not be empty";
        assert (nodes != null) : "Parameter 'nodes' of method 'replace' must not be null";
        assert (replaceStrategy != null) : "Parameter 'replaceStrategy' of method 'replace' must not be null";
        Collections.reverse(nodes);
        StringBuilder sb = new StringBuilder(content);
        for (Node node : nodes) {
            Position position = node.getPosition();
            sb.replace(position.getOffset(), position.getOffset() + position.getLength(), replaceStrategy.a(node.getLexeme()));
        }
        return sb.toString();
    }

    private static void a(a visitor, final ArchitectureFile architectureFile) {
        assert (visitor != null) : "Parameter 'visitor' of method 'applyVisitor' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'applyVisitor' must not be null";
        l parser = new l(new d(){

            public void a(int severity, Position pos, String msg) {
                aa.warn("{}: '{}' in architecture file {} at line {} position {}", new Object[]{severity, msg, architectureFile, pos.getLine(), pos.getColumn()});
                aa.warn("###" + StringUtility.showWhitespace((String)architectureFile.getContent()) + "###");
            }
        });
        try {
            InnerNode root = parser.parse(new StringReader(architectureFile.getContent()), architectureFile.getName());
            if (root != null) {
                visitor.c();
                root.accept((Visitor)visitor);
            }
        }
        catch (IOException e2) {
            aa.warn("Parsing architecture file " + architectureFile, (Throwable)e2);
        }
    }

    public static Map<ArchitectureFile, String> a(List<ArchitectureFile> availableArchitectureFiles, ArchitectureFile renamedArchitectureFile, String newName) {
        assert (availableArchitectureFiles != null) : "Parameter 'availableArchitectureFiles' of method 'processApplyAndRequireStatements' must not be null";
        assert (renamedArchitectureFile != null) : "Parameter 'renamedArchitectureFile' of method 'changeApplyStatements' must not be null";
        assert (newName != null) : "Parameter 'newName' of method 'processApplyStatements' must not be null";
        HashMap<ArchitectureFile, String> result = new HashMap<ArchitectureFile, String>();
        a visitor = new a(renamedArchitectureFile);
        for (ArchitectureFile nextArchitectureFile : availableArchitectureFiles) {
            if (nextArchitectureFile == renamedArchitectureFile) continue;
            com.hello2morrow.sonargraph.core.controller.system.architecture.a.a(visitor, nextArchitectureFile);
            if (visitor.b() <= 0) continue;
            i replaceStrategy = new i(nextArchitectureFile.getNewApplyName(newName));
            String newContent = com.hello2morrow.sonargraph.core.controller.system.architecture.a.a(nextArchitectureFile.getContent(), visitor.a(), replaceStrategy);
            result.put(nextArchitectureFile, newContent);
        }
        return result;
    }

    public static List<ArchitectureFile> a(List<ArchitectureFile> availableArchitectureFiles, ArchitectureFile architectureFile) {
        assert (availableArchitectureFiles != null) : "Parameter 'availableArchitectureFiles' of method 'getApplyingAndRequiringFiles' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getApplyingFiles' must not be null";
        ArrayList<ArchitectureFile> result = new ArrayList<ArchitectureFile>();
        a visitor = new a(architectureFile);
        for (ArchitectureFile other : availableArchitectureFiles) {
            if (other == architectureFile) continue;
            com.hello2morrow.sonargraph.core.controller.system.architecture.a.a(visitor, other);
            if (visitor.b() <= 0) continue;
            result.add(other);
        }
        return result;
    }
}

