/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.s;
import com.hello2morrow.sonargraph.core.controller.system.architecture.t;
import com.hello2morrow.sonargraph.core.controller.system.architecture.u;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AutoCompletionArtifactCollector {
    private static final Logger b = LoggerFactory.getLogger(AutoCompletionArtifactCollector.class);
    private static final String c = "#ROOT#";
    private final ArrayDeque<u> d = new ArrayDeque();
    private final Map<String, Set<String>> e = new THashMap();

    private AutoCompletionArtifactCollector() {
    }

    private boolean a(String identifyingPath, u scope) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'includeReferencedArchitectureFile' must not be empty";
        THashSet scopes = this.e.get(identifyingPath);
        if (scopes == null) {
            scopes = new THashSet();
            this.e.put(identifyingPath, (Set<String>)scopes);
        }
        return scopes.add(scope == null ? c : scope.b());
    }

    private String a(String artifactName) {
        assert (artifactName != null && artifactName.length() > 0) : "Parameter 'artifactName' of method 'getFullName' must not be empty";
        StringBuilder builder = new StringBuilder();
        if (!this.d.isEmpty()) {
            Iterator<u> iter = this.d.descendingIterator();
            while (iter.hasNext()) {
                u next = iter.next();
                builder.append(next.c()).append('.');
            }
        }
        builder.append(artifactName);
        b.trace("Full name: " + builder.toString());
        return builder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private int a(StringTokenizer tokenizer) {
        if (AutoCompletionArtifactCollector.a || tokenizer != null) ** GOTO lbl8
        throw new AssertionError((Object)"Parameter 'tokenizer' of method 'getNameToken' must not be null");
lbl-1000:
        // 1 sources

        {
            nextToken = tokenizer.nextToken();
            if (nextToken.equals("\n")) {
                return 1;
            }
            if (!nextToken.equals("\"")) continue;
            return 0;
lbl8:
            // 2 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl9:
        // 1 sources

        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private String b(StringTokenizer tokenizer) {
        if (AutoCompletionArtifactCollector.a || tokenizer != null) ** GOTO lbl8
        throw new AssertionError((Object)"Parameter 'tokenizer' of method 'getNameToken' must not be null");
lbl-1000:
        // 1 sources

        {
            nextToken = tokenizer.nextToken();
            if (nextToken.length() == 1 && ((c = nextToken.charAt(0)) == '{' || c == '}')) {
                return null;
            }
            if (s.a(nextToken) || s.b().contains(nextToken)) continue;
            return nextToken;
lbl8:
            // 2 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl9:
        // 1 sources

        return "";
    }

    private t a(StringTokenizer tokenizer, Architecture architecture) {
        assert (tokenizer != null) : "Parameter 'tokenizer' of method 'getArchitectureFileReference' must not be null";
        assert (architecture != null) : "Parameter 'architecture' of method 'getArchitectureFileReference' must not be null";
        int lines = 0;
        boolean started = false;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (nextToken.equals("\n")) {
                ++lines;
                if (!started) continue;
                return null;
            }
            if (nextToken.equals("\t")) {
                if (!started) continue;
                return null;
            }
            if (nextToken.equals(" ")) {
                if (!started) continue;
                return null;
            }
            if (nextToken.equals("\"")) {
                if (!started) {
                    started = true;
                    continue;
                }
                return null;
            }
            if (!started) continue;
            if (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\"")) {
                    String content;
                    final String identifyingPath = "./" + (nextToken.toLowerCase().endsWith(".arc") ? nextToken : String.valueOf(nextToken) + ".arc");
                    ArchitectureFile architectureFile = architecture.getFirstChild(new NamedElement.IFilter(){

                        @Override
                        public boolean accept(NamedElement namedElement) {
                            if (!(a || namedElement != null && namedElement instanceof ArchitectureFile)) {
                                throw new AssertionError((Object)("Unexpected class in method 'accept': " + namedElement));
                            }
                            return ((ArchitectureFile)namedElement).getIdentifyingPath().equals(identifyingPath);
                        }
                    }, ArchitectureFile.class);
                    if (architectureFile != null && (content = architectureFile.getContent()) != null && !content.isEmpty()) {
                        return new t(lines, identifyingPath, content);
                    }
                    return new t(lines);
                }
                if (token.equals("\n")) {
                    ++lines;
                }
                return new t(lines);
            }
            return new t(lines);
        }
        return new t(lines);
    }

    private int c(StringTokenizer tokenizer) {
        assert (tokenizer != null) : "Parameter 'tokenizer' of method 'skip' must not be null";
        int lines = 0;
        int curlyBraces = -1;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (nextToken.equals("{")) {
                if (curlyBraces == -1) {
                    curlyBraces = 0;
                }
                ++curlyBraces;
                continue;
            }
            if (nextToken.equals("}")) {
                if (curlyBraces == -1) {
                    return -1;
                }
                if (--curlyBraces != 0) continue;
                return lines;
            }
            if (!nextToken.equals("\n")) continue;
            ++lines;
        }
        return -1;
    }

    private int d(StringTokenizer tokenizer) {
        assert (tokenizer != null) : "Parameter 'tokenizer' of method 'skipComment' must not be null";
        int lines = 0;
        Comment comment = null;
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (firstToken) {
                if (!nextToken.equals("/") && !nextToken.equals("*")) {
                    return -1;
                }
                firstToken = false;
            }
            if (nextToken.equals("/")) {
                if (comment == null) {
                    comment = Comment.SLASH_SLASH;
                    continue;
                }
                if (!Comment.SLASH_STAR_SECOND.equals((Object)comment)) continue;
                return lines;
            }
            if (nextToken.equals("*")) {
                if (comment == null) {
                    comment = Comment.SLASH_STAR_FIRST;
                    continue;
                }
                if (Comment.SLASH_STAR_FIRST.equals((Object)comment)) {
                    comment = Comment.SLASH_STAR_SECOND;
                    continue;
                }
                if (!Comment.SLASH_STAR_SECOND.equals((Object)comment)) continue;
                return -1;
            }
            if (nextToken.equals("\n")) {
                ++lines;
                if (!Comment.SLASH_SLASH.equals((Object)comment)) continue;
                return lines;
            }
            if (!Comment.SLASH_STAR_SECOND.equals((Object)comment)) continue;
            return -1;
        }
        return -1;
    }

    private void a(String text, String identifyingPath, Architecture architecture, List<u> toplevelArtifacts, a action) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'tokenize' must not be empty";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'tokenize' must not be empty";
        assert (architecture != null) : "Parameter 'architecture' of method 'tokenize' must not be null";
        assert (toplevelArtifacts != null) : "Parameter 'toplevelArtifacts' of method 'tokenize' must not be null";
        int currentLine = 1;
        boolean isExposed = false;
        StringTokenizer tokenizer = new StringTokenizer(text, s.a(), true);
        while (tokenizer.hasMoreTokens()) {
            u nextCurrentArtifactEntry;
            String content;
            String identifyingPathToApply;
            String nextToken = tokenizer.nextToken();
            if (b.isTraceEnabled()) {
                b.trace("Token '" + nextToken + "' [line=" + currentLine + "]");
            }
            if (nextToken.equals("\"")) {
                currentLine += this.a(tokenizer);
                continue;
            }
            if (nextToken.equals("template")) {
                int lines = this.c(tokenizer);
                if (lines == -1) {
                    return;
                }
                currentLine += lines;
                continue;
            }
            if (nextToken.equals("connection-scheme")) {
                int lines = this.c(tokenizer);
                if (lines == -1) {
                    return;
                }
                currentLine += lines;
                continue;
            }
            if (nextToken.equals("/")) {
                int lines = this.d(tokenizer);
                if (lines == -1) {
                    return;
                }
                currentLine += lines;
                continue;
            }
            if (nextToken.equals("apply")) {
                t info = this.a(tokenizer, architecture);
                currentLine += info.a();
                identifyingPathToApply = info.b();
                content = info.c();
                if (identifyingPathToApply == null || identifyingPathToApply.isEmpty() || content == null || content.isEmpty()) continue;
                b.debug("[" + identifyingPath + "] 'apply' " + identifyingPathToApply + " [line=" + currentLine + "]");
                if (this.a(identifyingPathToApply, this.d.peek())) {
                    this.a(content, identifyingPathToApply, architecture, toplevelArtifacts, null);
                    continue;
                }
                b.debug("Was already included");
                continue;
            }
            if (nextToken.equals("require")) {
                t info = this.a(tokenizer, architecture);
                currentLine += info.a();
                identifyingPathToApply = info.b();
                content = info.c();
                if (identifyingPathToApply == null || identifyingPathToApply.isEmpty() || content == null || content.isEmpty()) continue;
                b.debug("[" + identifyingPath + "] 'require' " + identifyingPathToApply + " [line=" + currentLine + "]");
                if (this.a(identifyingPathToApply, this.d.peek())) {
                    this.a(content, identifyingPathToApply, architecture, toplevelArtifacts, null);
                    continue;
                }
                b.debug("Was already included");
                continue;
            }
            if (nextToken.equals("exposed")) {
                isExposed = true;
                continue;
            }
            if (nextToken.equals("artifact")) {
                String nextNameToken = this.b(tokenizer);
                if (nextNameToken == null) {
                    return;
                }
                if (nextNameToken.isEmpty()) continue;
                u nextArtifactEntry = new u(identifyingPath, this.a(nextNameToken), nextNameToken, currentLine, isExposed);
                isExposed = false;
                u nextParentArtifact = this.d.peek();
                if (nextParentArtifact == null) {
                    toplevelArtifacts.add(nextArtifactEntry);
                } else {
                    nextParentArtifact.b(nextArtifactEntry);
                }
                this.d.push(nextArtifactEntry);
                continue;
            }
            if (nextToken.equals("interface")) {
                String nextNameToken = this.b(tokenizer);
                if (nextNameToken == null) {
                    return;
                }
                if (nextNameToken.isEmpty() || (nextCurrentArtifactEntry = this.d.peek()) == null) continue;
                nextCurrentArtifactEntry.a(nextNameToken);
                continue;
            }
            if (nextToken.equals("connector")) {
                String nextNameToken = this.b(tokenizer);
                if (nextNameToken == null) {
                    return;
                }
                if (nextNameToken.isEmpty() || (nextCurrentArtifactEntry = this.d.peek()) == null) continue;
                nextCurrentArtifactEntry.b(nextNameToken);
                continue;
            }
            if (nextToken.equals("{")) {
                u artifactEntry = this.d.peek();
                if (artifactEntry == null) continue;
                artifactEntry.e();
                b.trace("'{': " + artifactEntry.toString());
                continue;
            }
            if (nextToken.equals("}")) {
                u artifact = this.d.peek();
                if (artifact == null || artifact.f() > 0) continue;
                artifact.a(currentLine);
                if (action != null) {
                    action.a(artifact);
                }
                this.d.pop();
                continue;
            }
            if (!nextToken.equals("\n")) continue;
            ++currentLine;
        }
    }

    static u a(String text, int line, List<u> toplevelArtifacts, String identifyingPath, Architecture architecture) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'collectArtifactAndInterfaceProposals' must not be empty";
        assert (toplevelArtifacts != null) : "Parameter 'toplevelArtifacts' of method 'collectArtifacts' must not be null";
        assert (architecture != null) : "Parameter 'architecture' of method 'collectArtifacts' must not be null";
        AutoCompletionArtifactCollector collector = new AutoCompletionArtifactCollector();
        a finishArtifactAction = new a(line);
        collector.a(text, identifyingPath, architecture, toplevelArtifacts, finishArtifactAction);
        if (b.isTraceEnabled()) {
            for (u next : toplevelArtifacts) {
                b.trace("\n" + next);
            }
        }
        return finishArtifactAction.a();
    }

    private static enum Comment {
        SLASH_SLASH,
        SLASH_STAR_FIRST,
        SLASH_STAR_SECOND;

    }

    private static final class a {
        private final int b;
        private u c;

        a(int line) {
            this.b = line;
        }

        void a(u artifact) {
            assert (artifact != null) : "Parameter 'artifact' of method 'finish' must not be null";
            if (this.c == null && this.b >= artifact.g() && this.b <= artifact.h()) {
                this.c = artifact;
            }
        }

        u a() {
            return this.c;
        }
    }
}

