/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.api;

import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IElementAccess;
import com.hello2morrow.sonargraph.api.IIssueAccess;
import com.hello2morrow.sonargraph.api.IScmPeriod;
import com.hello2morrow.sonargraph.api.ScmPeriod;
import com.hello2morrow.sonargraph.core.api.model.AggregatedDependencyAccess;
import com.hello2morrow.sonargraph.core.api.model.ComponentAccess;
import com.hello2morrow.sonargraph.core.api.model.DependencyAccess;
import com.hello2morrow.sonargraph.core.api.model.DirectoryAccess;
import com.hello2morrow.sonargraph.core.api.model.DirectoryFragmentAccess;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.api.model.ExternalAccess;
import com.hello2morrow.sonargraph.core.api.model.ExternalElementContainerAccess;
import com.hello2morrow.sonargraph.core.api.model.FieldAccess;
import com.hello2morrow.sonargraph.core.api.model.GenericClassAccess;
import com.hello2morrow.sonargraph.core.api.model.GenericFieldAccess;
import com.hello2morrow.sonargraph.core.api.model.GenericFunctionAccess;
import com.hello2morrow.sonargraph.core.api.model.GenericMethodAccess;
import com.hello2morrow.sonargraph.core.api.model.IssueAccess;
import com.hello2morrow.sonargraph.core.api.model.LogicalExternalAccess;
import com.hello2morrow.sonargraph.core.api.model.LogicalModuleAccess;
import com.hello2morrow.sonargraph.core.api.model.LogicalModuleProgrammingElementAccess;
import com.hello2morrow.sonargraph.core.api.model.LogicalNamespaceAccess;
import com.hello2morrow.sonargraph.core.api.model.LogicalSystemAccess;
import com.hello2morrow.sonargraph.core.api.model.LogicalSystemProgrammingElementAccess;
import com.hello2morrow.sonargraph.core.api.model.MethodAccess;
import com.hello2morrow.sonargraph.core.api.model.ModuleAccess;
import com.hello2morrow.sonargraph.core.api.model.NamespaceFragmentAccess;
import com.hello2morrow.sonargraph.core.api.model.PluginProgrammingElement;
import com.hello2morrow.sonargraph.core.api.model.PluginProgrammingElementAccess;
import com.hello2morrow.sonargraph.core.api.model.ProgrammingElementAccess;
import com.hello2morrow.sonargraph.core.api.model.RootAccess;
import com.hello2morrow.sonargraph.core.api.model.RoutineAccess;
import com.hello2morrow.sonargraph.core.api.model.SourceFileAccess;
import com.hello2morrow.sonargraph.core.api.model.TypeAccess;
import com.hello2morrow.sonargraph.core.api.model.architecture.ArchitectureModelAccess;
import com.hello2morrow.sonargraph.core.api.model.architecture.ArtifactAccess;
import com.hello2morrow.sonargraph.core.api.model.architecture.ConnectorAccess;
import com.hello2morrow.sonargraph.core.api.model.architecture.InterfaceAccess;
import com.hello2morrow.sonargraph.core.api.model.architecture.UnassignedExternalAccess;
import com.hello2morrow.sonargraph.core.api.model.architecture.UnassignedInternalAccess;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.author.Author;
import com.hello2morrow.sonargraph.core.model.author.AuthorsInfo;
import com.hello2morrow.sonargraph.core.model.author.IAuthorsProvider;
import com.hello2morrow.sonargraph.core.model.author.SourceFilesToAuthorsInfo;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericClass;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericField;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericFunction;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericMethod;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IHierarchicalIssueProvider;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.AbstractComponent;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.programming.ExternalElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreFactoryVisitor
extends NamedElementVisitor
implements ElementAccess.IAccessFactory,
PluginProgrammingElement.IVisitor,
ArchitectureFile.IVisitor,
Artifact.IVisitor,
Connector.IVisitor,
Interface.IVisitor,
UnassignedExternal.IVisitor,
UnassignedInternal.IVisitor,
GenericClass.IVisitor,
GenericField.IVisitor,
GenericFunction.IVisitor,
GenericMethod.IVisitor,
DirectoryFragment.IVisitor,
DirectoryPath.IVisitor,
SourceFile.IVisitor,
AbstractComponent.IVisitor,
ExternalElementContainer.IVisitor,
ExternalLogicalNamespaceRoot.IVisitor,
InternalLogicalNamespaceRoot.IVisitor,
LogicalModuleProgrammingElement.IVisitor,
LogicalNamespace.IVisitor,
LogicalSystemProgrammingElement.IVisitor,
NamespaceFragment.IVisitor,
PhysicalElementBasedLogicalRoot.IVisitor,
ProgrammingElement.IVisitor,
LogicalModuleNamespaces.IVisitor,
LogicalSystemNamespaces.IVisitor,
External.IVisitor,
Module.IVisitor,
ModuleBasedLogicalNamespaceRoot.IVisitor,
Workspace.IVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreFactoryVisitor.class);
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private SourceFilesToAuthorsInfo m_sourceFilesToAuthors;
    protected ElementAccess<? extends NamedElement> m_product;

    public CoreFactoryVisitor(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'CoreFactoryVisitor' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'CoreFactoryVisitor' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public final Number getMetricValue(NamedElement element, IMetricId id) {
        return this.m_installation.getExtension(IMetricAccessor.class).getMetricValue(this.m_softwareSystem, element, id);
    }

    @Override
    public Set<String> getAuthors(NamedElement element, IScmPeriod period) {
        Author[] authors;
        if (this.m_sourceFilesToAuthors == null) {
            this.m_sourceFilesToAuthors = this.m_softwareSystem.getExtension(IAuthorsProvider.class).getSourceFilesToAuthors();
        }
        if (this.m_sourceFilesToAuthors == null) {
            throw new UnsupportedOperationException("No SCM info available.");
        }
        if (!(element instanceof SourceFile)) {
            throw new IllegalArgumentException("Not a source file: " + element);
        }
        SourceFile sourceFile = (SourceFile)element;
        AuthorsInfo authorsInfo = this.m_sourceFilesToAuthors.getInfo().get(sourceFile);
        if (authorsInfo == null) {
            return Collections.emptySet();
        }
        if (period == ScmPeriod._30_DAYS) {
            authors = authorsInfo.getAuthors30();
        } else if (period == ScmPeriod._90_DAYS) {
            authors = authorsInfo.getAuthors90();
        } else if (period == ScmPeriod._365_DAYS) {
            authors = authorsInfo.getAuthors365();
        } else if (period == ScmPeriod._2_YEARS) {
            authors = authorsInfo.getAuthors2y();
        } else if (period == ScmPeriod._5_YEARS) {
            authors = authorsInfo.getAuthors5y();
        } else {
            throw new IllegalArgumentException("Unsupported period: " + period);
        }
        return AuthorsInfo.convertArrayToSetOfStrings(authors);
    }

    @Override
    public final Number getMetricValue(NamedElement element, IMetricLevel level, IMetricId id) {
        return this.m_installation.getExtension(IMetricAccessor.class).getMetricValue(this.m_softwareSystem, element, level, id, true);
    }

    @Override
    public void visitAbstractComponent(AbstractComponent element) {
        this.m_product = new ComponentAccess(element, (ElementAccess.IAccessFactory)this);
    }

    @Override
    public void visitModule(Module element) {
        this.m_product = new ModuleAccess(element);
    }

    @Override
    public void visitInterface(Interface element) {
        this.m_product = new InterfaceAccess(element);
    }

    @Override
    public void visitConnector(Connector element) {
        this.m_product = new ConnectorAccess(element);
    }

    @Override
    public void visitArtifact(Artifact element) {
        this.m_product = new ArtifactAccess(element);
    }

    @Override
    public void visitUnassignedInternal(UnassignedInternal element) {
        this.m_product = new UnassignedInternalAccess(element);
    }

    @Override
    public void visitUnassignedExternal(UnassignedExternal element) {
        this.m_product = new UnassignedExternalAccess(element);
    }

    @Override
    public void visitArchitectureFile(ArchitectureFile element) {
        this.m_product = new ArchitectureModelAccess(element);
    }

    @Override
    public void visitModuleBasedLogicalNamespaceRoot(ModuleBasedLogicalNamespaceRoot element) {
        this.m_product = new LogicalModuleAccess(element);
    }

    @Override
    public void visitInternalLogicalNamespaceRoot(InternalLogicalNamespaceRoot element) {
        this.m_product = new LogicalSystemAccess(element);
    }

    @Override
    public void visitExternalElementContainer(ExternalElementContainer element) {
        this.m_product = new ExternalElementContainerAccess(element);
    }

    @Override
    public void visitLogicalExternal(PhysicalElementBasedLogicalRoot element) {
        this.m_product = new LogicalExternalAccess(element);
    }

    @Override
    public void visitExternalLogicalNamespaceRoot(ExternalLogicalNamespaceRoot element) {
        this.m_product = new LogicalExternalAccess(element);
    }

    @Override
    public void visitDirectoryPath(DirectoryPath element) {
        this.m_product = new DirectoryAccess(element);
    }

    @Override
    public void visitDirectoryFragment(DirectoryFragment element) {
        this.m_product = new DirectoryFragmentAccess(element);
    }

    @Override
    public void visitSourceFile(SourceFile element) {
        this.m_product = new SourceFileAccess(element);
    }

    @Override
    public void visitExternal(External element) {
        this.m_product = new ExternalAccess(element);
    }

    @Override
    public void visitNamespaceFragment(NamespaceFragment element) {
        this.m_product = new NamespaceFragmentAccess(element);
    }

    @Override
    public void visitLogicalNamespace(LogicalNamespace lns) {
        this.m_product = new LogicalNamespaceAccess(lns);
    }

    @Override
    public void visitLogicalSystemProgrammingElement(LogicalSystemProgrammingElement element) {
        this.m_product = new LogicalSystemProgrammingElementAccess(element);
    }

    @Override
    public void visitLogicalModuleProgrammingElement(LogicalModuleProgrammingElement element) {
        this.m_product = new LogicalModuleProgrammingElementAccess(element);
    }

    @Override
    public void visitGenericProgrammingElement(PluginProgrammingElement element) {
        this.m_product = new PluginProgrammingElementAccess(element);
    }

    @Override
    public void visitProgrammingElement(ProgrammingElement element) {
        this.m_product = element instanceof IType ? new TypeAccess((IType)((Object)element)) : (element instanceof IMethod ? new MethodAccess((IMethod)((Object)element)) : (element instanceof IField ? new FieldAccess((IField)((Object)element)) : (element instanceof IRoutine ? new RoutineAccess((IRoutine)((Object)element)) : new ProgrammingElementAccess(element))));
    }

    @Override
    public void visitGenericField(GenericField element) {
        this.m_product = new GenericFieldAccess(element);
    }

    @Override
    public void visitGenericClass(GenericClass element) {
        this.m_product = new GenericClassAccess(element);
    }

    @Override
    public void visitGenericFunction(GenericFunction obj) {
        this.m_product = new GenericFunctionAccess(obj);
    }

    @Override
    public void visitGenericMethod(GenericMethod obj) {
        this.m_product = new GenericMethodAccess(obj);
    }

    @Override
    public void visitLogicalSystemNamespaces(LogicalSystemNamespaces logicalNamespaces) {
        this.m_product = new RootAccess(logicalNamespaces);
    }

    @Override
    public void visitLogicalModuleNamespaces(LogicalModuleNamespaces logicalNamespaces) {
        this.m_product = new RootAccess(logicalNamespaces);
    }

    @Override
    public void visitWorkspace(Workspace element) {
        this.m_product = new RootAccess(element);
    }

    @Override
    public final ElementAccess<? extends NamedElement> createAccessObject(NamedElement element) {
        if (element == null) {
            return null;
        }
        this.m_product = null;
        element.accept(this);
        if (this.m_product == null) {
            return null;
        }
        this.m_product.setFactory(this);
        return this.m_product;
    }

    @Override
    public final IAggregatedDependencyAccess createAccessObject(AggregatedDependency dependency) {
        if (dependency == null) {
            return null;
        }
        return new AggregatedDependencyAccess(dependency, (ElementAccess.IAccessFactory)this);
    }

    private Collection<ElementWithIssues> getRelevantElements(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getRelevantElements' must not be null";
        ArrayList<ElementWithIssues> relevant = new ArrayList<ElementWithIssues>();
        if (element instanceof NamedElement) {
            if (this.createAccessObject((NamedElement)element) != null) {
                relevant.add((NamedElement)element);
            } else {
                LOGGER.warn("Unhandled element of class '" + element.getClass().getName() + "'");
            }
        } else if (element instanceof ParserDependency) {
            relevant.add((ParserDependency)element);
        } else if (element instanceof AggregatedDependency) {
            ((AggregatedDependency)element).getParserDependencies().forEach(p2 -> {
                boolean bl2 = relevant.add((ElementWithIssues)p2);
            });
        } else {
            LOGGER.warn("Unhandled element of class '" + element.getClass().getName() + "'");
        }
        return relevant;
    }

    @Override
    public final int getNumberOfIssues(Element element, List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean includingSecondaryIssues, boolean recursive) {
        assert (element != null) : "Parameter 'element' of method 'getIssues' must not be null";
        return this.m_installation.getExtension(IHierarchicalIssueProvider.class).getNumberOfIssues(this.m_softwareSystem, this.getRelevantElements(element), categories, issueIds, providers, severities, includingSecondaryIssues, recursive);
    }

    @Override
    public final List<IIssueAccess> getIssues(Element element, List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean includingSecondaryIssues, boolean recursive) {
        assert (element != null) : "Parameter 'element' of method 'getIssues' must not be null";
        List<StrictPair<Issue, ElementWithIssues>> issues = this.m_installation.getExtension(IHierarchicalIssueProvider.class).getIssues(this.m_softwareSystem, this.getRelevantElements(element), categories, issueIds, providers, severities, includingSecondaryIssues, recursive);
        if (!issues.isEmpty()) {
            ArrayList<IIssueAccess> issueAccesses = new ArrayList<IIssueAccess>();
            for (StrictPair<Issue, ElementWithIssues> nextIssue : issues) {
                ElementWithIssues nextElement = (ElementWithIssues)nextIssue.getSecond();
                if (nextElement instanceof NamedElement) {
                    ElementAccess<? extends NamedElement> elementAccess = this.createAccessObject((NamedElement)nextElement);
                    if (elementAccess != null) {
                        issueAccesses.add(new IssueAccess((Issue)nextIssue.getFirst(), (IElementAccess)elementAccess));
                        continue;
                    }
                    LOGGER.warn("Unhandled element of class '" + element.getClass().getName() + "'");
                    continue;
                }
                if (nextElement instanceof ParserDependency) {
                    issueAccesses.add(new IssueAccess((Issue)nextIssue.getFirst(), (IElementAccess)new DependencyAccess((ParserDependency)nextElement, (ElementAccess.IAccessFactory)this)));
                    continue;
                }
                LOGGER.warn("Unhandled element of class '" + nextElement.getClass().getName() + "'");
            }
            return issueAccesses;
        }
        return Collections.emptyList();
    }
}

