/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.api;

import com.hello2morrow.sonargraph.api.IComponentAccess;
import com.hello2morrow.sonargraph.core.api.controller.IArchitectureVisitor;
import com.hello2morrow.sonargraph.core.api.controller.ICoreVisitor;
import com.hello2morrow.sonargraph.core.api.model.ComponentAccess;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.controller.system.api.ArchitectureVisitor;
import com.hello2morrow.sonargraph.core.controller.system.api.CoreVisitor;
import com.hello2morrow.sonargraph.core.controllerinterface.system.e;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCoreAccess
extends ElementAccess<SoftwareSystem> {
    public AbstractCoreAccess(SoftwareSystem element) {
        super(element);
    }

    public List<IComponentAccess> getComponents(boolean includeExternals) {
        List<Object> components;
        Workspace ws = ((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class);
        if (includeExternals) {
            components = ws.getChildrenRecursively(IComponent.class, IComponent.class);
        } else {
            components = new ArrayList();
            ws.getChildren(Module.class).forEach(module -> module.getChildrenRecursively(IComponent.class, IComponent.class).forEach(comp -> {
                boolean bl2 = components.add(comp);
            }));
        }
        ArrayList<IComponentAccess> result = new ArrayList<IComponentAccess>();
        for (IComponent iComponent : components) {
            ComponentAccess comp = new ComponentAccess(iComponent, this.m_factory);
            result.add(comp);
        }
        return result;
    }

    public List<IComponentAccess> getComponents() {
        return this.getComponents(true);
    }

    public ICoreVisitor createVisitor() {
        return new CoreVisitor(this.m_factory, null);
    }

    public final IArchitectureVisitor createArchitectureVisitor() {
        return new ArchitectureVisitor(this.m_factory);
    }

    public final void visitActiveArchitectureModels(IArchitectureVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitActiveArchitectureModels' must not be null";
        Architecture archNode = ((SoftwareSystem)this.m_element).getUniqueExistingChild(Files.class).getArchitecture();
        archNode.getChildren(ArchitectureFile.class).stream().filter(af2 -> af2.isChecked()).forEach(af2 -> af2.accept((ArchitectureVisitor)visitor));
    }

    public final void visitActiveArchitectureModel(IArchitectureVisitor visitor, String name) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitActiveArchitectureModel' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'visitActiveArchitectureModel' must not be empty";
        String findByName = String.valueOf(name.startsWith("./") ? name : "./" + name) + (name.endsWith(".arc") ? "" : ".arc");
        ArchitectureFile found = null;
        for (ArchitectureFile architectureFile : ((SoftwareSystem)this.m_element).getExtension(e.class).getAvailableArchitectureFiles()) {
            if (!findByName.equals(architectureFile.getName())) continue;
            found = architectureFile;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("No architecture model with name '" + findByName + "' found");
        }
        if (!found.isChecked()) {
            throw new IllegalArgumentException("Architecture model with name '" + findByName + "' not active (i.e. not checked)");
        }
        found.accept((ArchitectureVisitor)visitor);
    }

    public final ElementAccess<? extends NamedElement> findElementByFqn(String fqn) {
        if (fqn == null || fqn.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter 'fqn' must not be null or empty");
        }
        ISoftwareSystemProvider ssp = ((SoftwareSystem)this.m_element).getExtension(ISoftwareSystemProvider.class);
        NamedElement result = ssp.getElementResolver().resolve((Root)this.m_element, fqn);
        if (result == null) {
            return null;
        }
        return this.m_factory.createAccessObject(result);
    }

    public final void visitModel(ICoreVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        ((SoftwareSystem)this.m_element).accept((CoreVisitor)visitor);
    }

    public final void visitParserModel(ICoreVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        ((SoftwareSystem)this.m_element).getUniqueExistingChild(Workspace.class).accept((CoreVisitor)visitor);
    }

    public final void visitLogicalModuleNamespaces(ICoreVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        ((SoftwareSystem)this.m_element).getUniqueExistingChild(LogicalModuleNamespaces.class).accept((CoreVisitor)visitor);
    }

    public final void visitLogicalSystemNamespaces(ICoreVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Parameter 'visitor' must not be null");
        }
        ((SoftwareSystem)this.m_element).getUniqueExistingChild(LogicalSystemNamespaces.class).accept((CoreVisitor)visitor);
    }

    @Override
    public Object getMetricLevel() {
        return CoreMetricLevel.SYSTEM;
    }

    public final Float getACDMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_ACD);
    }

    public final Integer getBiggestComponentCycleGroupMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_BIGGEST_COMPONENT_CYCLE_GROUP);
    }

    public final Integer getCCDMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_CCD);
    }

    public final Integer getCodeCommentLinesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_CODE_COMMENT_LINES);
    }

    public final Integer getCommentLinesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_COMMENT_LINES);
    }

    public final Integer getLinesOfCodeMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_LINES_OF_CODE);
    }

    public final Float getNCCDMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_NCCD);
    }

    public final Integer getNumberOfComponentCycleGroupsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_COMPONENT_CYCLE_GROUPS);
    }

    public final Integer getNumberOfComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_COMPONENTS);
    }

    public final Integer getNumberOfCyclicComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_CYCLIC_COMPONENTS);
    }

    public final Integer getNumberOfIgnoredCyclicComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_IGNORED_CYCLIC_COMPONENTS);
    }

    public final Integer getNumberOfStatementsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_STATEMENTS);
    }

    public final Float getPropagationCostMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_PROPAGATION_COST);
    }

    public final Integer getSourceElementCountMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT);
    }

    public final Integer getTotalLinesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_TOTAL_LINES);
    }

    public final Integer getNumberOfCodeDuplicatesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_DUPLICATES);
    }

    public final Integer getNumberOfDuplicatedLinesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_DUPLICATED_LINES);
    }

    public final Integer getNumberOfIgnoredCodeDuplicatesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_IGNORED_DUPLICATES);
    }

    public final Float getBiggestModuleACDMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_MAX_ACD);
    }

    public final Integer getComponentCyclicityMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_CYCLICITY_COMPONENTS);
    }

    public final Float getComponentRelativeCyclicityMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS);
    }

    public final Integer getComponentStructuralDebtIndexMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_STRUCTURAL_DEBT_INDEX_COMPONENTS);
    }

    public final Integer getComponentParserDependenciesToRemoveMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_PARSER_DEPENDENCIES_TO_REMOVE_COMPONENTS);
    }

    public final Integer getComponentDependenciesToRemoveMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_COMPONENT_DEPENDENCIES_TO_REMOVE_COMPONENTS);
    }

    public final Integer getNumberOfUnassignedComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_UNASSIGNED_COMPONENTS);
    }

    public final Integer getNumberOfComponentViolationsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_VIOLATIONS_COMPONENT_DEPENDENCIES);
    }

    public final Integer getNumberOfViolatingComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_VIOLATING_COMPONENTS);
    }

    @Deprecated
    public final Integer getNumberOfAllViolatingComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_VIOLATING_COMPONENTS);
    }

    public final Integer getNumberOfParserDependencyViolationsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES);
    }

    public final Integer getNumberOfIgnoredParserDependencyViolationsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_IGNORED_VIOLATIONS_PARSER_DEPENDENCIES);
    }

    public final Integer getNumberOfModulesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_MODULES);
    }

    public final Integer getNumberOfCyclicModulesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_CYCLIC_MODULES);
    }

    public final Integer getNumberOfArtifactsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_ARTIFACT_COUNT);
    }

    public final Integer getNumberOfEmptyArtifactsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_EMPTY_ARTIFACT_COUNT);
    }

    @Deprecated
    public final Integer getNumberOfComponntsInDeprectaedArtifactsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_COMPONENTS_IN_DEPRECATED_ARTIFACTS);
    }

    @Deprecated
    public final Integer getNumberOfComponentsInDeprecatedArtifactsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_COMPONENTS_IN_DEPRECATED_ARTIFACTS);
    }

    public final Float getMaintainabilityLevelMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.SYSTEM, CoreMetricId.CORE_MAINTAINABILITY_LEVEL);
    }

    public final File getBaseDirectory() {
        return new File(((SoftwareSystem)this.getElement()).getBaseDirectory());
    }

    public final String getBaseDirectoryPath() {
        return ((SoftwareSystem)this.getElement()).getBaseDirectory();
    }
}

