/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import java.math.BigDecimal;

public class ap
implements ITextValidator {
    private final Number a;
    private final Number b;
    private final boolean c;

    public ap(Number lowerBorder, Number upperBorder, boolean isDecimal) {
        this.a = lowerBorder != null ? lowerBorder : new BigDecimal(Integer.MIN_VALUE);
        this.b = upperBorder != null ? upperBorder : new BigDecimal(Integer.MAX_VALUE);
        this.c = isDecimal;
    }

    @Override
    public ValidationResult isValid(String initialInput, String newInput) {
        int numberOfDecimalDigits;
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
        if (newInput == null || newInput.trim().length() == 0) {
            result.addError("Must not be empty");
            newInput = "";
        }
        String trimmedInput = newInput.trim();
        int decimalIndex = trimmedInput.indexOf(NumberUtility.getDecimalSeparator());
        if (!this.c && decimalIndex > -1) {
            result.addError("No decimal number allowed");
            return result;
        }
        Number number = NumberUtility.parse((String)trimmedInput, (!this.c ? 1 : 0) != 0, (boolean)true);
        if (number == null) {
            result.addError("Invalid number format");
            return result;
        }
        int n2 = numberOfDecimalDigits = decimalIndex < 0 ? 0 : trimmedInput.length() - decimalIndex - 1;
        if (numberOfDecimalDigits > 2) {
            result.addError("Only up to 2 decimal digits supported");
            return result;
        }
        int groupingIndex = trimmedInput.indexOf(NumberUtility.getGroupingSeparator());
        if (groupingIndex == 0) {
            result.addError("Number must not start with grouping character '" + NumberUtility.getGroupingSeparator() + "'");
            return result;
        }
        if (decimalIndex > -1 && groupingIndex > decimalIndex) {
            result.addError("Wrong position of grouping character '" + NumberUtility.getGroupingSeparator() + "'");
            return result;
        }
        boolean endReached = false;
        while (!endReached && groupingIndex > 0) {
            int nextGroupingIndex = trimmedInput.indexOf(NumberUtility.getGroupingSeparator(), groupingIndex + 1);
            if (nextGroupingIndex == -1) {
                nextGroupingIndex = trimmedInput.indexOf(NumberUtility.getDecimalSeparator());
                endReached = true;
            }
            if (nextGroupingIndex == -1) {
                nextGroupingIndex = trimmedInput.length();
                endReached = true;
            }
            if ((nextGroupingIndex - (groupingIndex + 1)) % 3 != 0) {
                result.addError("Wrong position of grouping character '" + NumberUtility.getGroupingSeparator() + "'");
                return result;
            }
            groupingIndex = nextGroupingIndex;
        }
        if (this.a != null) {
            if (!this.c && number.longValue() < this.a.longValue()) {
                result.addError("Number must not be lower than '" + NumberUtility.format((Number)this.a, (boolean)true) + "'");
                return result;
            }
            if (this.c && number.doubleValue() < this.a.doubleValue()) {
                result.addError("Number must not be lower than '" + NumberUtility.format((Number)this.a, (boolean)true) + "'");
                return result;
            }
        }
        if (this.b != null) {
            if (!this.c && number.longValue() > this.b.longValue()) {
                result.addError("Number must not be lower than '" + NumberUtility.format((Number)this.a, (boolean)true) + "'");
                return result;
            }
            if (this.c && number.doubleValue() > this.b.doubleValue()) {
                result.addError("Number must not be greater than '" + NumberUtility.format((Number)this.b, (boolean)true) + "'");
                return result;
            }
        }
        return result;
    }
}

