/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.text.IntBasedHash;
import com.hello2morrow.foundation.text.Levenshtein;
import com.hello2morrow.sonargraph.core.controller.system.analysis.b;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.FloatThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.IntegerThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.LastScriptRunnerExecutionStatus;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.MetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptMetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.MetricDescriptor;
import com.hello2morrow.sonargraph.core.model.metrics.MetricValue;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.SourceFileReferenceWithLineNumberAndContext;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.script.AutomatedGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.AutomatedScriptDuplicateMetricDefinition;
import com.hello2morrow.sonargraph.core.model.script.IScriptMetricId;
import com.hello2morrow.sonargraph.core.model.script.ScriptElementIssueWithDescription;
import com.hello2morrow.sonargraph.core.model.script.ScriptElementIssueWithDescriptionAndLine;
import com.hello2morrow.sonargraph.core.model.script.ScriptElementIssueWithDescriptionAndLineContext;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueId;
import com.hello2morrow.sonargraph.core.model.script.ScriptParserDependencyIssue;
import com.hello2morrow.sonargraph.core.model.script.ScriptProviderId;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class j
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    private static final Logger d = LoggerFactory.getLogger(j.class);
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.SCRIPT_RUNNER;
    private final Map<String, MetricProvider> e = new THashMap();

    public j(g controller) {
        super(controller, a);
    }

    private void a(final AutomatedGroovyScript automatedGroovyScript, final Installation installation, final AnalyzerResult result, final Map<String, MetricDescriptor> metricDescriptors) {
        assert (automatedGroovyScript != null) : "Parameter 'automatedGroovyScript' of method 'collectMetricInfo' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'collectMetricInfo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'collectMetricInfo' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'collectMetricInfo' must not be null";
        final String nextIdentifyingPath = automatedGroovyScript.getIdentifyingPath();
        automatedGroovyScript.getResultSet().visitMetricValues(new ScriptResultSet.IMetricValueVisitor(){

            @Override
            public void visitMetricValue(IScriptMetricId id, IMetricLevel level, NamedElement element, Number value) {
                String metricDescriptorKey = String.valueOf(id.getStandardName()) + ":" + level.getStandardName();
                MetricDescriptor descriptor = (MetricDescriptor)metricDescriptors.get(metricDescriptorKey);
                if (descriptor == null) {
                    MetricProvider nextMetricProvider = j.this.e.get(nextIdentifyingPath);
                    if (nextMetricProvider == null) {
                        ScriptProviderId metricProviderId = new ScriptProviderId(nextIdentifyingPath);
                        nextMetricProvider = new ScriptMetricProvider(installation.getMetricProviders(), metricProviderId);
                        installation.getMetricProviders().addChild(nextMetricProvider);
                        j.this.e.put(nextIdentifyingPath, nextMetricProvider);
                        installation.addProviderIds(Collections.singleton(metricProviderId));
                    }
                    descriptor = new MetricDescriptor(nextMetricProvider, id, level, j.this.o().getId(), null, null);
                    nextMetricProvider.addChild(descriptor);
                    metricDescriptors.put(metricDescriptorKey, descriptor);
                    if (id.getLowerThreshold() != null || id.getUpperThreshold() != null) {
                        Number upperThreshold;
                        Number lowerThreshold = id.getLowerThreshold();
                        if (lowerThreshold == null) {
                            lowerThreshold = Float.valueOf(id.isFloat() ? Float.MIN_VALUE : -2.1474836E9f);
                        }
                        if ((upperThreshold = id.getUpperThreshold()) == null) {
                            upperThreshold = Float.valueOf(id.isFloat() ? Float.MAX_VALUE : 2.1474836E9f);
                        }
                        MetricThreshold th = null;
                        th = id.isFloat() ? new FloatThreshold(result, descriptor, new BigDecimal(lowerThreshold.toString()), new BigDecimal(upperThreshold.toString()), Severity.WARNING) : new IntegerThreshold(result, descriptor, lowerThreshold.intValue(), upperThreshold.intValue(), Severity.WARNING);
                        result.addChild(th);
                    }
                    result.addChild(new MetricValue(result, element, value, descriptor));
                    j.this.l();
                    j.this.m();
                    installation.metricDescriptorsChanged();
                } else {
                    MetricProvider metricProvider = descriptor.getParent(MetricProvider.class, new Class[0]);
                    if (!b && metricProvider == null) {
                        throw new AssertionError((Object)"Parameter 'metricProvider' of method 'internalRun' must not be null");
                    }
                    if (!metricProvider.getProvider().getStandardName().equals(nextIdentifyingPath)) {
                        StringBuilder builder = new StringBuilder("Ignoring metric '");
                        builder.append(metricDescriptorKey);
                        builder.append("' in script '");
                        builder.append(nextIdentifyingPath);
                        builder.append("' - already defined in scipt '");
                        builder.append(metricProvider.getProvider().getStandardName());
                        builder.append("'");
                        automatedGroovyScript.addIssue(new AutomatedScriptDuplicateMetricDefinition(automatedGroovyScript, builder.toString()));
                    } else {
                        result.addChild(new MetricValue(result, element, value, descriptor));
                        j.this.l();
                    }
                }
            }
        });
    }

    private void a(AutomatedGroovyScript automatedGroovyScript, final Installation installation, final VirtualModel model) {
        assert (automatedGroovyScript != null) : "Parameter 'automatedGroovyScript' of method 'collectIssueInfo' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'collectIssueInfo' must not be null";
        assert (model != null) : "Parameter 'model' of method 'collectIssueInfo' must not be null";
        final LinkedHashMap<ElementWithIssues, List<Issue>> lineBasedIssueCollector = new LinkedHashMap<ElementWithIssues, List<Issue>>();
        automatedGroovyScript.getResultSet().visitIssueInfo(new ScriptResultSet.IIssueInfoVisitor(){

            @Override
            public void issueInfo(Element element, ScriptIssueId issueId, String description) {
                if (!b && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'issueInfo' must not be null");
                }
                if (!b && issueId == null) {
                    throw new AssertionError((Object)"Parameter 'issueId' of method 'issueInfo' must not be null");
                }
                if (!b && description == null) {
                    throw new AssertionError((Object)"Parameter 'description' of method 'issueInfo' must not be null");
                }
                if (!element.ignoreIssues()) {
                    if (element instanceof ParserDependency) {
                        model.addElementIssue((ParserDependency)element, new ScriptParserDependencyIssue((ParserDependency)element, issueId, description));
                    } else if (element instanceof ElementWithIssues) {
                        model.addElementIssue((ElementWithIssues)element, new ScriptElementIssueWithDescription((NamedElement)element, issueId, description));
                    } else if (!b) {
                        throw new AssertionError((Object)("Unsupported class '" + element.getClass().getCanonicalName() + "'"));
                    }
                }
                installation.addProviderIds(Collections.singleton(issueId.getProvider()));
                installation.addIssueIds(Collections.singleton(issueId));
            }

            @Override
            public void issueInfo(SourceFile element, ScriptIssueId issueId, String description, int line) {
                if (!b && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'issueInfo' must not be null");
                }
                if (!b && issueId == null) {
                    throw new AssertionError((Object)"Parameter 'issueId' of method 'issueInfo' must not be null");
                }
                if (!b && description == null) {
                    throw new AssertionError((Object)"Parameter 'description' of method 'issueInfo' must not be null");
                }
                if (!element.ignoreIssues()) {
                    model.addElementIssue(element, new ScriptElementIssueWithDescriptionAndLine(element, issueId, description, line));
                }
                installation.addProviderIds(Collections.singleton(issueId.getProvider()));
                installation.addIssueIds(Collections.singleton(issueId));
            }

            @Override
            public void issueInfo(SourceFile element, ScriptIssueId issueId, String description, SourceFileReferenceWithLineNumberAndContext line) {
                if (!b && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'issueInfo' must not be null");
                }
                if (!b && issueId == null) {
                    throw new AssertionError((Object)"Parameter 'issueId' of method 'issueInfo' must not be null");
                }
                if (!b && description == null) {
                    throw new AssertionError((Object)"Parameter 'description' of method 'issueInfo' must not be null");
                }
                if (!b && line == null) {
                    throw new AssertionError((Object)"Parameter 'line' of method 'issueInfo' must not be null");
                }
                if (!element.ignoreIssues()) {
                    IntBasedHash prefixHashs = Levenshtein.createHashsForWordsOfLines((String[])line.getSourceLine().getPrefix());
                    IntBasedHash postfixHashs = Levenshtein.createHashsForWordsOfLines((String[])line.getSourceLine().getPostfix());
                    List sourceFileIssues = lineBasedIssueCollector.computeIfAbsent(element, e2 -> new ArrayList(1));
                    sourceFileIssues.add(new ScriptElementIssueWithDescriptionAndLineContext(element, issueId, description, line.getLineNumber(), line.getSourceLine().getText(), prefixHashs, postfixHashs));
                }
                installation.addProviderIds(Collections.singleton(issueId.getProvider()));
                installation.addIssueIds(Collections.singleton(issueId));
            }
        });
        if (!lineBasedIssueCollector.isEmpty()) {
            model.addElementIssues(lineBasedIssueCollector);
        }
    }

    @Override
    protected void a(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        ScriptRunnerConfiguration configuration = this.o().getConfiguration(ScriptRunnerConfiguration.class);
        assert (configuration != null) : "'configuration' of method 'runJobs' must not be null";
        List<ScriptRunnerData> scriptRunnerData = configuration.getScriptRunnerData();
        if (!scriptRunnerData.isEmpty()) {
            a job = new a(this.p(), result, this.g(), scriptRunnerData, this.d());
            job.i();
        }
    }

    @Override
    protected boolean b(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        VirtualModel vm = this.j();
        THashSet issueIds = new THashSet();
        THashSet providerIds = new THashSet();
        for (AutomatedGroovyScript next : result.getChildren(AutomatedGroovyScript.class)) {
            for (IIssueId iIssueId : next.getResultSet().getIssueIds()) {
                issueIds.add(iIssueId);
            }
            for (IProviderId iProviderId : next.getResultSet().getIssueProviderIds()) {
                providerIds.add(iProviderId);
            }
        }
        if (!issueIds.isEmpty()) {
            assert (!providerIds.isEmpty()) : "Parameter 'providerIds' of method 'reset' must not be empty";
            vm.removeElementIssues(issueIds.toArray(new IIssueId[issueIds.size()]));
            this.g().o().removeIssueIds((Collection<? extends IIssueId>)issueIds);
        }
        THashSet descriptors = new THashSet();
        for (MetricValue nextMetricValue : result.getChildren(MetricValue.class)) {
            descriptors.add(nextMetricValue.getMetricDescriptor());
        }
        this.k().b((Collection<IMetricDescriptor>)descriptors);
        THashSet metricProviders = new THashSet();
        for (IMetricDescriptor iMetricDescriptor : descriptors) {
            MetricDescriptor descriptor = (MetricDescriptor)iMetricDescriptor;
            MetricProvider nextMetricProvider = descriptor.getParent(MetricProvider.class, new Class[0]);
            assert (nextMetricProvider != null) : "Parameter 'nextMetricProvider' of method 'clear' must not be null";
            metricProviders.add(nextMetricProvider);
            descriptor.remove();
        }
        for (MetricProvider metricProvider : metricProviders) {
            if (metricProvider.hasChildren(false, IMetricDescriptor.class)) continue;
            MetricProvider nextRemoved = this.e.remove(metricProvider.getProvider().getStandardName());
            assert (nextRemoved == metricProvider) : "Different instances";
            providerIds.add(nextRemoved.getProvider());
            metricProvider.remove();
        }
        this.g().o().removeProviderIds((Set<IProviderId>)providerIds);
        result.removeChildren(LastScriptRunnerExecutionStatus.class);
        vm.removeElementIssues(issue -> issue.getAffectedElement() instanceof AutomatedGroovyScript);
        return super.b(result);
    }

    @Override
    protected IssueFilter f(AnalyzerResult result) {
        IssueFilter filter = super.f(result);
        for (AutomatedGroovyScript script : result.getChildren(AutomatedGroovyScript.class)) {
            ScriptProviderId providerId = new ScriptProviderId(script.getIdentifyingPath());
            filter.add(providerId);
        }
        return filter.isEmpty() ? null : filter;
    }

    @Override
    protected void g(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'finished' must not be null";
        this.k().a();
        for (IMetricThreshold th : result.getChildren(IMetricThreshold.class)) {
            for (IMetricValue value : result.getChildren(IMetricValue.class)) {
                if (value.getMetricDescriptor() != th.getMetricDescriptor()) continue;
                this.a(th, value);
            }
        }
        super.g(result);
    }

    private final class a
    extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.b {
        private final List<ScriptRunnerData> d;

        a(AnalyzerGroup group, AnalyzerResult result, g controller, List<ScriptRunnerData> scriptRunnerData, Collection<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
            assert (scriptRunnerData != null && !scriptRunnerData.isEmpty()) : "Parameter 'scriptRunnerData' of method 'ScriptRunnerAnalyzerJob' must not be empty";
            this.d = scriptRunnerData;
        }

        @Override
        protected void a() {
            if (!this.d.isEmpty()) {
                d.debug("Execute " + this.d.size() + " automated script(s)");
                b scriptAccess = this.c().getExtension(b.class);
                com.hello2morrow.sonargraph.core.controller.system.script.internal.b metricIdProvider = new com.hello2morrow.sonargraph.core.controller.system.script.internal.b();
                AnalyzerResult result = this.getResult();
                Installation installation = this.d();
                VirtualModel vm = j.this.j();
                IWorkerContext workerContext = this.g();
                THashMap metricDescriptors = new THashMap();
                int numberOfScripts = this.d.size();
                int numberOfNotExecutedScripts = 0;
                workerContext.setNumberOfSteps(numberOfScripts);
                for (ScriptRunnerData next : this.d) {
                    if (workerContext.hasBeenCanceled()) break;
                    String nextIdentifyingPath = next.getIdentifyingScriptPath();
                    d.debug("Executing script '" + nextIdentifyingPath + "'");
                    AutomatedGroovyScript nextAutomatedGroovyScript = scriptAccess.a(result, nextIdentifyingPath, next.getRunConfigurationName(), metricIdProvider);
                    if (nextAutomatedGroovyScript != null) {
                        j.this.a(nextAutomatedGroovyScript, installation, vm);
                        j.this.a(nextAutomatedGroovyScript, installation, result, (Map<String, MetricDescriptor>)metricDescriptors);
                        nextAutomatedGroovyScript.getResultSet().resultsCollected();
                    } else {
                        ++numberOfNotExecutedScripts;
                        d.debug("Not successfully executed.");
                    }
                    workerContext.endStep();
                }
                result.addChild(new LastScriptRunnerExecutionStatus(result, numberOfScripts, numberOfScripts - numberOfNotExecutedScripts));
                d.debug("Execute " + this.d.size() + " automated script(s) - done");
            } else {
                d.debug("No scripts to execute");
            }
        }
    }
}

