/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.collections.MultipleValueMap;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.scm.BranchCommits;
import com.hello2morrow.scm.Commit;
import com.hello2morrow.scm.ConfigurationException;
import com.hello2morrow.scm.Diff;
import com.hello2morrow.scm.DiffMode;
import com.hello2morrow.scm.ICommitRetriever;
import com.hello2morrow.scm.IScmDataAndConfigurationProvider;
import com.hello2morrow.scm.IScmDataProvider;
import com.hello2morrow.scm.RetrieveException;
import com.hello2morrow.scm.ScmManager;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.b;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controllerinterface.system.v;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.ScmAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.StringList;
import com.hello2morrow.sonargraph.core.model.author.Author;
import com.hello2morrow.sonargraph.core.model.author.AuthorsInfo;
import com.hello2morrow.sonargraph.core.model.author.IAuthorsProvider;
import com.hello2morrow.sonargraph.core.model.author.SourceFilesToAuthorsInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.CouplingLink;
import com.hello2morrow.sonargraph.core.model.path.scm.SourceNode;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingModel;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingNode;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class i
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    private static final Logger d = LoggerFactory.getLogger(i.class);
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.SCM_METRICS;
    private static final String e = ";";
    private final ScmManager f;
    private final IAuthorsProvider g;
    private final IMetricDescriptor h;
    private final IMetricDescriptor i;
    private final IMetricDescriptor j;
    private final IMetricDescriptor k;
    private final IMetricDescriptor l;
    private final IMetricDescriptor m;
    private final IMetricDescriptor n;
    private final IMetricDescriptor o;
    private final IMetricDescriptor p;
    private final IMetricDescriptor q;
    private final IMetricDescriptor r;
    private final IMetricDescriptor s;
    private final IMetricDescriptor t;
    private final IMetricDescriptor u;
    private final IMetricDescriptor v;
    private final IMetricDescriptor w;
    private final IMetricDescriptor x;
    private final IMetricDescriptor y;
    private final IMetricDescriptor z;
    private final IMetricDescriptor A;
    private final IMetricDescriptor B;
    private final IMetricDescriptor C;
    private final IMetricDescriptor D;
    private final IMetricDescriptor E;
    private final IMetricDescriptor F;
    private final IMetricDescriptor G;
    private final IMetricDescriptor H;
    private final IMetricDescriptor I;
    private final IMetricDescriptor J;
    private final IMetricDescriptor K;
    private final IMetricDescriptor L;
    private final IMetricDescriptor M;
    private final IMetricDescriptor N;
    private final IMetricDescriptor O;
    private final IMetricDescriptor P;
    private final IMetricDescriptor Q;
    private final IMetricDescriptor R;
    private final IMetricDescriptor S;
    private final IMetricDescriptor T;
    private final IMetricDescriptor U;
    private final IMetricDescriptor V;
    private final IMetricDescriptor W;
    private final IMetricDescriptor X;
    private final IMetricDescriptor Y;
    private final IMetricDescriptor Z;
    private final IMetricDescriptor aa;
    private final IMetricDescriptor ab;
    private final IMetricDescriptor ac;
    private final IMetricDescriptor ad;
    private final IMetricDescriptor ae;
    private final IMetricDescriptor af;
    private final IMetricDescriptor ag;
    private final IMetricDescriptor ah;
    private final IMetricDescriptor ai;
    private final IMetricDescriptor aj;
    private final IMetricDescriptor ak;
    private final IMetricDescriptor al;
    private final IMetricDescriptor am;
    private final IMetricDescriptor an;
    private final IMetricDescriptor ao;
    private final IMetricDescriptor ap;

    public i(g controller, ScmManager scmManager) {
        super(controller, a);
        assert (scmManager != null) : "Parameter 'scmManager' of method 'ScmAnalyzerAdapter' must not be null";
        IMetricsProvider metricsProvider = this.h().getExtension(IMetricsProvider.class);
        MetricProvider mp = metricsProvider.getMetricProvider(CoreProviderId.INSTANCE);
        this.g = this.i().getExtension(IAuthorsProvider.class);
        this.f = scmManager;
        this.h = this.b(mp, CoreMetricId.CORE_CHANGES_30, CoreMetricLevel.SOURCE_FILE);
        this.i = this.b(mp, CoreMetricId.CORE_CHANGES_90, CoreMetricLevel.SOURCE_FILE);
        this.j = this.b(mp, CoreMetricId.CORE_CHANGES_365, CoreMetricLevel.SOURCE_FILE);
        this.k = this.b(mp, CoreMetricId.CORE_CHANGES_2Y, CoreMetricLevel.SOURCE_FILE);
        this.l = this.b(mp, CoreMetricId.CORE_CHANGES_5Y, CoreMetricLevel.SOURCE_FILE);
        this.m = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricLevel.SOURCE_FILE);
        this.n = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricLevel.SOURCE_FILE);
        this.o = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricLevel.SOURCE_FILE);
        this.p = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricLevel.SOURCE_FILE);
        this.q = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricLevel.SOURCE_FILE);
        this.r = this.b(mp, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricLevel.SOURCE_FILE);
        this.s = this.b(mp, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricLevel.SOURCE_FILE);
        this.t = this.b(mp, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricLevel.SOURCE_FILE);
        this.u = this.b(mp, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricLevel.SOURCE_FILE);
        this.v = this.b(mp, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricLevel.SOURCE_FILE);
        this.w = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricLevel.SOURCE_FILE);
        this.x = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricLevel.SOURCE_FILE);
        this.y = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricLevel.SOURCE_FILE);
        this.z = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricLevel.SOURCE_FILE);
        this.A = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricLevel.SOURCE_FILE);
        this.ap = this.b(mp, CoreMetricId.CORE_DAYS_SINCE_LAST_COMMIT, CoreMetricLevel.SOURCE_FILE);
        this.B = this.b(mp, CoreMetricId.CORE_CHANGES_30, CoreMetricLevel.MODULE);
        this.C = this.b(mp, CoreMetricId.CORE_CHANGES_90, CoreMetricLevel.MODULE);
        this.D = this.b(mp, CoreMetricId.CORE_CHANGES_365, CoreMetricLevel.MODULE);
        this.E = this.b(mp, CoreMetricId.CORE_CHANGES_2Y, CoreMetricLevel.MODULE);
        this.F = this.b(mp, CoreMetricId.CORE_CHANGES_5Y, CoreMetricLevel.MODULE);
        this.G = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricLevel.MODULE);
        this.H = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricLevel.MODULE);
        this.I = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricLevel.MODULE);
        this.J = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricLevel.MODULE);
        this.K = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricLevel.MODULE);
        this.L = this.b(mp, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricLevel.MODULE);
        this.M = this.b(mp, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricLevel.MODULE);
        this.N = this.b(mp, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricLevel.MODULE);
        this.O = this.b(mp, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricLevel.MODULE);
        this.P = this.b(mp, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricLevel.MODULE);
        this.Q = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricLevel.MODULE);
        this.R = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricLevel.MODULE);
        this.S = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricLevel.MODULE);
        this.T = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricLevel.MODULE);
        this.U = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricLevel.MODULE);
        this.V = this.b(mp, CoreMetricId.CORE_CHANGES_30, CoreMetricLevel.SYSTEM);
        this.W = this.b(mp, CoreMetricId.CORE_CHANGES_90, CoreMetricLevel.SYSTEM);
        this.X = this.b(mp, CoreMetricId.CORE_CHANGES_365, CoreMetricLevel.SYSTEM);
        this.Y = this.b(mp, CoreMetricId.CORE_CHANGES_2Y, CoreMetricLevel.SYSTEM);
        this.Z = this.b(mp, CoreMetricId.CORE_CHANGES_5Y, CoreMetricLevel.SYSTEM);
        this.aa = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricLevel.SYSTEM);
        this.ab = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricLevel.SYSTEM);
        this.ac = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricLevel.SYSTEM);
        this.ad = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricLevel.SYSTEM);
        this.ae = this.b(mp, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricLevel.SYSTEM);
        this.af = this.b(mp, CoreMetricId.CORE_CODE_CHURN_30, CoreMetricLevel.SYSTEM);
        this.ag = this.b(mp, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricLevel.SYSTEM);
        this.ah = this.b(mp, CoreMetricId.CORE_CODE_CHURN_365, CoreMetricLevel.SYSTEM);
        this.ai = this.b(mp, CoreMetricId.CORE_CODE_CHURN_2Y, CoreMetricLevel.SYSTEM);
        this.aj = this.b(mp, CoreMetricId.CORE_CODE_CHURN_5Y, CoreMetricLevel.SYSTEM);
        this.ak = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_30, CoreMetricLevel.SYSTEM);
        this.al = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_90, CoreMetricLevel.SYSTEM);
        this.am = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS, CoreMetricLevel.SYSTEM);
        this.an = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y, CoreMetricLevel.SYSTEM);
        this.ao = this.b(mp, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y, CoreMetricLevel.SYSTEM);
    }

    @Override
    protected boolean a() {
        String scm = this.u();
        if (scm.equals("No SCM System")) {
            return false;
        }
        return this.f.canRun(scm, (IScmDataAndConfigurationProvider)this.i().getExtension(v.class));
    }

    @Override
    protected boolean b(AnalyzerResult result) {
        boolean done = super.b(result);
        result.removeChildren(SourceFilesToAuthorsInfo.class, Author.class, TemporalCouplingModel.class);
        return done;
    }

    @Override
    public void a(boolean baseDirectoryChanged) {
        super.a(baseDirectoryChanged);
        if (baseDirectoryChanged) {
            this.q();
        }
    }

    private String u() {
        String scm = (String)this.o().getConfiguration(ScmAnalyzerConfiguration.class).getValue("ScmName");
        return scm == null ? "Auto Detect" : scm;
    }

    @Override
    protected void a(AnalyzerResult result) {
        a job = new a(this.p(), result, this.g());
        job.i();
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    protected void d(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'saveResult' must not be null";
        INamedElementResolver resolver = this.g().a();
        SourceFilesToAuthorsInfo sourceFilesToAuthorsInfo = result.getUniqueChild(SourceFilesToAuthorsInfo.class);
        if (sourceFilesToAuthorsInfo != null) {
            ArrayList<String> flattened = new ArrayList<String>();
            for (Map.Entry<SourceFile, AuthorsInfo> nextEntry : sourceFilesToAuthorsInfo.getInfo().entrySet()) {
                flattened.add(resolver.getDescriptor(nextEntry.getKey()));
                flattened.add(e);
                AuthorsInfo info = nextEntry.getValue();
                Author[] authors30 = info.getAuthors30();
                int i2 = 0;
                while (i2 < authors30.length) {
                    flattened.add(authors30[i2].getName());
                    ++i2;
                }
                flattened.add(e);
                Author[] authors90 = info.getAuthors90();
                int i3 = 0;
                while (i3 < authors90.length) {
                    flattened.add(authors90[i3].getName());
                    ++i3;
                }
                flattened.add(e);
                Author[] authors365 = info.getAuthors365();
                int i4 = 0;
                while (i4 < authors365.length) {
                    flattened.add(authors365[i4].getName());
                    ++i4;
                }
                Author[] authors2y = info.getAuthors2y();
                int i5 = 0;
                while (i5 < authors2y.length) {
                    flattened.add(authors2y[i5].getName());
                    ++i5;
                }
                Author[] authors5y = info.getAuthors5y();
                int i6 = 0;
                while (i6 < authors5y.length) {
                    flattened.add(authors5y[i6].getName());
                    ++i6;
                }
                flattened.add(null);
            }
            StringList stringList = new StringList(result, flattened.toArray(new String[flattened.size()]));
            result.addChild(stringList);
        }
        long start = System.currentTimeMillis();
        super.d(result);
        d.debug("Finished saving result in {} ms", (Object)(System.currentTimeMillis() - start));
        result.removeChildren(StringList.class);
    }

    @Override
    protected void e(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        THashMap authorMap = new THashMap();
        for (Author next : result.getChildren(Author.class)) {
            authorMap.put(next.getShortName(), next);
        }
        StringList stringList = result.getUniqueChild(StringList.class);
        if (stringList != null) {
            SourceFilesToAuthorsInfo info = new SourceFilesToAuthorsInfo(result);
            result.addChild(info);
            INamedElementResolver resolver = this.g().a();
            ArrayList<String> sourceFileAndAuthors = new ArrayList<String>();
            String[] stringArray = stringList.getList();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String next = stringArray[n3];
                if (next == null) {
                    this.a(resolver, (Map<String, Author>)authorMap, info, sourceFileAndAuthors);
                    sourceFileAndAuthors.clear();
                } else {
                    sourceFileAndAuthors.add(next);
                }
                ++n3;
            }
            result.removeChild(stringList);
        }
        super.e(result);
    }

    private void a(INamedElementResolver resolver, Map<String, Author> authorMap, SourceFilesToAuthorsInfo sourceFilesToAuthorsInfo, List<String> sourceFileAndAuthors) {
        assert (resolver != null) : "Parameter 'resolver' of method 'processSourceFileAndAuthors' must not be null";
        assert (authorMap != null) : "Parameter 'authorMap' of method 'processSourceFileAndAuthors' must not be null";
        assert (sourceFileAndAuthors != null) : "Parameter 'sourceFileAndAuthors' of method 'processSourceFileAndAuthors' must not be null";
        assert (sourceFileAndAuthors.size() >= 4) : "Parameter 'sourceFileAndAuthors' of method 'processSourceFileAndAuthors' must at least be of size 4: " + sourceFileAndAuthors;
        String fileDescriptor = sourceFileAndAuthors.get(0);
        Element resolvedSource = resolver.resolve(fileDescriptor);
        if (!(resolvedSource instanceof SourceFile)) {
            d.error("Failed to resolve source file for descriptor {}", (Object)fileDescriptor);
            return;
        }
        StrictPair<Author[], Integer> authors30 = this.a(authorMap, sourceFileAndAuthors, 2);
        StrictPair<Author[], Integer> authors90 = this.a(authorMap, sourceFileAndAuthors, (Integer)authors30.getSecond());
        StrictPair<Author[], Integer> authors365 = this.a(authorMap, sourceFileAndAuthors, (Integer)authors90.getSecond());
        StrictPair<Author[], Integer> authors2y = this.a(authorMap, sourceFileAndAuthors, (Integer)authors365.getSecond());
        StrictPair<Author[], Integer> authors5y = this.a(authorMap, sourceFileAndAuthors, (Integer)authors2y.getSecond());
        sourceFilesToAuthorsInfo.addInfo((SourceFile)resolvedSource, new AuthorsInfo((Author[])authors30.getFirst(), (Author[])authors90.getFirst(), (Author[])authors365.getFirst(), (Author[])authors2y.getFirst(), (Author[])authors5y.getFirst()));
    }

    private StrictPair<Author[], Integer> a(Map<String, Author> authorMap, List<String> sourceFileAndAuthors, int start) {
        ArrayList<Author> authors = new ArrayList<Author>();
        int i2 = start;
        while (i2 < sourceFileAndAuthors.size()) {
            String authorName = sourceFileAndAuthors.get(i2);
            if (authorName.equals(e)) {
                ++i2;
                break;
            }
            Author author = authorMap.get(authorName);
            if (author == null) {
                d.debug("Missing author element for name {}", (Object)authorName);
            } else {
                authors.add(author);
            }
            ++i2;
        }
        Author[] authorsArray = authors.toArray(new Author[0]);
        return new StrictPair((Object)authorsArray, (Object)i2);
    }

    private class com.hello2morrow.sonargraph.core.controller.system.analysis.i$a
    extends b {
        private final Map<String, SourceFile> d;
        private final long e;
        private final long f;
        private final long g;
        private final long h;
        private final long i;
        private final Map<Module, Integer> j;
        private final Map<Module, Integer> k;
        private final Map<Module, Integer> l;
        private final Map<Module, Integer> m;
        private final Map<Module, Integer> n;
        private final Map<Module, Integer> o;
        private final Map<Module, Integer> p;
        private final Map<Module, Integer> q;
        private final Map<Module, Integer> r;
        private final Map<Module, Integer> s;
        private final Map<Module, Integer> t;
        private final Map<Module, Set<Author>> u;
        private final Map<Module, Set<Author>> v;
        private final Map<Module, Set<Author>> w;
        private final Map<Module, Set<Author>> x;
        private final Map<Module, Set<Author>> y;
        private final Map<String, Module> z;
        private int A;

        private com.hello2morrow.sonargraph.core.controller.system.analysis.i$a(AnalyzerGroup group, AnalyzerResult result, g controller) {
            super(group, result, controller);
            this.d = new THashMap(4201);
            this.j = new THashMap();
            this.k = new THashMap();
            this.l = new THashMap();
            this.m = new THashMap();
            this.n = new THashMap();
            this.o = new THashMap();
            this.p = new THashMap();
            this.q = new THashMap();
            this.r = new THashMap();
            this.s = new THashMap();
            this.t = new THashMap();
            this.u = new THashMap();
            this.v = new THashMap();
            this.w = new THashMap();
            this.x = new THashMap();
            this.y = new THashMap();
            this.z = new THashMap();
            this.A = 0;
            this.i = System.currentTimeMillis();
            this.e = this.i - 2592000000L;
            this.f = this.i - 7776000000L;
            this.g = this.i - 31536000000L;
            this.h = this.i - 63072000000L;
        }

        private void b() {
            this.c().getUniqueExistingChild(Workspace.class).accept(new a());
        }

        private void a(List<Commit> commits, Map<String, String> renameMap, IWorkerContext workerContext) {
            Collection<SourceNode> nodes = this.b(commits, renameMap, workerContext);
            if (nodes.size() > 0) {
                TemporalCouplingNode[] modelNodes = new TemporalCouplingNode[nodes.size()];
                int j2 = 0;
                for (SourceNode node : nodes) {
                    int[] links = new int[node.getLinkCount() * 2];
                    int i2 = 0;
                    for (CouplingLink link : node.getLinks()) {
                        int targetId = link.getTarget(node).getId();
                        assert (targetId != node.getId());
                        links[i2++] = targetId;
                        links[i2++] = link.getWeight();
                    }
                    modelNodes[j2++] = new TemporalCouplingNode(node.getSourceFile(), links);
                }
                nodes.clear();
                TemporalCouplingModel model = new TemporalCouplingModel(this.getResult(), modelNodes);
                this.getResult().addChild(model);
            }
        }

        private void a(List<Commit> commits, IWorkerContext workerContext) throws IWorkerContext.WorkerContextCancelledException {
            MultipleValueMap fileHistory = new MultipleValueMap();
            THashMap renameMap = new THashMap();
            if (this.g().hasBeenCanceled()) {
                throw new IWorkerContext.WorkerContextCancelledException();
            }
            long t2 = System.currentTimeMillis();
            this.b();
            this.a(commits, (MultipleValueMap<String, Pair<Commit, Diff>>)fileHistory, (Map<String, String>)renameMap);
            d.debug("Time to build history: " + (System.currentTimeMillis() - t2) + " ms");
            workerContext.beginBlockOfWork(commits.size() + fileHistory.size());
            Thread temporalCouplingThread = new Thread(() -> this.c(commits, (Map)renameMap, workerContext));
            temporalCouplingThread.start();
            t2 = System.currentTimeMillis();
            this.a((MultipleValueMap<String, Pair<Commit, Diff>>)fileHistory, workerContext);
            fileHistory.keySet().forEach(k2 -> {
                SourceFile sourceFile = this.d.remove(k2);
            });
            this.j();
            this.k();
            d.debug("Time to process history: " + (System.currentTimeMillis() - t2) + " ms");
            try {
                t2 = System.currentTimeMillis();
                temporalCouplingThread.join();
                d.debug("Time to wait for temporal coupling processor: " + (System.currentTimeMillis() - t2) + " ms");
            }
            catch (InterruptedException e2) {
                d.error("Temporal coupling thread interrupted unexpectedly: ", (Throwable)e2);
            }
        }

        private void a(List<Commit> commits, MultipleValueMap<String, Pair<Commit, Diff>> fileHistory, Map<String, String> renameMap) throws IWorkerContext.WorkerContextCancelledException {
            for (Commit commit : commits) {
                for (Diff diff : commit.getChanges()) {
                    if (this.g().hasBeenCanceled()) {
                        throw new IWorkerContext.WorkerContextCancelledException();
                    }
                    String path = renameMap.get(diff.getPath());
                    if (path == null) {
                        path = diff.getPath();
                    }
                    if (diff.getMode() == DiffMode.RENAMED) {
                        renameMap.put(diff.getOriginalPath(), path);
                    }
                    if (path != null) {
                        if (this.d.get(path) == null) continue;
                        fileHistory.put((Object)path, (Object)new Pair((Object)commit, (Object)diff));
                        continue;
                    }
                    path = diff.getOriginalPath();
                    for (String root : this.z.keySet()) {
                        if (this.g().hasBeenCanceled()) {
                            throw new IWorkerContext.WorkerContextCancelledException();
                        }
                        if (!path.startsWith(root)) continue;
                        Module mod = this.z.get(root);
                        assert (mod != null);
                        int deletedLines = diff.getRemovedLines();
                        if (commit.getTimeStamp() >= this.e) {
                            this.o.put(mod, this.o.get(mod) + 1);
                            this.j.put(mod, this.j.get(mod) + deletedLines);
                        }
                        if (commit.getTimeStamp() >= this.f) {
                            this.p.put(mod, this.p.get(mod) + 1);
                            this.k.put(mod, this.k.get(mod) + deletedLines);
                        }
                        if (commit.getTimeStamp() >= this.g) {
                            this.q.put(mod, this.q.get(mod) + 1);
                            this.l.put(mod, this.l.get(mod) + deletedLines);
                        }
                        if (commit.getTimeStamp() >= this.h) {
                            this.r.put(mod, this.r.get(mod) + 1);
                            this.m.put(mod, this.m.get(mod) + deletedLines);
                        }
                        this.s.put(mod, this.s.get(mod) + 1);
                        this.n.put(mod, this.n.get(mod) + deletedLines);
                    }
                }
            }
        }

        private SourceNode a(Diff diff, Map<String, SourceNode> nodeMap, Map<String, String> renameMap, Map<SourceNode, Map<SourceNode, CouplingLink>> connectionMap, List<SourceNode> nodes) {
            String path = diff.getPath();
            String path2 = renameMap.get(path);
            if (path2 != null) {
                path = path2;
            }
            if (path == null) {
                return null;
            }
            SourceNode node = nodeMap.get(path);
            if (node == null) {
                SourceFile source = this.d.get(path);
                if (source == null) {
                    return null;
                }
                node = new SourceNode(source, this.A++);
                nodes.add(node);
                nodeMap.put(path, node);
                connectionMap.put(node, (Map<SourceNode, CouplingLink>)new THashMap());
            }
            return node;
        }

        private Collection<SourceNode> b(List<Commit> commits, Map<String, String> renameMap, IWorkerContext workerContext) {
            THashMap nodeMap = new THashMap();
            ArrayList<SourceNode> nodes = new ArrayList<SourceNode>();
            THashMap connectionMap = new THashMap();
            long t2 = System.currentTimeMillis();
            int count = 0;
            for (Commit commit : commits) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                List diffs = commit.getChanges();
                int i2 = 0;
                while (i2 < diffs.size() - 1) {
                    SourceNode node1 = this.a((Diff)diffs.get(i2), (Map<String, SourceNode>)nodeMap, renameMap, (Map<SourceNode, Map<SourceNode, CouplingLink>>)connectionMap, nodes);
                    if (node1 != null) {
                        int j2 = i2 + 1;
                        while (j2 < diffs.size()) {
                            SourceNode node2 = this.a((Diff)diffs.get(j2), (Map<String, SourceNode>)nodeMap, renameMap, (Map<SourceNode, Map<SourceNode, CouplingLink>>)connectionMap, nodes);
                            if (node2 != null && node1 != node2) {
                                Map linkMap1 = (Map)connectionMap.get(node1);
                                CouplingLink link = (CouplingLink)linkMap1.get(node2);
                                if (link == null) {
                                    Map linkMap2 = (Map)connectionMap.get(node2);
                                    link = new CouplingLink(node1, node2);
                                    node1.addLink(link);
                                    node2.addLink(link);
                                    linkMap1.put(node2, link);
                                    linkMap2.put(node1, link);
                                    ++count;
                                } else {
                                    link.increaseWeight();
                                }
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
                workerContext.workItemCompleted();
            }
            t2 = System.currentTimeMillis() - t2;
            d.debug("Temporal coupling analysis took " + t2 + " ms, links=" + count);
            return nodes;
        }

        private void a(MultipleValueMap<String, Pair<Commit, Diff>> fileHistory, IWorkerContext workerContext) throws IWorkerContext.WorkerContextCancelledException {
            SourceFilesToAuthorsInfo sourceFilesToAuthorsMap = new SourceFilesToAuthorsInfo(this.getResult());
            THashSet unprocessedSources = new THashSet();
            unprocessedSources.addAll(this.d.values());
            for (String path : fileHistory.keySet()) {
                if (workerContext.hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                SourceFile source = this.d.get(path);
                THashSet authors30 = new THashSet();
                THashSet authors90 = new THashSet();
                THashSet authors365 = new THashSet();
                THashSet authors2y = new THashSet();
                THashSet authors5y = new THashSet();
                boolean thirtyDaysPassed = false;
                boolean ninetyDaysPassed = false;
                boolean oneYearPassed = false;
                boolean twoYearsPassed = false;
                int changeCount = 0;
                int changedLines = 0;
                int changeCount30 = 0;
                int changeCount90 = 0;
                int changeCount1y = 0;
                int changeCount2y = 0;
                int changedLines30 = 0;
                int changedLines90 = 0;
                int changedLines1y = 0;
                int changedLines2y = 0;
                long time = System.currentTimeMillis();
                boolean first = true;
                assert (source != null);
                for (Pair pair : fileHistory.get((Object)path)) {
                    if (workerContext.hasBeenCanceled()) {
                        throw new IWorkerContext.WorkerContextCancelledException();
                    }
                    Commit commit = (Commit)pair.getFirst();
                    Diff diff = (Diff)pair.getSecond();
                    long commitTime = commit.getTimeStamp();
                    if (first) {
                        int daysSinceLasstCommit = (int)((this.i - commitTime) / 86400000L);
                        unprocessedSources.remove(source);
                        i.this.a(this.getResult(), source, daysSinceLasstCommit, i.this.ap);
                        first = false;
                    }
                    if (!thirtyDaysPassed && commitTime < this.e) {
                        thirtyDaysPassed = true;
                        authors30.addAll(authors5y);
                        changeCount30 = changeCount;
                        changedLines30 = changedLines;
                    }
                    if (!ninetyDaysPassed && commitTime < this.f) {
                        ninetyDaysPassed = true;
                        authors90.addAll(authors5y);
                        changeCount90 = changeCount;
                        changedLines90 = changedLines;
                    }
                    if (!oneYearPassed && commitTime < this.g) {
                        oneYearPassed = true;
                        authors365.addAll(authors5y);
                        changeCount1y = changeCount;
                        changedLines1y = changedLines;
                    }
                    if (!twoYearsPassed && commitTime < this.h) {
                        twoYearsPassed = true;
                        authors2y.addAll(authors5y);
                        changeCount2y = changeCount;
                        changedLines2y = changedLines;
                    }
                    assert (commitTime <= time) : "We assume commits to be ordered descending by time";
                    time = commitTime;
                    String authorName = commit.getAuthor();
                    if (authorName != null) {
                        authorName = i.this.g.getAuthorNameFromPotentialAlias(authorName);
                        Author author = this.a(this.getResult(), authorName);
                        authors5y.add(author);
                    }
                    ++changeCount;
                    changedLines += diff.getAddedLines() + diff.getRemovedLines();
                }
                if (!thirtyDaysPassed) {
                    thirtyDaysPassed = true;
                    authors30.addAll(authors5y);
                    changeCount30 = changeCount;
                    changedLines30 = changedLines;
                }
                if (!ninetyDaysPassed) {
                    ninetyDaysPassed = true;
                    authors90.addAll(authors5y);
                    changeCount90 = changeCount;
                    changedLines90 = changedLines;
                }
                if (!oneYearPassed) {
                    oneYearPassed = true;
                    authors365.addAll(authors5y);
                    changeCount1y = changeCount;
                    changedLines1y = changedLines;
                }
                if (!twoYearsPassed) {
                    twoYearsPassed = true;
                    authors2y.addAll(authors5y);
                    changeCount2y = changeCount;
                    changedLines2y = changedLines;
                }
                if (source.getTotalLines() == 0) continue;
                float churn30 = (float)(100.0 * (double)changedLines30 / (double)source.getTotalLines());
                float churn90 = (float)(100.0 * (double)changedLines90 / (double)source.getTotalLines());
                float churn365 = (float)(100.0 * (double)changedLines1y / (double)source.getTotalLines());
                float churn2y = (float)(100.0 * (double)changedLines2y / (double)source.getTotalLines());
                float churn5y = (float)(100.0 * (double)changedLines / (double)source.getTotalLines());
                i.this.a(this.getResult(), source, changeCount30, i.this.h);
                i.this.a(this.getResult(), source, changeCount90, i.this.i);
                i.this.a(this.getResult(), source, changeCount1y, i.this.j);
                i.this.a(this.getResult(), source, changeCount2y, i.this.k);
                i.this.a(this.getResult(), source, changeCount, i.this.l);
                i.this.a(this.getResult(), source, changedLines30, i.this.r);
                i.this.a(this.getResult(), source, changedLines90, i.this.s);
                i.this.a(this.getResult(), source, changedLines1y, i.this.t);
                i.this.a(this.getResult(), source, changedLines2y, i.this.u);
                i.this.a(this.getResult(), source, changedLines, i.this.v);
                i.this.a(this.getResult(), source, Float.valueOf(churn30), i.this.m);
                i.this.a(this.getResult(), source, Float.valueOf(churn90), i.this.n);
                i.this.a(this.getResult(), source, Float.valueOf(churn365), i.this.o);
                i.this.a(this.getResult(), source, Float.valueOf(churn2y), i.this.p);
                i.this.a(this.getResult(), source, Float.valueOf(churn5y), i.this.q);
                i.this.a(this.getResult(), source, authors30.size(), i.this.w);
                i.this.a(this.getResult(), source, authors90.size(), i.this.x);
                i.this.a(this.getResult(), source, authors365.size(), i.this.y);
                i.this.a(this.getResult(), source, authors2y.size(), i.this.z);
                i.this.a(this.getResult(), source, authors5y.size(), i.this.A);
                AuthorsInfo authorsInfo = new AuthorsInfo(this.a((Set<Author>)authors30), this.a((Set<Author>)authors90), this.a((Set<Author>)authors365), this.a((Set<Author>)authors2y), this.a((Set<Author>)authors5y));
                sourceFilesToAuthorsMap.addInfo(source, authorsInfo);
                Module module = source.getParent(Module.class, new Class[0]);
                assert (module != null) : "Missing module for source " + source;
                this.o.put(module, this.o.get(module) + changeCount30);
                this.p.put(module, this.p.get(module) + changeCount90);
                this.q.put(module, this.q.get(module) + changeCount1y);
                this.r.put(module, this.r.get(module) + changeCount2y);
                this.s.put(module, this.s.get(module) + changeCount);
                this.j.put(module, this.j.get(module) + changedLines30);
                this.k.put(module, this.k.get(module) + changedLines90);
                this.l.put(module, this.l.get(module) + changedLines1y);
                this.m.put(module, this.m.get(module) + changedLines2y);
                this.n.put(module, this.n.get(module) + changedLines);
                this.u.get(module).addAll((Collection<Author>)authors30);
                this.v.get(module).addAll((Collection<Author>)authors90);
                this.w.get(module).addAll((Collection<Author>)authors365);
                this.x.get(module).addAll((Collection<Author>)authors2y);
                this.y.get(module).addAll((Collection<Author>)authors5y);
                if (workerContext.hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                workerContext.workItemCompleted();
            }
            unprocessedSources.forEach(src -> i.this.a(this.getResult(), src, 9999, i.this.ap));
            this.getResult().addChild(sourceFilesToAuthorsMap);
        }

        private Author[] a(Set<Author> authors) {
            assert (authors != null) : "Parameter 'authors' of method 'getSortedAuthorsAsArray' must not be null";
            if (authors.isEmpty()) {
                return new Author[0];
            }
            Author[] array = new Author[authors.size()];
            int i2 = 0;
            for (Author next : authors) {
                array[i2++] = next;
            }
            if (array.length > 1) {
                Arrays.sort(array, 0, i2, (a1, a2) -> a1.getName().compareTo(a2.getName()));
            }
            return array;
        }

        private Author a(AnalyzerResult result, String authorName) {
            assert (result != null) : "Parameter 'result' of method 'getOrCreateAuthor' must not be null";
            assert (authorName != null && authorName.length() > 0) : "Parameter 'authorName' of method 'getOrCreateAuthor' must not be empty";
            Author author = result.getUniqueChild(new ShortNameFilter(authorName), Author.class);
            if (author == null) {
                author = new Author(result, authorName);
                result.addChild(author);
            }
            return author;
        }

        private void j() throws IWorkerContext.WorkerContextCancelledException {
            for (SourceFile source : this.d.values()) {
                if (this.g().hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                i.this.a(this.getResult(), source, 0, i.this.h);
                i.this.a(this.getResult(), source, 0, i.this.i);
                i.this.a(this.getResult(), source, 0, i.this.j);
                i.this.a(this.getResult(), source, 0, i.this.k);
                i.this.a(this.getResult(), source, 0, i.this.l);
                i.this.a(this.getResult(), source, 0, i.this.r);
                i.this.a(this.getResult(), source, 0, i.this.s);
                i.this.a(this.getResult(), source, 0, i.this.t);
                i.this.a(this.getResult(), source, 0, i.this.u);
                i.this.a(this.getResult(), source, 0, i.this.v);
                i.this.a(this.getResult(), source, Float.valueOf(0.0f), i.this.m);
                i.this.a(this.getResult(), source, Float.valueOf(0.0f), i.this.n);
                i.this.a(this.getResult(), source, Float.valueOf(0.0f), i.this.o);
                i.this.a(this.getResult(), source, Float.valueOf(0.0f), i.this.p);
                i.this.a(this.getResult(), source, Float.valueOf(0.0f), i.this.q);
                i.this.a(this.getResult(), source, 0, i.this.w);
                i.this.a(this.getResult(), source, 0, i.this.x);
                i.this.a(this.getResult(), source, 0, i.this.y);
                i.this.a(this.getResult(), source, 0, i.this.z);
                i.this.a(this.getResult(), source, 0, i.this.A);
            }
        }

        private void k() throws IWorkerContext.WorkerContextCancelledException {
            int sysTotalLines = 0;
            int sysChanges30 = 0;
            int sysChanges90 = 0;
            int sysChanges365 = 0;
            int sysChanges2y = 0;
            int sysChanges5y = 0;
            int sysChangedLines30 = 0;
            int sysChangedLines90 = 0;
            int sysChangedLines365 = 0;
            int sysChangedLines2y = 0;
            int sysChangedLines5y = 0;
            THashSet sysAuthors30 = new THashSet();
            THashSet sysAuthors90 = new THashSet();
            THashSet sysAuthors365 = new THashSet();
            THashSet sysAuthors2y = new THashSet();
            THashSet sysAuthors5y = new THashSet();
            for (Module module : this.t.keySet()) {
                if (this.g().hasBeenCanceled()) {
                    throw new IWorkerContext.WorkerContextCancelledException();
                }
                int totalLines = this.t.get(module);
                if (totalLines == 0) continue;
                int changes30 = this.o.get(module);
                int changes90 = this.p.get(module);
                int changes365 = this.q.get(module);
                int changes2y = this.r.get(module);
                int changes5y = this.s.get(module);
                int changedLines30 = this.j.get(module);
                int changedLines90 = this.k.get(module);
                int changedLines365 = this.l.get(module);
                int changedLines2y = this.m.get(module);
                int changedLines5y = this.n.get(module);
                float churn30 = (float)(100.0 * (double)changedLines30 / (double)totalLines);
                float churn90 = (float)(100.0 * (double)changedLines90 / (double)totalLines);
                float churn365 = (float)(100.0 * (double)changedLines365 / (double)totalLines);
                float churn2y = (float)(100.0 * (double)changedLines2y / (double)totalLines);
                float churn5y = (float)(100.0 * (double)changedLines5y / (double)totalLines);
                Set<Author> modAuthors30 = this.u.get(module);
                Set<Author> modAuthors90 = this.v.get(module);
                Set<Author> modAuthors365 = this.w.get(module);
                Set<Author> modAuthors2y = this.x.get(module);
                Set<Author> modAuthors5y = this.y.get(module);
                sysTotalLines += totalLines;
                sysChanges30 += changes30;
                sysChanges90 += changes90;
                sysChanges365 += changes365;
                sysChanges2y += changes2y;
                sysChanges5y += changes5y;
                sysChangedLines30 += changedLines30;
                sysChangedLines90 += changedLines90;
                sysChangedLines365 += changedLines365;
                sysChangedLines2y += changedLines2y;
                sysChangedLines5y += changedLines5y;
                sysAuthors30.addAll(modAuthors30);
                sysAuthors90.addAll(modAuthors90);
                sysAuthors365.addAll(modAuthors365);
                sysAuthors2y.addAll(modAuthors2y);
                sysAuthors5y.addAll(modAuthors5y);
                i.this.a(this.getResult(), module, changes30, i.this.B);
                i.this.a(this.getResult(), module, changes90, i.this.C);
                i.this.a(this.getResult(), module, changes365, i.this.D);
                i.this.a(this.getResult(), module, changes2y, i.this.E);
                i.this.a(this.getResult(), module, changes5y, i.this.F);
                i.this.a(this.getResult(), module, changedLines30, i.this.L);
                i.this.a(this.getResult(), module, changedLines90, i.this.M);
                i.this.a(this.getResult(), module, changedLines365, i.this.N);
                i.this.a(this.getResult(), module, changedLines2y, i.this.O);
                i.this.a(this.getResult(), module, changedLines5y, i.this.P);
                i.this.a(this.getResult(), module, Float.valueOf(churn30), i.this.G);
                i.this.a(this.getResult(), module, Float.valueOf(churn90), i.this.H);
                i.this.a(this.getResult(), module, Float.valueOf(churn365), i.this.I);
                i.this.a(this.getResult(), module, Float.valueOf(churn2y), i.this.J);
                i.this.a(this.getResult(), module, Float.valueOf(churn5y), i.this.K);
                i.this.a(this.getResult(), module, modAuthors30.size(), i.this.Q);
                i.this.a(this.getResult(), module, modAuthors90.size(), i.this.R);
                i.this.a(this.getResult(), module, modAuthors365.size(), i.this.S);
                i.this.a(this.getResult(), module, modAuthors2y.size(), i.this.T);
                i.this.a(this.getResult(), module, modAuthors5y.size(), i.this.U);
            }
            if (sysTotalLines > 0) {
                float churn30 = (float)(100.0 * (double)sysChangedLines30 / (double)sysTotalLines);
                float churn90 = (float)(100.0 * (double)sysChangedLines90 / (double)sysTotalLines);
                float churn365 = (float)(100.0 * (double)sysChangedLines365 / (double)sysTotalLines);
                float churn2y = (float)(100.0 * (double)sysChangedLines2y / (double)sysTotalLines);
                float churn5y = (float)(100.0 * (double)sysChangedLines5y / (double)sysTotalLines);
                i.this.a(this.getResult(), this.c(), sysChanges30, i.this.V);
                i.this.a(this.getResult(), this.c(), sysChanges90, i.this.W);
                i.this.a(this.getResult(), this.c(), sysChanges365, i.this.X);
                i.this.a(this.getResult(), this.c(), sysChanges2y, i.this.Y);
                i.this.a(this.getResult(), this.c(), sysChanges5y, i.this.Z);
                i.this.a(this.getResult(), this.c(), sysChangedLines30, i.this.af);
                i.this.a(this.getResult(), this.c(), sysChangedLines90, i.this.ag);
                i.this.a(this.getResult(), this.c(), sysChangedLines365, i.this.ah);
                i.this.a(this.getResult(), this.c(), sysChangedLines2y, i.this.ai);
                i.this.a(this.getResult(), this.c(), sysChangedLines5y, i.this.aj);
                i.this.a(this.getResult(), this.c(), Float.valueOf(churn30), i.this.aa);
                i.this.a(this.getResult(), this.c(), Float.valueOf(churn90), i.this.ab);
                i.this.a(this.getResult(), this.c(), Float.valueOf(churn365), i.this.ac);
                i.this.a(this.getResult(), this.c(), Float.valueOf(churn2y), i.this.ad);
                i.this.a(this.getResult(), this.c(), Float.valueOf(churn5y), i.this.ae);
                i.this.a(this.getResult(), this.c(), sysAuthors30.size(), i.this.ak);
                i.this.a(this.getResult(), this.c(), sysAuthors90.size(), i.this.al);
                i.this.a(this.getResult(), this.c(), sysAuthors365.size(), i.this.am);
                i.this.a(this.getResult(), this.c(), sysAuthors2y.size(), i.this.an);
                i.this.a(this.getResult(), this.c(), sysAuthors5y.size(), i.this.ao);
            }
        }

        @Override
        protected void a() {
            IScmDataAndConfigurationProvider scmProvider = this.c().getExtension(v.class);
            try {
                ICommitRetriever retriever = i.this.f.getCommitRetriever(i.this.u(), scmProvider);
                Date after = new Date(System.currentTimeMillis() - 157593600000L);
                IWorkerContext workerContext = this.g();
                workerContext.setNumberOfSteps(2, new int[]{60, 40});
                workerContext.beginSubTask("Scanning repositoris");
                long t2 = System.currentTimeMillis();
                BranchCommits commits = retriever.retrieveCommits((IScmDataProvider)scmProvider, after, workerContext);
                d.debug("Time to retrieve commits: " + (System.currentTimeMillis() - t2) + " ms");
                workerContext.endSubTask();
                assert (commits != null);
                workerContext.beginSubTask("Extrating SCM metrics");
                t2 = System.currentTimeMillis();
                this.a(commits.getCommits(), workerContext);
                d.debug("Time to process commits: " + (System.currentTimeMillis() - t2) + " ms");
                i.this.g.scmDataAnalysisFinished();
                workerContext.endSubTask();
            }
            catch (ConfigurationException | RetrieveException e2) {
                d.error("Problem reading data from Git: ", e2);
                this.getResult().setErrorMessage(e2.getMessage());
            }
            catch (IWorkerContext.WorkerContextCancelledException workerContextCancelledException) {
                // empty catch block
            }
        }

        private /* synthetic */ void c(List list, Map map, IWorkerContext iWorkerContext) {
            this.a((List<Commit>)list, map, iWorkerContext);
        }

        private class a
        extends NamedElementVisitor
        implements RootDirectoryPath.IVisitor,
        SourceFile.IVisitor,
        External.IVisitor,
        Module.IVisitor {
            private int b = 0;
            private Module c = null;

            private a() {
            }

            @Override
            public void visitExternal(External external) {
            }

            @Override
            public void visitRootDirectoryPath(RootDirectoryPath root) {
                if (root.mayContainSourceFiles()) {
                    a.this.z.put(root.getIdentifyingPath(), this.c);
                    this.visitChildrenOf(root);
                }
            }

            @Override
            public void visitModule(Module module) {
                Integer zero = 0;
                this.c = module;
                a.this.o.put(module, zero);
                a.this.p.put(module, zero);
                a.this.q.put(module, zero);
                a.this.r.put(module, zero);
                a.this.s.put(module, zero);
                a.this.j.put(module, zero);
                a.this.k.put(module, zero);
                a.this.l.put(module, zero);
                a.this.m.put(module, zero);
                a.this.n.put(module, zero);
                a.this.u.put(module, (Set<Author>)new THashSet());
                a.this.v.put(module, (Set<Author>)new THashSet());
                a.this.w.put(module, (Set<Author>)new THashSet());
                a.this.x.put(module, (Set<Author>)new THashSet());
                a.this.y.put(module, (Set<Author>)new THashSet());
                this.visitChildrenOf(module);
                a.this.t.put(module, this.b);
                this.b = 0;
                this.c = null;
            }

            @Override
            public void visitSourceFile(SourceFile source) {
                if (!source.isExcluded()) {
                    a.this.d.put(source.getIdentifyingPath(), source);
                    this.b += source.getTotalLines();
                }
            }
        }
    }
}

