/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.scm.IScmDataAndConfigurationProvider;
import com.hello2morrow.scm.ScmManager;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.analysis.f;
import com.hello2morrow.sonargraph.core.controller.system.base.h;
import com.hello2morrow.sonargraph.core.controllerinterface.system.n;
import com.hello2morrow.sonargraph.core.controllerinterface.system.v;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.author.AuthorsInfo;
import com.hello2morrow.sonargraph.core.model.author.SourceFilesToAuthorsInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssuesDiff;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRankRecord;
import com.hello2morrow.sonargraph.core.model.system.ranking.Rank;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class g
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.ISSUE_RANKING;
    private static final Logger d = LoggerFactory.getLogger(b.class);

    public static IssueFilter l_() {
        return new IssueFilter(com.hello2morrow.sonargraph.core.controller.system.analysis.g$a.b);
    }

    public g(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g controller) {
        super(controller, a);
    }

    @Override
    public boolean b() {
        return false;
    }

    private boolean a(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'isScmAnalysisActive' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerProvider = softwareSystem.getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        AnalyzerConfiguration scmConfiguration = analyzerProvider.b(CoreAnalyzerId.SCM_METRICS);
        if (scmConfiguration == null) {
            return false;
        }
        String scm = (String)scmConfiguration.getValue("ScmName");
        String string = scm = scm == null ? "Auto Detect" : scm;
        if ("No SCM System".equals(scm)) {
            return false;
        }
        return ScmManager.getInstance().canRun(scm, (IScmDataAndConfigurationProvider)softwareSystem.getExtension(v.class));
    }

    @Override
    protected void a(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        b job = new b(this.p(), result, this.g(), this.d(), this.h().getExtension(IMetricAccessor.class), this.a(this.i()));
        job.i();
    }

    private static final class a
    extends NamedElementVisitor
    implements RootDirectoryPath.IVisitor,
    SourceFile.IVisitor,
    ProgrammingElement.IVisitor {
        private static final IssueFilter b = new IssueFilter((IStandardEnumeration[])new Enum[]{ResolutionMode.NONE, Severity.ERROR, Severity.WARNING, Severity.INFO, IssueCategory.THRESHOLD_VIOLATION, IssueCategory.CYCLE_GROUP, IssueCategory.DUPLICATE_CODE, IssueCategory.SCRIPT_BASED, IssueCategory.ARCHITECTURE_VIOLATION, IssueCategory.ARCHITECTURE_DEPRECATION, IssueCategory.PLUGIN_BASED});
        private final Map<Issue, Set<SourceFile>> c = new THashMap();
        private final IWorkerContext d;
        private final h e;
        private SourceFile f;

        a(IWorkerContext workerContext, h issueParticipationProvider) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'IssueCollector' must not be null";
            assert (issueParticipationProvider != null) : "Parameter 'issueParticipationProvider' of method 'IssueCollector' must not be null";
            this.d = workerContext;
            this.e = issueParticipationProvider;
        }

        Map<Issue, Set<SourceFile>> a() {
            return this.c;
        }

        @Override
        public boolean done() {
            return this.d.hasBeenCanceled();
        }

        @Override
        public void visitRootDirectoryPath(RootDirectoryPath element) {
            assert (element != null) : "Parameter 'element' of method 'visitRootDirectoryPath' must not be null";
            if (element.mayContainSourceFiles()) {
                this.visitChildrenOf(element);
            }
        }

        @Override
        public void visitSourceFile(SourceFile sourceFile) {
            assert (sourceFile != null) : "Parameter 'sourceFile' of method 'visitSourceFile' must not be null";
            this.f = sourceFile;
            if (!sourceFile.isExcluded()) {
                for (Issue issue : this.e.b(sourceFile)) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    this.a(this.f, issue);
                }
                for (Issue issue : this.e.a(sourceFile)) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    this.a(this.f, issue);
                }
                this.visitNamedElement(sourceFile);
            }
            this.f = null;
        }

        private void a(SourceFile sourceFile, Issue issue) {
            assert (issue != null) : "Parameter 'issue' of method 'addIssue' must not be null";
            if (!b.accept(issue)) {
                return;
            }
            if (sourceFile == null) {
                this.c.put(issue, Collections.emptySet());
                return;
            }
            THashSet sourceFiles = this.c.get(issue);
            if (sourceFiles == null) {
                sourceFiles = new THashSet(2);
                this.c.put(issue, (Set<SourceFile>)sourceFiles);
            }
            sourceFiles.add((SourceFile)sourceFile);
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            for (Issue next : namedElement.getIssues()) {
                if (this.d.hasBeenCanceled()) {
                    return;
                }
                this.a(this.f, next);
            }
            super.visitNamedElement(namedElement);
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement programmingElement) {
            assert (programmingElement != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            for (ParserDependency dependency : programmingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (this.d.hasBeenCanceled()) {
                    return;
                }
                for (Issue next : dependency.getIssues()) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    this.a(this.f, next);
                }
            }
            this.visitNamedElement(programmingElement);
        }
    }

    private final class b
    extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.b {
        private final IMetricAccessor d;
        private final boolean e;

        private b(AnalyzerGroup group, AnalyzerResult result, com.hello2morrow.sonargraph.core.controller.system.analysis.base.g controller, Collection<AnalyzerResult> requiredResults, IMetricAccessor metricAccessor, boolean isScmAnalysisActive) {
            super(group, result, controller, requiredResults);
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'IssueRankingJob' must not be null";
            this.d = metricAccessor;
            this.e = isScmAnalysisActive;
        }

        @Override
        protected void a() {
            THashMap modifiedIssues;
            boolean isSystemDiffActive;
            long start = System.currentTimeMillis();
            SoftwareSystem softwareSystem = this.c();
            IWorkerContext workerContext = this.g();
            a issueCollector = new a(workerContext, softwareSystem.getExtension(h.class));
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextModule.accept(issueCollector);
            }
            Map<Issue, Set<SourceFile>> issueToSourceFiles = issueCollector.a();
            if (workerContext.hasBeenCanceled() || issueToSourceFiles.isEmpty()) {
                return;
            }
            SoftwareSystemDiff systemDiff = softwareSystem.getExtension(ISystemDiffProvider.class).getSoftwareSystemDiff();
            boolean bl2 = isSystemDiffActive = systemDiff != null;
            if (isSystemDiffActive) {
                modifiedIssues = new THashMap();
                IssuesDiff issuesDiff = systemDiff.getUniqueExistingChild(IssuesDiff.class);
                for (IIssueDiff nextIIssueDiff : issuesDiff.getChildren(IIssueDiff.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    IDiffElement.Change change = nextIIssueDiff.getChange();
                    if (change == IDiffElement.Change.UNMODIFIED || change == IDiffElement.Change.REMOVED || change == IDiffElement.Change.RESOLUTION_ADDED) continue;
                    modifiedIssues.put(nextIIssueDiff.getCurrent(), nextIIssueDiff);
                }
            } else {
                modifiedIssues = Collections.emptyMap();
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            Map<Object, Object> sourceToScmData = this.e ? this.a(issueToSourceFiles, softwareSystem) : Collections.emptyMap();
            ArrayList<IssueRankRecord> scores = new ArrayList<IssueRankRecord>();
            f computation = new f(isSystemDiffActive, this.e);
            for (Map.Entry<Issue, Set<SourceFile>> entry : issueToSourceFiles.entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Issue issue = entry.getKey();
                Set<SourceFile> sourceFiles = entry.getValue();
                Map<SourceFile, Rank.ScmDataRecord> scmData = this.e ? sourceFiles.stream().collect(Collectors.toMap(s2 -> s2, s2 -> (Rank.ScmDataRecord)sourceToScmData.get(s2))) : Collections.emptyMap();
                IssueRankRecord ranking = computation.a(issue, sourceFiles, (IIssueDiff)modifiedIssues.get(issue), scmData);
                scores.add(ranking);
            }
            Collections.sort(scores, (s1, s2) -> Double.compare(s2.getScore(), s1.getScore()));
            for (IssueRankRecord issueRankRecord : scores) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                this.getResult().addChild(issueRankRecord.createElement(this.getResult()));
            }
            d.debug("{} ms needed to rank issues", (Object)(System.currentTimeMillis() - start));
        }

        private Map<SourceFile, Rank.ScmDataRecord> a(Map<Issue, Set<SourceFile>> issueToSourceFiles, SoftwareSystem softwareSystem) {
            SourceFilesToAuthorsInfo sourceFilesToAuthorsInfo;
            assert (issueToSourceFiles != null) : "Parameter 'issueToSourceFiles' of method 'collectScmDataForSourceFilesAffectedByIssues' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'collectScmDataForSourceFilesAffectedByIssues' must not be null";
            THashMap fileToScmData = new THashMap();
            Installation installation = softwareSystem.getExtension(ISoftwareSystemProvider.class).getInstallation();
            n metricsExtension = installation.getExtension(n.class);
            Map<IMetricId, IMetricDescriptor> scmMetrics = this.a(metricsExtension, EnumSet.of(CoreMetricId.CORE_CHANGES_30, new CoreMetricId[]{CoreMetricId.CORE_CODE_CHURN_30, CoreMetricId.CORE_CHANGES_90, CoreMetricId.CORE_CODE_CHURN_90, CoreMetricId.CORE_CHANGES_365, CoreMetricId.CORE_CODE_CHURN_365}));
            com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = softwareSystem.getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
            AnalyzerResult result = analyzerExtension.d(CoreAnalyzerId.SCM_METRICS);
            Map<SourceFile, AuthorsInfo> sourceFilesToAuthorsMap = null;
            if (result != null && (sourceFilesToAuthorsInfo = result.getUniqueChild(SourceFilesToAuthorsInfo.class)) != null) {
                sourceFilesToAuthorsMap = sourceFilesToAuthorsInfo.getInfo();
            }
            for (Set<SourceFile> nextFiles : issueToSourceFiles.values()) {
                for (SourceFile nextFile : nextFiles) {
                    Rank.ScmDataRecord scmData = (Rank.ScmDataRecord)fileToScmData.get(nextFile);
                    if (scmData == null) {
                        AuthorsInfo authorsInfo = sourceFilesToAuthorsMap != null ? sourceFilesToAuthorsMap.get(nextFile) : null;
                        scmData = this.a(this.d, softwareSystem, scmMetrics, nextFile, authorsInfo);
                    }
                    fileToScmData.put(nextFile, scmData);
                }
            }
            return fileToScmData;
        }

        private Map<IMetricId, IMetricDescriptor> a(n metricsExtension, Set<CoreMetricId> metricIds) {
            assert (metricsExtension != null) : "Parameter 'metricsExtension' of method 'getScmMetrics' must not be null";
            assert (metricIds != null && !metricIds.isEmpty()) : "Parameter 'metricIds' of method 'getScmMetrics' must not be empty";
            THashMap descriptors = new THashMap();
            for (CoreMetricId next : metricIds) {
                IMetricDescriptor metricDescriptor = metricsExtension.findMetricByIdAndLevel(next, CoreMetricLevel.SOURCE_FILE);
                assert (metricDescriptor != null) : "Missing descriptor for metric " + next;
                descriptors.put(next, metricDescriptor);
            }
            return descriptors;
        }

        private Rank.ScmDataRecord a(IMetricAccessor metricAccessor, SoftwareSystem softwareSystem, Map<IMetricId, IMetricDescriptor> scmMetrics, FilePath file, AuthorsInfo authorsInfo) {
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'collectScmDataForFile' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'collectScmDataForFile' must not be null";
            assert (scmMetrics != null && scmMetrics.size() > 0) : "Parameter 'scmMetrics' of method 'collectScmDataForFile' must not be empty";
            assert (file != null) : "Parameter 'source' of method 'collectScmDataForFile' must not be null";
            Rank.ScmDataRecord scmData = new Rank.ScmDataRecord();
            for (Map.Entry<IMetricId, IMetricDescriptor> next : scmMetrics.entrySet()) {
                int value = this.a(metricAccessor, softwareSystem, file, next.getValue());
                if (value == -1) continue;
                scmData.setScmValue(next.getKey(), value);
            }
            if (authorsInfo != null) {
                scmData.setAuthors30(AuthorsInfo.convertArrayToSet(authorsInfo.getAuthors30()));
                scmData.setAuthors90(AuthorsInfo.convertArrayToSet(authorsInfo.getAuthors90()));
                scmData.setAuthors365(AuthorsInfo.convertArrayToSet(authorsInfo.getAuthors365()));
            }
            return scmData;
        }

        private int a(IMetricAccessor metricAccessor, SoftwareSystem softwareSystem, FilePath file, IMetricDescriptor metricDescriptor) {
            Number number;
            IMetricValue metricValue = metricAccessor.getMetricValue(softwareSystem, (IWorkerContext)DefaultWorkerContext.INSTANCE, file, metricDescriptor, false);
            if (metricValue != null && (number = metricValue.getValue()) != null) {
                return number.intValue();
            }
            return -1;
        }
    }
}

