/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.author.Author;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.script.ScriptMetricId;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRankRecord;
import com.hello2morrow.sonargraph.core.model.system.ranking.Rank;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class f {
    private static final Logger b = LoggerFactory.getLogger(f.class);
    private static final float c = 1.0f;
    private static final float d = 5.0f;
    private static final int e = 100;
    private static final int f = 100;
    private static final int g = 4;
    private static final int h = 16;
    private final boolean i;
    private final boolean j;
    private static volatile /* synthetic */ int[] k;
    private static volatile /* synthetic */ int[] l;

    f(boolean isSystemDiffActive, boolean isScmAnalysisActive) {
        this.j = isSystemDiffActive;
        this.i = isScmAnalysisActive;
    }

    final IssueRankRecord a(Issue issue, Set<SourceFile> involvedSourceFiles, IIssueDiff issueDiff, Map<SourceFile, Rank.ScmDataRecord> sourceToScmData) {
        assert (issue != null) : "Parameter 'issue' of method 'compute' must not be null";
        assert (involvedSourceFiles != null) : "Parameter 'sourceFiles' of method 'compute' must not be null";
        assert (sourceToScmData != null) : "Parameter 'sourceToScmData' of method 'compute' must not be null";
        IssueRankRecord ranking = new IssueRankRecord(issue);
        StrictPair<Float, String> overallImportance = this.a(issue, ranking);
        ranking.setImportance(((Float)overallImportance.getFirst()).floatValue());
        ranking.setImportanceAlgorithm((String)overallImportance.getSecond());
        StrictPair<Float, String> overallUrgency = this.a(issue, involvedSourceFiles, ranking, this.j, issueDiff, this.i, sourceToScmData);
        ranking.setUrgency(((Float)overallUrgency.getFirst()).floatValue());
        ranking.setUrgencyAlgorithm((String)overallUrgency.getSecond());
        StrictPair<Float, String> overallScore = this.a(((Float)overallImportance.getFirst()).floatValue(), ((Float)overallUrgency.getFirst()).floatValue());
        ranking.setScore(((Float)overallScore.getFirst()).floatValue());
        ranking.setScoreAlgorithm((String)overallScore.getSecond());
        return ranking;
    }

    private StrictPair<Float, String> a(Issue issue, IssueRankRecord ranking) {
        float severityImportance = this.a(issue.getSeverity());
        ranking.setImportanceSeverity(severityImportance);
        float categoryImportance = this.a(issue.getId().getCategory());
        ranking.setImportanceIssueType(categoryImportance);
        StrictPair<Float, String> impactImportance = this.a(issue);
        ranking.setImportanceImpact(((Float)impactImportance.getFirst()).floatValue());
        ranking.setImportanceImpactAlgorithm((String)impactImportance.getSecond());
        StrictPair<Float, String> overallImportance = this.a(severityImportance, categoryImportance, ((Float)impactImportance.getFirst()).floatValue());
        return overallImportance;
    }

    private float a(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'calculateSeverityImportance' must not be null";
        switch (com.hello2morrow.sonargraph.core.controller.system.analysis.f.a()[severity.ordinal()]) {
            case 1: {
                return 4.0f;
            }
            case 2: {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    private float a(IssueCategory issueCategory) {
        assert (issueCategory != null) : "Parameter 'issueCategory' of method 'calculateImportanceCategory' must not be null";
        switch (com.hello2morrow.sonargraph.core.controller.system.analysis.f.b()[issueCategory.ordinal()]) {
            case 13: {
                return 8.0f;
            }
            case 14: {
                return 2.0f;
            }
            case 5: {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    private StrictPair<Float, String> a(Issue issue) {
        StrictPair importance;
        assert (issue != null) : "Parameter 'issue' of method 'calculateImportanceImpact' must not be null";
        if (issue instanceof ThresholdViolationIssue) {
            importance = this.a((ThresholdViolationIssue)issue);
        } else if (issue instanceof CycleGroupIssue) {
            String algorithm;
            float value;
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)issue.getAffectedElement();
            int linesOfCodeOfInvolvedSourceFiles = cycleGroup.getLinesOfCodeOfInvolvedSourceFiles();
            if (linesOfCodeOfInvolvedSourceFiles < 0) {
                value = 1.0f;
                algorithm = "1 (Lines of code of involved source files is not available)";
            } else {
                value = 1.0f + (float)linesOfCodeOfInvolvedSourceFiles / 1000.0f;
                String valueString = NumberUtility.format((Number)Float.valueOf(value));
                algorithm = String.format("%s = 1 + (Lines of code of involved source files [%d] / 1000)", valueString, cycleGroup.getLinesOfCodeOfInvolvedSourceFiles());
            }
            importance = new StrictPair((Object)Float.valueOf(value), (Object)algorithm);
        } else if (issue instanceof DuplicateCodeBlockIssue) {
            DuplicateCodeBlock block = (DuplicateCodeBlock)issue.getAffectedElement();
            float value = 1.0f + (float)block.getTotalDuplicateLineCount() / 100.0f;
            String algorithm = String.format("%s = 1 + (Total Duplicate Line Count [%d] / %d)", NumberUtility.format((Number)Float.valueOf(value)), block.getTotalDuplicateLineCount(), 100);
            importance = new StrictPair((Object)Float.valueOf(value), (Object)algorithm);
        } else {
            importance = new StrictPair((Object)Float.valueOf(1.0f), (Object)NumberUtility.format((Number)Float.valueOf(1.0f)));
        }
        assert ((double)((Float)importance.getFirst()).floatValue() >= 1.0) : "'importance ' of method 'calculateIssueImportance' must be >= 1.0 but is " + importance;
        return importance;
    }

    private StrictPair<Float, String> a(ThresholdViolationIssue thresholdViolation) {
        StrictPair importance;
        assert (thresholdViolation != null) : "Parameter 'issue' of method 'calculateImportanceForThresholdViolation' must not be null";
        float metricValue = thresholdViolation.getValue().floatValue();
        IMetricId.IMetricRange range = thresholdViolation.getMetricDescriptor().getMetricId().getRange();
        if (range instanceof ScriptMetricId) {
            double lower = ((ScriptMetricId)range).getMinValue();
            double upper = ((ScriptMetricId)range).getMaxValue();
            if (Double.compare(lower, 0.0) == 0 && Double.compare(upper, 1.0) <= 0) {
                range = IMetricId.MetricRange.ZERO_TO_ONE;
            } else if (Double.compare(lower, -1.0) == 0 && Double.compare(upper, 1.0) == 0) {
                range = IMetricId.MetricRange.MINUS_ONE_TO_ONE;
            } else if (Double.compare(lower, 0.0) == 0 && Double.compare(upper, 100.0) == 0) {
                range = IMetricId.MetricRange.PERCENTAGE;
            } else if (Double.compare(lower, 0.0) == 0 && Double.compare(upper, Double.POSITIVE_INFINITY) == 0) {
                range = IMetricId.MetricRange.NULL_OR_POSITIVE;
            } else {
                b.warn("No direct support for custom range [{}, {}] of Script Metric Id " + range + ". Using [0, +inf] instead to calculate importance");
                range = IMetricId.MetricRange.NULL_OR_POSITIVE;
            }
        }
        float lowerThreshold = thresholdViolation.getThreshold().getLowerThreshold().floatValue();
        float upperThreshold = thresholdViolation.getThreshold().getUpperThreshold().floatValue();
        if (Float.compare(metricValue, upperThreshold) > 0) {
            if (Float.compare(upperThreshold, 0.0f) == 0) {
                String algorithm = String.format("%s = Metric Value [%s]", NumberUtility.format((Number)Float.valueOf(metricValue)), NumberUtility.format((Number)Float.valueOf(metricValue)));
                importance = new StrictPair((Object)Float.valueOf(metricValue), (Object)algorithm);
            } else {
                importance = this.a((double)metricValue, range, upperThreshold);
            }
        } else if (Float.compare(metricValue, lowerThreshold) < 0) {
            importance = this.a((double)metricValue, range, lowerThreshold);
        } else {
            float value = 1.0f;
            String algorithm = NumberUtility.format((Number)Float.valueOf(1.0f));
            importance = new StrictPair((Object)Float.valueOf(1.0f), (Object)algorithm);
        }
        return importance;
    }

    private StrictPair<Float, String> a(double metricValue, IMetricId.IMetricRange range, float threshold) {
        double importance = 1.0;
        String algorithm = NumberUtility.format((Number)importance);
        double diff = Math.abs((double)threshold - metricValue);
        if (range == IMetricId.MetricRange.NULL_OR_POSITIVE) {
            if ((double)threshold > 0.0) {
                algorithm = String.format("%s = %s + abs(Threshold [%s] - Metric Value [%s]) / Threshold [%s]", NumberUtility.format((Number)(importance += diff / (double)threshold)), NumberUtility.format((Number)Float.valueOf(1.0f)), NumberUtility.format((Number)Float.valueOf(threshold)), NumberUtility.format((Number)metricValue), NumberUtility.format((Number)Float.valueOf(threshold)));
            }
        } else if (range == IMetricId.MetricRange.MINUS_ONE_TO_ONE) {
            algorithm = String.format("%s = %s + abs(Threshold [%s] - Metric Value [%s])", NumberUtility.format((Number)(importance += diff)), NumberUtility.format((Number)Float.valueOf(1.0f)), NumberUtility.format((Number)Float.valueOf(threshold)), NumberUtility.format((Number)metricValue));
        } else if (range == IMetricId.MetricRange.PERCENTAGE) {
            algorithm = String.format("%s = %s + abs(Threshold [%s] - Metric Value [%s]) / 100.0", NumberUtility.format((Number)(importance += diff / 100.0)), NumberUtility.format((Number)Float.valueOf(1.0f)), NumberUtility.format((Number)Float.valueOf(threshold)), NumberUtility.format((Number)metricValue));
        } else if (range == IMetricId.MetricRange.ZERO_TO_ONE) {
            algorithm = String.format("%s = %s + abs(Threshold [%s] - Metric Value [%s])", NumberUtility.format((Number)(importance += diff)), NumberUtility.format((Number)Float.valueOf(1.0f)), NumberUtility.format((Number)Float.valueOf(threshold)), NumberUtility.format((Number)metricValue));
        } else if (Float.compare(threshold, 0.0f) != 0) {
            algorithm = String.format("%s = %s + abs((Threshold [%s] - Metric Value [%s]) / Threshold [%s])", NumberUtility.format((Number)(importance += Math.abs(diff / (double)threshold))), NumberUtility.format((Number)Float.valueOf(1.0f)), NumberUtility.format((Number)Float.valueOf(threshold)), NumberUtility.format((Number)metricValue), NumberUtility.format((Number)Float.valueOf(threshold)));
        }
        return new StrictPair((Object)Float.valueOf((float)importance), (Object)algorithm);
    }

    private StrictPair<Float, String> a(float importanceSeverity, float importanceIssueType, float importanceImpact) {
        float result = importanceSeverity * importanceIssueType * importanceImpact;
        String algorithm = String.format("%s = Importance Severity [%s] * Importance Issue Category [%s] * Importance Impact [%s]", NumberUtility.format((Number)Float.valueOf(result)), NumberUtility.format((Number)Float.valueOf(importanceSeverity)), NumberUtility.format((Number)Float.valueOf(importanceIssueType)), NumberUtility.format((Number)Float.valueOf(importanceImpact)));
        return new StrictPair((Object)Float.valueOf(result), (Object)algorithm);
    }

    private StrictPair<Float, String> a(Issue issue, Set<SourceFile> sourceFiles, IssueRankRecord ranking, boolean isSystemDiffActive, IIssueDiff issueDiff, boolean isScmAnalysisActive, Map<SourceFile, Rank.ScmDataRecord> sourceToScmData) {
        StrictPair<Float, String> urgencyEaseOfFixAndAlgorithm = this.b(issue);
        Float urgencyIssueType = (Float)urgencyEaseOfFixAndAlgorithm.getFirst();
        ranking.setUrgencyEaseOfFix(urgencyIssueType.floatValue());
        ranking.setUrgencyEaseOfFixAlgorithm((String)urgencyEaseOfFixAndAlgorithm.getSecond());
        float urgencySystemDiff = isSystemDiffActive && issueDiff != null ? this.a(issue, issueDiff.getChange()) : 1.0f;
        ranking.setUrgencySystemDiff(urgencySystemDiff);
        StrictPair urgencyScm = isScmAnalysisActive ? this.a(issue, sourceFiles, sourceToScmData, ranking) : new StrictPair((Object)Float.valueOf(1.0f), (Object)NumberUtility.format((Number)Float.valueOf(1.0f)));
        ranking.setUrgencyScm(((Float)urgencyScm.getFirst()).floatValue());
        ranking.setUrgencyScmAlgorithm((String)urgencyScm.getSecond());
        Float value = Float.valueOf(urgencyIssueType.floatValue() * urgencySystemDiff * ((Float)urgencyScm.getFirst()).floatValue());
        String algorithm = String.format("%s = Urgency Ease of Fix [%s] * Urgency System Diff [%s] * Urgency Scm [%s]", NumberUtility.format((Number)value), NumberUtility.format((Number)urgencyIssueType), NumberUtility.format((Number)Float.valueOf(urgencySystemDiff)), NumberUtility.format((Number)((Number)urgencyScm.getFirst())));
        return new StrictPair((Object)value, (Object)algorithm);
    }

    private StrictPair<Float, String> b(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'calculateUrgencyEaseOfFix' must not be null";
        if (issue instanceof CycleGroupIssue) {
            CycleGroupIssue cycleGroupIssue = (CycleGroupIssue)issue;
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)cycleGroupIssue.getAffectedElement();
            int dependenciesToRemove = cycleGroup.getParserDependenciesToRemove();
            int numberOfCyclicElements = cycleGroup.getNumberOfCyclicElements();
            float urgency = 1.0f + (float)numberOfCyclicElements / (float)dependenciesToRemove;
            String algorithm = String.format("%s = 1 + Number of Cyclic Elements [%d] / Parser Dependencies to Remove [%d]", NumberUtility.format((Number)Float.valueOf(urgency)), numberOfCyclicElements, dependenciesToRemove);
            return new StrictPair((Object)Float.valueOf(urgency), (Object)algorithm);
        }
        if (issue instanceof DuplicateCodeBlockIssue) {
            DuplicateCodeBlock block = (DuplicateCodeBlock)issue.getAffectedElement();
            int overallTolerance = 0;
            for (DuplicateCodeBlockOccurrence next : block.getChildren(DuplicateCodeBlockOccurrence.class)) {
                overallTolerance += next.getToleranceAsInt();
            }
            float urgency = 5.0f - 5.0f * (float)overallTolerance / ((float)block.getTotalDuplicateLineCount() / 100.0f);
            if ((double)urgency > 1.0) {
                String algorithm = String.format("%s = 5 - (5 * Overall Tolerance Lines [%d] / (Total Duplicate Lines [%d] / %d))", NumberUtility.format((Number)Float.valueOf(urgency)), overallTolerance, block.getTotalDuplicateLineCount(), 100);
                return new StrictPair((Object)Float.valueOf(urgency), (Object)algorithm);
            }
        }
        return new StrictPair((Object)Float.valueOf(1.0f), (Object)NumberUtility.format((Number)Float.valueOf(1.0f)));
    }

    private float a(Issue issue, IDiffElement.Change change) {
        assert (issue != null) : "Parameter 'issue' of method 'calculateUrgencyBasedOnSystemDiff' must not be null";
        assert (change != null) : "Parameter 'change' of method 'calculateUrgencyBasedOnSystemDiff' must not be null";
        switch (change) {
            case ADDED: {
                return 4.0f;
            }
            case WORSENED: {
                return 2.0f;
            }
            case RESOLUTION_REMOVED: {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    private StrictPair<Float, String> a(Issue issue, Set<SourceFile> sourceFiles, Map<SourceFile, Rank.ScmDataRecord> sourceToScmData, IssueRankRecord ranking) {
        String algorithm;
        assert (issue != null) : "Parameter 'issue' of method 'calculateUrgencyBasedOnScmData' must not be null";
        assert (sourceFiles != null) : "Parameter 'issueToFilePaths' of method 'calculateUrgencyBasedOnScmData' must not be null";
        assert (sourceToScmData != null) : "Parameter 'sourceToScmData' of method 'calculateUrgencyBasedOnScmData' must not be null";
        assert (ranking != null) : "Parameter 'ranking' of method 'calculateUrgencyBasedOnScmData' must not be null";
        if (sourceFiles.isEmpty()) {
            return new StrictPair((Object)Float.valueOf(1.0f), (Object)NumberUtility.format((Number)Float.valueOf(1.0f)));
        }
        Rank.ScmDataRecord integrated = new Rank.ScmDataRecord();
        for (SourceFile next : sourceFiles) {
            Rank.ScmDataRecord scmData = sourceToScmData.get(next);
            if (scmData != null) {
                integrated.integrate(scmData);
                continue;
            }
            b.warn("Missing scmData record for source file {}", (Object)next);
        }
        if (integrated.isEmpty()) {
            b.warn("Missing scmData for files {} affected by issue {}", (Object)issue);
            return new StrictPair((Object)Float.valueOf(1.0f), (Object)NumberUtility.format((Number)Float.valueOf(1.0f)));
        }
        StrictPair<Float, String> scmUrgency30d = this.a(integrated.getChanges30(), integrated.getChurn30(), integrated.getAuthors30(), sourceFiles.size(), 1);
        this.a("30d", ((Float)scmUrgency30d.getFirst()).floatValue(), issue, sourceToScmData);
        ranking.setUrgencyScm30d(((Float)scmUrgency30d.getFirst()).floatValue());
        ranking.setUrgencyScm30Algorithm((String)scmUrgency30d.getSecond());
        StrictPair<Float, String> scmUrgency90d = this.a(integrated.getChanges90(), integrated.getChurn90(), integrated.getAuthors90(), sourceFiles.size(), 4);
        this.a("90d", ((Float)scmUrgency90d.getFirst()).floatValue() * 4.0f, issue, sourceToScmData);
        ranking.setUrgencyScm90d(((Float)scmUrgency90d.getFirst()).floatValue());
        ranking.setUrgencyScm90Algorithm((String)scmUrgency90d.getSecond());
        StrictPair<Float, String> scmUrgency365d = this.a(integrated.getChanges365(), integrated.getChurn365(), integrated.getAuthors365(), sourceFiles.size(), 16);
        this.a("365d", ((Float)scmUrgency365d.getFirst()).floatValue() * 16.0f, issue, sourceToScmData);
        ranking.setUrgencyScm365d(((Float)scmUrgency365d.getFirst()).floatValue());
        ranking.setUrgencyScm365Algorithm((String)scmUrgency365d.getSecond());
        Float value = Float.valueOf((((Float)scmUrgency30d.getFirst()).floatValue() + ((Float)scmUrgency90d.getFirst()).floatValue() + ((Float)scmUrgency365d.getFirst()).floatValue()) / 3.0f);
        if (Math.abs(value.floatValue()) < 1.0f) {
            value = Float.valueOf(1.0f);
            algorithm = String.format("%s", NumberUtility.format((Number)Float.valueOf(1.0f)));
        } else {
            algorithm = String.format("%s = (Urgency Scm Data 30 Days [%s] + Urgency Scm Data 90 Days [%s] + Urgency Scm Data 365 Days [%s]) / 3", NumberUtility.format((Number)value), NumberUtility.format((Number)((Number)scmUrgency30d.getFirst())), NumberUtility.format((Number)((Number)scmUrgency90d.getFirst())), NumberUtility.format((Number)((Number)scmUrgency365d.getFirst())));
        }
        return new StrictPair((Object)value, (Object)algorithm);
    }

    private StrictPair<Float, String> a(int changes, int churn, Set<Author> authors, int numberOfFiles, int damping) {
        Float value = Float.valueOf(1.0f + ((float)changes + (float)churn / 100.0f + (float)authors.size()) / (float)damping);
        String algorithm = damping == 1 ? String.format("%s = 1 + Authors [%d] + Changes [%d] + Churn [%d] / %d; aggregated from %d involved source files", NumberUtility.format((Number)value), authors.size(), changes, churn, 100, numberOfFiles) : String.format("%s = 1 + (Authors [%d] + Changes [%d] + Churn [%d] / %d) / %d; aggregated from %d involved source files", NumberUtility.format((Number)value), authors.size(), changes, churn, 100, damping, numberOfFiles);
        return new StrictPair((Object)value, (Object)algorithm);
    }

    private void a(String interval, float scmUrgency, Issue issue, Map<SourceFile, Rank.ScmDataRecord> sourceToScmData) {
        assert ((double)scmUrgency >= 1.0) : "ScmUrgency(" + interval + ") must be > 1.0, but was " + scmUrgency + " for issue " + issue + " involving file(s): " + sourceToScmData.keySet().stream().map(s2 -> s2.getPath()).collect(Collectors.joining(", "));
    }

    private StrictPair<Float, String> a(float importance, float urgency) {
        float value = (float)Math.sqrt(importance * importance + urgency * urgency);
        String algorithm = String.format("%s = sqrt( (importance [%s])\u00b2 + (urgency [%s])\u00b2 )", NumberUtility.format((Number)Float.valueOf(value)), NumberUtility.format((Number)Float.valueOf(importance)), NumberUtility.format((Number)Float.valueOf(urgency)));
        return new StrictPair((Object)Float.valueOf(value), (Object)algorithm);
    }

    static /* synthetic */ int[] a() {
        if (k != null) {
            return k;
        }
        int[] nArray = new int[Severity.values().length];
        try {
            nArray[Severity.ERROR.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Severity.INFO.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Severity.NONE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Severity.WARNING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        k = nArray;
        return nArray;
    }

    static /* synthetic */ int[] b() {
        if (l != null) {
            return l;
        }
        int[] nArray = new int[IssueCategory.values().length];
        try {
            nArray[IssueCategory.ARCHITECTURAL_VIEW.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.ARCHITECTURE_CONSISTENCY.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.ARCHITECTURE_DEFINITION.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.ARCHITECTURE_DEPRECATION.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.ARCHITECTURE_VIOLATION.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.CYCLE_GROUP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.DUPLICATE_CODE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.INSTALLATION_CONFIGURATION.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.PLUGIN_BASED.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.QUALITY_GATE.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.REFACTORING.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.SCRIPT_BASED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.SCRIPT_DEFINITION.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.SYSTEM_CONFIGURATION.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.THRESHOLD_VIOLATION.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.TODO.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IssueCategory.WORKSPACE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        l = nArray;
        return nArray;
    }
}

