/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.analysis.k;
import com.hello2morrow.sonargraph.core.controller.system.base.h;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.Collection;
import java.util.List;

public final class e
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.ISSUE_DENSITY;
    private final IMetricDescriptor d;
    private final IMetricDescriptor e;
    private final IMetricDescriptor f;
    private final IMetricDescriptor g;

    public e(g controller) {
        super(controller, a);
        IMetricsProvider metricsProvider = this.h().getExtension(IMetricsProvider.class);
        MetricProvider mp = metricsProvider.getMetricProvider(CoreProviderId.INSTANCE);
        this.d = this.b(mp, CoreMetricId.CORE_ISSUE_DENSITY, CoreMetricLevel.SOURCE_FILE);
        this.e = this.b(mp, CoreMetricId.CORE_ISSUE_DENSITY, CoreMetricLevel.MODULE);
        this.f = this.b(mp, CoreMetricId.CORE_ISSUE_DENSITY, CoreMetricLevel.SYSTEM);
        this.g = this.a(mp, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT, CoreMetricLevel.SOURCE_FILE);
        assert (this.g != null) : "Metric descriptor 'source element count' for level 'source file' not found";
    }

    @Override
    protected void a(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        IMetricAccessor metricAccessor = this.h().getExtension(IMetricAccessor.class);
        c job = new c(this.p(), result, this.g(), metricAccessor, this.d());
        job.i();
    }

    private static final class com.hello2morrow.sonargraph.core.controller.system.analysis.e$a
    extends NamedElementVisitor
    implements RootDirectoryPath.IVisitor,
    SourceFile.IVisitor,
    ProgrammingElement.IVisitor,
    Module.IVisitor {
        private final IssueFilter b = new IssueFilter((IStandardEnumeration[])new Enum[]{ResolutionMode.NONE, Severity.ERROR, Severity.WARNING});
        private final a c;
        private final IWorkerContext d;
        private final h e;
        private final b f;
        private b g;
        private b h;

        com.hello2morrow.sonargraph.core.controller.system.analysis.e$a(a storage, SoftwareSystem softwareSystem, IWorkerContext workerContext) {
            assert (storage != null) : "Parameter 'storage' of method 'SourceVisitor' must not be null";
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'IssueCollector' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'IssueCollector' must not be null";
            this.c = storage;
            this.f = new b(softwareSystem);
            this.e = softwareSystem.getExtension(h.class);
            this.d = workerContext;
        }

        @Override
        public boolean done() {
            return this.d.hasBeenCanceled();
        }

        private void a(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'collectIssues' must not be null";
            for (Issue next : namedElement.getIssues()) {
                if (this.d.hasBeenCanceled()) {
                    return;
                }
                if (!this.b.accept(next)) continue;
                if (this.h != null) {
                    this.h.a(next);
                    continue;
                }
                if (this.g != null) {
                    this.g.a(next);
                    continue;
                }
                this.f.a(next);
            }
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            this.a(namedElement);
            super.visitNamedElement(namedElement);
        }

        @Override
        public void visitRootDirectoryPath(RootDirectoryPath rootPath) {
            assert (rootPath != null) : "Parameter 'rootPath' of method 'visitRootDirectoryPath' must not be null";
            if (rootPath.mayContainSourceFiles()) {
                for (IComponent nextComponent : rootPath.getChildrenRecursively(IComponent.class, ProgrammingElement.class)) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    if (nextComponent.ignoreIssues()) continue;
                    List<SourceFile> sourceFiles = k.a(nextComponent);
                    for (SourceFile nextSource : sourceFiles) {
                        if (this.d.hasBeenCanceled()) {
                            return;
                        }
                        this.visitSourceFile(nextSource);
                    }
                }
            }
        }

        @Override
        public void visitModule(Module module) {
            assert (module != null) : "Parameter 'module' of method 'visitModule' must not be null";
            this.d.working("Collect issues of module " + module.getName(), true);
            this.g = new b(module);
            this.visitNamedElement(module);
            for (WorkspaceDependency next : module.getOutgoingWorkspaceDependencies()) {
                if (this.d.hasBeenCanceled()) {
                    return;
                }
                for (Issue nextIssue : next.getIssues()) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.b.accept(nextIssue)) continue;
                    this.g.a(nextIssue);
                }
            }
            this.c.a(this.g);
            this.f.a(this.g);
            this.g = null;
        }

        @Override
        public void visitSourceFile(SourceFile sourceFile) {
            assert (sourceFile != null) : "Parameter 'sourceFile' of method 'visitSourceFile' must not be null";
            if (!sourceFile.isExcluded()) {
                this.h = new b(sourceFile);
                int sourceFileSize = this.c.a(sourceFile);
                if (sourceFileSize > 0) {
                    this.h.a(sourceFileSize);
                }
                for (Issue issue : this.e.b(sourceFile)) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.b.accept(issue)) continue;
                    this.h.a(issue);
                }
                for (Issue issue : this.e.a(sourceFile)) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.b.accept(issue)) continue;
                    this.h.a(issue);
                }
                this.visitNamedElement(sourceFile);
                this.c.a(this.h);
                this.g.a(this.h);
            }
            this.h = null;
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement programmingElement) {
            assert (programmingElement != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (this.d.hasBeenCanceled()) {
                return;
            }
            for (ParserDependency dependency : programmingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (this.d.hasBeenCanceled()) {
                    return;
                }
                for (Issue next : dependency.getIssues()) {
                    if (this.d.hasBeenCanceled()) {
                        return;
                    }
                    if (!this.b.accept(next)) continue;
                    this.h.a(next);
                }
            }
            this.visitNamedElement(programmingElement);
        }

        void a() {
            this.c.a(this.f);
        }

        public static interface a {
            public void a(b var1);

            public int a(SourceFile var1);
        }
    }

    private static final class b {
        private final NamedElement b;
        private int c = 0;
        private int d = 0;
        private int e = 0;
        private int f = 0;
        private int g = 0;

        b(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'IssueDensity' must not be null";
            this.b = element;
        }

        void a(int increment) {
            this.g += increment;
        }

        int a() {
            return this.g;
        }

        void a(Issue issue) {
            assert (issue != null) : "Parameter 'issue' of method 'add' must not be null";
            switch (issue.getSeverity()) {
                case ERROR: {
                    ++this.c;
                    break;
                }
                case WARNING: {
                    ++this.d;
                    break;
                }
                case INFO: {
                    ++this.e;
                    break;
                }
                case NONE: {
                    ++this.f;
                    break;
                }
                default: {
                    assert (false) : "Unsupported severity: " + issue;
                    break;
                }
            }
        }

        int b() {
            return this.c;
        }

        int c() {
            return this.d;
        }

        int d() {
            return this.e;
        }

        int e() {
            return this.f;
        }

        int f() {
            return this.b() + this.c() + this.d() + this.e();
        }

        void a(b other) {
            assert (other != null) : "Parameter 'other' of method 'integrate' must not be null";
            this.g += other.a();
            this.b(other);
        }

        void b(b other) {
            assert (other != null) : "Parameter 'other' of method 'integrateIssues' must not be null";
            this.c += other.b();
            this.d += other.c();
            this.e += other.d();
            this.f += other.e();
        }

        NamedElement g() {
            return this.b;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IssueDensity [m_element=");
            builder.append(this.b.getShortName());
            builder.append(", m_errorCount=");
            builder.append(this.c);
            builder.append(", m_warningCount=");
            builder.append(this.d);
            builder.append(", m_infoCount=");
            builder.append(this.e);
            builder.append(", m_noneCount=");
            builder.append(this.f);
            builder.append(", m_size=");
            builder.append(this.g);
            builder.append("]");
            return builder.toString();
        }
    }

    private final class c
    extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.b
    implements a.a {
        private final IMetricAccessor d;

        private c(AnalyzerGroup group, AnalyzerResult result, g controller, IMetricAccessor metricAccessor, Collection<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'IssueDensityJob' must not be null";
            this.d = metricAccessor;
        }

        @Override
        protected void a() {
            SoftwareSystem softwareSystem = this.c();
            IWorkerContext workerContext = this.g();
            workerContext.setNumberOfSteps(5 + softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class).size());
            a issueCollector = new a(this, softwareSystem, workerContext);
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextModule.accept(issueCollector);
            }
            issueCollector.a();
        }

        @Override
        public void a(b density) {
            IMetricDescriptor descriptor;
            assert (density != null) : "Parameter 'density' of method 'storeDensity' must not be null";
            NamedElement element = density.g();
            if (element instanceof SourceFile) {
                descriptor = e.this.d;
            } else if (element instanceof Module) {
                descriptor = e.this.e;
            } else if (element instanceof SoftwareSystem) {
                descriptor = e.this.f;
            } else {
                assert (false) : "Unsupported element for issue density: " + element.getClass().getCanonicalName() + ", " + element;
                descriptor = null;
            }
            float value = density.a() > 0 ? (float)density.f() * 1000.0f / (float)density.a() : -1.0f;
            e.this.a(this.getResult(), element, Float.valueOf(value), descriptor);
        }

        @Override
        public int a(SourceFile sourceFile) {
            Number value;
            assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getSourceFileSize' must not be null";
            IMetricValue metricValue = this.d.getMetricValue(this.c(), (IWorkerContext)DefaultWorkerContext.INSTANCE, sourceFile, e.this.g, false);
            if (metricValue != null && (value = metricValue.getValue()) != null) {
                return value.intValue();
            }
            return -1;
        }
    }
}

