/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INodeRankAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.NodeRank;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssueSourceFilesParticipationInfo;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.SourceFileIssueParticipationInfo;
import com.hello2morrow.sonargraph.core.model.analysis.StringList;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ResolutionNameComparator;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class g
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    public static final Predicate<ProgrammingElement> b = pe -> !pe.isExcluded() && !pe.ignoreIssues() && !pe.getRefactoringState().hasBeenDeleted();
    public static final Predicate<ParserDependency> d = pd -> !pd.isExcluded() && !pd.getTo().isExcluded() && !pd.ignoreIssues() && pd.includeInDependencyAnalysis() && !pd.getRefactoringState().hasBeenDeleted();
    private static final Logger a = LoggerFactory.getLogger(g.class);

    protected g(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g controller, IConfigurableAnalyzerId analyzerId) {
        super(controller, analyzerId);
    }

    protected abstract IIssueId u();

    protected CycleAnalyzerConfiguration v() {
        return this.o().getConfiguration(CycleAnalyzerConfiguration.class);
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    protected void d(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'saveResult' must not be null";
        INamedElementResolver resolver = this.g().a();
        SourceFileIssueParticipationInfo info = result.getUniqueChild(SourceFileIssueParticipationInfo.class);
        if (info != null) {
            ArrayList<String> flattened = new ArrayList<String>();
            for (Map.Entry nextEntry : info.getSourceFileToIssues().entrySet()) {
                flattened.add(resolver.getDescriptor(nextEntry.getKey()));
                for (CycleGroupIssue nextIssue : nextEntry.getValue()) {
                    flattened.add(resolver.getDescriptor(nextIssue));
                }
                flattened.add(null);
            }
            StringList stringList = new StringList(result, flattened.toArray(new String[flattened.size()]));
            result.addChild(stringList);
        }
        super.d(result);
        result.removeChildren(StringList.class);
    }

    @Override
    protected void e(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        StringList stringList = result.getUniqueChild(StringList.class);
        if (stringList != null) {
            SourceFileIssueParticipationInfo info = result.getUniqueChild(SourceFileIssueParticipationInfo.class);
            if (info == null) {
                info = new SourceFileIssueParticipationInfo(result);
                result.addChild(info);
            }
            INamedElementResolver resolver = this.g().a();
            SourceFile resolvedSourceFile = null;
            THashSet resolvedIssues = new THashSet();
            String[] stringArray = stringList.getList();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Element nextResolved;
                String next = stringArray[n3];
                if (resolvedSourceFile == null) {
                    assert (next != null && next.length() > 0) : "'next' of method 'resultSuccessfullyRestored' must not be empty";
                    nextResolved = resolver.resolve(next);
                    if (nextResolved == null || !(nextResolved instanceof SourceFile)) {
                        throw new RestoreException("Unable to restore source file: " + next);
                    }
                    resolvedSourceFile = (SourceFile)nextResolved;
                } else if (next != null) {
                    nextResolved = resolver.resolve(next);
                    if (nextResolved == null || !(nextResolved instanceof CycleGroupIssue)) {
                        throw new RestoreException("Unable to restore issue: " + next);
                    }
                    resolvedIssues.add((CycleGroupIssue)nextResolved);
                } else {
                    if (resolvedIssues.isEmpty()) {
                        throw new RestoreException("Unable to restore issues");
                    }
                    info.put(resolvedSourceFile, resolvedIssues);
                    resolvedSourceFile = null;
                    resolvedIssues.clear();
                }
                ++n3;
            }
            result.removeChild(stringList);
        }
        super.e(result);
    }

    @Override
    protected boolean b(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        boolean removed = super.b(result);
        return removed |= result.removeChildren(SourceFileIssueParticipationInfo.class);
    }

    @Override
    protected List<IIssueId> c(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueIds' must not be null";
        ArrayList<IIssueId> ids = new ArrayList<IIssueId>(super.c(result));
        ids.add(this.u());
        return ids;
    }

    @Override
    protected IssueFilter f(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueFilter' must not be null";
        IssueFilter filter = super.f(result);
        filter.addIgnore(issue -> issue instanceof CycleGroupIssue && ((CycleGroupIssue)issue).getAnalyzerId() != this.n());
        return filter;
    }

    protected abstract class a
    extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.b {
        private IMetricDescriptor a;
        private IMetricDescriptor b;
        private IMetricDescriptor f;
        private IMetricDescriptor g;
        private ValueList h;
        private ValueList i;
        private ValueList j;
        private ValueList k;
        private final int l;

        protected a(AnalyzerGroup group, AnalyzerResult result, com.hello2morrow.sonargraph.core.controller.system.analysis.base.g controller) {
            super(group, result, controller);
            this.l = g.this.v().getCriticalCycleGroupSize();
        }

        protected Integer l() {
            return null;
        }

        private String b(int index) {
            Integer baseIndex = this.l();
            return String.valueOf(baseIndex != null ? baseIndex + "." : "") + index;
        }

        protected final void a(IMetricDescriptor rankMetric) {
            this.g = rankMetric;
        }

        protected final void b(IMetricDescriptor numberOfIncomingDependenciesMetric) {
            this.a = numberOfIncomingDependenciesMetric;
        }

        protected final void c(IMetricDescriptor numberOfOutgoingDependenciesMetric) {
            this.b = numberOfOutgoingDependenciesMetric;
        }

        protected final void d(IMetricDescriptor instabilityMetric) {
            this.f = instabilityMetric;
        }

        protected abstract Collection<? extends NamedElement> j();

        protected boolean a(int cycleGroupSize) {
            return cycleGroupSize >= this.l;
        }

        protected abstract AnalyzerCycleGroup a(boolean var1);

        protected NamedElement m() {
            return this.c();
        }

        private void a(NamedElement element, int incoming, int outgoing) {
            assert (element != null) : "Parameter 'element' of method 'setNumberOfConnectedDependencies' must not be null";
            if (this.i == null && this.a != null) {
                this.i = g.this.a(this.getResult(), this.a, this.m());
            }
            if (this.i != null) {
                this.i.addValue(element, incoming);
            }
            if (this.j == null && this.b != null) {
                this.j = g.this.a(this.getResult(), this.b, this.m());
            }
            if (this.j != null) {
                this.j.addValue(element, outgoing);
            }
            if (this.f != null) {
                if (this.k == null) {
                    this.k = g.this.a(this.getResult(), this.f, null);
                }
                float instability = incoming + outgoing > 0 ? (float)outgoing / (float)(incoming + outgoing) : 1.0f;
                this.k.addValue(element, Float.valueOf(instability));
                this.c(element, instability);
            }
        }

        protected NodeAdapterSet<ParserDependencyNodeAdapter> a(Collection<? extends NamedElement> elements) {
            return new ParserDependencyNodeAdapterSet(this.g(), elements, new DependencyEndpointCollector(), b, d);
        }

        protected abstract boolean k();

        protected void a(NamedElement element, float value) {
        }

        protected void b(NamedElement element, float value) {
        }

        protected abstract List<IType> a(NamedElement var1);

        protected final void c(NamedElement namedElement, float instability) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'calculateElementMetrics' must not be null";
            int totalTypes = 0;
            int abstractTypes = 0;
            for (IType type : this.a(namedElement)) {
                ++totalTypes;
                if (!type.isAbstract()) continue;
                ++abstractTypes;
            }
            if (totalTypes > 0) {
                float abstractness = (float)abstractTypes / (float)totalTypes;
                this.b(namedElement, abstractness);
                this.a(namedElement, abstractness + instability - 1.0f);
            }
        }

        private boolean a(NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, Set<ParserDependencyNodeAdapter> cycleGroup) {
            assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'inDifferentModules' must not be null";
            assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'inDifferentModules' must not be null";
            IWorkerContext workerContext = this.g();
            Module currentModule = null;
            for (ParserDependencyNodeAdapter nextCyclicFrom : cycleGroup) {
                if (workerContext.hasBeenCanceled()) {
                    return false;
                }
                for (ParserDependencyNodeAdapter nextCyclicTo : cycleGroup) {
                    ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> foundEdge;
                    if (workerContext.hasBeenCanceled()) {
                        return false;
                    }
                    if (nextCyclicFrom == nextCyclicTo || (foundEdge = nextCyclicFrom.getOutgoingEdge(nextCyclicTo)) == null) continue;
                    for (ParserDependency next : foundEdge.getDependencies()) {
                        if (workerContext.hasBeenCanceled()) {
                            return false;
                        }
                        Module nextFromModule = next.getFrom().getParent(Module.class, new Class[0]);
                        assert (nextFromModule != null) : "'nextFromModule' of method 'inDifferentModules' must not be null";
                        if (currentModule == null) {
                            currentModule = nextFromModule;
                        } else if (currentModule != nextFromModule) {
                            return true;
                        }
                        Module nextToModule = next.getTo().getParent(Module.class, new Class[0]);
                        assert (nextToModule != null) : "'nextToModule' of method 'inDifferentModules' must not be null";
                        assert (currentModule != null) : "'currentModule' of method 'inDifferentModules' must not be null";
                        if (currentModule == nextToModule) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private void a(Set<ParserDependencyNodeAdapter> cycleGroup, NamedElement duplicate) {
            assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'logDuplicateInCycleGroup' must not be null";
            assert (duplicate != null) : "Parameter 'duplicate' of method 'logDuplicateInCycleGroup' must not be null";
            a.error("Duplicate cyclic element [" + duplicate.getClass().getSimpleName() + "] " + duplicate.getFullyQualifiedName());
            a.error("In cycle of " + cycleGroup.size() + " elements:");
            for (ParserDependencyNodeAdapter nextInCycleGroup : cycleGroup) {
                a.error("[" + nextInCycleGroup.getUnderlyingObject().getClass().getSimpleName() + "] " + nextInCycleGroup.getUnderlyingObject().getFullyQualifiedName());
            }
        }

        private List<AnalyzerCycleGroup> a(NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, CycleAnalyzerAdapter cycleAnalyzerAdapter, Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>> cycleGroupToNodes) {
            assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'processCycles' must not be null";
            assert (cycleAnalyzerAdapter != null) : "Parameter 'cycleAnalyzerAdapter' of method 'processCycles' must not be null";
            assert (cycleGroupToNodes != null) : "Parameter 'cycleGroupToNodes' of method 'processCycles' must not be null";
            IWorkerContext workerContext = this.g();
            THashMap indexToNodeAdapters = new THashMap();
            for (NodeAdapter nodeAdapter : cycleAnalyzerAdapter.getCyclicNodes()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                assert (nodeAdapter != null && nodeAdapter instanceof ParserDependencyNodeAdapter) : "Unexpected class in method 'processCycles': " + nodeAdapter;
                Integer nextGroupIndex = cycleAnalyzerAdapter.getGroup(nodeAdapter);
                Set nextNodeAdapters = (Set)indexToNodeAdapters.get(nextGroupIndex);
                if (nextNodeAdapters == null) {
                    nextNodeAdapters = new THashSet();
                    indexToNodeAdapters.put(nextGroupIndex, nextNodeAdapters);
                }
                nextNodeAdapters.add((ParserDependencyNodeAdapter)nodeAdapter);
            }
            ArrayList<AnalyzerCycleGroup> arrayList = new ArrayList<AnalyzerCycleGroup>();
            for (Map.Entry nextEntry : indexToNodeAdapters.entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                Set nextCycleGroupNodeAdapters = (Set)nextEntry.getValue();
                if (this.k() && !this.a(nodeAdapterSet, nextCycleGroupNodeAdapters)) continue;
                AnalyzerCycleGroup nextCreatedCycleGroup = this.a(this.a(nextCycleGroupNodeAdapters.size()));
                THashSet nextUnderlyingCyclicElements = new THashSet(nextCycleGroupNodeAdapters.size());
                Iterator iterator = nextCycleGroupNodeAdapters.iterator();
                while (iterator.hasNext()) {
                    ParserDependencyNodeAdapter nextNodeAdapter = (ParserDependencyNodeAdapter)iterator.next();
                    NamedElement nextUnderlyingCyclicElement = nextNodeAdapter.getUnderlyingObject();
                    if (!nextUnderlyingCyclicElements.add(nextUnderlyingCyclicElement)) {
                        this.a(nextCycleGroupNodeAdapters, nextUnderlyingCyclicElement);
                        continue;
                    }
                    nextCreatedCycleGroup.addCyclicElement(nextUnderlyingCyclicElement);
                }
                arrayList.add(nextCreatedCycleGroup);
                cycleGroupToNodes.put(nextCreatedCycleGroup, nextCycleGroupNodeAdapters);
            }
            Collections.sort(arrayList, ResolutionNameComparator.INSTANCE);
            AnalyzerResult result = this.getResult();
            for (AnalyzerCycleGroup next : arrayList) {
                next.setParent(result);
                result.addChild(next);
            }
            Iterator<ParserDependencyNodeAdapter> iterator = nodeAdapterSet.iterator();
            while (iterator.hasNext()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                ParserDependencyNodeAdapter nextNodeAdapter = iterator.next();
                this.a(nextNodeAdapter.getUnderlyingObject(), nextNodeAdapter.getNumberOfIncomingEdges(), nextNodeAdapter.getNumberOfOutgoingEdges());
            }
            return arrayList;
        }

        protected void a(AnalyzerResult result) {
            assert (result != null) : "Parameter 'result' of method 'finished' must not be null";
        }

        @Override
        public void a() {
            CycleGroupIssueSourceFilesParticipationInfo cycleToInvolvedSourceFiles;
            IWorkerContext workerContext = this.g();
            workerContext.setNumberOfSteps(7, new int[]{5, 5, 10, 40, 5, 30, 5});
            workerContext.beginSubTask("Get relevant elements");
            Collection<? extends NamedElement> elements = this.j();
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled() || elements.isEmpty()) {
                return;
            }
            workerContext.beginSubTask("Creating node adapter set");
            NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet = this.a(elements);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Computing rank");
            AnalyzerResult analyzerResult = this.getResult();
            this.a(nodeAdapterSet, analyzerResult);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Analyze cycles");
            CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
            CycleAnalyzer.compute(cycleAnalyzerAdapter, workerContext);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Process cycles");
            THashMap cycleGroupToNodeAdapters = new THashMap();
            List<AnalyzerCycleGroup> sortedCycleGroups = this.a(nodeAdapterSet, cycleAnalyzerAdapter, (Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)cycleGroupToNodeAdapters);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Calculating breakup metrics for cycles");
            if (!cycleGroupToNodeAdapters.isEmpty()) {
                workerContext.beginSubTask("Calculating cycle breakup for cycle");
                com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.a.a((Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)cycleGroupToNodeAdapters, workerContext);
                workerContext.endSubTask();
            }
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Finish cycles");
            SourceFileIssueParticipationInfo<CycleGroupIssue> sourceFileParticipationInfo = analyzerResult.getUniqueChild(SourceFileIssueParticipationInfo.class);
            if (sourceFileParticipationInfo == null) {
                sourceFileParticipationInfo = new SourceFileIssueParticipationInfo<CycleGroupIssue>(analyzerResult);
                analyzerResult.addChild(sourceFileParticipationInfo);
            }
            if ((cycleToInvolvedSourceFiles = analyzerResult.getUniqueChild(CycleGroupIssueSourceFilesParticipationInfo.class)) == null) {
                cycleToInvolvedSourceFiles = new CycleGroupIssueSourceFilesParticipationInfo(analyzerResult, g.this.u());
                analyzerResult.addChild(cycleToInvolvedSourceFiles);
            }
            this.a(workerContext, (Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)cycleGroupToNodeAdapters, sortedCycleGroups, sourceFileParticipationInfo, cycleToInvolvedSourceFiles);
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            this.a(analyzerResult);
            workerContext.endSubTask();
        }

        private void a(IWorkerContext workerContext, Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>> cycleGroupToNodeAdapters, List<AnalyzerCycleGroup> sortedCycleGroups, SourceFileIssueParticipationInfo<CycleGroupIssue> sourceFileParticipationInfo, CycleGroupIssueSourceFilesParticipationInfo cycleToInvolvedSourceFiles) {
            int index = 1;
            for (AnalyzerCycleGroup nextCycleGroup : sortedCycleGroups) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                CycleGroupIssue issue = new CycleGroupIssue(nextCycleGroup, nextCycleGroup.createIssueDescription(), g.this.n(), nextCycleGroup.getCycleGroupIssueId(), nextCycleGroup.isCritical() ? Severity.ERROR : Severity.WARNING);
                nextCycleGroup.addIssue(issue);
                nextCycleGroup.finish(this.b(index));
                ++index;
                Set<? extends NodeAdapter> nextNodeAdaptersInCycleGroup = cycleGroupToNodeAdapters.get(nextCycleGroup);
                if (nextNodeAdaptersInCycleGroup == null) continue;
                THashSet sourceFiles = new THashSet();
                for (NodeAdapter nodeAdapter : nextNodeAdaptersInCycleGroup) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : nodeAdapter.getOutgoingEdges()) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        assert (edgeAdapter != null && edgeAdapter instanceof ParserDependencyEdgeAdapter) : "Unexpected class in method 'internalRun': " + edgeAdapter;
                        for (ParserDependency nextOutParserDependency : ((ParserDependencyEdgeAdapter)edgeAdapter).getDependencies()) {
                            if (workerContext.hasBeenCanceled()) {
                                return;
                            }
                            ProgrammingElement nextFrom = nextOutParserDependency.getFrom();
                            SourceFile nextSourceFile = nextFrom.getParent(SourceFile.class, new Class[0]);
                            if (nextSourceFile != null) {
                                sourceFiles.add(nextSourceFile);
                                continue;
                            }
                            a.error("No source file parent found for: " + nextFrom);
                            NamedElement current = nextFrom.getParent();
                            while (current != null) {
                                a.error("Parent: " + current);
                                current = current.getParent();
                            }
                        }
                    }
                }
                sourceFileParticipationInfo.add(issue, (Set<SourceFile>)sourceFiles);
                cycleToInvolvedSourceFiles.add(issue, (Set<SourceFile>)sourceFiles);
                nextCycleGroup.setNumberOfInvolvedSourceFiles(sourceFiles.size());
                int n2 = sourceFiles.parallelStream().mapToInt(s2 -> s2.getLinesOfCode()).filter(lines -> lines > 0).sum();
                nextCycleGroup.setLinesOfCodeOfInvolvedSourceFiles(n2);
            }
            cycleToInvolvedSourceFiles.finishModification();
            sourceFileParticipationInfo.finishModification();
        }

        private void a(final NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, final AnalyzerResult analyzerResult) {
            assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'computeRank' must not be null";
            assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'computeRank' must not be null";
            if (this.g != null) {
                NodeRank nodeRankComputer = new NodeRank();
                nodeRankComputer.compute(new INodeRankAdapter(){

                    @Override
                    public Collection<? extends INode<?>> getNodes() {
                        return nodeAdapterSet.getNodes();
                    }

                    @Override
                    public void setRank(INode<?> node, double rank) {
                        if (a.this.h == null) {
                            a.this.h = g.this.a(analyzerResult, a.this.g, null);
                        }
                        NamedElement element = (NamedElement)node.getUnderlyingObject();
                        a.this.h.addValue(element, rank);
                    }
                }, this.g());
            }
        }
    }

    protected abstract class b
    extends a {
        private int a;
        private Module b;
        private final Workspace h;

        protected b(AnalyzerGroup group, AnalyzerResult result, com.hello2morrow.sonargraph.core.controller.system.analysis.base.g controller, Workspace workspace) {
            super(group, result, controller);
            this.a = 1;
            this.h = workspace;
        }

        @Override
        protected final Integer l() {
            return this.a;
        }

        @Override
        protected final NamedElement m() {
            return this.b;
        }

        protected abstract Language b();

        @Override
        public final void a() {
            final Language language = this.b();
            List<Module> modules = language == null ? this.h.getChildren(Module.class) : this.h.getChildren(new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement namedElement) {
                    if (!(g || namedElement != null && namedElement instanceof Module)) {
                        throw new AssertionError((Object)("Unexpected class in method 'accept': " + namedElement));
                    }
                    return language.equals(namedElement.getLanguage());
                }
            }, Module.class);
            if (!modules.isEmpty()) {
                IWorkerContext workerContext = this.g();
                workerContext.setNumberOfSteps(modules.size());
                for (Module nextModule : modules) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.b = nextModule;
                    workerContext.beginSubTask(nextModule.getName());
                    super.a();
                    workerContext.endSubTask();
                    ++this.a;
                }
            }
        }
    }
}

