/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.b;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;

public abstract class CycleMetricsAnalyzerAdapter
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    private final List<IAnalyzerId> a;

    public CycleMetricsAnalyzerAdapter(g controller, IConfigurableAnalyzerId analyzerId, List<IAnalyzerId> basedOn) {
        super(controller, analyzerId);
        assert (basedOn != null && !basedOn.isEmpty() && basedOn.size() <= 2) : "Parameter 'basedOn' of method 'CycleMetricsAnalyzerAdapter' must not be empty and must contain at most 2: " + basedOn;
        this.a = new ArrayList<IAnalyzerId>(basedOn.size());
        for (IAnalyzerId next : basedOn) {
            assert (next != CoreAnalyzerId.SIZE_METRICS) : "Unexpected analyzer id '" + CoreAnalyzerId.SIZE_METRICS + "'";
            assert (!this.a.contains(next)) : "Already added: " + next;
            this.a.add(next);
        }
    }

    protected abstract IMetricDescriptor u();

    protected abstract IMetricDescriptor v();

    protected abstract IMetricDescriptor w();

    protected abstract IMetricDescriptor x();

    protected abstract IMetricDescriptor y();

    protected abstract IMetricDescriptor z();

    protected abstract IMetricDescriptor A();

    protected abstract IMetricDescriptor B();

    protected abstract IMetricDescriptor C();

    protected abstract IMetricDescriptor D();

    protected abstract IMetricId E();

    protected abstract boolean F();

    protected Language G() {
        return null;
    }

    @Override
    protected IssueFilter f(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    protected void a(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        ArrayList<AnalyzerResult> requiredResults = new ArrayList<AnalyzerResult>(this.a.size() + 1);
        g controller = this.g();
        requiredResults.add(controller.d(CoreAnalyzerId.SIZE_METRICS));
        this.a.forEach(r2 -> {
            boolean bl2 = requiredResults.add(controller.d((IAnalyzerId)r2));
        });
        a job = new a(this.p(), result, controller, requiredResults);
        job.i();
    }

    private class com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CycleMetricsAnalyzerAdapter$a
    extends b {
        private com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CycleMetricsAnalyzerAdapter$a(AnalyzerGroup group, AnalyzerResult result, g controller, List<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void a() {
            IMetricAccessor accessor = CycleMetricsAnalyzerAdapter.this.g().o().getExtension(IMetricAccessor.class);
            if (CycleMetricsAnalyzerAdapter.this.F()) {
                a computer = new a(this.c(), accessor);
                computer.a();
            } else {
                IWorkerContext workerContext = this.g();
                for (Module module : this.c().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (CycleMetricsAnalyzerAdapter.this.G() != null && module.getLanguage() != CycleMetricsAnalyzerAdapter.this.G()) continue;
                    a computer = new a(module, accessor);
                    computer.a();
                }
            }
        }

        private class a {
            private final NamedElement c;
            private final IMetricAccessor d;

            private a(NamedElement scope, IMetricAccessor acc) {
                this.c = scope;
                this.d = acc;
            }

            private void a(int n2) {
                if (CycleMetricsAnalyzerAdapter.this.v() != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, n2, CycleMetricsAnalyzerAdapter.this.v());
                }
            }

            private void b(int n2) {
                if (CycleMetricsAnalyzerAdapter.this.w() != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, n2, CycleMetricsAnalyzerAdapter.this.w());
                }
            }

            private void c(int n2) {
                if (CycleMetricsAnalyzerAdapter.this.y() != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, n2, CycleMetricsAnalyzerAdapter.this.y());
                }
            }

            private void d(int n2) {
                if (CycleMetricsAnalyzerAdapter.this.u() != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, n2, CycleMetricsAnalyzerAdapter.this.u());
                }
            }

            private void e(int n2) {
                if (CycleMetricsAnalyzerAdapter.this.x() != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, n2, CycleMetricsAnalyzerAdapter.this.x());
                }
            }

            private void f(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.z();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, val, md);
                }
            }

            private void g(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.A();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, val, md);
                }
            }

            private void h(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.B();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, val, md);
                }
            }

            private void i(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.C();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, val, md);
                }
                this.j(val);
            }

            private void j(int cyclicity) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.D();
                if (md != null) {
                    IMetricId noe = CycleMetricsAnalyzerAdapter.this.E();
                    if (noe == null) {
                        return;
                    }
                    Number noElements = this.d.getMetricValue(a.this.c(), this.c, noe);
                    if (noElements == null || noElements.intValue() == 0) {
                        CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, Float.valueOf(0.0f), md);
                        return;
                    }
                    double val = 100.0 * Math.sqrt(cyclicity) / noElements.doubleValue();
                    CycleMetricsAnalyzerAdapter.this.a(a.this.getResult(), this.c, Float.valueOf((float)val), md);
                }
            }

            protected void a() {
                IWorkerContext workerContext = a.this.g();
                VirtualModel vm = CycleMetricsAnalyzerAdapter.this.j();
                List requiredResults = a.this.h();
                assert (requiredResults.size() >= 2) : "At least 2 required results expected: " + requiredResults;
                assert (((AnalyzerResult)requiredResults.get(0)).getId().equals(CoreAnalyzerId.SIZE_METRICS)) : "Size metrics analyzer result must be at first position: " + requiredResults;
                int cyclicElements = 0;
                int ignoredCyclicElements = 0;
                int cycleGroupCount = 0;
                int criticalCycleGroupCount = 0;
                int biggestCycleGroupSize = 0;
                int cyclicity = 0;
                int refsToCut = 0;
                int cdToCut = 0;
                int sdi = 0;
                int i2 = 1;
                while (i2 < requiredResults.size()) {
                    AnalyzerResult nextRequiredBaseAnalyzerResult = (AnalyzerResult)requiredResults.get(i2);
                    for (AnalyzerCycleGroup nextCycleGroup : nextRequiredBaseAnalyzerResult.getChildren(AnalyzerCycleGroup.class)) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        if (!CycleMetricsAnalyzerAdapter.this.F() && nextCycleGroup.getScope() != this.c) continue;
                        ResolutionState resolutionState = ResolutionState.NONE;
                        Issue issue = vm.getElementIssue(nextCycleGroup, nextCycleGroup.getCycleGroupIssueId());
                        if (issue != null && issue.getResolution() != null) {
                            ResolutionState resolutionState2 = resolutionState = issue.getResolution().ignores() ? ResolutionState.IGNORED : ResolutionState.TASK;
                        }
                        if (resolutionState == ResolutionState.IGNORED) {
                            ignoredCyclicElements += nextCycleGroup.getNumberOfCyclicElements();
                        }
                        int size = nextCycleGroup.getNumberOfCyclicElements();
                        cyclicElements += size;
                        ++cycleGroupCount;
                        if (nextCycleGroup.isCritical()) {
                            ++criticalCycleGroupCount;
                        }
                        cyclicity += size * size;
                        if (size > biggestCycleGroupSize) {
                            biggestCycleGroupSize = size;
                        }
                        refsToCut += nextCycleGroup.getParserDependenciesToRemove();
                        cdToCut += nextCycleGroup.getComponentDependenciesToRemove();
                        sdi += nextCycleGroup.getStructuralDebtIndex();
                    }
                    ++i2;
                }
                this.d(ignoredCyclicElements);
                this.a(cycleGroupCount);
                this.b(criticalCycleGroupCount);
                this.e(cyclicElements);
                this.c(biggestCycleGroupSize);
                this.i(cyclicity);
                this.f(refsToCut);
                this.g(cdToCut);
                this.h(sdi);
            }
        }
    }

    private static enum ResolutionState {
        NONE,
        IGNORED,
        TASK;

    }
}

