/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.complexity;

import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.j;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class b
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    private static final Logger d = LoggerFactory.getLogger(b.class);
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.COMPLEXITY_SYSTEM_METRICS;
    private final IMetricDescriptor e;
    private final IMetricDescriptor f;
    private final IMetricDescriptor g;
    private final IMetricDescriptor h;
    private final IMetricDescriptor i;
    private final IMetricDescriptor j;
    private final IMetricDescriptor k;
    private final IMetricDescriptor l;
    private final IMetricDescriptor m;

    public b(g controller) {
        super(controller, a);
        MetricProvider mp = this.h().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.f = this.a(mp, CoreMetricId.CORE_MODIFIED_EXTENDED_CCN, CoreMetricLevel.ROUTINE);
        this.g = this.a(mp, CoreMetricId.CORE_MAX_NESTING, CoreMetricLevel.ROUTINE);
        this.e = this.b(mp, CoreMetricId.CORE_STATEMENTS_FULLY_ANALYZED, CoreMetricLevel.SYSTEM);
        this.h = this.b(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS, CoreMetricLevel.SYSTEM);
        this.i = this.b(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_PERCENT, CoreMetricLevel.SYSTEM);
        this.j = this.b(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_IGNORED, CoreMetricLevel.SYSTEM);
        this.k = this.b(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_IGNORED_PERCENT, CoreMetricLevel.SYSTEM);
        this.l = this.b(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX, CoreMetricLevel.SYSTEM);
        this.m = this.b(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX_PERCENT, CoreMetricLevel.SYSTEM);
    }

    @Override
    protected IssueFilter f(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    protected void e(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        if (result.getMetricValue(this.i(), this.i) == null) {
            throw new RestoreException("Missing expected metric value for fully analyzed lines of code.");
        }
        super.e(result);
    }

    @Override
    protected void a(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        a job = new a(this.p(), result, this.g(), this.d());
        job.i();
    }

    private final class a
    extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.b {
        private static final int d = 15;
        private static final int e = 4;

        protected a(AnalyzerGroup group, AnalyzerResult result, g controller, Collection<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void a() {
            j thresholdController = this.c().getExtension(j.class);
            Map<IMetricDescriptor, IMetricThreshold> thresholds = thresholdController.a(Arrays.asList(b.this.f, b.this.g));
            Number maxCyclomaticThresholdValue = this.a(thresholds, b.this.f);
            boolean maxCyclomaticThresholdDefined = maxCyclomaticThresholdValue != null;
            int maxCyclomaticThreshold = maxCyclomaticThresholdDefined ? maxCyclomaticThresholdValue.intValue() : 15;
            Number maxNestingThresholdValue = this.a(thresholds, b.this.g);
            boolean maxNestingThresholdDefined = maxNestingThresholdValue != null;
            int maxNestingThreshold = maxNestingThresholdDefined ? maxNestingThresholdValue.intValue() : 4;
            Workspace workspace = this.c().getUniqueExistingChild(Workspace.class);
            int fullyAnalyzedStatements = 0;
            int complexStatements = 0;
            int complexStatementsIgnored = 0;
            int complexStatementsToBeFixed = 0;
            for (Module nextModule : workspace.getChildren(Module.class)) {
                if (this.g().hasBeenCanceled()) {
                    return;
                }
                for (SourceFile nextSource : nextModule.getChildrenRecursively(SourceFile.class, SourceFile.class)) {
                    if (this.g().hasBeenCanceled()) {
                        return;
                    }
                    if (nextSource.isExcluded()) continue;
                    List<IRoutine> componentRoutines = nextSource.getChildrenRecursively(IRoutine.class, IRoutine.class);
                    for (IRoutine nextRoutine : componentRoutines) {
                        ThresholdViolationIssue issue;
                        int numberOfStatements;
                        if (this.g().hasBeenCanceled()) {
                            return;
                        }
                        NamedElement routine = (NamedElement)((Object)nextRoutine);
                        if (routine.ignoreIssues() || (numberOfStatements = nextRoutine.getNumberOfStatements()) <= 0) continue;
                        int maxNesting = nextRoutine.getMaxNesting();
                        int cyclomaticComplexity = nextRoutine.getModifiedExtendedCyclomaticComplexity();
                        boolean cyclomaticComplexityViolated = cyclomaticComplexity > maxCyclomaticThreshold;
                        boolean nestingViolated = maxNesting > maxNestingThreshold;
                        boolean isComplex = cyclomaticComplexityViolated || nestingViolated;
                        fullyAnalyzedStatements += numberOfStatements;
                        if (!isComplex) continue;
                        boolean isIgnored = false;
                        boolean hasTask = false;
                        if (cyclomaticComplexityViolated && maxCyclomaticThresholdDefined) {
                            issue = this.a(nextRoutine, b.this.f);
                            if (issue != null) {
                                if (issue.isIgnored()) {
                                    isIgnored = true;
                                } else if (issue.getResolution() instanceof TaskDefinition) {
                                    hasTask = true;
                                }
                            } else {
                                d.warn("Cyclomatic complexity threshold issue not found (own/max/defined): " + cyclomaticComplexity + "/" + maxCyclomaticThreshold + "/" + maxCyclomaticThresholdValue + " for routine:\n" + nextRoutine);
                            }
                        }
                        if (nestingViolated && maxNestingThresholdDefined && !isIgnored) {
                            issue = this.a(nextRoutine, b.this.g);
                            if (issue != null) {
                                if (issue.isIgnored()) {
                                    isIgnored = true;
                                } else if (issue.getResolution() instanceof TaskDefinition) {
                                    hasTask = true;
                                }
                            } else {
                                d.warn("Max Block Nesting Depth threshold issue not found (own/max/defined): " + maxNesting + "/" + maxNestingThreshold + "/" + maxNestingThresholdValue + " for routine:\n" + nextRoutine);
                            }
                        }
                        complexStatements += numberOfStatements;
                        if (isIgnored) {
                            complexStatementsIgnored += numberOfStatements;
                            continue;
                        }
                        if (!hasTask) continue;
                        complexStatementsToBeFixed += numberOfStatements;
                    }
                }
            }
            b.this.a(this.getResult(), this.c(), fullyAnalyzedStatements, b.this.e);
            b.this.a(this.getResult(), this.c(), complexStatements, b.this.h);
            b.this.a(this.getResult(), this.c(), Float.valueOf(this.a(complexStatements, fullyAnalyzedStatements)), b.this.i);
            b.this.a(this.getResult(), this.c(), complexStatementsIgnored, b.this.j);
            b.this.a(this.getResult(), this.c(), Float.valueOf(this.a(complexStatementsIgnored, fullyAnalyzedStatements)), b.this.k);
            b.this.a(this.getResult(), this.c(), complexStatementsToBeFixed, b.this.l);
            b.this.a(this.getResult(), this.c(), Float.valueOf(this.a(complexStatementsToBeFixed, fullyAnalyzedStatements)), b.this.m);
        }

        private Number a(Map<IMetricDescriptor, IMetricThreshold> thresholds, IMetricDescriptor descriptor) {
            assert (thresholds != null) : "Parameter 'thresholds' of method 'getUpperThreshold' must not be null";
            assert (descriptor != null) : "Parameter 'descriptor' of method 'getUpperThreshold' must not be null";
            IMetricThreshold threshold = thresholds.get(descriptor);
            if (threshold != null) {
                return threshold.getUpperThreshold();
            }
            return null;
        }

        private ThresholdViolationIssue a(IRoutine routine, IMetricDescriptor metricDescriptor) {
            assert (routine != null) : "Parameter 'routine' of method 'getThresholdViolationIssue' must not be null";
            assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getThresholdViolationIssue' must not be null";
            NamedElement method = (NamedElement)((Object)routine);
            return method.getIssues(CoreIssueId.THRESHOLD_VIOLATION).stream().filter(i2 -> i2 instanceof ThresholdViolationIssue).map(i2 -> (ThresholdViolationIssue)i2).filter(t2 -> t2.getMetricDescriptor() == metricDescriptor).findFirst().orElse(null);
        }
    }
}

