/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.c;

import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.analysis.k;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class b
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.DUPLICATE_CODE_METRICS;
    private static final Logger d = LoggerFactory.getLogger(a.class);
    private final IMetricDescriptor e;
    private final IMetricDescriptor f;
    private final IMetricDescriptor g;
    private final IMetricDescriptor h;
    private final IMetricDescriptor i;
    private final IMetricDescriptor j;
    private final IMetricDescriptor k;

    public b(g controller) {
        super(controller, a);
        MetricProvider metricProvider = this.h().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.e = this.a(metricProvider, CoreMetricId.CORE_DUPLICATED_LINES, CoreMetricLevel.SYSTEM, null);
        this.f = this.a(metricProvider, CoreMetricId.CORE_DUPLICATES, CoreMetricLevel.SYSTEM, null);
        this.g = this.a(metricProvider, CoreMetricId.CORE_IGNORED_DUPLICATES, CoreMetricLevel.SYSTEM, null);
        this.h = this.a(metricProvider, CoreMetricId.CORE_DUPLICATES_FIXED, CoreMetricLevel.SYSTEM, null);
        this.i = this.a(metricProvider, CoreMetricId.CORE_REDUNDANCY, CoreMetricLevel.SYSTEM, null);
        this.j = this.a(metricProvider, CoreMetricId.CORE_REDUNDANCY_IGNORED, CoreMetricLevel.SYSTEM, null);
        this.k = this.a(metricProvider, CoreMetricId.CORE_REDUNDANCY_FIXED, CoreMetricLevel.SYSTEM, null);
    }

    @Override
    protected IssueFilter f(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    protected void e(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        if (result.getMetricValue(this.i(), this.i) == null) {
            throw new RestoreException("Missing expected metric value for redundancy.");
        }
        super.e(result);
    }

    @Override
    protected void a(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        a job = new a(this.p(), result, this.g(), this.d());
        job.i();
    }

    private final class a
    extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.b {
        private a(AnalyzerGroup group, AnalyzerResult result, g controller, Collection<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void a() {
            float redundancyFixed;
            float redundancyIgnored;
            float redundancy;
            List<AnalyzerResult> requiredResults = this.h();
            assert (requiredResults.size() == 1) : "Only 1 required result expected";
            AnalyzerResult requiredResult = requiredResults.get(0);
            VirtualModel virtualModel = b.this.j();
            int duplicates = 0;
            int duplicatesIgnored = 0;
            int duplicatesFixed = 0;
            int duplicatedLines = 0;
            THashMap sourceFileToOccurrences = new THashMap();
            THashMap sourceFileToIgnoredOccurrences = new THashMap();
            THashMap sourceFileToToBeFixedOccurrences = new THashMap();
            for (DuplicateCodeBlock block : requiredResult.getChildren(DuplicateCodeBlock.class)) {
                if (this.g().hasBeenCanceled()) {
                    return;
                }
                Issue issue = virtualModel.getElementIssue(block, CoreIssueId.DUPLICATE_CODE_BLOCK);
                assert (issue != null) : "Missing issue for duplicate code block: " + block;
                ++duplicates;
                this.a(block, (Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToOccurrences);
                if (issue.isIgnored()) {
                    ++duplicatesIgnored;
                    this.a(block, (Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToIgnoredOccurrences);
                } else if (issue.getResolution() != null) {
                    ++duplicatesFixed;
                    this.a(block, (Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToToBeFixedOccurrences);
                }
                duplicatedLines += block.getDuplicatedLineCount();
            }
            SoftwareSystem softwareSystem = this.c();
            b.this.a(this.getResult(), softwareSystem, duplicatedLines, b.this.e);
            b.this.a(this.getResult(), softwareSystem, duplicates, b.this.f);
            b.this.a(this.getResult(), softwareSystem, duplicatesIgnored, b.this.g);
            b.this.a(this.getResult(), softwareSystem, duplicatesFixed, b.this.h);
            int linesOfCodeReferenceForRedundancy = this.a(softwareSystem);
            if (linesOfCodeReferenceForRedundancy > 0) {
                int totalLinesInvolvedInDuplicates = this.a((Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToOccurrences);
                redundancy = this.b(totalLinesInvolvedInDuplicates, linesOfCodeReferenceForRedundancy);
                int totalLinesInvolvedInDuplicatesIgnored = this.a((Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToIgnoredOccurrences);
                redundancyIgnored = this.b(totalLinesInvolvedInDuplicatesIgnored, linesOfCodeReferenceForRedundancy);
                int totalLinesInvolvedInDuplicatesFixed = this.a((Map<SourceFile, List<DuplicateCodeBlockOccurrence>>)sourceFileToToBeFixedOccurrences);
                redundancyFixed = this.b(totalLinesInvolvedInDuplicatesFixed, linesOfCodeReferenceForRedundancy);
            } else {
                redundancy = 0.0f;
                redundancyIgnored = 0.0f;
                redundancyFixed = 0.0f;
            }
            b.this.a(this.getResult(), softwareSystem, Float.valueOf(redundancy), b.this.i);
            b.this.a(this.getResult(), softwareSystem, Float.valueOf(redundancyIgnored), b.this.j);
            b.this.a(this.getResult(), softwareSystem, Float.valueOf(redundancyFixed), b.this.k);
        }

        private int a(Map<SourceFile, List<DuplicateCodeBlockOccurrence>> sourceFileToOccurrences) {
            assert (sourceFileToOccurrences != null) : "Parameter 'sourceFileToOccurrences' of method 'computeDuplicatedLines' must not be null";
            int duplicatedLines = 0;
            for (Map.Entry<SourceFile, List<DuplicateCodeBlockOccurrence>> next : sourceFileToOccurrences.entrySet()) {
                SourceFile source = next.getKey();
                List<DuplicateCodeBlockOccurrence> occurrences = next.getValue();
                if (occurrences.size() == 1) {
                    duplicatedLines += occurrences.get(0).getBlockSize();
                    continue;
                }
                int totalLines = source.getTotalLines();
                if (totalLines <= 0) {
                    d.warn("Number of total lines is {} for source {}", (Object)totalLines, (Object)source.getFullyQualifiedName());
                    continue;
                }
                BitSet lines = new BitSet(totalLines);
                for (DuplicateCodeBlockOccurrence nextOcc : occurrences) {
                    lines.set(nextOcc.getBlockBegin() - 1, nextOcc.getBlockEnd() - 1, true);
                }
                duplicatedLines += lines.cardinality();
            }
            return duplicatedLines;
        }

        private void a(DuplicateCodeBlock block, Map<SourceFile, List<DuplicateCodeBlockOccurrence>> sourceFileToOccurrences) {
            assert (block != null) : "Parameter 'block' of method 'collectOccurrences' must not be null";
            assert (sourceFileToOccurrences != null) : "Parameter 'sourceFileToOccurrences' of method 'collectOccurrences' must not be null";
            for (DuplicateCodeBlockOccurrence next : block.getChildren(DuplicateCodeBlockOccurrence.class)) {
                SourceFile source = next.getSourceFile();
                List<DuplicateCodeBlockOccurrence> occurrences = sourceFileToOccurrences.get(source);
                if (occurrences == null) {
                    occurrences = new ArrayList<DuplicateCodeBlockOccurrence>(2);
                    sourceFileToOccurrences.put(source, occurrences);
                }
                occurrences.add(next);
            }
        }

        private float b(int value, int reference) {
            assert (reference > 0) : "reference must be > 0, but is " + reference;
            return (float)value * 100.0f / (float)reference;
        }

        private int a(SoftwareSystem softwareSystem) {
            THashSet fullyAnalyzedSources = new THashSet();
            for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                for (IComponent nextComponent : nextModule.getChildrenRecursively(IComponent.class, IComponent.class)) {
                    if (nextComponent.isExcluded() || nextComponent.ignoreIssues()) continue;
                    fullyAnalyzedSources.addAll(com.hello2morrow.sonargraph.core.controller.system.analysis.k.a(nextComponent));
                }
            }
            int totalLines = 0;
            int commentLines = 0;
            int codeCommentLines = 0;
            for (SourceFile next : fullyAnalyzedSources) {
                totalLines += next.getTotalLines();
                commentLines += next.getCommentLines();
                codeCommentLines += next.getCodeCommentLines();
            }
            int linesOfCodeReferenceForRedundancy = totalLines - commentLines + codeCommentLines;
            return linesOfCodeReferenceForRedundancy;
        }
    }
}

