/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.c;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfo;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfoEQClass;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateCodeChecker;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.SourceFileIssueParticipationInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ResolutionNameComparator;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IRelevantSourceFileIterator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class a
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.DUPLICATE_CODE;
    private static final Logger d = LoggerFactory.getLogger(a.class);

    public a(g controller) {
        super(controller, a);
    }

    @Override
    public void a(AnalyzerResult result) {
        a job = new a(this.p(), result, this.g());
        job.i();
    }

    @Override
    protected List<IIssueId> c(AnalyzerResult result) {
        ArrayList<IIssueId> ids = new ArrayList<IIssueId>(super.c(result));
        ids.add(CoreIssueId.DUPLICATE_CODE_BLOCK);
        return ids;
    }

    @Override
    protected boolean b(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        result.removeChildren(SourceFileIssueParticipationInfo.class);
        return super.b(result);
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    protected void e(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.analysis.c.a.j(result);
        super.e(result);
    }

    private static void j(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'fillCache' must not be null";
        assert (result.getFirstChild(SourceFileIssueParticipationInfo.class) == null) : "Info already present";
        SourceFileIssueParticipationInfo<DuplicateCodeBlockIssue> info = new SourceFileIssueParticipationInfo<DuplicateCodeBlockIssue>(result);
        result.addChild(info);
        for (DuplicateCodeBlock nextCodeBlock : result.getChildren(DuplicateCodeBlock.class)) {
            THashSet sourceFiles = new THashSet();
            for (DuplicateCodeBlockOccurrence nextOccurrence : nextCodeBlock.getChildren(DuplicateCodeBlockOccurrence.class)) {
                sourceFiles.add(nextOccurrence.getSourceFile());
            }
            info.add((DuplicateCodeBlockIssue)nextCodeBlock.getAssociatedIssue(), (Set<SourceFile>)sourceFiles);
        }
        info.finishModification();
    }

    private boolean a(DuplicateCodeBlock nextCodeBlock) {
        StrictPair<String, Double> matchingInfoSummary = nextCodeBlock.getMatchingInfoSummary();
        double differenceRatio = (Double)matchingInfoSummary.getSecond();
        double threshold = 0.1;
        if (Double.compare(differenceRatio, 0.1) > 0) {
            d.debug("Difference in tolerance and distance detected with a ratio of diff/occurrence-size {} > {}: {}", new Object[]{differenceRatio, 0.1, matchingInfoSummary.getFirst()});
            return false;
        }
        return true;
    }

    private final class a
    extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.b {
        a(AnalyzerGroup group, AnalyzerResult result, g controller) {
            super(group, result, controller);
        }

        @Override
        public void a() {
            DuplicateCodeAnalyzerConfiguration configuration = this.f().getConfiguration(DuplicateCodeAnalyzerConfiguration.class);
            assert (configuration != null) : "'configuration' of method 'internalRun' must not be null";
            int minimalLineLength = configuration.getMinimalLineLength();
            int maximalTolerance = configuration.getMaximalTolerancePerEdit();
            int minimalBlockLength = configuration.getMinimalBlockLength();
            int maximumNumberOfCopies = configuration.getMaximumNumberOfCopies();
            int maximumRelativeTolerancePercentage = configuration.getMaximumRelativeTolerancePercentage();
            IWorkerContext workerContext = this.g();
            DuplicateCodeChecker duplicateCodeChecker = new DuplicateCodeChecker(minimalLineLength, maximalTolerance, minimalBlockLength, maximumNumberOfCopies, maximumRelativeTolerancePercentage, workerContext);
            IRelevantSourceFileIterator relevantSourceFileIterator = this.c().getExtension(ISoftwareSystemProvider.class).getRelevantSourceFileIterator();
            List<DuplicateBlockInfoEQClass> duplicateBlockInfoEQClassList = duplicateCodeChecker.compute(relevantSourceFileIterator, relevantSourceFileIterator.getTotalNumberOfRelevantSourceFiles());
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            assert (duplicateBlockInfoEQClassList != null) : "'duplicateBlockInfoEQClassList' of method 'internalRun' must not be null";
            int counter = 1;
            ArrayList<DuplicateCodeBlock> duplicateCodeBlocks = new ArrayList<DuplicateCodeBlock>();
            b comparator = new b();
            for (DuplicateBlockInfoEQClass nextDuplicateBlockInfoEQClass : duplicateBlockInfoEQClassList) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                List<DuplicateBlockInfo> nextOccurrences = nextDuplicateBlockInfoEQClass.getElements();
                if (nextOccurrences.size() < 2) continue;
                DuplicateCodeBlock nextCodeBlock = new DuplicateCodeBlock(null, nextDuplicateBlockInfoEQClass, counter++);
                ArrayList<DuplicateCodeBlockOccurrence> occurrences = new ArrayList<DuplicateCodeBlockOccurrence>(nextOccurrences.size());
                for (DuplicateBlockInfo nextBlockInfo : nextOccurrences) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    DuplicateCodeBlockOccurrence nextOccurrence = new DuplicateCodeBlockOccurrence(nextCodeBlock, nextBlockInfo);
                    occurrences.add(nextOccurrence);
                }
                Collections.sort(occurrences, comparator);
                for (DuplicateCodeBlockOccurrence occ : occurrences) {
                    nextCodeBlock.addChild(occ);
                }
                duplicateCodeBlocks.add(nextCodeBlock);
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            Collections.sort(duplicateCodeBlocks, ResolutionNameComparator.INSTANCE);
            AnalyzerResult result = this.getResult();
            for (DuplicateCodeBlock nextCodeBlock : duplicateCodeBlocks) {
                nextCodeBlock.setParent(result);
                result.addChild(nextCodeBlock);
                DuplicateCodeBlockIssue nextIssue = new DuplicateCodeBlockIssue(nextCodeBlock, nextCodeBlock.createIssueDescription());
                nextCodeBlock.addIssue(nextIssue);
            }
            if (d.isDebugEnabled()) {
                int mismatchCount = 0;
                for (DuplicateCodeBlock nextCodeBlock : duplicateCodeBlocks) {
                    if (a.this.a(nextCodeBlock)) continue;
                    ++mismatchCount;
                }
                d.debug("{} of {} duplicate code blocks contain occurrences where tolerance and distance values differ.", (Object)mismatchCount, (Object)duplicateCodeBlocks.size());
            }
            com.hello2morrow.sonargraph.core.controller.system.analysis.c.a.j(result);
        }
    }

    static final class b
    implements Comparator<NamedElement> {
        b() {
        }

        public int a(NamedElement occurrence1, NamedElement occurrence2) {
            assert (occurrence1 != null && occurrence1 instanceof DuplicateCodeBlockOccurrence) : "Unexpected class in method 'compare': " + occurrence1;
            assert (occurrence2 != null && occurrence2 instanceof DuplicateCodeBlockOccurrence) : "Unexpected class in method 'compare': " + occurrence2;
            return ((DuplicateCodeBlockOccurrence)occurrence1).getName().compareTo(((DuplicateCodeBlockOccurrence)occurrence2).getName());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((NamedElement)object, (NamedElement)object2);
        }
    }
}

