/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.c;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.d;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.i;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.j;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerJobElement;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.metrics.FloatValueList;
import com.hello2morrow.sonargraph.core.model.metrics.IntegerValueList;
import com.hello2morrow.sonargraph.core.model.metrics.MetricDescriptor;
import com.hello2morrow.sonargraph.core.model.metrics.MetricValue;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class a {
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private final Set<IMetricDescriptor> b = new LinkedHashSet<IMetricDescriptor>();
    private final Map<IMetricDescriptor, List<ValueList>> d = new THashMap();
    private final Set<a> e = new THashSet();
    private final g f;
    private final Analyzer g;
    private i h;
    private j i;
    private Map<IMetricDescriptor, IMetricThreshold> j;
    private Throwable k;
    private boolean l;
    private boolean m;
    private boolean n;
    private long o = -1L;

    protected a(g controller, IConfigurableAnalyzerId analyzerId) {
        assert (controller != null) : "Parameter 'controller' of method 'AnalysisAdapter' must not be null";
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'AnalysisAdapter' must not be null";
        this.f = controller;
        Analyzers analyzers = controller.n().getUniqueExistingChild(Files.class).getAnalyzers();
        Analyzer analyzer = null;
        for (Analyzer nextAnalyzer : analyzers.getChildren(Analyzer.class)) {
            if (!nextAnalyzer.getId().equals(analyzerId)) continue;
            analyzer = nextAnalyzer;
            break;
        }
        assert (analyzer != null) : "'analyzer' of method 'AnalysisAdapter' must not be null";
        this.g = analyzer;
    }

    protected final List<AnalyzerResult> d() {
        ArrayList<AnalyzerResult> requiredResults = new ArrayList<AnalyzerResult>();
        for (a next : this.e) {
            AnalyzerResult analyzerResult = this.g().d(next.n());
            if (analyzerResult == null) continue;
            requiredResults.add(analyzerResult);
        }
        return requiredResults;
    }

    public final void a(a adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'addDependingAdapter' must not be null";
        if (this != adapter) {
            this.e.add(adapter);
        }
    }

    public final Set<a> e() {
        return Collections.unmodifiableSet(this.e);
    }

    public final void f() {
        this.e.clear();
    }

    protected final g g() {
        return this.f;
    }

    protected final Installation h() {
        return this.f.o();
    }

    protected final SoftwareSystem i() {
        return this.f.n();
    }

    protected final VirtualModel j() {
        VirtualModel vm = this.i().getCurrentModel(VirtualModel.class);
        assert (vm != null) : "Parameter 'vm' of method 'getCurrentModel' must not be null";
        return vm;
    }

    protected final j k() {
        if (this.i == null) {
            this.i = this.i().getExtension(j.class);
            assert (this.i != null) : "'m_thresholdController' of method 'getThresholdController' must not be null";
        }
        return this.i;
    }

    protected final void a(IMetricThreshold th, IMetricValue value) {
        assert (th != null) : "Parameter 'th' of method 'checkValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'checkValue' must not be null";
        this.k().a(th, value);
    }

    protected final void l() {
        this.l = true;
    }

    protected final void m() {
        this.m = true;
    }

    protected final void a(AnalyzerResult result, NamedElement element, Number value, IMetricDescriptor descriptor) {
        assert (result != null) : "Parameter 'result' of method 'storeMetricValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'storeMetricValue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'storeMetricValue' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'storeMetricValue' must not be null";
        assert (this.j != null) : "'m_thresholdMap' of method 'storeMetricValue' must not be null";
        MetricValue metricValue = new MetricValue(result, element, value, descriptor);
        result.addChild(metricValue);
        IMetricThreshold th = this.j.get(descriptor);
        if (th != null) {
            this.a(th, metricValue);
        }
        this.l();
    }

    public final IConfigurableAnalyzerId n() {
        return this.g.getId();
    }

    public final Analyzer o() {
        return this.g;
    }

    public final AnalyzerGroup p() {
        return this.g.getId().getGroup();
    }

    private void a(i consumer) {
        this.h = consumer;
    }

    protected final IMetricDescriptor a(MetricProvider metricProvider, IMetricId id, IMetricLevel level) {
        assert (metricProvider != null) : "Parameter 'metricProvider' of method 'findMetricDescriptor' must not be null";
        assert (id != null) : "Parameter 'id' of method 'findMetricDescriptor' must not be null";
        assert (level != null) : "Parameter 'level' of method 'findMetricDescriptor' must not be null";
        for (IMetricDescriptor nextMetricDescriptor : metricProvider.getChildren(IMetricDescriptor.class)) {
            if (nextMetricDescriptor.getMetricId() != id || nextMetricDescriptor.getLevel() != level) continue;
            return nextMetricDescriptor;
        }
        return null;
    }

    protected final IMetricDescriptor a(MetricProvider mp, IMetricId id, IMetricLevel level, Predicate<NamedElement> elementFilter, Language language) {
        assert (mp != null) : "Parameter 'mp' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (id != null) : "Parameter 'id' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addMetricDescriptorIfNotExistent' must not be null";
        IMetricDescriptor descriptor = this.a(mp, id, level);
        if (descriptor == null) {
            MetricDescriptor md = new MetricDescriptor(mp, id, level, this.o().getId(), elementFilter, language);
            descriptor = md;
            mp.addChild(md);
        }
        this.b.add(descriptor);
        return descriptor;
    }

    protected final IMetricDescriptor a(MetricProvider mp, IMetricId id, IMetricLevel level, Predicate<NamedElement> elementFilter) {
        assert (mp != null) : "Parameter 'mp' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (id != null) : "Parameter 'id' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addMetricDescriptorIfNotExistent' must not be null";
        return this.a(mp, id, level, elementFilter, mp.getLanguage());
    }

    protected final IMetricDescriptor b(MetricProvider mp, IMetricId id, IMetricLevel level) {
        assert (mp != null) : "Parameter 'mp' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (id != null) : "Parameter 'id' of method 'addMetricDescriptorIfNotExistent' must not be null";
        assert (level != null) : "Parameter 'level' of method 'addMetricDescriptorIfNotExistent' must not be null";
        return this.a(mp, id, level, null, mp.getLanguage());
    }

    protected final void a(IMetricDescriptor md) {
        assert (md != null) : "Parameter 'md' of method 'addMetricDescriptor' must not be null";
        this.b.add(md);
    }

    protected final ValueList a(AnalyzerResult result, IMetricDescriptor descriptor, NamedElement root) {
        assert (result != null) : "Parameter 'result' of method 'createValueList' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'createValueList' must not be null";
        assert (this.b.contains(descriptor)) : "Unknown metric descriptor: " + descriptor;
        ValueList valueList = descriptor.isFloat() ? new FloatValueList(result, descriptor) : new IntegerValueList(result, descriptor, root);
        result.addChild(valueList);
        List<ValueList> valueLists = this.d.get(descriptor);
        if (valueLists == null) {
            valueLists = new ArrayList<ValueList>();
            this.d.put(descriptor, valueLists);
        }
        valueLists.add(valueList);
        this.l();
        return valueList;
    }

    protected boolean b(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        a.debug("AnalyzerAdapter.clearResult(result) : " + this.n());
        IssueFilter filter = this.f(result);
        if (filter != null && !filter.isEmpty()) {
            this.j().removeElementIssues(issue -> filter.accept((Issue)issue));
        }
        this.k().b(this.b);
        boolean reset = result.clear();
        this.l = false;
        this.m = false;
        return reset;
    }

    protected List<IIssueId> c(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueIds' must not be null";
        return Collections.emptyList();
    }

    protected IssueFilter f(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueFilter' must not be null";
        IssueFilter filter = new IssueFilter(new IStandardEnumeration[0]);
        this.c(result).stream().filter(id -> id != CoreIssueId.THRESHOLD_VIOLATION).forEach(id -> filter.add(id));
        filter.addIgnore(issue -> issue.getId() == CoreIssueId.THRESHOLD_VIOLATION);
        return filter;
    }

    private List<Issue> j(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssues' must not be null";
        IssueFilter filter = this.f(result);
        if (filter == null || filter.isEmpty()) {
            return Collections.emptyList();
        }
        return this.j().getIssueList(filter).getIssues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean q() {
        AnalyzerResult result;
        a.debug("AnalyzerAdapter.reset(result) : " + this.n());
        AnalyzerResult analyzerResult = result = this.g.getResult();
        synchronized (analyzerResult) {
            switch (result.getState()) {
                case FINISHED: 
                case INACTIVE: 
                case ERROR: 
                case CANCELLED: {
                    boolean isReset = this.b(result);
                    result.removeChildren(new Class[0]);
                    result.resetFrozen();
                    result.setState(AnalyzerState.HAS_NOT_BEEN_RUN);
                    result.notifyAll();
                    return isReset;
                }
                case HAS_NOT_BEEN_RUN: {
                    break;
                }
                case RUNNING: {
                    assert (false) : this.n() + " is still running: " + result;
                    break;
                }
                default: {
                    assert (false) : "Unhandled state: " + (Object)((Object)result.getState());
                    break;
                }
            }
        }
        return false;
    }

    protected abstract void a(AnalyzerResult var1);

    protected void g(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'finished' must not be null";
        if (this.b() && !this.n) {
            this.d(result);
        }
        this.n = false;
        this.o = -1L;
        result.finished();
    }

    protected d h(AnalyzerResult result) {
        return new d(result, this.g());
    }

    protected c i(AnalyzerResult result) {
        return new c(result, this.g());
    }

    private TFile a(TFile dir) {
        return new TFile((File)dir, String.valueOf(this.n().getStandardName()) + CoreFileType.SNAPSHOT.getDefaultExtension());
    }

    protected void d(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'saveResult' must not be null";
        d writer = this.h(result);
        TFile file = this.a(this.f.getAnalyzerResultStorageDirectory());
        try {
            writer.storeChildrenAndAdditionalObjects(file, this.j(result));
        }
        catch (Exception e2) {
            a.error("Error while writing analyzer result: ", (Throwable)e2);
        }
    }

    protected long c() {
        AnalyzerConfigurationFile configFile = this.g().a(this.n());
        long result = configFile != null && configFile.existsOnDisk() ? configFile.getFile().lastModified() : 0L;
        for (a dependsUpon : this.e) {
            result = Long.max(result, dependsUpon.u());
        }
        return result;
    }

    private long u() {
        if (this.o == -1L) {
            this.o = this.c();
        }
        return this.o;
    }

    protected void e(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
    }

    private boolean k(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'readResult' must not be null";
        assert (this.b());
        TFile file = this.a(this.f.d());
        TFile datFile = new TFile((File)file, "model.dat");
        if (file.exists() && this.u() < datFile.lastModified()) {
            c reader = this.i(result);
            try {
                reader.retrieve(file);
                result.finished();
                this.e(result);
                this.n = true;
                for (ValueList nextValueList : result.getChildren(ValueList.class)) {
                    List<ValueList> valueLists;
                    IMetricDescriptor nextListItemMetricDescriptor;
                    IMetricDescriptor nextValueMetricDescriptor = nextValueList.getValueMetricDescriptor();
                    if (nextValueMetricDescriptor != (nextListItemMetricDescriptor = nextValueList.getListItemMetricDescriptor())) {
                        a.warn("Different descriptors: " + nextValueMetricDescriptor + "/" + nextListItemMetricDescriptor);
                    }
                    if ((valueLists = this.d.get(nextListItemMetricDescriptor)) == null) {
                        valueLists = new ArrayList<ValueList>();
                        this.d.put(nextListItemMetricDescriptor, valueLists);
                    }
                    valueLists.add(nextValueList);
                }
                for (MetricValue nextMetricValue : result.getChildren(MetricValue.class)) {
                    IMetricThreshold nextThreshold = this.j.get(nextMetricValue.getMetricDescriptor());
                    if (nextThreshold == null) continue;
                    this.a(nextThreshold, nextMetricValue);
                }
                return true;
            }
            catch (Throwable t2) {
                a.warn("[" + this.o().getName() + "] failed to restore analyzer result from '" + file.getPath() + "'", t2);
                result.forgetChildren(true);
            }
        }
        return false;
    }

    public boolean b() {
        return false;
    }

    private void v() {
        if (!this.d.isEmpty()) {
            Map<IMetricDescriptor, IMetricThreshold> thresholdMap = this.k().a(this.d.keySet());
            for (List<ValueList> nextLists : this.d.values()) {
                for (ValueList nextList : nextLists) {
                    IMetricDescriptor descriptor = nextList.getListItemMetricDescriptor();
                    IMetricThreshold th = thresholdMap.get(descriptor);
                    if (th == null) continue;
                    nextList.processValues(null, v2 -> this.a(th, v2));
                }
            }
            this.d.clear();
        }
    }

    public boolean r() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void a(boolean loadResultIfPresent, boolean canRun) {
        SoftwareSystem softwareSystem = this.i();
        AnalyzerResult result = this.g.getResult();
        assert (result != null) : "Parameter 'result' of method 'run' must not be null";
        ISoftwareSystemProvider provider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
        boolean resultLoaded = false;
        try {
            try {
                assert (!result.hasChildrenExcept(AnalyzerJobElement.class)) : "Analyzer result not cleared: " + this.n();
                assert (!this.l) : "Metric value added not reset: " + this.n();
                assert (!this.m) : "Metric descriptor added not reset: " + this.n();
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerResultStateChangedEvent(provider, result, AnalyzerState.RUNNING));
                this.j = this.k().a(this.b);
                boolean runJobs = true;
                if (this.b() && loadResultIfPresent) {
                    resultLoaded = this.k(result);
                    boolean bl2 = runJobs = !resultLoaded;
                }
                if (runJobs && canRun) {
                    this.a(result);
                    AnalyzerResult analyzerResult = result;
                    synchronized (analyzerResult) {
                        while (result.getNumberOfRunningJobs() > 0) {
                            result.wait();
                        }
                    }
                }
                this.v();
                this.j = null;
            }
            catch (Throwable t2) {
                this.f.a(this.k, this.g.getId(), this.l, this.m);
                AnalyzerResult analyzerResult = result;
                synchronized (analyzerResult) {
                    result.setState(AnalyzerState.CANCELLED);
                    result.notifyAll();
                }
                this.g().a("Exception in AnalyzerAdapter.run() [1] in analyzer '" + this.n().getStandardName() + "'", t2);
                a.error("Set state to CANCELLED because of exception for: " + this.n(), t2);
                this.j = null;
                return;
            }
        }
        finally {
            this.j = null;
        }
        try {
            try {
                AnalyzerState newState;
                boolean cancelled = false;
                AnalyzerResult analyzerResult = result;
                synchronized (analyzerResult) {
                    if (result.getErrorMessage() == null && canRun) {
                        for (AnalyzerJobElement node : result.getChildren(AnalyzerJobElement.class)) {
                            AnalyzerState state = node.getState();
                            if (state == AnalyzerState.FINISHED) continue;
                            cancelled = true;
                            break;
                        }
                    }
                    if (cancelled) {
                        a.debug("Set state to CANCELLED for: " + this.n() + " (not all analyzer job elements were finished)");
                        newState = AnalyzerState.CANCELLED;
                        result.setState(newState);
                    } else if (result.getErrorMessage() == null) {
                        if (canRun || resultLoaded) {
                            newState = AnalyzerState.FINISHED;
                            result.setState(newState);
                            this.g(result);
                        } else {
                            newState = AnalyzerState.INACTIVE;
                            result.setState(newState);
                        }
                    } else {
                        newState = AnalyzerState.ERROR;
                        result.setState(newState);
                        cancelled = true;
                    }
                    result.notifyAll();
                }
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerResultStateChangedEvent(provider, result, newState));
                analyzerResult = result;
                synchronized (analyzerResult) {
                    for (AnalyzerJobElement job : result.getChildren(AnalyzerJobElement.class)) {
                        job.remove();
                    }
                    if (cancelled) {
                        result.forgetChildren(true);
                        result.clear();
                    }
                }
                if (!cancelled) {
                    EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerResultAvailableEvent(provider, result, this.h != null ? this.h.b() : null));
                    if (this.h != null) {
                        this.h.a(result);
                    }
                }
            }
            catch (Throwable t3) {
                this.g().a("Exception in AnalyzerAdapter.run() [2] in analyzer '" + this.n().getStandardName() + "'", t3);
                this.a((i)null);
                this.f.a(this.k, this.g.getId(), this.l, this.m);
            }
        }
        finally {
            this.a((i)null);
            this.f.a(this.k, this.g.getId(), this.l, this.m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean a(AnalyzerResult result, i consumer, boolean loadResultIfPresent) {
        assert (result != null) : "Parameter 'result' of method 'startJobsIfNotRunning' must not be null";
        if (!this.g.getId().getExecutionLevel().matchesOrIsLowerThan(this.f.b()) || !this.r()) {
            return false;
        }
        boolean consume = false;
        boolean startJobController = false;
        AnalyzerResult analyzerResult = result;
        synchronized (analyzerResult) {
            AnalyzerState state = result.getState();
            assert (state != AnalyzerState.CANCELLED) : "Wrong state 'CANCELLED' for: " + this.n();
            if (state == AnalyzerState.HAS_NOT_BEEN_RUN) {
                SoftwareSystemMode mode = this.g().n().getMode();
                boolean canRun = this.a();
                if (canRun || mode != SoftwareSystemMode.SYSTEM) {
                    if (a.isTraceEnabled()) {
                        this.k = new Throwable();
                    }
                    Thread jobManager = new Thread(() -> this.a(loadResultIfPresent, canRun), "Manager: " + this.g.getId().getPresentationName());
                    jobManager.setUncaughtExceptionHandler(this.f);
                    startJobController = true;
                    result.setState(AnalyzerState.RUNNING);
                    this.a(consumer);
                    jobManager.start();
                } else {
                    result.setState(AnalyzerState.INACTIVE);
                    result.notifyAll();
                }
            } else if (state == AnalyzerState.RUNNING) {
                if (consumer != null) {
                    this.a(consumer);
                }
            } else if (consumer != null && state == AnalyzerState.FINISHED) {
                consume = true;
            }
        }
        if (startJobController) {
            this.f.f(this.g.getId());
        }
        if (consume) {
            assert (consumer != null);
            consumer.a(result);
        }
        return true;
    }

    protected boolean a() {
        return true;
    }

    public void s() {
        if (!this.b.isEmpty()) {
            this.k().c(this.b);
        }
    }

    protected final void a(Collection<IMetricDescriptor> metricDescriptors) {
        assert (metricDescriptors != null && !metricDescriptors.isEmpty()) : "Parameter 'metricDescriptors' of method 'remove' must not be empty";
        this.k().c(metricDescriptors);
        for (IMetricDescriptor nextMetricDescriptor : metricDescriptors) {
            boolean success = this.b.remove(nextMetricDescriptor);
            assert (success) : "'success' of method 'remove' must true";
            nextMetricDescriptor.getNamedElement().remove();
            this.d.remove(nextMetricDescriptor);
        }
    }

    public void a(com.hello2morrow.sonargraph.core.controller.system.base.i languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
    }

    public void b(com.hello2morrow.sonargraph.core.controller.system.base.i languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageRemoved' must not be null";
    }

    public final String toString() {
        return this.g.getName();
    }

    public void a(boolean baseDirectoryChanged) {
    }
}

