/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.a;

import com.hello2morrow.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.b;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.analysis.k;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.transients.AssignedElementsResult;
import com.hello2morrow.sonargraph.core.model.analysis.transients.ComponentsWithViolationsResult;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class d
extends com.hello2morrow.sonargraph.core.controller.system.analysis.base.a {
    public static final IConfigurableAnalyzerId a = CoreAnalyzerId.ARCHITECTURE_SOURCECODE_METRICS;
    private final IMetricDescriptor d;
    private final IMetricDescriptor e;
    private final IMetricDescriptor f;
    private final IMetricDescriptor g;
    private final IMetricDescriptor h;
    private final IMetricDescriptor i;
    private final IMetricDescriptor j;

    public d(g controller) {
        super(controller, a);
        MetricProvider mp = this.h().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.d = this.b(mp, CoreMetricId.CORE_VIOLATING_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.e = this.b(mp, CoreMetricId.CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.f = this.b(mp, CoreMetricId.CORE_VIOLATING_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
        this.g = this.b(mp, CoreMetricId.CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
        this.h = this.b(mp, CoreMetricId.CORE_UNASSIGNED_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.i = this.b(mp, CoreMetricId.CORE_VIOLATION_DENSITY_SOURCE_ELEMENTS, CoreMetricLevel.SYSTEM);
        this.j = this.b(mp, CoreMetricId.CORE_VIOLATION_DENSITY_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
    }

    @Override
    protected void a(AnalyzerResult result) {
        a job = new a(this.p(), result, this.g(), this.d());
        job.i();
    }

    @Override
    protected void e(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        if (result.getMetricValue(this.i(), this.d) == null) {
            throw new RestoreException("Missing expected metric value for fully analyzed lines of code.");
        }
        super.e(result);
    }

    private final class a
    extends b {
        private a(AnalyzerGroup group, AnalyzerResult result, g controller, List<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void a() {
            IMetricAccessor metricAccessor = this.d().getExtension(IMetricAccessor.class);
            int relevantLoc = this.a(metricAccessor);
            if (relevantLoc <= 0) {
                return;
            }
            AnalyzerResult architectureCheck = this.a(this.h());
            if (architectureCheck == null) {
                return;
            }
            if (!this.a(architectureCheck)) {
                return;
            }
            this.a(relevantLoc);
            this.b(relevantLoc);
            this.a(metricAccessor, relevantLoc);
        }

        private boolean a(AnalyzerResult architectureCheck) {
            Analyzer architectureAnalyzer = architectureCheck.getParent(Analyzer.class, new Class[0]);
            ArchitectureCheckConfiguration config = architectureAnalyzer.getUniqueExistingChild(ArchitectureCheckConfiguration.class);
            if (config == null) {
                return false;
            }
            return !config.getIdentifyingPaths().isEmpty();
        }

        private AnalyzerResult a(List<AnalyzerResult> results) {
            for (AnalyzerResult next : results) {
                if (next.getId() != CoreAnalyzerId.ARCHITECTURE_CHECK) continue;
                return next;
            }
            return null;
        }

        private int a(IMetricAccessor metricAccessor) {
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'computeMaximumLocCheckedByArchitecture' must not be null";
            Number fullyAnalyzedLocValue = metricAccessor.getMetricValue(this.c(), this.c(), CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED);
            if (fullyAnalyzedLocValue == null) {
                return -1;
            }
            int fullyAnalyzedLoc = fullyAnalyzedLocValue.intValue();
            Number issueIgnoringLocValue = metricAccessor.getMetricValue(this.c(), this.c(), CoreMetricId.CORE_LINES_OF_CODE_ISSUE_IGNORING);
            if (issueIgnoringLocValue == null) {
                return -1;
            }
            int issueIgnoringLoc = issueIgnoringLocValue.intValue();
            return fullyAnalyzedLoc + issueIgnoringLoc;
        }

        private void a(int issueIgnoringLoc) {
            ComponentsWithViolationsResult violatingComponentsResult = null;
            for (AnalyzerResult next : this.h()) {
                if (next.getId() != CoreAnalyzerId.ARCHITECTURE_CHECK) continue;
                violatingComponentsResult = next.getUniqueChild(ComponentsWithViolationsResult.class);
                break;
            }
            if (violatingComponentsResult == null) {
                return;
            }
            Set<IComponent> violatingComponents = violatingComponentsResult.getComponentsWithViolations();
            Set<IComponent> componentsWithDeprecations = violatingComponentsResult.getComponentsWithDeprecations();
            if (violatingComponents == null || componentsWithDeprecations == null) {
                return;
            }
            THashSet sourceFiles = new THashSet();
            THashSet sourceFilesWithViolationsOrDeprecations = new THashSet();
            for (IComponent next : violatingComponents) {
                sourceFiles.addAll(k.a(next));
            }
            componentsWithDeprecations.removeAll(violatingComponents);
            sourceFilesWithViolationsOrDeprecations.addAll(sourceFiles);
            for (IComponent next : componentsWithDeprecations) {
                sourceFilesWithViolationsOrDeprecations.addAll(k.a(next));
            }
            violatingComponentsResult.reset();
            int locOfViolatingSourceFiles = k.a((Collection<SourceFile>)sourceFiles);
            int locOfViolatingOrDeprecatedSourceFiles = k.a((Collection<SourceFile>)sourceFilesWithViolationsOrDeprecations);
            float percentageOfCodeInViolatingSources = (float)locOfViolatingSourceFiles * 100.0f / (float)issueIgnoringLoc;
            float percentageOfCodeInViolatingorDeprecayedSources = (float)locOfViolatingOrDeprecatedSourceFiles * 100.0f / (float)issueIgnoringLoc;
            d.this.a(this.getResult(), this.c(), Float.valueOf(percentageOfCodeInViolatingSources), d.this.d);
            d.this.a(this.getResult(), this.c(), Float.valueOf(percentageOfCodeInViolatingorDeprecayedSources), d.this.e);
            d.this.a(this.getResult(), this.c(), locOfViolatingSourceFiles, d.this.f);
            d.this.a(this.getResult(), this.c(), locOfViolatingOrDeprecatedSourceFiles, d.this.g);
        }

        private void b(int relevantLoc) {
            AssignedElementsResult assignedElementsResult = null;
            for (AnalyzerResult next : this.h()) {
                if (next.getId() != CoreAnalyzerId.ARCHITECTURE_CHECK) continue;
                assignedElementsResult = next.getUniqueChild(AssignedElementsResult.class);
                break;
            }
            if (assignedElementsResult == null) {
                return;
            }
            Set<NamedElement> assignedElements = assignedElementsResult.getAssignedElements();
            if (assignedElements == null) {
                return;
            }
            THashSet sourceFiles = new THashSet();
            for (NamedElement next : assignedElements) {
                NamedElement element;
                if (next instanceof AssignedElement) {
                    AssignedElement assigned = (AssignedElement)next;
                    element = assigned.getRepresentedElement();
                } else {
                    element = next;
                }
                if (element.isExternal()) continue;
                sourceFiles.addAll(k.a(element));
            }
            assignedElementsResult.reset();
            int assignedLoc = k.a((Collection<SourceFile>)sourceFiles);
            int unassignedLoc = relevantLoc - assignedLoc;
            float percentageOfUnassignedLoc = (float)unassignedLoc * 100.0f / (float)relevantLoc;
            d.this.a(this.getResult(), this.c(), Float.valueOf(percentageOfUnassignedLoc), d.this.h);
        }

        private void a(IMetricAccessor metricAccessor, int relevantLoc) {
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'computeViolationDensity' must not be null";
            Number sourceElementCountValue = metricAccessor.getMetricValue(this.c(), this.c(), CoreMetricId.CORE_SOURCE_ELEMENT_COUNT);
            if (sourceElementCountValue == null) {
                return;
            }
            int sourceElementCount = sourceElementCountValue.intValue();
            assert (sourceElementCount > 0) : "SourceElementCount for System must be > 0, but was " + sourceElementCount;
            Number violationCountValue = metricAccessor.getMetricValue(this.c(), this.c(), CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES);
            if (violationCountValue == null) {
                return;
            }
            int violationCount = violationCountValue.intValue();
            assert (violationCount >= 0) : "Violation count for System must be >= 0, but was " + violationCount;
            float violationDensitySourceElements = (float)violationCount * 1000.0f / (float)sourceElementCount;
            d.this.a(this.getResult(), this.c(), Float.valueOf(violationDensitySourceElements), d.this.i);
            float violationDensityLoc = (float)violationCount * 1000.0f / (float)relevantLoc;
            d.this.a(this.getResult(), this.c(), Float.valueOf(violationDensityLoc), d.this.j);
        }
    }
}

