/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.model.architecture.ArtifactNameUtility;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class al {
    private al() {
    }

    static String a() {
        StringBuilder sb = new StringBuilder();
        sb.append("// Press F1 to get detailed help about Sonargraph's architecture DSL.\n");
        sb.append("//\n");
        sb.append("// To enable architecture checking on this file please right click on it in\n");
        sb.append("// the architecture view or files view and select 'Add to Architecture Check'.\n");
        sb.append("//\n");
        return sb.toString();
    }

    static String a(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'generate' must not be null";
        StringBuilder sb = new StringBuilder();
        sb.append(al.a());
        sb.append("// The allowed dependencies (connect statements) are based on your workspace\n");
        sb.append("// dependencies which can be visualized by opening the workspace dependencies\n");
        sb.append("// view. If you get \"Missing workspace dependency\" warnings in the issues view you\n");
        sb.append("// will also get architecture violations. To remedy this problem you have to add\n");
        sb.append("// the allowed connections to the artifacts causing the violations. The best way\n");
        sb.append("// to inspect architecture violations is to use the architecture view and select the\n");
        sb.append("// architecture file of interest. You can also add the missing workspace dependencies\n");
        sb.append("// in the workspace dependencies view and then re-generate this architecture.\n");
        sb.append("//\n");
        sb.append("// You can now enhance this initial architecture by fleshing out the internal structure of\n");
        sb.append("// your modules. Please make sure to read our documentation about the architecture DSL (F1) so\n");
        sb.append("// that you get a better idea how you can create a concise and elegant architectural blueprint\n");
        sb.append("// for your application.\n");
        List<Module> modules = softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class);
        ArrayList<Module> sortedModules = new ArrayList<Module>();
        for (Module mod : modules) {
            boolean inserted = false;
            int i2 = 0;
            while (i2 < sortedModules.size()) {
                if (mod.canAccess((IWorkspaceDependencyElement)sortedModules.get(i2))) {
                    sortedModules.add(i2, mod);
                    inserted = true;
                    break;
                }
                ++i2;
            }
            if (inserted) continue;
            sortedModules.add(mod);
        }
        sortedModules.forEach(m2 -> al.a(m2, sb));
        return sb.toString();
    }

    private static String a(String moduleName) {
        StringBuilder artifactName = new StringBuilder();
        int i2 = 0;
        while (i2 < moduleName.length()) {
            char c2 = moduleName.charAt(i2);
            switch (c2) {
                case ' ': 
                case '$': 
                case '.': 
                case ':': 
                case '@': {
                    artifactName.append('_');
                    break;
                }
                case '+': {
                    artifactName.append("Plus");
                    break;
                }
                case '#': {
                    artifactName.append("Sharp");
                    break;
                }
                default: {
                    if (Character.isJavaIdentifierStart(c2) || i2 > 0 && Character.isJavaIdentifierPart(c2) || c2 == '-') {
                        artifactName.append(c2);
                        break;
                    }
                    char val = c2;
                    artifactName.append(String.format("%04X", val));
                }
            }
            ++i2;
        }
        return artifactName.toString();
    }

    private static void a(Module m2, StringBuilder sb) {
        assert (m2 != null) : "Parameter 'm' of method 'generateModuleArtifact' must not be null";
        assert (sb != null) : "Parameter 'sb' of method 'generateModuleArtifact' must not be null";
        sb.append('\n');
        sb.append("artifact ").append(al.a(ArtifactNameUtility.createValidName(m2.getName()))).append('\n');
        sb.append("{\n");
        sb.append("    include \"").append(m2.getName()).append("/**\"\n");
        List deps = m2.getOutgoingWorkspaceDependencies().stream().filter(dep -> dep.getTo().isModule()).collect(Collectors.toList());
        if (!deps.isEmpty()) {
            sb.append('\n');
            String sep = "    connect to ";
            for (WorkspaceDependency dep2 : deps) {
                sb.append(sep);
                sep = ", ";
                sb.append(al.a(dep2.getToName()));
            }
            sb.append('\n');
        }
        sb.append("}\n");
    }
}

