/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.BackgroundTaskException;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ak {
    private static final Logger b = LoggerFactory.getLogger(ak.class);

    private ak() {
    }

    static void a(SoftwareSystem system, boolean parserModelChanged) {
        assert (system != null) : "Parameter 'system' of method 'validate' must not be null";
        if (b.isDebugEnabled()) {
            long start = System.currentTimeMillis();
            b.debug("Validate system '" + system.getName() + "' [" + system.getAbsolutePath() + "]");
            int numberOfErrors = 0;
            b.debug("Validate virtual models");
            List<ParserModel> parserModels = system.getUniqueExistingChild(Files.class).getVirtualModels().getChildrenRecursively(ParserModel.class, new Class[0]);
            VirtualModel activeProductionModel = null;
            if (parserModels.size() != 1) {
                b.error("Exactly 1 parser model expected");
                ++numberOfErrors;
            } else {
                activeProductionModel = parserModels.get(0).getActiveProductionModel();
            }
            List<ModifiableModel> modifiableModels = system.getUniqueExistingChild(Files.class).getVirtualModels().getChildrenRecursively(ModifiableModel.class, new Class[0]);
            boolean activeProductionModelFound = false;
            for (ModifiableModel nextModifiableModel : modifiableModels) {
                if (activeProductionModel == nextModifiableModel) {
                    activeProductionModelFound = true;
                }
                if (!nextModifiableModel.needsApplication()) continue;
                b.error("Modifiable model '" + nextModifiableModel.getIdentifyingPath() + "' still needs application");
                ++numberOfErrors;
            }
            if (activeProductionModel != null && !activeProductionModelFound) {
                b.error("Active production model not set in parser model");
                ++numberOfErrors;
            }
            b.debug("Validate virtual models - done: " + numberOfErrors + " validation error(s)");
            TreeMap<String, Integer> categoryCollector = null;
            if (parserModelChanged) {
                categoryCollector = new TreeMap<String, Integer>();
                b.debug("Validate parser model");
                c parserModelCheck = new c(categoryCollector, system.getExtension(ISoftwareSystemProvider.class).getElementResolver());
                for (NamedElement namedElement : system.getUniqueExistingChild(Workspace.class).getChildren(ComponentContainer.class)) {
                    b.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]'");
                    namedElement.accept(parserModelCheck);
                    b.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]' - done");
                }
                b.debug("Validate parser model - done " + (numberOfErrors += parserModelCheck.b()) + " validation error(s)");
                b.debug("Validate logical model");
                a a2 = new a(categoryCollector);
                for (NamedElement namedElement : system.getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(LogicalRoot.class)) {
                    b.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]'");
                    namedElement.accept(a2);
                    b.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]' - done: " + numberOfErrors + " validation error(s)");
                }
                numberOfErrors += a2.b();
                a2.a();
                for (NamedElement namedElement : system.getUniqueExistingChild(LogicalSystemNamespaces.class).getChildren(LogicalRoot.class)) {
                    b.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]'");
                    namedElement.accept(a2);
                    b.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]' - done: " + numberOfErrors + " validation error(s)");
                }
                b.debug("Validate logical model - done: " + (numberOfErrors += a2.b()) + " validation error(s)");
            }
            b.debug("Validate system '" + system.getName() + "' [" + system.getAbsolutePath() + "] - done in " + (System.currentTimeMillis() - start) + " ms (" + numberOfErrors + " error(s))");
            if (categoryCollector != null) {
                for (Map.Entry nextEntry : categoryCollector.entrySet()) {
                    b.debug((String)nextEntry.getKey() + ": " + nextEntry.getValue());
                }
            }
            if (numberOfErrors > 0 && b.isTraceEnabled()) {
                EventManager.getInstance().dispatch((Object)system, (Event)new ExceptionEvent(system.getExtension(ISoftwareSystemProvider.class), new BackgroundTaskException("There are " + numberOfErrors + " validation error(s)")));
            }
        }
    }

    private static final class a
    extends b {
        private final Map<ProgrammingElement, LogicalProgrammingElement> c = new THashMap();

        a(Map<String, Integer> categoryCollector) {
            super(categoryCollector);
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
            for (NamedElement namedElement : element.getAllChildren()) {
                namedElement.accept(this);
                if (this.done()) break;
            }
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            block6: {
                block4: {
                    List<ProgrammingElement> list;
                    block5: {
                        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
                        if (!(element instanceof LogicalNamespace)) break block4;
                        list = ((LogicalNamespace)element).getProgrammingElements();
                        if (!((LogicalNamespace)element).isPart()) break block5;
                        if (!list.isEmpty()) {
                            b.error("Logical part namespace contains " + list.size() + " programming elements: " + element.getFullyQualifiedName() + " [" + element.getClass().getName() + "]");
                            this.a("Logical part namespace contains programming elements");
                        }
                        break block6;
                    }
                    if (!list.isEmpty()) break block6;
                    b.error("Logical non-part namespace contains no programming elements: " + element.getFullyQualifiedName() + " [" + element.getClass().getName() + "]");
                    this.a("Logical non-part namespace contains no programming elements");
                    break block6;
                }
                if (element instanceof LogicalProgrammingElement) {
                    for (ProgrammingElement programmingElement : ((LogicalProgrammingElement)element).getLogicalGroup()) {
                        LogicalProgrammingElement previous = this.c.put(programmingElement, (LogicalProgrammingElement)element);
                        if (previous == null || previous == element) continue;
                        b.error("Duplicate logical assignment [" + programmingElement.getClass().getName() + "]\n PE: " + programmingElement.getFullyQualifiedName() + "\n MAPPED TO: " + previous + "\n MAPPED TO: " + element);
                        this.a("Duplicate logical assignment");
                    }
                }
            }
            this.visitChildrenOf(element);
        }

        @Override
        void a() {
            super.a();
            this.c.clear();
        }
    }

    private static abstract class b
    extends NamedElementVisitor {
        private final Map<String, Integer> a;
        private int c;

        b(Map<String, Integer> categoryCollector) {
            assert (categoryCollector != null) : "Parameter 'categoryCollector' of method 'ModelCheck' must not be null";
            this.a = categoryCollector;
        }

        protected final void a(String category) {
            assert (category != null && category.length() > 0) : "Parameter 'category' of method 'addError' must not be empty";
            Integer number = this.a.get(category);
            if (number == null) {
                this.a.put(category, 1);
            } else {
                this.a.put(category, number + 1);
            }
            ++this.c;
        }

        final int b() {
            return this.c;
        }

        void a() {
            this.c = 0;
        }
    }

    private static final class c
    extends b {
        private final Set<ProgrammingElement> c = new THashSet();
        private final Set<String> d = new THashSet();
        private final Set<String> e = new THashSet();
        private final IElementResolver f;

        c(Map<String, Integer> categoryCollector, IElementResolver resolver) {
            super(categoryCollector);
            assert (resolver != null) : "Parameter 'resolver' of method 'ParserModelCheck' must not be null";
            this.f = resolver;
        }

        private void a(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'checkDependencies' must not be null";
            List<ParserDependency> outgoingDependencies = element.getOutgoingDependencies(new IParserDependencyType[0]);
            if (element.isGhost() && !outgoingDependencies.isEmpty()) {
                b.error("Ghost programming element " + element + " has " + outgoingDependencies.size() + " outgoing dependencies");
                for (ParserDependency next : outgoingDependencies) {
                    b.error(next.toString());
                    this.a("Ghost programming element has outgoing dependencies");
                }
            }
            for (ParserDependency nextOut : outgoingDependencies) {
                ProgrammingElement nextTo = nextOut.getTo();
                if (nextTo == null) {
                    b.error("'to' of outgoing dependency is 'null' for: " + nextOut);
                    this.a("'to' of outgoing dependency is 'null'");
                } else if (nextTo.getParent() == null) {
                    b.error("'to' of outgoing dependency has no parent for :" + nextOut);
                    this.a("'to' of outgoing dependency has no parent");
                } else if (nextTo.isGhost()) {
                    b.error("'to' is ghost programming element - outgoing dependency: " + nextOut);
                    this.a("'to' is ghost programming element - outgoing dependency");
                }
                String nextDescriptor = this.f.getDescriptor(nextOut);
                if (this.d.add(nextDescriptor)) continue;
                b.error("Outgoing dependency descriptor '" + nextDescriptor + "' not unique for: " + nextOut);
                this.a("Outgoing dependency descriptor not unique");
            }
            List<ParserDependency> incomingDependencies = element.getIncomingDependencies(new IStandardEnumeration[0]);
            if (element.isGhost() && !incomingDependencies.isEmpty()) {
                b.error("Ghost programming element " + element + " has " + incomingDependencies.size() + " incoming dependencies");
                for (ParserDependency next : incomingDependencies) {
                    b.error(next.toString());
                    this.a("Ghost programming element has incoming dependencies");
                }
            }
            for (ParserDependency nextIn : incomingDependencies) {
                ProgrammingElement nextFrom = nextIn.getFrom();
                if (nextFrom == null) {
                    b.error("'from' of incoming dependency is 'null' for: " + nextIn);
                    this.a("'from' of incoming dependency is 'null'");
                    continue;
                }
                if (nextFrom.getParent() == null) {
                    b.error("'from' of incoming dependency has no parent for :" + nextIn);
                    this.a("'from' of incoming dependency has no parent");
                    continue;
                }
                if (!nextFrom.isGhost()) continue;
                b.error("'from' is ghost programming element - incoming dependency: " + nextIn);
                this.a("'from' is ghost programming element - incoming dependency");
            }
            this.d.clear();
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            if (!element.isValid()) {
                b.error("Named element is not valid: " + element);
                this.a("Named element is not valid");
            } else {
                String descriptor;
                String fqNamePart;
                if (element instanceof ProgrammingElement) {
                    ProgrammingElement programmingElement = (ProgrammingElement)element;
                    if (!this.c.add(programmingElement)) {
                        b.error("Programming element has duplicate FQName: " + programmingElement);
                        this.a((String)null);
                    }
                    if (programmingElement.getParent() == null) {
                        b.error("Programming element has no parent: " + programmingElement);
                        this.a("Programming element has no parent");
                    }
                    this.a(programmingElement);
                    Language language = programmingElement.getLanguage();
                    if (language == null) {
                        b.error("Programming element has no language: " + programmingElement);
                        this.a("Programming element has no language");
                    }
                }
                if ((fqNamePart = element.getFullyQualifiedNamePart()) == null || fqNamePart.isEmpty()) {
                    b.error("Fully qualified name part is empty for: " + element);
                    this.a("Fully qualified name part is empty");
                }
                if ((descriptor = this.f.getDescriptor(element)) == null || descriptor.isEmpty()) {
                    b.error("Descriptor is empty for: " + element);
                    this.a("Descriptor is empty");
                } else {
                    Element element2 = this.f.resolve(descriptor);
                    if (element2 == null) {
                        b.error("Unable to resolve element with descriptor '" + descriptor + "' for : " + element);
                        this.a("Unable to resolve element");
                    } else if (element != element2) {
                        b.error("Different element resolved with descriptor '" + descriptor + "'\nElement:\n" + element.getDebugInfo() + "\nResolved:\n" + element2.getDebugInfo());
                        this.a("Different element resolved");
                    }
                }
                for (NamedElement namedElement : element.getAllChildren()) {
                    String nextFqNamePart = namedElement.getFullyQualifiedNamePart();
                    if (this.e.add(nextFqNamePart)) continue;
                    b.error("Fully qualified name part '" + nextFqNamePart + "' not unique for: " + namedElement);
                    this.a("Fully qualified name part not unique");
                }
                this.e.clear();
                this.visitChildrenOf(element);
            }
        }
    }
}

