/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.controller.system.diff.m;
import com.hello2morrow.sonargraph.core.controller.system.graphview.h;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardFilePathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.system.BaselinesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.diff.Baseline;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfigurationIssue;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffDefaultBaselineUsedIssue;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.persistence.diff.BaselineReader;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class aX
extends Extension
implements h,
ISystemDiffProvider {
    private static final Logger a = LoggerFactory.getLogger(aX.class);
    protected static final String b = "localBaselinePath";
    protected static final String c = "useLocalBaseline";
    private final SoftwareSystem e;

    protected aX(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SystemDiffProvider' must not be null";
        this.e = softwareSystem;
    }

    @Override
    public IPathValidator getBaselineValidator() {
        return new a();
    }

    protected final SoftwareSystem b() {
        return this.e;
    }

    @Override
    public String getBaselineFileNameProposal() {
        return String.valueOf(this.e.getName()) + "_" + Iso8601DateFormat.formatDateAndTimeForFileName((Date)new Date());
    }

    @Override
    public OperationResultWithOutcome<BaselineInfo> getBaselineInfo(TFile baselineReport) {
        if (baselineReport == null) {
            return null;
        }
        try {
            return new BaselineReader().read(baselineReport);
        }
        catch (Exception e2) {
            OperationResultWithOutcome result = new OperationResultWithOutcome("Reading info for baseline " + baselineReport.getPath());
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e2);
            return result;
        }
    }

    @Override
    public BaselinesDirectory getBaselinesDirectory() {
        return this.e.getUniqueExistingChild(Files.class).getUniqueExistingChild(SoftwareSystemBaseDirectory.class).getUniqueExistingChild(SoftwareSystemDirectory.class).getUniqueExistingChild(BaselinesDirectory.class);
    }

    @Override
    public IDiffElement getFirstDiffElement(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getDiffElements' must not be null";
        if (!this.isSystemDiffActive()) {
            return null;
        }
        SoftwareSystemDiff softwareSystemDiff = this.getSoftwareSystemDiff();
        if (softwareSystemDiff == null) {
            return null;
        }
        for (Element next : elements) {
            Element toMatch = next instanceof IssueRank ? ((IssueRank)next).getRankedElement() : next;
            IDiffElement diff = m.a(softwareSystemDiff, toMatch);
            if (diff == null) continue;
            return diff;
        }
        return null;
    }

    @Override
    public Set<NamedElement> a(List<CycleGroup> cycleGroups) {
        assert (cycleGroups != null) : "Parameter 'cycleGroups' of method 'getAddedCyclicElements' must not be null";
        if (!cycleGroups.isEmpty() && this.isSystemDiffActive()) {
            THashSet namedElements = new THashSet();
            for (CycleGroup nextCycleGroup : cycleGroups) {
                IDiffElement diffElement = this.getFirstDiffElement(Collections.singletonList(nextCycleGroup));
                if (diffElement == null) continue;
                assert (diffElement instanceof CycleGroupIssueDiff) : "Wrong diff element type: " + diffElement.getClass().getCanonicalName();
                CycleGroupIssueDiff cycleDiff = (CycleGroupIssueDiff)diffElement;
                if (diffElement.getChange() == IDiffElement.Change.ADDED) {
                    namedElements.addAll(cycleDiff.getChildren(CyclicElementDiff.class).stream().map(e2 -> (NamedElement)e2.getCurrent()).collect(Collectors.toSet()));
                    continue;
                }
                namedElements.addAll(cycleDiff.getChildren(CyclicElementDiff.class).stream().filter(e2 -> e2.getChange() == IDiffElement.Change.ADDED).map(e2 -> (NamedElement)e2.getCurrent()).collect(Collectors.toSet()));
            }
            return Collections.unmodifiableSet(namedElements);
        }
        return Collections.emptySet();
    }

    protected SystemDiffAnalyzerConfiguration c() {
        g analyzerExtension = this.b().getExtension(g.class);
        AnalyzerConfiguration config = analyzerExtension.b(CoreAnalyzerId.SYSTEM_DIFF);
        assert (config != null && config instanceof SystemDiffAnalyzerConfiguration) : "Unexpected class in method 'setBaseline': " + config;
        return (SystemDiffAnalyzerConfiguration)config;
    }

    @Override
    public String createDiffFileName(String mainReportFileName, Date timestamp) {
        assert (timestamp != null) : "Parameter 'timestamp' of method 'createDiffFileName' must not be null";
        return mainReportFileName != null && mainReportFileName.trim().length() > 0 ? String.valueOf(mainReportFileName) + "_diff" : this.a(timestamp);
    }

    protected String a(Date timestamp) {
        return String.valueOf(this.b().getName()) + "_diff_" + Iso8601DateFormat.formatDateAndTimeForFileName((Date)timestamp);
    }

    protected final StrictPair<TFile, BaselineType> d() {
        Properties systemProperties = this.b().getSystemProperties();
        String enabledLocalBaselineValue = this.b().getSystemProperty(c);
        if (enabledLocalBaselineValue != null && Boolean.valueOf(enabledLocalBaselineValue).booleanValue()) {
            String localBaselineValue = systemProperties.getProperty(b);
            if (localBaselineValue == null || localBaselineValue.trim().isEmpty()) {
                a.error("Local baseline is activated but no path is found");
                return null;
            }
            return new StrictPair((Object)new TFile(localBaselineValue), (Object)BaselineType.LOCAL);
        }
        TFile systemBaseline = this.e();
        if (systemBaseline == null) {
            return null;
        }
        return new StrictPair((Object)systemBaseline, (Object)BaselineType.SYSTEM);
    }

    protected final TFile e() {
        TFile baseline;
        g analyzerExtension = this.b().getExtension(g.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = analyzerExtension.a(CoreAnalyzerId.SYSTEM_DIFF);
        if (analyzerConfigurationFile == null) {
            return null;
        }
        analyzerConfigurationFile.removeIssues();
        AnalyzerConfiguration configuration = analyzerExtension.b(CoreAnalyzerId.SYSTEM_DIFF);
        assert (configuration != null) : "Configuration must not be null";
        assert (configuration instanceof SystemDiffAnalyzerConfiguration) : "Unexpected class in method 'checkConfiguration': " + configuration;
        SystemDiffAnalyzerConfiguration diffConfiguration = (SystemDiffAnalyzerConfiguration)configuration;
        diffConfiguration.resetWarnings();
        String baselinePath = diffConfiguration.getBaselinePath();
        if (baselinePath == null || baselinePath.isEmpty()) {
            if (diffConfiguration.isEnabled()) {
                analyzerConfigurationFile.addIssue(new SystemDiffConfigurationIssue(analyzerConfigurationFile, "Missing baseline path"));
            }
            return null;
        }
        SoftwareSystemMode mode = this.b().getMode();
        switch (mode) {
            case SYSTEM: 
            case SYSTEM_ATTACHED_TO_SNAPSHOT: {
                baseline = aX.b(this.b(), baselinePath);
                break;
            }
            case SYSTEM_LOADED_FROM_SNAPSHOT: 
            case SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT: {
                StrictPair<TFile, String> fileAndPath = this.a(this.b(), baselinePath);
                baseline = (TFile)fileAndPath.getFirst();
                String defaultBaselinePath = (String)fileAndPath.getSecond();
                if (!baseline.exists() || !diffConfiguration.isEnabled()) break;
                analyzerConfigurationFile.addIssue(new SystemDiffDefaultBaselineUsedIssue(analyzerConfigurationFile, "Ignored configured baseline '" + baselinePath + "', using baseline '" + defaultBaselinePath + "' instead."));
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + (Object)((Object)mode);
                return null;
            }
        }
        if (!baseline.exists()) {
            analyzerConfigurationFile.addIssue(new SystemDiffConfigurationIssue(analyzerConfigurationFile, "Baseline '" + baseline.getAbsolutePath() + "' not found."));
            return null;
        }
        if (!baseline.canRead()) {
            analyzerConfigurationFile.addIssue(new SystemDiffConfigurationIssue(analyzerConfigurationFile, "Baseline '" + baseline.getAbsolutePath() + "' cannot be read."));
            switch (mode) {
                case SYSTEM: 
                case SYSTEM_ATTACHED_TO_SNAPSHOT: {
                    diffConfiguration.setWarning(baselinePath, "Baseline cannot be read.");
                    break;
                }
                case SYSTEM_LOADED_FROM_SNAPSHOT: 
                case SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled mode: " + (Object)((Object)mode);
                    break;
                }
            }
            return null;
        }
        return baseline;
    }

    private StrictPair<TFile, String> a(SoftwareSystem softwareSystem, String baselinePath) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getBaselineFromSystemBaseDirectory' must not be null";
        assert (baselinePath != null && baselinePath.length() > 0) : "Parameter 'baselinePath' of method 'getBaselineFromSystemBaseDirectory' must not be empty";
        SoftwareSystemBaseDirectory baseDirectory = softwareSystem.getUniqueExistingChild(Files.class).getUniqueExistingChild(SoftwareSystemBaseDirectory.class);
        List parts = FileUtility.getPathParts((String)baselinePath);
        String fileName = (String)parts.get(parts.size() - 1);
        TFile defaultBaseline = new TFile((File)baseDirectory.getDirectoryFile(), fileName);
        String path = FileUtility.calculateRelativePath((TFile)defaultBaseline, (TFile)softwareSystem.getSystemDirectoryFile());
        return new StrictPair((Object)defaultBaseline, (Object)path);
    }

    private static TFile b(SoftwareSystem softwareSystem, String baselineReportPath) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getBaselineReportFile' must not be null";
        assert (baselineReportPath != null && baselineReportPath.length() > 0) : "Parameter 'baselineReportPath' of method 'getBaselineReportFile' must not be empty";
        TFile baselineReport = FileUtility.isRelativePath((String)baselineReportPath) ? new TFile((File)softwareSystem.getSystemDirectoryFile(), baselineReportPath).getNormalizedAbsoluteFile() : new TFile(baselineReportPath);
        return baselineReport;
    }

    @Override
    public SoftwareSystemDiff getSoftwareSystemDiff() {
        c analyzerExtension = this.b().getExtension(c.class);
        AnalyzerResult result = analyzerExtension.d((IAnalyzerId)CoreAnalyzerId.SYSTEM_DIFF);
        if (result == null) {
            return null;
        }
        return result.getUniqueChild(SoftwareSystemDiff.class);
    }

    protected final boolean f() {
        return this.b().getExtension(ISoftwareSystemProvider.class).getAnalyzerExecutionLevel() == CoreAnalyzerId.SYSTEM_DIFF.getExecutionLevel();
    }

    @Override
    public final boolean isDiffConfigurationEnabled() {
        return this.getDiffConfiguration().isActive();
    }

    @Override
    public boolean isLicensedAndEnabled() {
        g analyzerExtension = this.b().getExtension(g.class);
        return analyzerExtension.e(CoreAnalyzerId.SYSTEM_DIFF) && this.isDiffConfigurationEnabled();
    }

    @Override
    public boolean isSystemDiffActive() {
        ISoftwareSystemProvider systemProvider = this.b().getExtension(ISoftwareSystemProvider.class);
        return systemProvider.getAnalyzerExecutionLevel() == AnalyzerExecutionLevel.FULL && this.isLicensedAndEnabled();
    }

    @Override
    public List<Issue> getSystemDiffErrorIssues() {
        return this.g().getIssues(CoreIssueId.SYSTEM_DIFF_BASELINE_PROCESSING);
    }

    protected AnalyzerConfigurationFile g() {
        g analyzerExtension = this.b().getExtension(g.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = analyzerExtension.a(CoreAnalyzerId.SYSTEM_DIFF);
        return analyzerConfigurationFile;
    }

    @Override
    public MetricValueDiff getMetricDiff(SoftwareSystemDiff systemDiff, IMetricDescriptor metricDescriptor) {
        assert (systemDiff != null) : "Parameter 'systemDiff' of method 'getMetricDiff' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getMetricDiff' must not be null";
        MetricsDiff metricsDiff = systemDiff.getUniqueChild(MetricsDiff.class);
        if (metricsDiff == null) {
            return null;
        }
        if (metricDescriptor.getLevel() != CoreMetricLevel.SYSTEM) {
            return null;
        }
        for (MetricValueDiff next : metricsDiff.getChildren(MetricValueDiff.class)) {
            if (next.getCurrent() == null || ((IMetricValue)next.getCurrent()).getMetricDescriptor() != metricDescriptor) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean mayBeActivated(List<Element> selected) {
        if (selected == null || selected.size() != 1) {
            return false;
        }
        if (selected.get(0) instanceof Baseline) {
            Baseline baseline = (Baseline)selected.get(0);
            return !FileUtility.areEqual((TFile)this.getActiveBaseline(), (TFile)baseline.getFile());
        }
        return false;
    }

    @Override
    public boolean mayBeDeactivated(List<Element> selected) {
        if (selected == null || selected.size() != 1) {
            return false;
        }
        if (selected.get(0) instanceof Baseline) {
            Baseline baseline = (Baseline)selected.get(0);
            return FileUtility.areEqual((TFile)this.getActiveBaseline(), (TFile)baseline.getFile());
        }
        return false;
    }

    @Override
    public Pair<String, TFile> getActiveBaselineInfo() {
        TFile baseline = this.i();
        if (baseline == null) {
            return new Pair((Object)"Inactive", null);
        }
        StringBuilder info = new StringBuilder();
        info.append(baseline.getName());
        boolean systemDiffActive = this.isSystemDiffActive();
        info.append(systemDiffActive ? " (active)" : " (inactive)");
        return new Pair((Object)info.toString(), (Object)baseline);
    }

    private TFile i() {
        TFile baseline = this.getActiveBaseline();
        if (baseline != null) {
            return baseline;
        }
        ISystemDiffProvider.DiffConfiguration configuration = this.getDiffConfiguration();
        if (configuration.getType() == BaselineType.SYSTEM) {
            return configuration.getSystemBaseline();
        }
        return configuration.getLocalBaseline();
    }

    private static class a
    extends StandardFilePathValidator {
        public a() {
            super(CoreFileType.REPORT_XML, true, false);
        }

        @Override
        public ValidationResult isValid(TFile currentInput, TFile newInput) {
            ValidationResult result = super.isValid(currentInput, newInput);
            if (result.isFailure()) {
                return result;
            }
            try {
                BaselineReader reader = new BaselineReader();
                OperationResultWithOutcome<BaselineInfo> readResult = reader.read(newInput);
                if (readResult.isFailure()) {
                    result.addError("Invalid baseline");
                }
            }
            catch (Exception e2) {
                result.addError("Failed to process baseline");
            }
            return result;
        }
    }
}

