/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aR;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.ar;
import com.hello2morrow.sonargraph.core.controller.system.base.b;
import com.hello2morrow.sonargraph.core.controller.system.bi;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.history.FileHistoryOperation;
import com.hello2morrow.sonargraph.core.foundation.common.history.ModifiableFileHistory;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemFileEntry;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemFileHistory;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionContext;
import com.hello2morrow.sonargraph.core.persistence.system.XmlSystemPersistenceProvider;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class aV
extends b {
    private final SoftwareSystem c;
    private final aa d;
    private final ar e;
    private SoftwareSystemFileHistory f;

    public aV(SoftwareSystem system, aa languageProviderAccessor, ar persistenceAccessor) {
        assert (system != null) : "Parameter 'system' of method 'SoftwareSystemUndoRedoProvider' must not be null";
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'SoftwareSystemUndoRedoProvider' must not be null";
        assert (persistenceAccessor != null) : "Parameter 'persistenceAccessor' of method 'SoftwareSystemUndoRedoProvider' must not be null";
        this.c = system;
        this.d = languageProviderAccessor;
        this.e = persistenceAccessor;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(SoftwareSystemFile.class);
    }

    @Override
    public AnalyzerExecutionInfo getAnalyzerExecutionInfo(String identifyingPath, RestoreStateDto restoreDto) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerExecutionInfo' must not be empty";
        return AnalyzerExecutionInfo.all();
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream stream, OperationResult result) {
        assert (file instanceof SoftwareSystemFile) : "Unexpected class: " + file.getClass().getName();
        assert (stream != null) : "Parameter 'stream' of method 'writeContentToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        try {
            this.e.a(this.d.c()).writeToStream(this.c, this.c.getClassLoader(), stream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    public OperationResultWithOutcome<SoftwareSystemFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        OperationResultWithOutcome restoreResult = new OperationResultWithOutcome("Restore software system");
        XmlSystemPersistenceProvider persistence = this.e.a(this.d.c());
        OperationResultWithOutcome<SoftwareSystem> result = persistence.readFromStream(this.c, inputStream, dto.getModifiableFilePath());
        if (result.isFailure()) {
            restoreResult.addMessagesFrom(result);
            return restoreResult;
        }
        boolean previousClearable = this.c.isClearable();
        Set<Language> previousLanguages = this.c.getUsedLanguages();
        SoftwareSystem system = (SoftwareSystem)result.getOutcome();
        assert (system.getName().equals(this.c.getName())) : "Rename of system not supported by history";
        Installation installation = this.c.getExtension(ISoftwareSystemProvider.class).getInstallation();
        for (Z nextLp : this.d.a(system.getUsedLanguages())) {
            nextLp.a(installation, system, (OperationResult)restoreResult, true);
        }
        ModifiableModel modifiableModel = this.c.getExtension(bi.class).a();
        aR transferExtension = this.c.getExtension(aR.class);
        determinedModifications.addAll(transferExtension.b(this.d, system, this.c));
        this.c.getExtensions().forEach(e2 -> e2.finishSoftwareSystemInitializationInRestore((OperationResult)result));
        bi workspaceExtension = this.c.getExtension(bi.class);
        if (!previousLanguages.equals(this.c.getUsedLanguages())) {
            determinedModifications.add(Modification.AVAILABLE_LANGUAGES_MODIFIED);
            HashSet<Language> added = new HashSet<Language>(this.c.getUsedLanguages());
            added.removeAll(previousLanguages);
            HashSet<Language> removed = new HashSet<Language>(previousLanguages);
            removed.removeAll(this.c.getUsedLanguages());
            workspaceExtension.a((Set<Language>)added, (Set<Language>)removed, (OperationResult)result);
        }
        this.c.consumeNeedsReparseModification();
        system.remove();
        SoftwareSystemFileEntry currentEntry = (SoftwareSystemFileEntry)dto.getCurrentStateFileEntry();
        if (currentEntry.getNeedsReparseState()) {
            bi.a(this.c, (OperationResult)restoreResult);
        } else {
            this.c.setNeedsReparse(false);
        }
        this.c.consumeNeedsReparseModification();
        boolean modelLoaded = workspaceExtension.g();
        if (!modelLoaded) {
            if (previousClearable) {
                determinedModifications.add(Modification.WORKSPACE_CLEARED);
            }
            this.d.a(this.c.getUsedLanguages()).forEach(lp -> lp.c(this.c, false));
            this.c.setState(SoftwareSystemState.OPENED);
            workspaceExtension.c_(determinedModifications);
        }
        this.c.setIsClearable(modelLoaded);
        if (modifiableModel != null) {
            this.c.getExtension(bi.class).a(modifiableModel, determinedModifications);
        }
        restoreResult.setOutcome((Object)this.c.getUniqueExistingChild(Files.class).getSoftwareSystemFile());
        return restoreResult;
    }

    @Override
    public void updateState(IModifiableFile file, ModifiableFileHistory.FileHistoryEntry entry, boolean invalidatesParserModel) {
        assert (file != null) : "Parameter 'file' of method 'updateState' must not be null";
        assert (file instanceof SoftwareSystemFile) : "Unexpected class: " + file.getClass().getName();
        assert (file == this.c.getUniqueExistingChild(Files.class).getSoftwareSystemFile()) : "file must be identical to softwareSystemFile";
        assert (entry != null) : "Parameter 'entry' of method 'updateState' must not be null";
        assert (entry instanceof SoftwareSystemFileEntry) : "Unexpected class: " + entry.getClass().getName();
        super.updateState(file, entry, invalidatesParserModel);
        SoftwareSystemFileEntry systemEntry = (SoftwareSystemFileEntry)entry;
        systemEntry.setNeedsReparseState(this.c.needsReparse(), true, invalidatesParserModel);
    }

    @Override
    public ModifiableFileHistory createFileHistory(String name, String fileId) {
        this.f = new SoftwareSystemFileHistory(name, fileId);
        return this.f;
    }

    @Override
    public List<ModifiableFileHistory.FileHistoryEntry> createEntry(TransactionContext context, IModifiableFile historyFile, ModifiableFileHistory history, boolean needsSave, TFile stateFile) {
        assert (context != null) : "Parameter 'context' of method 'createEntry' must not be null";
        assert (historyFile != null) : "Parameter 'historyFile' of method 'createEntry' must not be null";
        assert (history != null) : "Parameter 'history' of method 'createEntry' must not be null";
        assert (history instanceof SoftwareSystemFileHistory) : "Unexpected class: " + history.getClass().getName();
        assert (stateFile != null) : "Parameter 'stateFile' of method 'createEntry' must not be null";
        List<ModifiableFileHistory.FileHistoryEntry> toBeRemoved = super.createEntry(context, historyFile, history, needsSave, stateFile);
        SoftwareSystemFileEntry fileEntry = (SoftwareSystemFileEntry)history.getLastAddedEntry();
        fileEntry.setNeedsReparseFlagModification(context.getNeedsReparseFlagModification());
        fileEntry.setInvalidatesParserModel(context.invalidatesParserModel());
        fileEntry.setNeedsReparseState(this.c.needsReparse());
        return toBeRemoved;
    }

    @Override
    public String getConfirmationMessageForNextRestore(RestoreStateDto dto) {
        String stateInfo;
        assert (dto != null) : "Parameter 'dto' of method 'getConfirmationMessageForNextRestore' must not be null";
        assert (dto.getCurrentStateFileEntry() instanceof SoftwareSystemFileEntry) : "Unexpected class: " + dto.getClass().getName();
        SoftwareSystemFileEntry entry = (SoftwareSystemFileEntry)dto.getCurrentStateFileEntry();
        if (dto.getOperation() == FileHistoryOperation.UNDO) {
            stateInfo = "previous";
        } else if (dto.getOperation() == FileHistoryOperation.REDO) {
            stateInfo = "next";
        } else {
            stateInfo = "";
            assert (false) : "Support for operation " + dto.getOperation().name() + " not yet implemented";
        }
        if (this.c.isClearable() && (entry.getNeedsReparseState() && this.c.needsReparse() || entry.invalidatesParserModel())) {
            return "Restoring the " + stateInfo + " state of '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "' might clear the system.\nDo you want to continue?";
        }
        return null;
    }
}

