/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.controller.system.S;
import com.hello2morrow.sonargraph.core.controller.system.base.j;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.SoftwareSystemDefinitionFileReadError;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileAccess;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemSettingsDirectory;
import com.hello2morrow.sonargraph.core.model.system.settings.PersistenceRoot;
import com.hello2morrow.sonargraph.core.model.system.settings.SoftwareSystemSettingsFile;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class aT
extends Extension
implements S,
j,
IModifiableFileDeltaKey {
    private static final String b = "systemSettings";
    private final Installation c;
    private final SoftwareSystem d;

    public static boolean a(String rootElement) {
        assert (rootElement != null && rootElement.length() > 0) : "Parameter 'rootElement' of method 'isValidRootElement' must not be empty";
        return b.equals(rootElement);
    }

    protected aT(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'SoftwareSystemSettingsExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SoftwareSystemSettingsExtension' must not be null";
        this.d = softwareSystem;
        this.c = installation;
    }

    private void j() {
        Files files = this.g().getUniqueExistingChild(Files.class);
        SoftwareSystemSettingsDirectory settingsDirectory = files.getSoftwareSystemSettingsDirectory();
        List<SoftwareSystemSettingsFile> existingFiles = settingsDirectory.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'createSoftwareSystemSettingsFileIfItDoesNotExist': " + namedElement));
                }
                return aT.this.c().equals(namedElement.getLanguage());
            }
        }, SoftwareSystemSettingsFile.class);
        assert (existingFiles.size() <= 1) : "More than on file exist: " + existingFiles;
        if (existingFiles.isEmpty()) {
            SoftwareSystemSettingsFile settingsFile = new SoftwareSystemSettingsFile(settingsDirectory, new TFile((File)settingsDirectory.getFile(), this.h()), files, this.c());
            settingsDirectory.addChild(settingsFile);
        }
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        if (this.g().getUsedLanguages().contains(this.c())) {
            this.j();
        }
    }

    @Override
    public void finishSoftwareSystemInitializationInRestore(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitializationInRestore' must not be null";
        if (this.g().getUsedLanguages().contains(this.c())) {
            this.j();
        }
    }

    void a() {
        this.j();
    }

    void b() {
        SoftwareSystemSettingsFile settingsFile = this.a(true);
        if (!settingsFile.exists()) {
            settingsFile.remove();
        }
    }

    protected abstract Language c();

    protected abstract OperationResult a(TFile var1, NamedElement var2, EnumSet<Modification> var3);

    protected abstract OperationResult a(SoftwareSystemSettingsFile var1, TFile var2);

    protected abstract void a(EnumSet<Modification> var1);

    private IModifiableFileDeltaKey k() {
        return this;
    }

    protected final Installation d() {
        return this.c;
    }

    protected final SoftwareSystem g() {
        return this.d;
    }

    protected final String h() {
        return String.valueOf(this.c().getStandardName()) + "SystemSettings.xml";
    }

    private SoftwareSystemSettingsFile b(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getOrCreateSoftwareSystemSettingsFile' must not be null";
        Files files = this.g().getUniqueExistingChild(Files.class);
        SoftwareSystemSettingsDirectory settingsDirectory = files.getSoftwareSystemSettingsDirectory();
        List<SoftwareSystemSettingsFile> existingFiles = settingsDirectory.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getOrCreateSoftwareSystemSettingsFile': " + namedElement));
                }
                return aT.this.c().equals(namedElement.getLanguage());
            }
        }, SoftwareSystemSettingsFile.class);
        assert (existingFiles.size() <= 1) : "More than on file exist: " + existingFiles;
        if (!existingFiles.isEmpty()) {
            return existingFiles.get(0);
        }
        SoftwareSystemSettingsFile settingsFile = new SoftwareSystemSettingsFile(settingsDirectory, new TFile((File)settingsDirectory.getFile(), this.h()), files, this.c());
        settingsDirectory.addChild(settingsFile);
        assert (FileUtility.areEqual((TFile)file, (TFile)settingsFile.getFile())) : "Different files: " + file + "/" + settingsFile.getFile();
        return settingsFile;
    }

    private SoftwareSystemSettingsFile a(boolean fileMustExist) {
        Files files = this.g().getUniqueExistingChild(Files.class);
        SoftwareSystemSettingsDirectory settingsDirectory = files.getSoftwareSystemSettingsDirectory();
        List<SoftwareSystemSettingsFile> existing = settingsDirectory.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + namedElement));
                }
                return aT.this.c().equals(namedElement.getLanguage());
            }
        }, SoftwareSystemSettingsFile.class);
        if (fileMustExist) {
            assert (existing.size() == 1) : "Exactly one file expected: " + existing;
            return existing.get(0);
        }
        assert (existing.size() <= 1) : "More than 1 file exists: " + existing;
        return existing.isEmpty() ? null : existing.get(0);
    }

    protected final SoftwareSystemSettingsFile i() {
        return this.a(true);
    }

    public final List<IModifiableFile> e() {
        List<IModifiableFile> available = this.g().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory().getChildren(SoftwareSystemSettingsFile.class).stream().filter(f2 -> f2.existsOnDisk() && f2.getLanguage().equals(this.c())).collect(Collectors.toList());
        assert (available.size() <= 1) : "At most one file expected: " + available;
        return available;
    }

    @Override
    public final void a(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        SoftwareSystemSettingsDirectory settingsDirectory = this.g().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
        settingsDirectory.enforceExistence(result);
        IModifiableFileAccess access = new IModifiableFileAccess(){

            @Override
            public boolean accept(String fileName) {
                if (!a && fileName == null) {
                    throw new AssertionError((Object)"Parameter 'fileName' of method 'accept' must not be null");
                }
                return aT.this.h().equals(fileName);
            }
        };
        if (result.isSuccess() && settingsDirectory.isOutOfSync(access, (String[][])new String[][]{CoreFileType.SOFTWARE_SYSTEM_SETTINGS.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system files", new Object[0]);
        }
    }

    @Override
    public final void a(IModifiableFile file, TFile targetFile, OperationResult result) {
        assert (file != null && file instanceof SoftwareSystemSettingsFile) : "Unexpected class in method 'exportFile': " + file;
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        result.addMessagesFrom(this.a((SoftwareSystemSettingsFile)file, targetFile));
    }

    @Override
    public final void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, final boolean onSystemOpen, final PrepareRefreshResult prepareRefreshResult) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        if (onSystemOpen || this.d.getMode() == SoftwareSystemMode.SYSTEM) {
            deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return aT.this.k();
                }

                @Override
                public boolean exists(IModifiableFile modifiableFile) {
                    if (!onSystemOpen && modifiableFile instanceof SoftwareSystemSettingsFile && aT.this.h().equals(((SoftwareSystemSettingsFile)modifiableFile).getShortName())) {
                        return ((SoftwareSystemSettingsFile)modifiableFile).existsOnDisk();
                    }
                    return false;
                }

                @Override
                public boolean accept(TFile file) {
                    if (!a && file == null) {
                        throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                    }
                    return aT.this.h().equals(file.getName());
                }

                @Override
                public boolean recursive() {
                    return false;
                }

                @Override
                public DirectoryPath getDirectoryPath() {
                    return aT.this.g().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
                }

                @Override
                public List<IFileType> getFileTypes() {
                    return Collections.singletonList(CoreFileType.SOFTWARE_SYSTEM_SETTINGS);
                }

                @Override
                public String getImageResource(IFileType fileType) {
                    return SoftwareSystemSettingsFile.class.getSimpleName();
                }
            });
            if (!onSystemOpen) {
                deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                    @Override
                    public IModifiableFileDeltaKey getKey() {
                        return aT.this.k();
                    }

                    @Override
                    public void visitModified(IModifiableFile modified) {
                        if (!(a || modified != null && modified instanceof SoftwareSystemSettingsFile)) {
                            throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + modified));
                        }
                        prepareRefreshResult.addInfo(String.valueOf(aT.this.h()) + " will be re-loaded");
                    }

                    @Override
                    public void visitDeleted(IModifiableFile deleted) {
                        if (!(a || deleted != null && deleted instanceof SoftwareSystemSettingsFile)) {
                            throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + deleted));
                        }
                        prepareRefreshResult.addInfo(String.valueOf(aT.this.h()) + " will be set to defaults");
                    }

                    @Override
                    public void visitAdded(ModifiableFileCandidate added) {
                        if (!a && added == null) {
                            throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                        }
                        prepareRefreshResult.addInfo(String.valueOf(aT.this.h()) + " will be loaded");
                    }
                }, false);
            }
        }
    }

    @Override
    public final void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, final EnumSet<Modification> modifications, final OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return aT.this.k();
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!(a || modified != null && modified instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + modified));
                }
                SoftwareSystemSettingsFile settingsFile = aT.this.a(true);
                if (!a && modified != settingsFile) {
                    throw new AssertionError((Object)"Different files");
                }
                settingsFile.removeIssues(CoreIssueId.SOFTWARE_SYSTEM_DEFINITION_FILE_READ_ERROR);
                PersistenceRoot root = new PersistenceRoot();
                OperationResult loadResult = aT.this.a(settingsFile.getFile(), root, (EnumSet<Modification>)modifications);
                if (loadResult.isSuccess()) {
                    settingsFile.forgetChildren(true);
                    root.transferChildrenTo(settingsFile);
                    ((SoftwareSystemSettingsFile)modified).resetTimestamp();
                }
                result.addMessagesFrom(loadResult);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!(a || deleted != null && deleted instanceof SoftwareSystemSettingsFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + deleted));
                }
                SoftwareSystemSettingsFile settingsFile = aT.this.a(true);
                if (!a && deleted != settingsFile) {
                    throw new AssertionError((Object)"Different files");
                }
                aT.this.a(modifications);
                if (aT.this.g().getUsedLanguages().contains(aT.this.c())) {
                    settingsFile.setExistsOnDisk(false);
                    settingsFile.forgetChildren(true);
                } else {
                    settingsFile.remove();
                }
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!a && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                SoftwareSystemSettingsFile settingsFile = aT.this.b(added.getFile());
                PersistenceRoot root = new PersistenceRoot();
                OperationResult addedResult = aT.this.a(settingsFile.getFile(), root, (EnumSet<Modification>)modifications);
                if (addedResult.isSuccess()) {
                    root.transferChildrenTo(settingsFile);
                    settingsFile.setExistsOnDisk(true);
                    settingsFile.setNeedsSave(false);
                } else {
                    settingsFile.addIssue(new SoftwareSystemDefinitionFileReadError(settingsFile, "Unable to read: " + addedResult.toString()));
                }
                result.addMessagesFrom(addedResult);
            }
        }, true);
    }

    @Override
    public final void a(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        this.g().getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory().setPath(new TFile((File)qualityModel, "./Settings"));
    }

    @Override
    public final boolean a(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.SOFTWARE_SYSTEM_SETTINGS.equals(modifiableFile.getFileType()) && this.h().equals(modifiableFile.getFile().getName());
    }

    @Override
    public final String f() {
        return "Settings";
    }

    @Override
    public final void a(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'discardFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        SoftwareSystemSettingsFile settingsFile = this.a(false);
        if (settingsFile != null) {
            if (settingsFile.existsOnDisk()) {
                this.a(modfications);
                SoftwareSystemFilesDirectory.removeFile(settingsFile.getFile(), false, result);
            }
            if (modfications != null) {
                modfications.add(Modification.WORKSPACE_SETUP_MODIFIED);
            }
        }
    }

    private OperationResult a(TFile contentFile, SoftwareSystemSettingsFile settingsFile, EnumSet<Modification> modifications) {
        assert (contentFile != null) : "Parameter 'contentFile' of method 'importContent' must not be null";
        assert (settingsFile != null) : "Parameter 'settingsFile' of method 'importContent' must not be null";
        OperationResult result = new OperationResult("Import System Settings Content '" + this.c() + "'");
        PersistenceRoot root = new PersistenceRoot();
        OperationResult loadResult = this.a(contentFile, root, modifications);
        result.addMessagesFrom(loadResult);
        if (loadResult.isSuccess()) {
            settingsFile.forgetChildren(true);
            root.transferChildrenTo(settingsFile);
            settingsFile.resetTimestamp();
            settingsFile.setNeedsSave(true);
            OperationResult saveResult = this.a(settingsFile, settingsFile.getFile());
            result.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                settingsFile.setExistsOnDisk(true);
                settingsFile.setNeedsSave(false);
            }
        }
        return result;
    }

    private ImportQualityModel.ImportQualityModelCandidate a(ImportQualityModel importQualityModel) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'getImportCandidate' must not be null";
        for (ImportQualityModel.ImportQualityModelCandidate next : importQualityModel.getCandidatesByFileType(CoreFileType.SOFTWARE_SYSTEM_SETTINGS)) {
            if (!next.isIncluded() || !next.getModifiableFile().getFile().getName().equals(this.h())) continue;
            return next;
        }
        return null;
    }

    @Override
    public final void a(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importFiles' must not be null";
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        ImportQualityModel.ImportQualityModelCandidate candidate = this.a(importQualityModel);
        if (candidate != null) {
            List<IModifiableFile> availableFiles;
            TFile contentFile = candidate.getModifiableFile().getFile();
            if (importQualityModel.discardCurrentContent() || !candidate.isAlreadyInModel()) {
                OperationResult importContentResult = this.a(contentFile, this.b(contentFile), modifications);
                result.addMessagesFrom(importContentResult);
            } else if (!importQualityModel.discardCurrentContent() && !(availableFiles = this.e()).isEmpty()) {
                assert (availableFiles.size() == 1) : "Exactly one file expected: " + availableFiles;
                IModifiableFile availableFile = availableFiles.get(0);
                assert (availableFile instanceof SoftwareSystemSettingsFile) : "Unexpected class in method 'importFiles': " + availableFile;
                OperationResult importContentResult = this.a(contentFile, (SoftwareSystemSettingsFile)availableFile, modifications);
                if (importContentResult.isSuccess()) {
                    ((SoftwareSystemSettingsFile)availableFile).reloaded(contentFile.lastModified(), false);
                }
                result.addMessagesFrom(importContentResult);
            }
        }
    }

    public final OperationResult a(SoftwareSystemSettingsFile settingsFile) {
        assert (settingsFile != null) : "Parameter 'settingsFile' of method 'save' must not be null";
        assert (settingsFile == this.a(true)) : "Different files";
        OperationResult saveResult = this.a(settingsFile, settingsFile.getFile());
        if (saveResult.isSuccess()) {
            settingsFile.setNeedsSave(false);
        }
        return saveResult;
    }
}

