/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyElementIdFilter;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignature;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignatureWithTimestamp;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class aR
extends Extension {
    private static final Logger b = LoggerFactory.getLogger(aR.class);
    private final aa c;

    public aR(aa languageProviderAccessor) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'WorkspaceDataTransfer' must not be null";
        this.c = languageProviderAccessor;
    }

    private void a(Filter fromSource, Filter fromTarget, EnumSet<Modification> modifications) {
        assert (fromSource != null) : "Parameter 'fromSource' of method 'transferFilters' must not be null";
        assert (fromTarget != null) : "Parameter 'fromTarget' of method 'transferFilters' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'transferFilters' must not be null";
        if (!Filter.areEqual(fromTarget, fromSource)) {
            modifications.add(Modification.WORKSPACE_MODIFIED);
            modifications.add(Modification.WORKSPACE_FILTER_MODIFIED);
        }
        fromTarget.removeChildren(new Class[0]);
        for (NamedElement nextFilterChild : new ArrayList<NamedElement>(fromSource.getChildren())) {
            nextFilterChild.changeParent(fromTarget, true);
        }
    }

    private void a(SoftwareSystem source, SoftwareSystem target) {
        Workspace sourceWorkspace = source.getUniqueExistingChild(Workspace.class);
        Workspace targetWorkspace = target.getUniqueExistingChild(Workspace.class);
        List<Module> sourceModules = aR.a(source);
        List<Module> targetModules = aR.a(target);
        int i2 = 0;
        while (i2 < sourceModules.size()) {
            Module sourceModule = sourceModules.get(i2);
            Module targetModule = targetModules.get(i2);
            if (!sourceModule.getName().equals(targetModule.getName())) {
                int index = sourceWorkspace.getIndexOf(Module.class, sourceModule);
                targetModule = targetWorkspace.getUniqueChild(new WorkspaceDependencyElementIdFilter(sourceModule.getId()), Module.class);
                targetWorkspace.moveChild(Module.class, targetModule, index);
            }
            ++i2;
        }
    }

    private static boolean d(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        WorkspaceFilter targetWorkspaceFilter;
        assert (source != null) : "Parameter 'source' of method 'checkIfWorkspaceFilterMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfWorkspaceFilterMatch' must not be null";
        WorkspaceFilter sourceWorkspaceFilter = source.getUniqueExistingChild(Workspace.class).getWorkspaceFilter();
        if (Filter.areEqual(sourceWorkspaceFilter, targetWorkspaceFilter = target.getUniqueExistingChild(Workspace.class).getWorkspaceFilter())) {
            return true;
        }
        if (result != null) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.WORKSPACE_FILTER_CHANGED);
        }
        return false;
    }

    private static boolean a(aa languageProviderAccessor, SoftwareSystem source, SoftwareSystem target, boolean checkWorkspaceFilter, OperationResult result) {
        if (checkWorkspaceFilter && !aR.d(source, target, result)) {
            return false;
        }
        if (!aR.e(source, target, result)) {
            return false;
        }
        if (!aR.c(source, target, result)) {
            return false;
        }
        if (!aR.b(source, target, result)) {
            return false;
        }
        return aR.b(languageProviderAccessor, source, target, result);
    }

    private static boolean e(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfModulesMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfModulesMatch' must not be null";
        List<Module> sourceModules = aR.a(source);
        List<Module> targetModules = aR.a(target);
        if (sourceModules.size() != targetModules.size()) {
            if (result != null) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.NUMBER_OF_MODULES_CHANGED);
            }
            return false;
        }
        for (Module targetModule : targetModules) {
            Module sourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(targetModule.getId()), Module.class);
            if (sourceModule != null) continue;
            if (result != null) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.MODULE_NOT_FOUND, "Module '" + targetModule.getName() + "' not found.", new Object[0]);
            }
            return false;
        }
        return true;
    }

    static boolean a(aa languageProviderAccessor, SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'checkIfModuleOrderMatch' must not be null";
        assert (source != null) : "Parameter 'source' of method 'checkIfModulesMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfModulesMatch' must not be null";
        List<Module> sourceModules = aR.a(source);
        List<Module> targetModules = aR.a(target);
        int i2 = 0;
        while (i2 < targetModules.size()) {
            Module targetModule = targetModules.get(i2);
            Module sourceModule = sourceModules.get(i2);
            Z lp = languageProviderAccessor.b(targetModule.getLanguage());
            if (lp.w() && !targetModule.getId().equals(sourceModule.getId())) {
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.MODULE_ORDER_CHANGED, "Position of module '" + sourceModule.getName() + "' changed.", new Object[0]);
                }
                return false;
            }
            ++i2;
        }
        return true;
    }

    static boolean a(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfModuleSettingsMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfModuleSettingsMatch' must not be null";
        assert (source != target) : "Same systems";
        int differences = 0;
        for (Module nextTargetModule : aR.a(target)) {
            Module sourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(nextTargetModule.getId()), Module.class);
            if (sourceModule != null && nextTargetModule.getClass().equals(sourceModule.getClass())) {
                ModuleSettings nextTargetSettings = nextTargetModule.getUniqueChild(ModuleSettings.class);
                ModuleSettings nextSourceSettings = sourceModule.getUniqueChild(ModuleSettings.class);
                if (nextTargetSettings == null || nextSourceSettings == null) continue;
                ModuleSettingsSignature targetSignature = nextTargetSettings.getUniqueChild(ModuleSettingsSignature.class);
                ModuleSettingsSignature sourceSignature = nextSourceSettings.getUniqueChild(ModuleSettingsSignature.class);
                if (targetSignature == null || sourceSignature == null || targetSignature.getName().equals(sourceSignature.getName())) continue;
                if (sourceSignature instanceof ModuleSettingsSignatureWithTimestamp && targetSignature instanceof ModuleSettingsSignatureWithTimestamp) {
                    String sourcePlainSignature = ((ModuleSettingsSignatureWithTimestamp)sourceSignature).getPlainString();
                    String targetPlainSignature = ((ModuleSettingsSignatureWithTimestamp)targetSignature).getPlainString();
                    b.info("Module signature changed for module '{}' from '{}' (source) to '{}' (target)", new Object[]{nextTargetModule.getName(), sourcePlainSignature, targetPlainSignature});
                } else {
                    b.info("Module signature changed for module '{}'", (Object)nextTargetModule.getName());
                }
                ++differences;
            }
            if (result != null) {
                result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.MODULE_SETTINGS_CHANGED, "Settings of module '" + nextTargetModule.getName() + "' changed.", new Object[0]);
                continue;
            }
            return false;
        }
        return differences == 0;
    }

    static boolean b(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfExternalsMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfExternalsMatch' must not be null";
        assert (source != target) : "Same systems";
        List<External> sourceExternals = source.getUniqueExistingChild(Workspace.class).getChildren(External.class);
        List<External> targetExternals = target.getUniqueExistingChild(Workspace.class).getChildren(External.class);
        for (External nextTagetExternal : targetExternals) {
            External matchingExternal = null;
            for (External nextSourceExternal : sourceExternals) {
                if (!nextSourceExternal.getClass().equals(nextTagetExternal.getClass())) continue;
                matchingExternal = nextSourceExternal;
                break;
            }
            if (matchingExternal != null) continue;
            if (result != null) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.EXTERNAL_NOT_FOUND, "External '" + nextTagetExternal + "' not found.", new Object[0]);
                continue;
            }
            return false;
        }
        return true;
    }

    private static List<Module> a(SoftwareSystem system) {
        return system.getUniqueExistingChild(Workspace.class).getChildren(Module.class).stream().filter(m2 -> !m2.isAutomatic()).collect(Collectors.toList());
    }

    static boolean b(aa lpAccessor, SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (lpAccessor != null) : "Parameter 'lpAccessor' of method 'checkIfWorkspaceDependenciesMatch' must not be null";
        assert (source != null) : "Parameter 'source' of method 'checkIfWorkspaceDependenciesMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfWorkspaceDependenciesMatch' must not be null";
        assert (source != target) : "Same systems";
        List<Module> sourceModules = aR.a(source);
        List<Module> targetModules = aR.a(target);
        assert (sourceModules.size() == targetModules.size()) : "checkIfModulesMatch() must have been called previously.";
        for (Module nextTargetModule : targetModules) {
            Z lp = lpAccessor.b(nextTargetModule.getLanguage());
            if (!lp.v()) continue;
            String moduleId = nextTargetModule.getId();
            Module sourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(moduleId), Module.class);
            assert (sourceModule != null) : "checkIfModulesMatch() must have been called previously.";
            ArrayList<WorkspaceDependency> targetDependencies = new ArrayList<WorkspaceDependency>(nextTargetModule.getOutgoingWorkspaceDependencies());
            aR.a(targetDependencies);
            ArrayList<WorkspaceDependency> sourceDependencies = new ArrayList<WorkspaceDependency>(sourceModule.getOutgoingWorkspaceDependencies());
            aR.a(sourceDependencies);
            if (sourceDependencies.size() != targetDependencies.size()) {
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.WORKSPACE_DEPENDENCIES_DO_NOT_MATCH, "Number of workspace dependencies changed.", new Object[0]);
                }
                return false;
            }
            for (WorkspaceDependency dep : targetDependencies) {
                Z languageProvider = lpAccessor.b(dep.getFrom().getLanguage());
                IWorkspaceDependencyElement endpoint = languageProvider.a(source.getUniqueExistingChild(Workspace.class), (IWorkspaceDependencyElement)sourceModule, dep.getType(), dep.getToId(), dep.getToName(), dep.getAdditionalDependencyData());
                if (endpoint != null) continue;
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.WORKSPACE_DEPENDENCIES_DO_NOT_MATCH, "Workspace dependency '" + dep.toString() + "' not found.", new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    private static void a(List<WorkspaceDependency> dependencies) {
        Iterator<WorkspaceDependency> iter = dependencies.iterator();
        while (iter.hasNext()) {
            WorkspaceDependency next = iter.next();
            if (!next.isForInternalUse()) continue;
            iter.remove();
        }
    }

    static boolean c(SoftwareSystem source, SoftwareSystem target, OperationResult result) {
        assert (source != null) : "Parameter 'source' of method 'checkIfRootsMatch' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkIfRootsMatch' must not be null";
        assert (source != target) : "Same systems";
        for (Module nextTargetModule : aR.a(target)) {
            Module nextSourceModule = source.getUniqueExistingChild(Workspace.class).getUniqueChild(new WorkspaceDependencyElementIdFilter(nextTargetModule.getId()), Module.class);
            assert (nextSourceModule != null) : "module '" + nextTargetModule.getName() + "' must exist";
            List<RootDirectoryPath> sourceRoots = nextSourceModule.getRelevantRootDirectoryPaths();
            List<RootDirectoryPath> targetRoots = nextTargetModule.getRelevantRootDirectoryPaths();
            if (sourceRoots.size() != targetRoots.size()) {
                if (result != null) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.ROOT_DIRECTORIES_DONT_MATCH, "Number of root directories for module '" + nextTargetModule.getName() + "' does not match", new Object[0]);
                    continue;
                }
                return false;
            }
            int i2 = 0;
            while (i2 < targetRoots.size()) {
                RootDirectoryPath nextTargetRoot = targetRoots.get(i2);
                RootDirectoryPath nextSourceRoot = sourceRoots.get(i2);
                if (!nextTargetRoot.getClass().equals(nextSourceRoot.getClass()) || !nextTargetRoot.getName().equals(nextSourceRoot.getName())) {
                    if (result != null) {
                        result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.ROOT_DIRECTORIES_DONT_MATCH, "Root directory '" + nextTargetRoot.getName() + "' changed.", new Object[0]);
                    } else {
                        return false;
                    }
                }
                if (nextTargetRoot.isEnabled() != nextSourceRoot.isEnabled()) {
                    if (result != null) {
                        result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.ROOT_DIRECTORIES_DONT_MATCH, "Enabled state of root directory '" + nextTargetRoot.getName() + "' changed.", new Object[0]);
                    } else {
                        return false;
                    }
                }
                ++i2;
            }
        }
        return true;
    }

    private static void a(Workspace workspace) {
        IssueFilter issueFilter;
        ProductionCodeFilter productionCodeFilter;
        assert (workspace != null) : "Parameter 'workspace' of method 'assureFilterOrder' must not be null";
        WorkspaceFilter fileFilter = workspace.getWorkspaceFilter();
        int index = workspace.getIndexOf(NamedElement.class, fileFilter);
        if (index != 0) {
            workspace.moveChild(NamedElement.class, fileFilter, 0);
        }
        if ((index = workspace.getIndexOf(NamedElement.class, productionCodeFilter = workspace.getProductionCodeFilter())) != 1) {
            workspace.moveChild(NamedElement.class, productionCodeFilter, 1);
        }
        if ((index = workspace.getIndexOf(NamedElement.class, issueFilter = workspace.getIssueFilter())) != 2) {
            workspace.moveChild(NamedElement.class, issueFilter, 2);
        }
    }

    private static void a(aa languageProviderAccessor, SoftwareSystem systemFromSnapshot, SoftwareSystem systemFromFile, Workspace workspaceFromSnapshot, Workspace workspaceFromFile, boolean attachOnly, boolean enableWorkspaceFilter) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'performTransfer' must not be null";
        assert (systemFromSnapshot != null) : "Parameter 'systemFromSnapshot' of method 'performTransfer' must not be null";
        assert (systemFromFile != null) : "Parameter 'systemFromFile' of method 'performTransfer' must not be null";
        assert (workspaceFromSnapshot != null) : "Parameter 'workspaceFromSnapshot' of method 'performTransfer' must not be null";
        assert (workspaceFromFile != null) : "Parameter 'workspaceFromFile' of method 'performTransfer' must not be null";
        workspaceFromSnapshot.removeChildren(ProductionCodeFilter.class, IssueFilter.class);
        workspaceFromFile.getProductionCodeFilter().changeParent(workspaceFromSnapshot, true);
        workspaceFromFile.getIssueFilter().changeParent(workspaceFromSnapshot, true);
        Set<Language> usedLanguages = attachOnly ? systemFromSnapshot.getUsedLanguages() : systemFromFile.getUsedLanguages();
        for (Z nextLanguageProvider : languageProviderAccessor.a(usedLanguages)) {
            nextLanguageProvider.a(workspaceFromFile, workspaceFromSnapshot);
        }
        workspaceFromFile.remove();
        workspaceFromSnapshot.changeParent(systemFromFile, true);
        workspaceFromSnapshot.getWorkspaceFilter().setEnabled(enableWorkspaceFilter);
        aR.a(workspaceFromSnapshot);
        systemFromFile.setIsClearable(systemFromSnapshot.isClearable());
        systemFromFile.getParserModel().initializeFrom(systemFromSnapshot.getParserModel());
    }

    public static void c(aa languageProviderAccessor, SoftwareSystem systemFromSnapshot, SoftwareSystem systemFromFile, OperationResult result) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'transferDataInSnapshotApply' must not be null";
        assert (systemFromSnapshot != null) : "Parameter 'systemFromSnapshot' of method 'transferDataInSnapshotApply' must not be null";
        assert (systemFromFile != null) : "Parameter 'systemFromFile' of method 'transferDataInSnapshotApply' must not be null";
        assert (systemFromSnapshot != systemFromFile) : "systemFromSnapshot and systemFromFile are the same instance";
        assert (result != null) : "Parameter 'result' of method 'transferDataInSnapshotApply' must not be null";
        Workspace workspaceFromSnapshot = systemFromSnapshot.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromSnapshot != null) : "'workspaceFromSnapshot' of method 'transferDataInSnapshotApply' must not be null";
        Workspace workspaceFromFile = systemFromFile.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromFile != null) : "'workspaceFromFile' of method 'transferDataInSnapshotApply' must not be null";
        boolean enableWorkspaceFilter = systemFromFile.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().isEnabled();
        aR.a(languageProviderAccessor, systemFromSnapshot, systemFromFile, enableWorkspaceFilter, result);
        if (result.isFailure()) {
            return;
        }
        aR.a(languageProviderAccessor, systemFromSnapshot, systemFromFile, result);
        if (result.isFailure()) {
            return;
        }
        languageProviderAccessor.a(systemFromFile.getUsedLanguages()).forEach(lp -> lp.a(workspaceFromSnapshot, workspaceFromFile, result));
        if (result.isFailure()) {
            return;
        }
        boolean moduleSettingsMatch = aR.a(systemFromSnapshot, systemFromFile, result);
        if (result.isFailure()) {
            return;
        }
        boolean installationConfigurationChanged = false;
        for (Z nextUsedLanguageProvider : languageProviderAccessor.a(systemFromFile.getUsedLanguages())) {
            boolean bl2 = installationConfigurationChanged = installationConfigurationChanged || nextUsedLanguageProvider.a(systemFromSnapshot, result);
        }
        if (result.isFailure()) {
            return;
        }
        aR.a(languageProviderAccessor, systemFromSnapshot, systemFromFile, workspaceFromSnapshot, workspaceFromFile, false, enableWorkspaceFilter);
        systemFromFile.setNeedsReparse(systemFromSnapshot.needsReparse() || installationConfigurationChanged || !moduleSettingsMatch || result.isFailure());
    }

    public static void a(aa languageProviderAccessor, SoftwareSystem systemFromSnapshot, SoftwareSystem systemFromFile) {
        Workspace workspaceFromSnapshot = systemFromSnapshot.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromSnapshot != null) : "'workspaceFromSnapshot' of method 'transferDataInSnapshotApply' must not be null";
        Workspace workspaceFromFile = systemFromFile.getUniqueExistingChild(Workspace.class);
        assert (workspaceFromFile != null) : "'workspaceFromFile' of method 'transferDataInSnapshotApply' must not be null";
        boolean enableWorkspaceFilter = systemFromFile.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().isEnabled();
        aR.a(languageProviderAccessor, systemFromSnapshot, systemFromFile, workspaceFromSnapshot, workspaceFromFile, true, enableWorkspaceFilter);
        systemFromFile.setNeedsReparse(false);
    }

    EnumSet<Modification> b(aa languageProviderAccessor, SoftwareSystem restoredSystem, SoftwareSystem previousSystem) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'transferDataInSoftwareSystemRestore' must not be null";
        assert (restoredSystem != null) : "Parameter 'restoredSystem' of method 'transferDataInSoftwareSystemRestore' must not be null";
        assert (previousSystem != null) : "Parameter 'previousSystem' of method 'transferDataInSoftwareSystemRestore' must not be null";
        assert (restoredSystem != previousSystem) : "Same software systems";
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        if (!previousSystem.getDescription().equals(restoredSystem.getDescription())) {
            previousSystem.setDescription(restoredSystem.getDescription());
            modifications.add(Modification.SYSTEM_MODIFIED);
        }
        Workspace workspaceFromRestoredSystem = restoredSystem.getUniqueExistingChild(Workspace.class);
        Workspace workspaceFromPreviousSystem = previousSystem.getUniqueExistingChild(Workspace.class);
        boolean enableWorkspaceFilter = previousSystem.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().isEnabled();
        if (!aR.a(languageProviderAccessor, restoredSystem, previousSystem, enableWorkspaceFilter, null)) {
            workspaceFromPreviousSystem.remove();
            workspaceFromRestoredSystem.changeParent(previousSystem, true);
            workspaceFromRestoredSystem.getWorkspaceFilter().setEnabled(enableWorkspaceFilter);
            for (Module nextModule : workspaceFromRestoredSystem.getChildren(Module.class)) {
                nextModule.getChildren(RootDirectoryPath.class).forEach(r2 -> r2.setModelServiceProvider(previousSystem));
            }
            modifications.add(Modification.WORKSPACE_MODIFIED);
            return modifications;
        }
        this.a(workspaceFromRestoredSystem.getWorkspaceFilter(), workspaceFromPreviousSystem.getWorkspaceFilter(), modifications);
        this.a(workspaceFromRestoredSystem.getProductionCodeFilter(), workspaceFromPreviousSystem.getProductionCodeFilter(), modifications);
        this.a(workspaceFromRestoredSystem.getIssueFilter(), workspaceFromPreviousSystem.getIssueFilter(), modifications);
        for (Z nextUsedLanguageProvider : this.c.a(previousSystem.getUsedLanguages())) {
            modifications.addAll(nextUsedLanguageProvider.a(workspaceFromRestoredSystem, workspaceFromPreviousSystem));
        }
        if (!aR.a(languageProviderAccessor, restoredSystem, previousSystem, null)) {
            this.a(restoredSystem, previousSystem);
            modifications.add(Modification.WORKSPACE_MODIFIED);
        }
        if (!aR.a(restoredSystem, previousSystem, null)) {
            previousSystem.setNeedsReparse(true);
            modifications.add(Modification.WORKSPACE_MODIFIED);
        } else {
            previousSystem.getParserModel().initializeFrom(restoredSystem.getParserModel());
        }
        return modifications;
    }
}

