/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.foundation.utilities.NioBufferJdk8Compatibility;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.D;
import com.hello2morrow.sonargraph.core.controller.system.SystemDiffExtension;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aR;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.base.l;
import com.hello2morrow.sonargraph.core.controller.system.bo;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.controllerinterface.system.x;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardFilePathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SnapshotSavedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.filter.ComponentFilter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemFromSnapshotCreator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotBaseDirectory;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotProcessor;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotReader;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotWriter;
import com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystemComponentFilterReader;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class aM
extends Extension
implements l,
x {
    private static final String b = "Snapshot file is corrupt, its format has changed or essential contained information has changed.";
    private static final Logger c = LoggerFactory.getLogger(aM.class);
    private final aa d;
    private final ISoftwareSystemFromSnapshotCreator e;
    private final SoftwareSystem f;
    private final bo g;
    private final ISoftwareSystemProvider.BackgroundTaskExecutionMode h;
    private final D i;
    private List<File> j;
    private File k;
    private long l = Long.MIN_VALUE;

    static IPathValidator a() {
        return new b();
    }

    static OperationResultWithOutcome<List<TFile>> a(IWorkerContext workerContext, TFile snapshotFile, TFile targetDirectory) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'isOpenSnapshotAttachedPossible' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'isOpenSnapshotAttachedPossible' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'isOpenSnapshotAttachedPossible' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Is open snapshot attached from '" + snapshotFile.getAbsolutePath() + "' possible");
        TFile targetSystemDirectory = null;
        TFile targetBaseline = null;
        TFile[] files = snapshotFile.listFiles();
        if (files != null) {
            TFile[] tFileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                TFile nextFile = tFileArray[n3];
                if (nextFile.getName().endsWith(CoreFileType.SOFTWARE_SYSTEM.getDefaultExtension())) {
                    if (targetSystemDirectory != null) {
                        result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Duplicate system directory found", new Object[0]);
                        return result;
                    }
                    targetSystemDirectory = new TFile((File)targetDirectory, nextFile.getName());
                } else if (nextFile.getName().endsWith(".xml")) {
                    if (targetBaseline != null) {
                        result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Duplicate baseline found", new Object[0]);
                        return result;
                    }
                    targetBaseline = new TFile((File)targetDirectory, nextFile.getName());
                }
                ++n3;
            }
        }
        if (targetSystemDirectory != null) {
            ArrayList<TFile> replace = new ArrayList<TFile>(2);
            if (targetSystemDirectory.exists()) {
                replace.add(targetSystemDirectory);
            }
            if (targetBaseline != null && targetBaseline.exists()) {
                replace.add(targetBaseline);
            }
            result.setOutcome(replace);
            return result;
        }
        result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Unable to locate system directory in '" + snapshotFile.getAbsolutePath() + "'", new Object[0]);
        return result;
    }

    static a b(IWorkerContext workerContext, TFile snapshotFile, TFile targetDirectory) throws IOException {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'extractSystemDefintionFilesSnapshot' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'extractSystemDefintionFilesSnapshot' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetSystemDirectory' of method 'extractSystemDefintionFilesSnapshot' must not be null";
        workerContext.working("Extract system definition files", true);
        TFile targetSystemDirectory = null;
        TFile targetBaseline = null;
        TFile[] files = snapshotFile.listFiles();
        if (files != null) {
            TFile[] tFileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                TFile nextFile = tFileArray[n3];
                if (nextFile.getName().endsWith(CoreFileType.SOFTWARE_SYSTEM.getDefaultExtension())) {
                    if (targetSystemDirectory != null) {
                        throw new IOException("Duplicate system directory found");
                    }
                    targetSystemDirectory = new TFile((File)targetDirectory, nextFile.getName());
                    if (targetSystemDirectory.exists()) {
                        TFile.rm_r((File)targetSystemDirectory);
                    }
                    TFile.cp_rp((File)nextFile, (File)targetSystemDirectory, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)TArchiveDetector.NULL);
                } else if (nextFile.getName().endsWith(".xml")) {
                    if (targetBaseline != null) {
                        throw new IOException("Duplicate baseline found");
                    }
                    targetBaseline = new TFile((File)targetDirectory, nextFile.getName());
                    TFile.cp((File)nextFile, (File)targetBaseline);
                }
                ++n3;
            }
        }
        if (targetSystemDirectory == null) {
            throw new IOException("Unable to locate system definition files.");
        }
        return new a(targetSystemDirectory, targetBaseline);
    }

    static OperationResultWithOutcome<SoftwareSystem> a(IWorkerContext workerContext, ISoftwareSystemFromSnapshotCreator creator, TFile snapshotFile, aa accessor) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'load' must not be null";
        assert (creator != null) : "Parameter 'creator' of method 'load' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'load' must not be null";
        assert (accessor != null) : "Parameter 'accessor' of method 'load' must not be null";
        snapshotFile.toNonArchiveFile().setReadOnly();
        TrueZipFacade.clear((TFile)snapshotFile);
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load snapshot from: " + snapshotFile.getAbsolutePath());
        if (!FileUtility.isArchive((TFile)snapshotFile)) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Snapshot file must be an archive.", new Object[0]);
            return result;
        }
        SoftwareSystem softwareSystem = null;
        workerContext.working("Loading snapshot", true);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (SnapshotReader reader = new SnapshotReader(snapshotFile);){
                if (reader.open((OperationResult)result)) {
                    softwareSystem = reader.readSnapshot((ClassLoader)accessor.a(), creator, null, (OperationResult)result);
                    if (result.isSuccess()) {
                        reader.mapRootDirectories(softwareSystem, new SnapshotBaseDirectory(softwareSystem, softwareSystem.getDirectoryFile()), (OperationResult)result);
                    }
                    if (result.isSuccess()) {
                        for (String lang : reader.getLanguages()) {
                            Language language = accessor.a(lang);
                            if (language != null) continue;
                            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.LANGUAGE_NOT_AVAILABLE, lang, new Object[0]);
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, ex.getMessage(), new Object[0]);
        }
        if (result.isSuccess()) {
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'load' must not be null";
            result.setOutcome(softwareSystem);
        }
        return result;
    }

    static void a(SoftwareSystem softwareSystem, TFile snapshotFile) {
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'finishOpenSnapshot' must not be null";
        TFile systemDirectory = null;
        TFile[] files = snapshotFile.listFiles();
        if (files != null) {
            TFile[] tFileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                TFile nextFile = tFileArray[n3];
                if (nextFile.getName().endsWith(CoreFileType.SOFTWARE_SYSTEM.getDefaultExtension())) {
                    systemDirectory = nextFile;
                    break;
                }
                ++n3;
            }
        }
        if (systemDirectory != null) {
            TFile systemFile = null;
            TFile[] filesInSystemDirectory = systemDirectory.listFiles();
            if (filesInSystemDirectory != null) {
                TFile[] tFileArray = filesInSystemDirectory;
                int n4 = filesInSystemDirectory.length;
                int n5 = 0;
                while (n5 < n4) {
                    TFile nextFile = tFileArray[n5];
                    if (nextFile.getName().equalsIgnoreCase("system.sonargraph")) {
                        systemFile = nextFile;
                        break;
                    }
                    ++n5;
                }
            }
            if (systemFile != null) {
                c.debug("Read system file");
                OperationResultWithOutcome<SoftwareSystemComponentFilterReader.ComponentFilterPatterns> result = SoftwareSystemComponentFilterReader.read(systemFile);
                if (result.isSuccess()) {
                    SoftwareSystemComponentFilterReader.ComponentFilterPatterns componentFilterPatterns = (SoftwareSystemComponentFilterReader.ComponentFilterPatterns)result.getOutcome();
                    if (componentFilterPatterns.hasPatterns()) {
                        WildcardPatternExclude wildcardPatternExclude;
                        WildcardPatternInclude wildcardPatternInclude;
                        ComponentFilter filter;
                        Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
                        if (componentFilterPatterns.hasProductionCodeFilterPatterns()) {
                            filter = workspace.getProductionCodeFilter();
                            filter.removeChildren(Pattern.class);
                            for (String next : componentFilterPatterns.getProductionCodeFilterIncludes()) {
                                wildcardPatternInclude = new WildcardPatternInclude(filter, next);
                                filter.addChild(wildcardPatternInclude);
                            }
                            for (String next : componentFilterPatterns.getProductionCodeFilterExcludes()) {
                                wildcardPatternExclude = new WildcardPatternExclude(filter, next);
                                filter.addChild(wildcardPatternExclude);
                            }
                        }
                        if (componentFilterPatterns.hasIssueFilterPatterns()) {
                            filter = workspace.getIssueFilter();
                            filter.removeChildren(Pattern.class);
                            for (String next : componentFilterPatterns.getIssueFilterIncludes()) {
                                wildcardPatternInclude = new WildcardPatternInclude(filter, next);
                                filter.addChild(wildcardPatternInclude);
                            }
                            for (String next : componentFilterPatterns.getIssueFilterExcludes()) {
                                wildcardPatternExclude = new WildcardPatternExclude(filter, next);
                                filter.addChild(wildcardPatternExclude);
                            }
                        }
                    }
                    if (result.containsWarning()) {
                        c.warn("Reading system file produced warning(s): " + result);
                    }
                } else {
                    c.error("Unable to read system file: " + result);
                }
                c.debug("Read system file - done");
            }
        }
    }

    public aM(aa accessor, ISoftwareSystemFromSnapshotCreator creator, SoftwareSystem softwareSystem, ISoftwareSystemProvider.BackgroundTaskExecutionMode backgroundTaskExecutionMode, D finishModelProcessor) {
        assert (accessor != null) : "Parameter 'accessor' of method 'SnapshotFunctionalExtension' must not be null";
        assert (creator != null) : "Parameter 'creator' of method 'SnapshotExtension' must not be null";
        assert (softwareSystem != null) : "'softwareSystem' must not be null";
        assert (backgroundTaskExecutionMode != null) : "Parameter 'backgroundTaskExecutionMode' of method 'SnapshotFunctionalExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'SnapshotExtension' must not be null";
        this.d = accessor;
        this.e = creator;
        this.f = softwareSystem;
        this.g = new bo(softwareSystem);
        this.h = backgroundTaskExecutionMode;
        this.i = finishModelProcessor;
    }

    boolean a(IWorkerContext workerContext, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyLastSnapshot' must not be null";
        assert (result != null) : "Parameter 'result' of method 'applyLastSnapshot' must not be null";
        TFile snapshotFile = SnapshotProcessor.getSnapshotFile(this.f);
        if (snapshotFile.exists()) {
            workerContext.working("Load and apply snapshot", true);
            SoftwareSystem softwareSystemFromSnapshot = null;
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (SnapshotReader reader = new SnapshotReader(snapshotFile);){
                    if (reader.open(result)) {
                        workerContext.working("Load snapshot", true);
                        softwareSystemFromSnapshot = reader.readSnapshot((ClassLoader)this.d.a(), this.e, this.f, result);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exc) {
                c.warn("Unable to close resource for '" + snapshotFile + "'", (Throwable)exc);
            }
            if (result.isSuccess()) {
                block22: {
                    assert (softwareSystemFromSnapshot != null) : "'softwareSystem' of method 'applyLastSnapshot' must not be null";
                    OperationResult applySnapshotResult = new OperationResult("Applying snapshot");
                    aR.c(this.d, softwareSystemFromSnapshot, this.f, applySnapshotResult);
                    result.addMessagesFrom(applySnapshotResult);
                    if (!applySnapshotResult.isSuccess()) break block22;
                    this.f.setState(SoftwareSystemState.MODEL_LOADED);
                    this.f.setLastAppliedSnapshot(snapshotFile);
                    return true;
                }
                try {
                    result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_APPLY_SNAPSHOT, b, new Object[0]);
                }
                catch (Throwable t2) {
                    c.error("Failed to apply snapshot", t2);
                    result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_APPLY_SNAPSHOT, b, new Object[0]);
                }
            } else {
                result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_APPLY_SNAPSHOT, b, new Object[0]);
            }
        }
        return false;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, ISnapshotProcessor.Mode mode, TFile file) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'saveSnapshot' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'saveSnapshot' must not be null";
        assert (file != null) : "Parameter 'file' of method 'saveSnapshot' must not be null";
        OperationResult result = new OperationResult("Save snapshot");
        List<String> allowedExtensions = Arrays.asList(CoreFileType.SNAPSHOT.getExtensions());
        if (!allowedExtensions.contains(FileUtility.getExtension((TFile)file))) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.UNEXPECTED_FILE_EXTENSION, "Not an allowed snapshot file extension '" + FileUtility.getExtension((TFile)file) + "'", new Object[0]);
            return result;
        }
        if (file.exists()) {
            if (!FileUtility.isArchive((TFile)file)) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_FILE, "Snapshot file '" + file.getNormalizedAbsolutePath() + "' already exists, but is not a snapshot file and thus won't be removed automatically.", new Object[0]);
                return result;
            }
            File standardFile = new File(file.getPath());
            standardFile.delete();
        } else if (!file.getParentFile().exists()) {
            try {
                file.getParentFile().mkdir(true);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, (Throwable)ex, "Failed to create directory for snapshot.", new Object[0]);
                return result;
            }
        } else if (!file.getParentFile().canWrite()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION, "No write permission for directory '" + file.getParentFile().getNormalizedAbsolutePath() + "'", new Object[0]);
            return result;
        }
        TFile activeBaseline = this.f.getExtension(ISystemDiffProvider.class).getActiveBaseline();
        new SnapshotWriter(this.f, mode).writeSnapshot(workerContext, file, activeBaseline == null ? Collections.emptyList() : Collections.singletonList(activeBaseline), result);
        if (result.isSuccess()) {
            EventManager.getInstance().dispatch((Object)this, (Event)new SnapshotSavedEvent(this.f.getExtension(ISoftwareSystemProvider.class), FileUtility.convertPathToUniversalForm((String)FileUtility.getCanonicalFilePath((TFile)file))));
        }
        return result;
    }

    @Override
    public void b() {
        this.g.a(ISnapshotProcessor.Mode.WORKSPACE);
        if (this.h == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            this.g.c();
        }
    }

    @Override
    public boolean c() {
        return this.g.b();
    }

    @Override
    public void d() {
        this.g.c();
    }

    @Override
    public String getDefaultSnapshotName() {
        return String.format("%s_%s", this.f.getName(), Iso8601DateFormat.formatDateAndTimeForFileName((Date)new Date()));
    }

    @Override
    public List<String> getPossibleSnapshotExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(CoreFileType.SNAPSHOT.getExtensions().length);
        String[] stringArray = CoreFileType.SNAPSHOT.getExtensions();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String next = stringArray[n3];
            extensions.add("*" + next);
            ++n3;
        }
        return extensions;
    }

    @Override
    public OperationResultWithOutcome<SoftwareSystem> a(IWorkerContext workerContext, TFile snapshotFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'loadSnaphot' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'loadSnaphot' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load snapshot '" + snapshotFile.getAbsolutePath() + "'");
        if (!snapshotFile.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Snapshot file not found.", new Object[0]);
            return result;
        }
        if (!FileUtility.isArchive((TFile)snapshotFile)) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Snapshot file must be an archive.", new Object[0]);
            return result;
        }
        SoftwareSystem systemLoadedFromSnapshot = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (SnapshotReader reader = new SnapshotReader(snapshotFile);){
                if (reader.open((OperationResult)result)) {
                    workerContext.working("Load snapshot", true);
                    systemLoadedFromSnapshot = reader.readSnapshot((ClassLoader)this.d.a(), this.e, this.f, (OperationResult)result);
                    if (result.isSuccess()) {
                        reader.mapRootDirectories(systemLoadedFromSnapshot, new SnapshotBaseDirectory(this.f, systemLoadedFromSnapshot.getDirectoryFile()), (OperationResult)result);
                    }
                    if (result.isSuccess()) {
                        for (String lang : reader.getLanguages()) {
                            Language language = this.d.a(lang);
                            if (language != null) continue;
                            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.LANGUAGE_NOT_AVAILABLE, lang, new Object[0]);
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            c.warn("Unable to close resource for '" + snapshotFile + "'", (Throwable)exc);
        }
        if (result.isSuccess()) {
            result.setOutcome(systemLoadedFromSnapshot);
            assert (systemLoadedFromSnapshot != null);
            systemLoadedFromSnapshot.setLoadedFromSnapshot(snapshotFile);
        }
        TrueZipFacade.clear((TFile)snapshotFile);
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, SoftwareSystem sourceSoftwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'attachSnapshot' must not be null";
        assert (sourceSoftwareSystem != null) : "Parameter 'sourceSoftwareSystem' of method 'attachSnapshot' must not be null";
        assert (this.f != sourceSoftwareSystem) : "Same instances";
        assert (this.f.getState() == SoftwareSystemState.OPENED) : "System has already a parser model";
        TFile snapshotFile = sourceSoftwareSystem.getSnapshot();
        assert (snapshotFile != null) : "'snapshotFile' of method 'attachSnapshot' must not be null";
        OperationResult result = new OperationResult("Attach snapshot '" + snapshotFile.getAbsolutePath() + "'");
        Set<Language> previousLanguages = this.f.getUsedLanguages();
        Set<Language> currentLanguages = sourceSoftwareSystem.getUsedLanguages();
        THashSet removedLanguages = new THashSet();
        THashSet addedLanguages = new THashSet();
        c analyzerExtension = this.f.getExtension(c.class);
        EnumSet<Modification> modifications = EnumSet.of(Modification.WORKSPACE_MODIFIED);
        if (!previousLanguages.equals(currentLanguages)) {
            Z nextlanguageProvider;
            for (Language next : previousLanguages) {
                if (currentLanguages.contains(next)) continue;
                removedLanguages.add(next);
                nextlanguageProvider = this.d.b(next);
                nextlanguageProvider.a(this.f);
                analyzerExtension.a(nextlanguageProvider);
            }
            for (Language next : currentLanguages) {
                if (previousLanguages.contains(next)) continue;
                addedLanguages.add(next);
                nextlanguageProvider = this.d.b(next);
                analyzerExtension.a(nextlanguageProvider, null);
            }
            modifications.add(Modification.AVAILABLE_LANGUAGES_MODIFIED);
        }
        VirtualModel resetTo = this.i.a(workerContext, this.f);
        aR.a(this.d, sourceSoftwareSystem, this.f);
        this.f.setState(SoftwareSystemState.MODEL_LOADED);
        this.f.setAttachedToSnapshot(snapshotFile, false);
        this.d.a(currentLanguages).forEach(lp -> lp.a(workerContext, this.f, (IFilePathListener)null));
        this.i.a(workerContext, this.f, resetTo, result);
        ModifiableModel modifiableModel = this.f.getCurrentModel(ModifiableModel.class);
        if (modifiableModel != null) {
            modifiableModel.setNeedsApplication();
        }
        this.i.a(workerContext, this.f, modifications, result);
        analyzerExtension.b(workerContext);
        return result;
    }

    void a(IWorkerContext workerContext, SoftwareSystem sourceSoftwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'attachSnapshot' must not be null";
        assert (sourceSoftwareSystem != null) : "Parameter 'sourceSoftwareSystem' of method 'attachSnapshot' must not be null";
        assert (result != null) : "Parameter 'result' of method 'attachSnapshot' must not be null";
        assert (this.f != sourceSoftwareSystem) : "Same instances";
        assert (this.f.getState() == SoftwareSystemState.OPENED) : "System has already a parser model";
        assert (this.f.getUsedLanguages().equals(sourceSoftwareSystem.getUsedLanguages())) : "Languages do not match";
        workerContext.working("Attach snapshot", true);
        TFile snapshotFile = sourceSoftwareSystem.getSnapshot();
        assert (snapshotFile != null) : "'snapshotFile' of method 'attachSnapshot' must not be null";
        VirtualModel resetTo = this.i.a(workerContext, this.f);
        aR.a(this.d, sourceSoftwareSystem, this.f);
        this.f.setState(SoftwareSystemState.MODEL_LOADED);
        this.f.setAttachedToSnapshot(snapshotFile, true);
        this.d.a(this.f.getUsedLanguages()).forEach(lp -> lp.a(workerContext, this.f, (IFilePathListener)null));
        this.i.a(workerContext, this.f, resetTo, result);
    }

    boolean e() {
        assert (this.f.getMode() == SoftwareSystemMode.SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT) : "Wrong mode: " + (Object)((Object)this.f.getMode());
        assert (this.j != null) : "'m_extractedFileList' of method 'offerSaveToOnExtractedAndAttachedSoftwareSystemClose' must not be null";
        assert (this.l != Long.MIN_VALUE) : "Extraction timestamp not set";
        TFile directory = this.f.getSystemDirectoryFile();
        assert (directory != null) : "'directory' of method 'prepareExtractedAndAttachedSoftwareSystemClose' must not be null";
        TFile baseline = this.f.getExtension(SystemDiffExtension.class).getActiveBaseline();
        if (baseline != null && baseline.lastModified() > this.l) {
            return true;
        }
        if (baseline == null && this.k != null || baseline != null && this.k == null) {
            return true;
        }
        if (baseline != null && this.k != null && !FileUtility.areEqual((TFile)baseline, (TFile)new TFile(this.k))) {
            return true;
        }
        List<File> fileList = this.a((File)directory);
        if (fileList.size() != this.j.size()) {
            return true;
        }
        for (File nextFile : this.j) {
            if (nextFile.exists() && nextFile.lastModified() <= this.l) continue;
            return true;
        }
        return false;
    }

    IPathValidator f() {
        return new IPathValidator(){

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.FILE;
            }

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null) {
                    result.addError("A target file must be specified.");
                } else if (newInput.isDirectory()) {
                    result.addError("A target file must be specified not a directory.");
                } else if (!newInput.getName().endsWith(CoreFileType.SNAPSHOT.getDefaultExtension())) {
                    result.addWarning("'" + CoreFileType.SNAPSHOT.getDefaultExtension() + "' extension will be added automatically.");
                }
                return result;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(String sourceFilePath, String targetFilePath, OperationResult result) {
        String tmpTargetFilePath;
        File targetFile;
        block64: {
            if (!a) {
                if (sourceFilePath == null) throw new AssertionError((Object)"Parameter 'sourceFilePath' of method 'saveSnapshotTo' must not be empty");
                if (sourceFilePath.length() <= 0) {
                    throw new AssertionError((Object)"Parameter 'sourceFilePath' of method 'saveSnapshotTo' must not be empty");
                }
            }
            if (!a) {
                if (targetFilePath == null) throw new AssertionError((Object)"Parameter 'targetFilePath' of method 'saveSnapshotTo' must not be empty");
                if (targetFilePath.length() <= 0) {
                    throw new AssertionError((Object)"Parameter 'targetFilePath' of method 'saveSnapshotTo' must not be empty");
                }
            }
            assert (result != null) : "Parameter 'result' of method 'saveSnapshotTo' must not be null";
            File sourceFile = new File(sourceFilePath);
            targetFile = new File(targetFilePath);
            tmpTargetFilePath = String.valueOf(targetFilePath) + ".tmp";
            String systemDirectoryName = this.f.getSystemDirectoryFile().getName();
            File systemDirectory = new File(this.f.getSystemDirectoryFile().getAbsolutePath());
            ByteBuffer buffer = ByteBuffer.allocateDirect(262144);
            File analyzerResultDirectory = new File((File)this.f.getHiddenDataDirectory(), "AnalyzerResults");
            boolean fetchAnalyzerResultsFromDisk = analyzerResultDirectory.exists();
            try {
                Throwable throwable = null;
                Object var13_16 = null;
                try {
                    FileInputStream fis = new FileInputStream(sourceFile);
                    try {
                        block63: {
                            ZipInputStream zis = new ZipInputStream(fis);
                            try {
                                block62: {
                                    ReadableByteChannel rbc = Channels.newChannel(zis);
                                    try {
                                        block61: {
                                            FileOutputStream fos = new FileOutputStream(tmpTargetFilePath);
                                            try {
                                                block60: {
                                                    ZipOutputStream zos = new ZipOutputStream(fos);
                                                    try {
                                                        block58: {
                                                            try (WritableByteChannel wbc = Channels.newChannel(zos);){
                                                                this.a(systemDirectoryName, systemDirectory, zos, wbc, buffer);
                                                                while (true) {
                                                                    ZipEntry ze;
                                                                    if ((ze = zis.getNextEntry()) == null) {
                                                                        TFile baseLine;
                                                                        if (fetchAnalyzerResultsFromDisk) {
                                                                            this.a("AnalyzerResults", analyzerResultDirectory, zos, wbc, buffer);
                                                                        }
                                                                        if ((baseLine = this.f.getExtension(SystemDiffExtension.class).getActiveBaseline()) == null) break block58;
                                                                        zos.putNextEntry(new ZipEntry(baseLine.getName()));
                                                                        Throwable throwable2 = null;
                                                                        Object var23_34 = null;
                                                                        try {
                                                                            FileInputStream fis2 = new FileInputStream((File)baseLine);
                                                                            try {
                                                                                try (ReadableByteChannel rbc2 = Channels.newChannel(fis2);){
                                                                                    this.a(buffer, rbc2, wbc);
                                                                                }
                                                                                if (fis2 == null) break;
                                                                            }
                                                                            catch (Throwable throwable3) {
                                                                                if (throwable2 == null) {
                                                                                    throwable2 = throwable3;
                                                                                } else if (throwable2 != throwable3) {
                                                                                    throwable2.addSuppressed(throwable3);
                                                                                }
                                                                                if (fis2 == null) throw throwable2;
                                                                                fis2.close();
                                                                                throw throwable2;
                                                                            }
                                                                            fis2.close();
                                                                            break;
                                                                        }
                                                                        catch (Throwable throwable4) {
                                                                            if (throwable2 == null) {
                                                                                throwable2 = throwable4;
                                                                                throw throwable2;
                                                                            }
                                                                            if (throwable2 == throwable4) throw throwable2;
                                                                            throwable2.addSuppressed(throwable4);
                                                                            throw throwable2;
                                                                        }
                                                                    }
                                                                    String entryName = ze.getName();
                                                                    if (entryName.startsWith(systemDirectoryName)) continue;
                                                                    if (entryName.startsWith("AnalyzerResults")) {
                                                                        if (fetchAnalyzerResultsFromDisk) continue;
                                                                        ZipEntry ze2 = new ZipEntry(entryName);
                                                                        ze2.setLastModifiedTime(ze.getLastModifiedTime());
                                                                        zos.putNextEntry(ze2);
                                                                        this.a(buffer, rbc, wbc);
                                                                        zos.closeEntry();
                                                                        continue;
                                                                    }
                                                                    if (entryName.endsWith(".xml") && !entryName.contains("/")) continue;
                                                                    zos.putNextEntry(new ZipEntry(entryName));
                                                                    this.a(buffer, rbc, wbc);
                                                                    zos.closeEntry();
                                                                }
                                                                zos.closeEntry();
                                                            }
                                                        }
                                                        if (zos == null) break block60;
                                                    }
                                                    catch (Throwable throwable5) {
                                                        if (throwable == null) {
                                                            throwable = throwable5;
                                                        } else if (throwable != throwable5) {
                                                            throwable.addSuppressed(throwable5);
                                                        }
                                                        if (zos == null) throw throwable;
                                                        zos.close();
                                                        throw throwable;
                                                    }
                                                    zos.close();
                                                }
                                                if (fos == null) break block61;
                                            }
                                            catch (Throwable throwable6) {
                                                if (throwable == null) {
                                                    throwable = throwable6;
                                                } else if (throwable != throwable6) {
                                                    throwable.addSuppressed(throwable6);
                                                }
                                                if (fos == null) throw throwable;
                                                fos.close();
                                                throw throwable;
                                            }
                                            fos.close();
                                        }
                                        if (rbc == null) break block62;
                                    }
                                    catch (Throwable throwable7) {
                                        if (throwable == null) {
                                            throwable = throwable7;
                                        } else if (throwable != throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                        if (rbc == null) throw throwable;
                                        rbc.close();
                                        throw throwable;
                                    }
                                    rbc.close();
                                }
                                if (zis == null) break block63;
                            }
                            catch (Throwable throwable8) {
                                if (throwable == null) {
                                    throwable = throwable8;
                                } else if (throwable != throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                                if (zis == null) throw throwable;
                                zis.close();
                                throw throwable;
                            }
                            zis.close();
                        }
                        if (fis == null) break block64;
                    }
                    catch (Throwable throwable9) {
                        if (throwable == null) {
                            throwable = throwable9;
                        } else if (throwable != throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        if (fis == null) throw throwable;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                }
                catch (Throwable throwable10) {
                    if (throwable == null) {
                        throwable = throwable10;
                        throw throwable;
                    }
                    if (throwable == throwable10) throw throwable;
                    throwable.addSuppressed(throwable10);
                    throw throwable;
                }
            }
            catch (IOException e2) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e2);
                File toDelete = new File(tmpTargetFilePath);
                toDelete.delete();
                return;
            }
        }
        try {
            if (targetFile.exists()) {
                TrueZipFacade.clear((TFile)new TFile(targetFile));
                targetFile.delete();
            }
            Files.move(Paths.get(tmpTargetFilePath, new String[0]), targetFile.toPath(), new CopyOption[0]);
            return;
        }
        catch (IOException e3) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void a(ByteBuffer buffer, ReadableByteChannel rbc, WritableByteChannel wbc) throws IOException {
        if (!aM.a && rbc == null) {
            throw new AssertionError((Object)"Parameter 'rbc' of method 'copyContent' must not be null");
        }
        if (aM.a || wbc != null) ** GOTO lbl9
        throw new AssertionError((Object)"Parameter 'wbc' of method 'copyContent' must not be null");
lbl-1000:
        // 1 sources

        {
            NioBufferJdk8Compatibility.flip((Buffer)buffer);
            wbc.write(buffer);
            NioBufferJdk8Compatibility.clear((Buffer)buffer);
lbl9:
            // 2 sources

            ** while (rbc.read((ByteBuffer)buffer) > 0)
        }
lbl10:
        // 1 sources

    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(String prefix, File dir, ZipOutputStream zos, WritableByteChannel wbc, ByteBuffer buffer) throws IOException {
        assert (dir != null) : "Parameter 'dir' of method 'copyDirectoryToSnapshot' must not be null";
        File[] files = dir.listFiles();
        if (files == null) return;
        File[] fileArray = files;
        int n2 = files.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray[n3];
            if (file.isDirectory()) {
                this.a(String.format("%s/%s", prefix, file.getName()), file, zos, wbc, buffer);
            } else {
                block18: {
                    ZipEntry ze = new ZipEntry(String.format("%s/%s", prefix, file.getName()));
                    ze.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
                    zos.putNextEntry(ze);
                    Throwable throwable = null;
                    Object var13_14 = null;
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        try {
                            try (ReadableByteChannel rbc = Channels.newChannel(fis);){
                                this.a(buffer, rbc, wbc);
                            }
                            if (fis == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (fis == null) throw throwable;
                            fis.close();
                            throw throwable;
                        }
                        fis.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                zos.closeEntry();
            }
            ++n3;
        }
        return;
    }

    static void a(a extractionInfo, OperationResult result) {
        assert (extractionInfo != null) : "Parameter 'extractionInfo' of method 'finishFailedExtraction' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishFailedExtraction' must not be null";
        try {
            extractionInfo.a().rm_r();
        }
        catch (IOException e2) {
            result.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)e2);
        }
        TFile targetBaseline = extractionInfo.b();
        if (targetBaseline != null) {
            try {
                targetBaseline.rm();
            }
            catch (IOException e3) {
                result.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)e3);
            }
        }
    }

    private void a(File file, List<File> collector) {
        assert (file != null) : "Parameter 'file' of method 'collectFiles' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectFiles' must not be null";
        File[] fileList = file.listFiles();
        if (fileList == null) {
            return;
        }
        File[] fileArray = fileList;
        int n2 = fileList.length;
        int n3 = 0;
        while (n3 < n2) {
            File nextFile = fileArray[n3];
            if (nextFile.isDirectory()) {
                this.a(nextFile, collector);
            } else {
                collector.add(nextFile);
            }
            ++n3;
        }
    }

    private List<File> a(File directory) {
        assert (directory != null) : "Parameter 'directory' of method 'createFileList' must not be null";
        ArrayList<File> files = new ArrayList<File>();
        this.a(directory, files);
        return files;
    }

    void b(a extractionInfo, OperationResult result) {
        assert (extractionInfo != null) : "Parameter 'extractionInfo' of method 'finishSuccessfulExtraction' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishfinishSuccessfulExtractionSucessfulExtraction' must not be null";
        this.j = this.a(new File(extractionInfo.a().getAbsolutePath()));
        TFile targetBaseline = extractionInfo.b();
        if (targetBaseline != null) {
            this.k = new File(targetBaseline.getAbsolutePath());
        }
        this.l = System.currentTimeMillis();
    }

    OperationResult a(IWorkerContext workerContext, TFile saveTo, boolean delete) {
        assert (this.f.getMode().equals((Object)SoftwareSystemMode.SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT)) : "Wrong mode: " + (Object)((Object)this.f.getMode());
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareExtractedAndAttachedSoftwareSystemClose' must not be null";
        OperationResult result = new OperationResult("Prepare extracted and attached system close");
        if (saveTo != null) {
            workerContext.working("Check analyzers", true);
            this.f.getExtension(c.class).a(workerContext);
            String targetSnapshotFilePath = saveTo.getName().endsWith(CoreFileType.SNAPSHOT.getDefaultExtension()) ? saveTo.getAbsolutePath() : String.valueOf(saveTo.getAbsolutePath()) + CoreFileType.SNAPSHOT.getDefaultExtension();
            workerContext.working("Update target snapshot file '" + targetSnapshotFilePath + "'", true);
            TFile sourceSnapshotFile = this.f.getSnapshot();
            assert (sourceSnapshotFile != null) : "'sourceSnapshotFile' of method 'prepareExtractedAndAttachedSoftwareSystemClose' must not be null";
            this.a(sourceSnapshotFile.getAbsolutePath(), targetSnapshotFilePath, result);
        }
        if (delete) {
            workerContext.working("Delete extracted system files", true);
            TFile directory = this.f.getSystemDirectoryFile();
            assert (directory != null) : "Parameter 'directory' of method 'prepareExtractedAndAttachedSoftwareSystemClose' must not be null";
            try {
                TFile.rm_r((File)directory);
            }
            catch (IOException e2) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)e2);
            }
            if (this.k != null) {
                try {
                    TFile.rm((File)this.k);
                }
                catch (IOException e3) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)e3);
                }
            }
        }
        return result;
    }

    static final class a {
        private final TFile b;
        private final TFile c;

        a(TFile targetSystemDirectory, TFile targetBaseline) {
            assert (targetSystemDirectory != null) : "Parameter 'targetSystemDirectory' of method 'ExtractionInfo' must not be null";
            this.b = targetSystemDirectory;
            this.c = targetBaseline;
        }

        TFile a() {
            return this.b;
        }

        public TFile b() {
            return this.c;
        }
    }

    private static class b
    extends StandardFilePathValidator {
        public b() {
            super(CoreFileType.SNAPSHOT);
        }

        @Override
        protected boolean exists(TFile file) {
            assert (file != null) : "Parameter 'file' of method 'exists' must not be null";
            File asFile = new File(FileUtility.getIdentifyingPath((TFile)file));
            return asFile.exists();
        }

        @Override
        protected boolean canRead(TFile file) {
            assert (file != null) : "Parameter 'file' of method 'canRead' must not be null";
            File asFile = new File(FileUtility.getIdentifyingPath((TFile)file));
            return asFile.canRead();
        }
    }
}

