/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryDoesNotExist;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootPathNoReadPermission;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import de.schlichtherle.truezip.file.TFile;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class aJ
implements IPathValidator {
    private static final Logger b = LoggerFactory.getLogger(aJ.class);
    private final List<Module> c;
    private final IPathValidator.PathType d;
    private final Class<? extends RootDirectoryPath> e;

    public aJ(List<Module> modules, IPathValidator.PathType pathType, Class<? extends RootDirectoryPath> clazz) {
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'RootDirectoryPathValidator' must not be empty";
        assert (pathType != null) : "Parameter 'pathType' of method 'RootDirectoryPathValidator' must not be null";
        assert (pathType == IPathValidator.PathType.DIRECTORY || pathType == IPathValidator.PathType.ARCHIVE_OR_DIRECTORY) : "Unexpected root path type: " + (Object)((Object)pathType);
        assert (clazz != null) : "Parameter 'clazz' of method 'RootDirectoryPathValidator' must not be null";
        this.c = new ArrayList<Module>(modules);
        this.d = pathType;
        this.e = clazz;
    }

    @Override
    public IPathValidator.PathType getType() {
        return this.d;
    }

    @Override
    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (newInput == null || newInput.getPath().isEmpty()) {
            result.addError("Must not be empty");
        } else {
            if (!newInput.exists()) {
                result.addWarning("Root path does not exist");
            } else if (this.d == IPathValidator.PathType.ARCHIVE_OR_DIRECTORY) {
                if (!newInput.isDirectory() && !FileUtility.isArchive((TFile)newInput)) {
                    result.addWarning("Neither an archive nor a directory");
                }
            } else if (!newInput.isDirectory()) {
                result.addWarning("Not a directory");
            }
            for (Module nextModule : this.c) {
                for (RootDirectoryPath rootDirectoryPath : nextModule.getChildren(this.e, true)) {
                    if (!FileUtility.areEqual((TFile)newInput, (TFile)rootDirectoryPath.getDirectoryFile())) continue;
                    result.addError("Root path already present in module: '" + nextModule.getName() + "'");
                }
            }
        }
        return result;
    }

    public static void a(RootDirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'removeIssues' must not be null";
        path.removeIssues(CoreIssueId.ROOT_PATH_DOES_NOT_EXIST, CoreIssueId.ROOT_PATH_NO_READ_PERMISSION);
    }

    public static boolean b(RootDirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'validate' must not be null";
        aJ.a(path);
        boolean result = true;
        try {
            TFile rootDir = path.getFile();
            if (rootDir.isDirectory()) {
                if (!rootDir.canRead()) {
                    path.addIssue(new RootPathNoReadPermission(path));
                    result = false;
                }
            } else {
                path.addIssue(new RootDirectoryDoesNotExist(path));
                result = false;
            }
        }
        catch (InvalidPathException ex) {
            b.error("Failed to validate path: ", (Throwable)ex);
            path.addIssue(new RootDirectoryDoesNotExist(path));
        }
        return result;
    }
}

