/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.CollectionUtility;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.foundation.common.base.IStructureId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistry;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistryNode;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class aH
extends Extension
implements IRepresentationProvider {
    protected abstract StructureItemRegistry e();

    @Override
    public final StructureItemRegistryNode getRootNodeForStructure() {
        StructureItemRegistryNode rootNode = new StructureItemRegistryNode("Structure Item Registry", "ProgrammingLanguages");
        for (Map.Entry<IStructureId, Pair<StructureInfo, StructureInfo>> entry : this.e().getAllStructures().entrySet()) {
            StructureItemRegistryNode parentOfItemNodes;
            Pair<StructureInfo, StructureInfo> pair = entry.getValue();
            boolean isLogical = pair.getSecond() == null;
            StructureItemRegistryNode languageNode = new StructureItemRegistryNode(entry.getKey().toString(), entry.getKey().getImageResourceName());
            rootNode.addChild(languageNode);
            StructureItemRegistryNode structureItemRegistryNode = parentOfItemNodes = isLogical ? languageNode : new StructureItemRegistryNode("Physical", null);
            if (languageNode != parentOfItemNodes) {
                languageNode.addChild(parentOfItemNodes);
            }
            for (IStructureItem item : ((StructureInfo)pair.getFirst()).getItemList()) {
                StructureItemRegistryNode itemNode = new StructureItemRegistryNode(item.toString(), item.getImageResourceName());
                parentOfItemNodes.addChild(itemNode);
            }
            if (isLogical) continue;
            StructureItemRegistryNode architectureNode = new StructureItemRegistryNode("Architecture", null);
            languageNode.addChild(architectureNode);
            for (IStructureItem item : ((StructureInfo)pair.getSecond()).getItemList()) {
                StructureItemRegistryNode itemNode = new StructureItemRegistryNode(item.toString(), item.getImageResourceName());
                architectureNode.addChild(itemNode);
            }
        }
        return rootNode;
    }

    @Override
    public final List<Element> filterElementsForShowInView(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'filterElementsForShowInView' must not be null";
        for (Element element : elements) {
            if (!(element instanceof Filter) && !(element instanceof Pattern)) continue;
            return Collections.emptyList();
        }
        if (elements.size() == 1) {
            return this.a(elements.get(0).getElement());
        }
        ArchitectureFile nextArchitectureFile = null;
        ArrayList<Element> elementsForShowInView = new ArrayList<Element>();
        for (Element element : elements) {
            Element candidate;
            if (element instanceof IDiffElement) {
                candidate = ((IDiffElement)((Object)element)).getCurrentElement();
                if (candidate == null) {
                    continue;
                }
            } else {
                candidate = element;
            }
            if (candidate instanceof Issue || candidate instanceof CycleGroup || candidate instanceof ArchitectureFile || candidate instanceof RepresentationEdge) {
                return Collections.emptyList();
            }
            if (candidate instanceof RepresentationNode) {
                candidate = ((RepresentationNode)candidate).getUnderlyingObject();
            }
            if (candidate instanceof NamedElementProxy) {
                candidate = candidate.getElement();
            }
            if (!(candidate instanceof NamedElement)) continue;
            NamedElement nextNamedElement = (NamedElement)candidate;
            IDomainRoot.Domain nextDomain = nextNamedElement.getDomain();
            if (nextDomain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || nextDomain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
                if (nextArchitectureFile == null) {
                    nextArchitectureFile = nextNamedElement.getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT);
                } else if (nextArchitectureFile != nextNamedElement.getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT)) {
                    return Collections.emptyList();
                }
            }
            if (!RepresentationUtility.isValidElementForRepresentation(nextNamedElement)) continue;
            elementsForShowInView.add(nextNamedElement);
        }
        return elementsForShowInView;
    }

    private List<Element> a(Element element) {
        Element candidate;
        assert (element != null) : "Parameter 'element' of method 'handleSingleElement' must not be null";
        if (element instanceof IDiffElement) {
            candidate = ((IDiffElement)((Object)element)).getCurrentElement();
            if (candidate == null) {
                return Collections.emptyList();
            }
        } else {
            candidate = element;
        }
        if (candidate instanceof Issue) {
            candidate = ((Issue)candidate).getAffectedElement();
        } else if (candidate instanceof RepresentationNode) {
            candidate = ((RepresentationNode)candidate).getUnderlyingObject();
        }
        if (candidate instanceof RepresentationEdge) {
            RepresentationEdge edge = (RepresentationEdge)candidate;
            boolean include = false;
            for (Dependency nextDependency : edge.getDependencies()) {
                if (nextDependency instanceof ParserDependency) {
                    if (!RepresentationUtility.PD.test((ParserDependency)nextDependency)) continue;
                    include = true;
                    break;
                }
                include = true;
                break;
            }
            if (!include) {
                return Collections.emptyList();
            }
            NamedElement from = edge.getFromEndPoint();
            NamedElement to = edge.getToEndPoint();
            if (RepresentationUtility.isValidElementForRepresentation(from) && RepresentationUtility.isValidElementForRepresentation(to)) {
                ArrayList<Element> elementsForShowInView = new ArrayList<Element>();
                if (from instanceof OnDemandCycleGroup) {
                    elementsForShowInView.addAll(((OnDemandCycleGroup)from).getCyclicNamedElements());
                    elementsForShowInView.add(to);
                    return elementsForShowInView;
                }
                if (to instanceof OnDemandCycleGroup) {
                    elementsForShowInView.add(from);
                    elementsForShowInView.addAll(((OnDemandCycleGroup)to).getCyclicNamedElements());
                    return elementsForShowInView;
                }
                return Arrays.asList(from, to);
            }
            return Collections.emptyList();
        }
        if (candidate instanceof CycleGroup) {
            if (RepresentationUtility.isValidElementForRepresentation((CycleGroup)candidate)) {
                return Arrays.asList(candidate);
            }
            return Collections.emptyList();
        }
        if (candidate instanceof ArchitectureFile) {
            List children;
            ArchitectureFile file = (ArchitectureFile)candidate;
            if (file.isChecked() && !(children = CollectionUtility.select(file.getAllChildren(RepresentationUtility.REPRESENTATION_FILTER), namedElement -> RepresentationUtility.isValidElementForRepresentation(namedElement))).isEmpty()) {
                return Arrays.asList(file);
            }
            return Collections.emptyList();
        }
        if (candidate instanceof NamedElement && RepresentationUtility.isValidElementForRepresentation((NamedElement)candidate)) {
            return Arrays.asList(candidate);
        }
        return Collections.emptyList();
    }
}

