/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.m;
import com.hello2morrow.sonargraph.core.controller.system.remoting.RemoteSelectionClient;
import com.hello2morrow.sonargraph.core.controller.system.remoting.a;
import com.hello2morrow.sonargraph.core.controllerinterface.system.t;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.RemoteSelectionRequestEvent;
import com.hello2morrow.sonargraph.core.model.event.RemoteSelectionServerStatusEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteConfiguration;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteSelectionData;
import com.hello2morrow.sonargraph.core.model.remoting.SelectionData;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.remote.ConfigurationPersistence;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class aF
extends OptionalExtension
implements m,
t {
    private static final Logger b = LoggerFactory.getLogger(aF.class);
    private static final String c = "RemoteConnection.properties";
    private final List<RemoteSelectionData> e = new ArrayList<RemoteSelectionData>();
    private final Installation f;
    private final SonargraphProduct g;
    private final INamedElementResolver h;
    private a i;
    private SoftwareSystem j;

    public aF(Installation installation, SonargraphProduct product, INamedElementResolver resolver, g finishModelProcessor, boolean enabled) {
        super(enabled);
        assert (installation != null) : "Parameter 'installation' of method 'RemoteSelectionExtension' must not be null";
        assert (product != null) : "Parameter 'product' of method 'RemoteSelectionExtension' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'RemoteSelectionExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'RemoteSelectionExtension' must not be null";
        this.f = installation;
        this.g = product;
        this.h = resolver;
        finishModelProcessor.a(this);
    }

    private String a(int port) {
        if (this.i == null) {
            try {
                this.i = new a(this, port);
                this.i.start();
                b.info("Started HTTP server listening on port '" + port + "'");
                return null;
            }
            catch (Exception e2) {
                this.i = null;
                b.error("Failed to start HTTP server listening on port '" + port + "' - " + e2.getLocalizedMessage());
                return e2.getLocalizedMessage();
            }
        }
        b.warn("Http server already running");
        return "Http server already running";
    }

    private String d() {
        if (this.i != null) {
            try {
                this.i.a();
                this.i = null;
                b.info("Stopped HTTP server");
                return null;
            }
            catch (Exception e2) {
                b.error("Failed to stop HTTP server - " + e2.getLocalizedMessage());
                return e2.getLocalizedMessage();
            }
        }
        b.warn("Http server not running");
        return "Http server not running";
    }

    @Override
    public void finishInstallationInitialization() {
        RemoteConfiguration configuration;
        OperationResultWithOutcome<RemoteConfiguration> configurationResult;
        if (this.isEnabled() && (configurationResult = this.e()).isSuccess() && (configuration = (RemoteConfiguration)configurationResult.getOutcome()).isEnabled()) {
            this.a(configuration.getServerPort());
        }
    }

    @Override
    public OperationResultWithOutcome<RemoteConfiguration> getConfiguration() {
        return this.e();
    }

    @Override
    public RemoteConfiguration getDefaultConfiguration() {
        int defaultServerPort = -1;
        int defaultRemotePort = -1;
        switch (this.g) {
            case SONARGRAPH: {
                defaultServerPort = 42420;
                defaultRemotePort = 42421;
                break;
            }
            case SONARGRAPH_BUILD: {
                break;
            }
            case SONARGRAPH_ECLIPSE: 
            case SONARGRAPH_INTELLI_J: {
                defaultServerPort = 42421;
                defaultRemotePort = 42420;
                break;
            }
            default: {
                assert (false) : "Unspported product: " + this.g.getPresentationName();
                break;
            }
        }
        return new RemoteConfiguration(false, defaultServerPort, false, defaultRemotePort);
    }

    @Override
    public boolean isRemoteListening() {
        OperationResultWithOutcome<RemoteConfiguration> configurationResult;
        if (this.isEnabled() && (configurationResult = this.e()).isSuccess()) {
            int remotePort = ((RemoteConfiguration)configurationResult.getOutcome()).getRemotePort();
            try {
                new ServerSocket(remotePort).close();
                return false;
            }
            catch (IOException e2) {
                return true;
            }
        }
        return false;
    }

    private OperationResultWithOutcome<RemoteConfiguration> e() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load current configuration for communication");
        RemoteConfiguration defaultConfiguration = this.getDefaultConfiguration();
        if (defaultConfiguration.getServerPort() == -1) {
            result.setOutcome(null);
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.UNSUPPORTED_PRODUCT, String.valueOf(this.g.getPresentationName()) + " does not support remote communication.", new Object[0]);
            return result;
        }
        TFile configDir = CoreResourceProviderAdapter.getInstance().getProductsConfigurationDirectory();
        if (configDir == null) {
            result.addWarning((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_LOAD_CONFIGURATION, "Failed to load remote connection properties. Working with defaults.", new Object[0]);
            result.setOutcome((Object)defaultConfiguration);
            return result;
        }
        TFile propsFile = new TFile((File)configDir, c);
        if (!propsFile.exists()) {
            result.setOutcome((Object)defaultConfiguration);
            return result;
        }
        ConfigurationPersistence reader = new ConfigurationPersistence(propsFile, this.g);
        RemoteConfiguration configuration = reader.load(defaultConfiguration.getServerPort(), defaultConfiguration.getRemotePort(), (OperationResult)result);
        if (result.isSuccess()) {
            result.setOutcome((Object)configuration);
        }
        return result;
    }

    @Override
    public void shutdown() {
        if (this.isServerRunning()) {
            this.d();
        }
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initialized' must not be null";
        this.j = softwareSystem;
    }

    @Override
    public void a(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'released' must not be null";
        assert (this.j == softwareSystem) : "Different system instances";
        this.j = null;
    }

    @Override
    public synchronized OperationResult handleSelection(Version version, String systemPath, List<RemoteSelectionData> selectionData) {
        assert (version != null) : "Parameter 'version' of method 'handleSelection' must not be null";
        assert (systemPath != null) : "Parameter 'systemPath' of method 'handleSelection' must not be null";
        assert (selectionData != null && !selectionData.isEmpty()) : "Parameter 'descriptors' of method 'handleSelection' must not be empty";
        OperationResult result = new OperationResult("Received (multi) selection request");
        this.a(version, systemPath, result);
        if (result.isFailure()) {
            return result;
        }
        this.e.clear();
        this.e.addAll(selectionData);
        if (this.j == null) {
            return result;
        }
        List<String> identifiers = selectionData.stream().map(s2 -> s2.getDescriptor()).collect(Collectors.toList());
        EventManager.getInstance().dispatch((Object)this, (Event)new RemoteSelectionRequestEvent(this.j.getExtension(ISoftwareSystemProvider.class), identifiers));
        return result;
    }

    private void a(Version version, String systemPath, OperationResult result) {
        if (this.j != null && !systemPath.equals(this.j.getAbsolutePath())) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.SYSTEM_MISMATCH, "System path from request '" + systemPath + "' does not match current system '" + this.j.getAbsolutePath() + "'.", new Object[0]);
        } else if (this.j == null) {
            String message = "Caching selection request for system " + systemPath;
            result.addWarning((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.SYSTEM_MISSING, message, new Object[0]);
            b.info("", (Object)systemPath);
        }
        if (new Version.VersionComparator().compare(this.f.getVersion(), version) != 0) {
            result.addWarning((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.VERSION_MISMATCH, "Product version of request (" + version + ") is different from this version (" + this.f.getVersion() + ").", new Object[0]);
        }
    }

    public synchronized OperationResult a(Version version, String systemFilePath, RemoteSelectionData data) {
        assert (version != null) : "Parameter 'version' of method 'handleSingleSelection' must not be null";
        assert (systemFilePath != null && systemFilePath.length() > 0) : "Parameter 'systemFilePath' of method 'handleSingleSelection' must not be empty";
        assert (data != null) : "Parameter 'data' of method 'handleSingleSelection' must not be null";
        OperationResult result = new OperationResult("Received (single) selection request");
        this.a(version, systemFilePath, result);
        if (result.isFailure()) {
            return result;
        }
        this.e.clear();
        this.e.add(data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResultWithOutcome<StrictPair<List<SelectionData>, List<String>>> a(IWorkerContext context) {
        assert (this.j != null) : "Software system must be present to reveal remote selection.";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Determine elements for the requested descriptors");
        ArrayList<RemoteSelectionData> requested = new ArrayList<RemoteSelectionData>();
        aF aF2 = this;
        synchronized (aF2) {
            assert (this.e != null && !this.e.isEmpty()) : "'m_requestedSelectionData' of method 'getNamedElementsForSelection' must not be empty";
            requested.addAll(this.e);
        }
        ArrayList<SelectionData> matchedElements = new ArrayList<SelectionData>();
        ArrayList<String> unmatchedDescriptors = new ArrayList<String>();
        for (RemoteSelectionData next : requested) {
            Element found = this.h.resolve(next.getDescriptor());
            if (found == null) {
                b.warn("No element found for descriptor '{}'", (Object)next);
                unmatchedDescriptors.add(next.getDescriptor());
            }
            if (!(found instanceof NamedElement)) continue;
            SelectionData data = null;
            NamedElement namedElement = (NamedElement)found;
            int line = next.getLine() > 0 ? next.getLine() : namedElement.getLineNumber();
            FilePath source = this.a(namedElement);
            if (source != null) {
                data = new SelectionData(namedElement, source, line <= 0 ? 1 : line);
            }
            if (data == null) {
                data = new SelectionData(namedElement);
            }
            matchedElements.add(data);
        }
        result.setOutcome((Object)new StrictPair(matchedElements, unmatchedDescriptors));
        return result;
    }

    private void a(RemoteConfiguration configuration, OperationResult result) {
        assert (configuration != null) : "Parameter 'configuration' of method 'updateConfiguration' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateConfiguration' must not be null";
        TFile configDir = CoreResourceProviderAdapter.getInstance().getProductsConfigurationDirectory();
        if (configDir == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, "Failed to create directory to persist remote connection properties", new Object[0]);
            return;
        }
        TFile propsFile = new TFile((File)configDir, c);
        ConfigurationPersistence persistence = new ConfigurationPersistence(propsFile, this.g);
        persistence.save(configuration);
    }

    @Override
    public synchronized OperationResult a() {
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.e();
        if (configResult.isFailure()) {
            return configResult;
        }
        RemoteConfiguration configuration = (RemoteConfiguration)configResult.getOutcome();
        OperationResult result = new OperationResult("Starting HTTP server");
        String failureMessage = this.a(configuration.getServerPort());
        if (failureMessage != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_START_SERVER, failureMessage, new Object[0]);
        } else {
            String detail = SonargraphProduct.SONARGRAPH.equals((Object)this.g) ? " from IDE." : " from Sonargraph.";
            result.addInfo((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.STARTED_SERVER, "Successfully started HTTP server listening on port '" + configuration.getServerPort() + "' to remote selection requests" + detail);
        }
        RemoteConfiguration newConfig = new RemoteConfiguration(true, configuration.getServerPort(), configuration.isRemoteEnabled(), configuration.getRemotePort());
        this.a(newConfig, result);
        EventManager.getInstance().dispatch((Object)this, (Event)new RemoteSelectionServerStatusEvent(this.f.getExtension(ISoftwareSystemProvider.class), this.i != null));
        return result;
    }

    @Override
    public synchronized OperationResult b() {
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.e();
        if (configResult.isFailure()) {
            return configResult;
        }
        RemoteConfiguration configuration = (RemoteConfiguration)configResult.getOutcome();
        OperationResult result = new OperationResult("Stopping HTTP server");
        String failureMessage = this.d();
        if (failureMessage != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_STOP_SERVER, failureMessage, new Object[0]);
        } else {
            String detail = SonargraphProduct.SONARGRAPH.equals((Object)this.g) ? " from IDE." : " from Sonargraph.";
            result.addInfo((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.STOPPED_SERVER, "Successfully stopped HTTP server listening on port '" + configuration.getServerPort() + "' to remote selection requests" + detail);
        }
        RemoteConfiguration newConfig = new RemoteConfiguration(false, configuration.getServerPort(), configuration.isRemoteEnabled(), configuration.getRemotePort());
        this.a(newConfig, result);
        EventManager.getInstance().dispatch((Object)this, (Event)new RemoteSelectionServerStatusEvent(this.f.getExtension(ISoftwareSystemProvider.class), this.i != null));
        return result;
    }

    @Override
    public synchronized boolean hasRemoteSelection() {
        return !this.e.isEmpty();
    }

    @Override
    public int a(SonargraphProduct product) {
        assert (product != null) : "Parameter 'product' of method 'getDefaultPort' must not be null";
        switch (product) {
            case SONARGRAPH: {
                return 42420;
            }
            case SONARGRAPH_BUILD: {
                return -1;
            }
            case SONARGRAPH_ECLIPSE: 
            case SONARGRAPH_INTELLI_J: {
                return 42421;
            }
        }
        return -1;
    }

    @Override
    public boolean isServerRunning() {
        return this.i != null;
    }

    @Override
    public OperationResult a(NamedElement element, int lineNumber) {
        assert (element != null) : "Parameter 'element' of method 'sendSingleSelectionEvent' must not be null";
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.e();
        if (configResult.isFailure()) {
            return configResult;
        }
        RemoteConfiguration config = (RemoteConfiguration)configResult.getOutcome();
        assert (config != null) : "RemoteConfiguration must not be null";
        RemoteSelectionClient client = new RemoteSelectionClient(config.getRemotePort());
        FilePath sourceFile = this.a(element);
        RemoteSelectionData data = new RemoteSelectionData(this.h.getDescriptor(element), sourceFile != null ? sourceFile.getAbsolutePath() : null, lineNumber >= 0 ? lineNumber : element.getLineNumber());
        return client.a(this.f.getVersion(), this.j.getAbsolutePath(), data);
    }

    private FilePath a(NamedElement element) {
        ILanguageProvider languageProvider;
        assert (element != null) : "Parameter 'element' of method 'getSourceFileForElement' must not be null";
        Language language = element.getLanguage();
        if (language != null && (languageProvider = this.f.getExtension(ISoftwareSystemProvider.class).getLanguageProvider(language)) != null) {
            return languageProvider.getSourceFile(element);
        }
        return null;
    }

    @Override
    public OperationResult a(List<NamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'sendSelectionRequest' must not be empty";
        OperationResult result = new OperationResult("Send remote selection request");
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.e();
        if (configResult.isFailure()) {
            result.addMessagesFrom(configResult);
            return result;
        }
        RemoteSelectionClient client = new RemoteSelectionClient(((RemoteConfiguration)configResult.getOutcome()).getRemotePort());
        ISoftwareSystemProvider softwareSystemProvider = this.j.getExtension(ISoftwareSystemProvider.class);
        INamedElementResolver resolver = softwareSystemProvider.getElementResolver();
        List<String> fqNames = elements.stream().map(e2 -> resolver.getDescriptor((Element)e2)).collect(Collectors.toList());
        return client.a(this.f.getVersion(), softwareSystemProvider.getSoftwareSystem().getSystemDirectoryFile().getAbsolutePath(), fqNames);
    }

    @Override
    public OperationResult a(RemoteConfiguration modifiedConfiguration) {
        String failureMessage;
        assert (modifiedConfiguration != null) : "Parameter 'modifiedConfiguration' of method 'updateConfiguration' must not be null";
        OperationResult result = new OperationResult("Update configuration for remote selection");
        boolean isRunning = this.i != null;
        boolean failedToStop = false;
        if (isRunning && (failureMessage = this.d()) != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_STOP_SERVER, failureMessage, new Object[0]);
            failedToStop = true;
        }
        this.a(modifiedConfiguration, result);
        if (isRunning && !failedToStop && (failureMessage = this.a(modifiedConfiguration.getServerPort())) != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_START_SERVER, "Failed to restart server with new configuration - " + failureMessage, new Object[0]);
        }
        return result;
    }
}

