/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.a;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramRepresentation;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentConnector;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentInterface;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class a {
    private static Logger b = LoggerFactory.getLogger(a.class);

    private a() {
    }

    private static boolean a(Artifact artifact) {
        assert (artifact != null) : "Parameter 'artifact' of method 'include' must not be null";
        if (artifact.isDeprecated()) {
            return false;
        }
        for (Artifact nextArtifactParent : artifact.getParents(Artifact.class, ArchitectureFile.class)) {
            if (!nextArtifactParent.isDeprecated()) continue;
            return false;
        }
        return true;
    }

    private static boolean a(Connector connector) {
        assert (connector != null) : "Parameter 'connector' of method 'include' must not be null";
        Artifact artifact = connector.getParent(Artifact.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (artifact != null) : "'artifact' of method 'include' must not be null";
        return com.hello2morrow.sonargraph.core.controller.system.a.a.a(artifact);
    }

    private static boolean a(Interface inter) {
        assert (inter != null) : "Parameter 'inter' of method 'include' must not be null";
        Artifact artifact = inter.getParent(Artifact.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (artifact != null) : "'artifact' of method 'include' must not be null";
        return com.hello2morrow.sonargraph.core.controller.system.a.a.a(artifact);
    }

    private static void a(Map<Artifact, UmlComponent> artifactToUmlComponent, UmlComponentInterface umlComponentInterface, Set<UmlComponentInterface> allowedInterfaces) {
        assert (artifactToUmlComponent != null) : "Parameter 'artifactToUmlComponent' of method 'collectExportedInterfacesRecursively' must not be null";
        assert (umlComponentInterface != null) : "Parameter 'umlComponentInterface' of method 'collectExportedInterfacesRecursively' must not be null";
        assert (allowedInterfaces != null) : "Parameter 'allowedInterfaces' of method 'collectExportedInterfacesRecursively' must not be null";
        assert (com.hello2morrow.sonargraph.core.controller.system.a.a.a((Interface)umlComponentInterface.getArchitectureElement())) : "Not included: " + umlComponentInterface;
        for (Interface nextExportedInterface : umlComponentInterface.getExportedInterfaces()) {
            Artifact nextArtifact = nextExportedInterface.getParent(Artifact.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextArtifact != null) : "Parameter 'nextArtifact' of method 'collectExportedInterfacesRecursively' must not be null";
            if (nextArtifact.isDeprecated()) continue;
            UmlComponent nextUmlComponent = artifactToUmlComponent.get(nextArtifact);
            assert (nextUmlComponent != null) : "'nextUmlComponent' of method 'collectExportedInterfacesRecursively' must not be null";
            List<UmlComponentInterface> nextFoundUmlComponentInterfaces = com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextUmlComponent, nextExportedInterface);
            assert (nextFoundUmlComponentInterfaces != null && nextFoundUmlComponentInterfaces.size() == 1) : "'nextFoundUmlComponentInterfaces' of method 'collectExportedInterfacesRecursively' must contain 1 uml component interface";
            allowedInterfaces.add(nextFoundUmlComponentInterfaces.get(0));
            com.hello2morrow.sonargraph.core.controller.system.a.a.a(artifactToUmlComponent, nextFoundUmlComponentInterfaces.get(0), allowedInterfaces);
        }
    }

    private static Set<UmlComponentInterface> a(Map<Artifact, UmlComponent> artifactToUmlComponent, UmlComponentConnector connector, ArchitectureDiagramRepresentation representation) {
        assert (artifactToUmlComponent != null) : "Parameter 'artifactToUmlComponent' of method 'getAllowedInterfaces' must not be null";
        assert (connector != null) : "Parameter 'connector' of method 'getAllowedInterfaces' must not be null";
        assert (com.hello2morrow.sonargraph.core.controller.system.a.a.a((Connector)connector.getArchitectureElement())) : "Not included: " + connector;
        assert (representation != null) : "Parameter 'representation' of method 'getAllowedInterfaces' must not be null";
        THashSet allowedInterfaces = new THashSet();
        UmlComponent component = connector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (component != null) : "'component' of method 'getAllowedInterfaces' must not be null";
        Artifact fromArtifact = component.getArtifact();
        List<UmlComponentInterface> allComponentInterfaces = representation.getChildrenRecursively(UmlComponentInterface.class, new Class[0]);
        for (UmlComponentInterface nextInterface : allComponentInterfaces) {
            com.hello2morrow.sonargraph.core.controller.system.analysis.a.a result;
            assert (com.hello2morrow.sonargraph.core.controller.system.a.a.a((Interface)nextInterface.getArchitectureElement())) : "Not included: " + nextInterface;
            UmlComponent nextToComponent = nextInterface.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextToComponent != null) : "'nextToComponent' of method 'getAllowedInterfaces' must not be null";
            if (fromArtifact == nextToComponent.getArtifact() || !(result = com.hello2morrow.sonargraph.core.controller.system.analysis.a.b.a((Connector)connector.getArchitectureElement(), (Interface)nextInterface.getArchitectureElement())).a()) continue;
            allowedInterfaces.add(nextInterface);
            com.hello2morrow.sonargraph.core.controller.system.a.a.a(artifactToUmlComponent, nextInterface, (Set<UmlComponentInterface>)allowedInterfaces);
        }
        return allowedInterfaces;
    }

    private static List<UmlComponentConnector> a(UmlComponent component, final Connector connector, final boolean includeIncluded) {
        assert (component != null) : "Parameter 'component' of method 'findUmlComponentConnector' must not be null";
        assert (connector != null) : "Parameter 'connector' of method 'findUmlComponentConnector' must not be null";
        return component.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof UmlComponentConnector)) {
                    throw new AssertionError((Object)("Unexpected class in method 'findUmlComponentConnector': " + namedElement));
                }
                UmlComponentConnector umlComponentConnector = (UmlComponentConnector)namedElement;
                if (umlComponentConnector.getArchitectureElement() == connector) {
                    return true;
                }
                if (includeIncluded) {
                    for (Connector nextIncluded : ((Connector)umlComponentConnector.getArchitectureElement()).getIncludedConnectors()) {
                        if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextIncluded) || nextIncluded != connector) continue;
                        return true;
                    }
                }
                return false;
            }
        }, UmlComponentConnector.class);
    }

    private static List<UmlComponentInterface> a(UmlComponent component, final Interface inter) {
        assert (component != null) : "Parameter 'component' of method 'findUmlComponentInterfaces' must not be null";
        assert (inter != null) : "Parameter 'inter' of method 'findUmlComponentInterfaces' must not be null";
        return component.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof UmlComponentInterface)) {
                    throw new AssertionError((Object)("Unexpected class in method 'findUmlComponentInterfaces': " + namedElement));
                }
                UmlComponentInterface umlComponentInterface = (UmlComponentInterface)namedElement;
                return com.hello2morrow.sonargraph.core.controller.system.a.a.a((Interface)umlComponentInterface.getArchitectureElement()) && umlComponentInterface.getArchitectureElement() == inter;
            }
        }, UmlComponentInterface.class);
    }

    private static void a(Artifact artifact, List<Interface> interfaces) {
        assert (artifact != null) : "Parameter 'artifact' of method 'collectExportedChildInterfaces' must not be null";
        assert (com.hello2morrow.sonargraph.core.controller.system.a.a.a(artifact)) : "Not included: " + artifact;
        assert (interfaces != null) : "Parameter 'interfaces' of method 'collectExportedChildInterfaces' must not be null";
        for (Artifact nextChildArtifact : artifact.getChildren(Artifact.class)) {
            if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextChildArtifact) || !nextChildArtifact.isExposed()) continue;
            for (Interface nextInterface : nextChildArtifact.getChildren(Interface.class)) {
                if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextInterface)) continue;
                interfaces.add(nextInterface);
            }
            com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextChildArtifact, interfaces);
        }
    }

    private static void a(NamedElement parent, List<Artifact> artifacts, Map<Artifact, UmlComponent> artifactToUmlComponent, int depth) {
        assert (parent != null) : "Parameter 'parent' of method 'createRecursively' must not be null";
        assert (artifacts != null) : "Parameter 'artifacts' of method 'createComponentsRecursively' must not be null";
        for (Artifact nextArtifact : artifacts) {
            if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextArtifact)) continue;
            UmlComponent nextUmlComponent = new UmlComponent(parent, nextArtifact, depth);
            parent.addChild(nextUmlComponent);
            UmlComponent previous = artifactToUmlComponent.put(nextArtifact, nextUmlComponent);
            assert (previous == null) : "'previous' of method 'createComponentsRecursively' must be null";
            for (Connector nextConnector : nextArtifact.getChildren(Connector.class)) {
                List<UmlComponentConnector> nextUmlComponentConnectors = com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextUmlComponent, nextConnector, false);
                assert (nextUmlComponentConnectors.isEmpty()) : "'nextUmlComponentConnectors' of method 'createComponents' must be empty";
                UmlComponentConnector nextUmlComponentConnector = new UmlComponentConnector((NamedElement)nextUmlComponent, nextConnector, new e());
                nextUmlComponent.addChild(nextUmlComponentConnector);
                for (Connector nextIncludedConnector : nextConnector.getIncludedConnectors()) {
                    if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextIncludedConnector)) continue;
                    nextUmlComponentConnector.addIncludedConnector(nextIncludedConnector);
                }
            }
            for (Interface nextInterface : nextArtifact.getChildren(Interface.class)) {
                List<UmlComponentInterface> nextUmlComponentInterfaces = com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextUmlComponent, nextInterface);
                assert (nextUmlComponentInterfaces.isEmpty()) : "'nextUmlComponentInterfaces' of method 'createComponents' must be empty";
                UmlComponentInterface nextUmlComponentInterface = new UmlComponentInterface((NamedElement)nextUmlComponent, nextInterface, new e());
                nextUmlComponent.addChild(nextUmlComponentInterface);
                for (Interface nextExportedInterface : nextInterface.getExportedInterfaces()) {
                    if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextExportedInterface)) continue;
                    nextUmlComponentInterface.addExportedInterface(nextExportedInterface);
                }
            }
            ArrayList<Interface> exportedInterfaces = new ArrayList<Interface>();
            com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextArtifact, exportedInterfaces);
            for (Interface nextExportedInterface : exportedInterfaces) {
                List<UmlComponentInterface> nextUmlComponentInterfaces = com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextUmlComponent, nextExportedInterface);
                assert (nextUmlComponentInterfaces.isEmpty()) : "'nextUmlComponentInterfaces' of method 'createComponents' must be empty";
                UmlComponentInterface nextUmlComponentInterface = new UmlComponentInterface(nextUmlComponent, nextExportedInterface, true, new e());
                nextUmlComponent.addChild(nextUmlComponentInterface);
                nextUmlComponentInterface.addExportedInterface(nextExportedInterface);
            }
            com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextUmlComponent, nextUmlComponent.getArtifactChildren(), artifactToUmlComponent, depth + 1);
        }
    }

    private static void a(ArchitectureDiagramRepresentation representation, UmlComponent sourceComponent, UmlComponentConnector sourceConnector, UmlComponent targetComponent, UmlComponentInterface targetInterface) {
        assert (representation != null) : "Parameter 'representation' of method 'addAsAllowedInterfaceIfApplicable' must not be null";
        assert (sourceComponent != null) : "Parameter 'sourceComponent' of method 'addAsAllowedInterfaceIfApplicable' must not be null";
        assert (sourceConnector != null) : "Parameter 'sourceConnector' of method 'addAsAllowedInterfaceIfApplicable' must not be null";
        assert (targetComponent != null) : "Parameter 'targetComponent' of method 'addAsAllowedInterfaceIfApplicable' must not be null";
        assert (targetInterface != null) : "Parameter 'targetInterface' of method 'addAsAllowedInterfaceIfApplicable' must not be null";
        if (!targetComponent.hasAsParent(sourceComponent, false) && !sourceComponent.hasAsParent(targetComponent, false)) {
            representation.addAllowedInterface(sourceConnector, targetInterface);
            b.debug("Add allowed interface: [" + sourceComponent.getName() + "] " + sourceConnector.getName() + " -> [" + targetComponent.getName() + "] " + targetInterface.getName());
        }
    }

    private static boolean a(ArchitectureDiagramRepresentation representation, Map<Artifact, UmlComponent> artifactToUmlComponent, UmlComponentConnector sourceUmlComponentConnector, UmlComponentInterface targetUmlComponentInterface) {
        assert (representation != null) : "Parameter 'representation' of method 'processSourceConnector' must not be null";
        assert (artifactToUmlComponent != null) : "Parameter 'artifactToUmlComponent' of method 'processSourceConnector' must not be null";
        assert (sourceUmlComponentConnector != null) : "Parameter 'sourceUmlComponentConnector' of method 'processSourceConnector' must not be null";
        assert (targetUmlComponentInterface != null) : "Parameter 'targetUmlComponentInterface' of method 'processSourceConnector' must not be null";
        UmlComponent sourceUmlComponent = sourceUmlComponentConnector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (sourceUmlComponent != null) : "'sourceUmlComponent' of method 'processSourceConnector' must not be null";
        boolean cont = true;
        UmlComponent parentOfSourceUmlComponent = sourceUmlComponent.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
        if (parentOfSourceUmlComponent != null) {
            ArrayList<UmlComponentConnector> includedByTarget = new ArrayList<UmlComponentConnector>();
            for (UmlComponentConnector nextConnectorInParentComponent : parentOfSourceUmlComponent.getChildren(UmlComponentConnector.class)) {
                Set<Connector> nextIncludedConnectors = nextConnectorInParentComponent.getIncludedConnectors();
                Set<Interface> nextConnectedToInterfaces = nextConnectorInParentComponent.getConnectedToInterfaces();
                if (!nextConnectedToInterfaces.contains(targetUmlComponentInterface.getArchitectureElement()) || !nextIncludedConnectors.contains(sourceUmlComponentConnector.getArchitectureElement())) continue;
                includedByTarget.add(nextConnectorInParentComponent);
            }
            if (includedByTarget.isEmpty()) {
                UmlComponentConnector createdUmlComponentConnector = new UmlComponentConnector(parentOfSourceUmlComponent, (Connector)sourceUmlComponentConnector.getArchitectureElement(), true, new e());
                parentOfSourceUmlComponent.addChild(createdUmlComponentConnector);
                createdUmlComponentConnector.addIncludedConnector((Connector)sourceUmlComponentConnector.getArchitectureElement());
                includedByTarget.add(createdUmlComponentConnector);
            }
            if (includedByTarget.size() > 1) {
                for (UmlComponentConnector next : includedByTarget) {
                    if (!next.isPassThrough()) continue;
                    cont = false;
                    break;
                }
            }
            for (UmlComponentConnector next : includedByTarget) {
                UmlComponent.IncludedBy includedBy = new UmlComponent.IncludedBy(sourceUmlComponentConnector, next);
                if (sourceUmlComponent.addAnchorBased(includedBy)) {
                    b.debug("Created 'includedBy' connector dependency: " + includedBy);
                    continue;
                }
                b.debug("'includedBy' connector dependency already exists: " + includedBy);
            }
        }
        return cont;
    }

    private static Set<Interface> a(UmlComponentConnector umlComponentConnector) {
        assert (umlComponentConnector != null) : "Parameter 'umlComponentConnector' of method 'getConnectedInterfaces' must not be null";
        assert (com.hello2morrow.sonargraph.core.controller.system.a.a.a((Connector)umlComponentConnector.getArchitectureElement())) : "Not included: " + umlComponentConnector;
        THashSet allConnectedInterfaces = new THashSet();
        Collection<Interface> connectedInterfaces = ((Connector)umlComponentConnector.getArchitectureElement()).getConnectedInterfaces();
        for (Interface nextConnectedInterface : connectedInterfaces) {
            if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextConnectedInterface)) continue;
            Artifact nextArtifactOfNextConnectedInterface = nextConnectedInterface.getParent(Artifact.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextArtifactOfNextConnectedInterface != null) : "'nextArtifactOfNextConnectedInterface' of method 'getConnectedInterfaces' must not be null";
            allConnectedInterfaces.add(nextConnectedInterface);
            Collection<Interface> nextExportedInterfaces = nextConnectedInterface.getExportedInterfaces();
            if (nextExportedInterfaces.isEmpty()) continue;
            for (Interface nextExportedInterface : nextExportedInterfaces) {
                if (!com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextExportedInterface)) continue;
                Artifact nextArtifactOfNextExportedInterface = nextExportedInterface.getParent(Artifact.class, ParentMode.ONLY_DIRECT_PARENT);
                assert (nextArtifactOfNextExportedInterface != null) : "'nextArtifactOfNextExportedInterface' of method 'getConnectedInterfaces' must not be null";
                if (nextArtifactOfNextExportedInterface.hasAsParent(nextArtifactOfNextConnectedInterface, false)) continue;
                allConnectedInterfaces.add(nextExportedInterface);
            }
        }
        Artifact artifactOfUmlComponentConnector = ((Connector)umlComponentConnector.getArchitectureElement()).getParent(Artifact.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (artifactOfUmlComponentConnector != null) : "'artifactOfUmlComponentConnector' of method 'getConnectedInterfaces' must not be null";
        if (artifactOfUmlComponentConnector.isUnrestricted()) {
            NamedElement parent = artifactOfUmlComponentConnector.getParent();
            assert (parent != null) : "'parent' of method 'getConnectedInterfaces' must not be null";
            for (Artifact nextSiblingArtifact : parent.getChildren(Artifact.class)) {
                if (nextSiblingArtifact == artifactOfUmlComponentConnector) continue;
                for (Interface nextInterface : nextSiblingArtifact.getChildren(Interface.class)) {
                    com.hello2morrow.sonargraph.core.controller.system.analysis.a.a result = com.hello2morrow.sonargraph.core.controller.system.analysis.a.b.a((Connector)umlComponentConnector.getArchitectureElement(), nextInterface);
                    if (!result.a()) continue;
                    allConnectedInterfaces.add(nextInterface);
                }
            }
        }
        return allConnectedInterfaces;
    }

    private static void a(ArchitectureDiagramRepresentation representation, Map<Artifact, UmlComponent> artifactToUmlComponent, UmlComponent sourceUmlComponent, UmlComponentConnector sourceConnector) {
        assert (representation != null) : "Parameter 'representation' of method 'processConnections' must not be null";
        assert (artifactToUmlComponent != null) : "Parameter 'artifactToUmlComponent' of method 'processConnections' must not be null";
        assert (sourceUmlComponent != null) : "Parameter 'sourceUmlComponent' of method 'processConnections' must not be null";
        assert (sourceConnector != null) : "Parameter 'sourceConnector' of method 'processConnections' must not be null";
        Set<Interface> connectedInterfaces = com.hello2morrow.sonargraph.core.controller.system.a.a.a(sourceConnector);
        if (!connectedInterfaces.isEmpty()) {
            List<UmlComponent> nextSourceUmlComponents = sourceConnector.getParents(UmlComponent.class, ArchitectureDiagramRepresentation.class);
            assert (nextSourceUmlComponents != null && !nextSourceUmlComponents.isEmpty()) : "'nextSourceUmlComponents' of method 'createDependencies' must not be empty";
            block0: for (Interface nextConnectedInterface : connectedInterfaces) {
                List<UmlComponent> targetUmlComponentPath;
                List<UmlComponent> sourceUmlComponentPath;
                Artifact nextTargetArtifact = nextConnectedInterface.getParent(Artifact.class, ParentMode.ONLY_DIRECT_PARENT);
                assert (nextTargetArtifact != null) : "'nextTargetArtifact' of method 'createDependencies' must not be null";
                if (nextTargetArtifact.isDeprecated()) continue;
                UmlComponent nextTargetUmlComponent = artifactToUmlComponent.get(nextTargetArtifact);
                assert (nextTargetUmlComponent != null) : "'nextTargetUmlComponent' of method 'createDependencies' must not be null";
                List<UmlComponentInterface> nextFoundTargetInterfaces = com.hello2morrow.sonargraph.core.controller.system.a.a.a(nextTargetUmlComponent, nextConnectedInterface);
                assert (nextFoundTargetInterfaces != null && nextFoundTargetInterfaces.size() == 1) : "'nextFoundTargetInterfaces' of method 'processConnections' must contain 1 interface";
                UmlComponentInterface nextTargetInterface = nextFoundTargetInterfaces.get(0);
                List<UmlComponent> nextTargetUmlComponents = nextTargetInterface.getParents(UmlComponent.class, ArchitectureDiagramRepresentation.class);
                assert (nextTargetUmlComponents != null && !nextTargetUmlComponents.isEmpty()) : "'nextTargetUmlComponents' of method 'createDependencies' must not be empty";
                int indexInSourceUmlComponents = -1;
                int indexInTargetUmlComponents = -1;
                int i2 = 0;
                while (i2 < nextSourceUmlComponents.size()) {
                    UmlComponent nextSourceParent = nextSourceUmlComponents.get(i2);
                    int index = nextTargetUmlComponents.indexOf(nextSourceParent);
                    if (index != -1) {
                        indexInTargetUmlComponents = index;
                        indexInSourceUmlComponents = i2;
                        break;
                    }
                    ++i2;
                }
                if (indexInSourceUmlComponents == -1) {
                    assert (indexInTargetUmlComponents == -1);
                    sourceUmlComponentPath = nextSourceUmlComponents;
                    targetUmlComponentPath = nextTargetUmlComponents;
                } else {
                    assert (indexInSourceUmlComponents != -1);
                    assert (indexInTargetUmlComponents != -1);
                    sourceUmlComponentPath = nextSourceUmlComponents.subList(0, nextSourceUmlComponents.size() - indexInSourceUmlComponents);
                    targetUmlComponentPath = nextTargetUmlComponents.subList(0, nextTargetUmlComponents.size() - indexInTargetUmlComponents);
                }
                assert (sourceUmlComponentPath.size() >= 1);
                assert (targetUmlComponentPath.size() >= 1);
                b.debug("Next connect to: [" + sourceUmlComponent.getName() + "] " + sourceConnector.getName() + " -> [" + nextTargetUmlComponent.getName() + "] " + nextTargetInterface.getName());
                int depth = Math.max(sourceUmlComponentPath.size(), targetUmlComponentPath.size());
                UmlComponent currentSourceUmlComponent = null;
                UmlComponent currentTargetUmlComponent = null;
                int i3 = 0;
                while (i3 < depth) {
                    boolean currentSourceUmlComponentChanged = false;
                    if (i3 < sourceUmlComponentPath.size()) {
                        currentSourceUmlComponent = sourceUmlComponentPath.get(i3);
                        currentSourceUmlComponentChanged = true;
                    }
                    if (i3 < targetUmlComponentPath.size()) {
                        currentTargetUmlComponent = targetUmlComponentPath.get(i3);
                    }
                    assert (currentSourceUmlComponent != null) : "'currentSourceUmlComponent' of method 'createDependencies' must not be null";
                    assert (currentTargetUmlComponent != null) : "'currentTargetUmlComponent' of method 'createDependencies' must not be null";
                    if (currentSourceUmlComponent.getParent() == currentTargetUmlComponent.getParent()) {
                        assert (currentSourceUmlComponent.getDepth() == currentTargetUmlComponent.getDepth());
                        if (currentSourceUmlComponent != currentTargetUmlComponent) {
                            List<UmlComponentConnector> foundUmlComponentConnectors = com.hello2morrow.sonargraph.core.controller.system.a.a.a(currentSourceUmlComponent, (Connector)sourceConnector.getArchitectureElement(), false);
                            List<UmlComponentInterface> foundUmlComponentInterfaces = com.hello2morrow.sonargraph.core.controller.system.a.a.a(currentTargetUmlComponent, (Interface)nextTargetInterface.getArchitectureElement());
                            if (foundUmlComponentConnectors.size() == 1 && foundUmlComponentInterfaces.size() == 1) {
                                UmlComponentInterface umlComponentInterface;
                                UmlComponentConnector source = foundUmlComponentConnectors.get(0);
                                UmlComponent.Uses nextUses = new UmlComponent.Uses(source, umlComponentInterface = foundUmlComponentInterfaces.get(0));
                                if (currentSourceUmlComponent.addUses(nextUses)) {
                                    b.debug("Created 'uses' dependency: " + nextUses);
                                } else {
                                    b.debug("'uses' already exists: " + nextUses);
                                }
                            } else {
                                StringBuilder builder = new StringBuilder();
                                builder.append("\nNo 'uses' could be added for: [").append(currentSourceUmlComponent.getName()).append("] ").append(sourceConnector.getName()).append(" -> [").append(currentTargetUmlComponent.getName()).append("] ").append(nextTargetInterface.getName()).append("\n");
                                builder.append("Found ").append(foundUmlComponentConnectors.size()).append(" source connector(s)");
                                if (!foundUmlComponentConnectors.isEmpty()) {
                                    for (UmlComponentConnector umlComponentConnector : foundUmlComponentConnectors) {
                                        builder.append("\n - ").append(umlComponentConnector.getName());
                                    }
                                } else {
                                    builder.append("\n");
                                }
                                builder.append("Found ").append(foundUmlComponentInterfaces.size()).append(" target interface(s)");
                                for (UmlComponentInterface umlComponentInterface : foundUmlComponentInterfaces) {
                                    builder.append("\n - ").append(umlComponentInterface.getName());
                                }
                                b.debug(builder.toString());
                            }
                        } else {
                            StringBuilder builder = new StringBuilder();
                            builder.append("\nNo 'uses' could be added for: [").append(currentSourceUmlComponent.getName()).append("] ").append(sourceConnector.getName()).append(" -> [").append(currentTargetUmlComponent.getName()).append("] ").append(nextTargetInterface.getName()).append("\n");
                            builder.append("Same UML components.");
                            b.debug(builder.toString());
                        }
                    } else if (currentSourceUmlComponentChanged && !com.hello2morrow.sonargraph.core.controller.system.a.a.a(representation, artifactToUmlComponent, sourceConnector, nextTargetInterface)) continue block0;
                    ++i3;
                }
            }
        }
    }

    private static void a(ArchitectureDiagramRepresentation representation, Map<Artifact, UmlComponent> artifactToUmlComponent) {
        assert (representation != null) : "Parameter 'representation' of method 'createDependencies' must not be null";
        assert (artifactToUmlComponent != null) : "Parameter 'artifactToUmlComponent' of method 'createDependencies' must not be null";
        for (UmlComponentInterface nextUmlComponentInterface : representation.getChildrenRecursively(UmlComponentInterface.class, new Class[0])) {
            Set<Interface> nextExportedInterfaces = nextUmlComponentInterface.getExportedInterfaces();
            if (nextExportedInterfaces.isEmpty()) continue;
            UmlComponent nextUmlComponent = nextUmlComponentInterface.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextUmlComponent != null) : "Parameter 'nextUmlComponent' of method 'createDependencies' must not be null";
            for (UmlComponent nextChildUmlComponent : nextUmlComponent.getChildren(UmlComponent.class)) {
                for (UmlComponentInterface nextPossibleExportedInterface : nextChildUmlComponent.getChildren(UmlComponentInterface.class)) {
                    if (!nextExportedInterfaces.contains(nextPossibleExportedInterface.getArchitectureElement())) continue;
                    nextChildUmlComponent.addAnchorBased(new UmlComponent.ExportedBy(nextPossibleExportedInterface, nextUmlComponentInterface));
                }
            }
        }
        List<UmlComponentConnector> allUmlComponentConnectors = representation.getChildrenRecursively(UmlComponentConnector.class, new Class[0]);
        for (UmlComponentConnector nextUmlComponentConnector : allUmlComponentConnectors) {
            Set<Connector> nextIncludedConnectors = nextUmlComponentConnector.getIncludedConnectors();
            if (nextIncludedConnectors.isEmpty()) continue;
            UmlComponent nextUmlComponent = nextUmlComponentConnector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextUmlComponent != null) : "Parameter 'nextUmlComponent' of method 'createDependencies' must not be null";
            for (UmlComponent nextChildUmlComponent : nextUmlComponent.getChildren(UmlComponent.class)) {
                for (UmlComponentConnector nextPossibleIncludedConnector : nextChildUmlComponent.getChildren(UmlComponentConnector.class)) {
                    if (!nextIncludedConnectors.contains(nextPossibleIncludedConnector.getArchitectureElement())) continue;
                    nextChildUmlComponent.addAnchorBased(new UmlComponent.IncludedBy(nextPossibleIncludedConnector, nextUmlComponentConnector));
                }
            }
        }
        for (UmlComponentConnector nextSourceConnector : allUmlComponentConnectors) {
            UmlComponent nextSourceUmlComponent = nextSourceConnector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextSourceUmlComponent != null) : "Parameter 'nextSourceUmlComponent' of method 'createDependencies' must not be null";
            Set<UmlComponentInterface> nextAllowedInterfaces = com.hello2morrow.sonargraph.core.controller.system.a.a.a(artifactToUmlComponent, nextSourceConnector, representation);
            for (UmlComponentInterface nextTargetInterface : nextAllowedInterfaces) {
                UmlComponent nextTargetUmlComponent = nextTargetInterface.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
                assert (nextTargetUmlComponent != null) : "'nextTargetUmlComponent' of method 'createDependencies' must not be null";
                com.hello2morrow.sonargraph.core.controller.system.a.a.a(representation, nextSourceUmlComponent, nextSourceConnector, nextTargetUmlComponent, nextTargetInterface);
            }
            com.hello2morrow.sonargraph.core.controller.system.a.a.a(representation, artifactToUmlComponent, nextSourceUmlComponent, nextSourceConnector);
        }
    }

    private static void b(ArchitectureDiagramRepresentation representation, UmlComponent sourceComponent, UmlComponentConnector sourceConnector, UmlComponent targetComponent, UmlComponentInterface targetInterface) {
        assert (representation != null) : "Parameter 'representation' of method 'addAsAllowedInterfaceIfApplicableRecursively' must not be null";
        assert (sourceComponent != null) : "Parameter 'sourceComponent' of method 'addAsAllowedInterfaceIfApplicableRecursively' must not be null";
        assert (sourceConnector != null) : "Parameter 'sourceConnector' of method 'addAsAllowedInterfaceIfApplicableRecursively' must not be null";
        assert (targetComponent != null) : "Parameter 'targetComponent' of method 'addAsAllowedInterfaceIfApplicableRecursively' must not be null";
        assert (targetInterface != null) : "Parameter 'targetInterface' of method 'addAsAllowedInterfaceIfApplicableRecursively' must not be null";
        com.hello2morrow.sonargraph.core.controller.system.a.a.a(representation, sourceComponent, sourceConnector, targetComponent, targetInterface);
        for (UmlComponentInterface nextTargetInterface : targetComponent.getExported(targetInterface)) {
            UmlComponent nextTargetComponent = nextTargetInterface.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextTargetComponent != null) : "'nextTargetComponent' of method 'collect' must not be null";
            com.hello2morrow.sonargraph.core.controller.system.a.a.b(representation, sourceComponent, sourceConnector, nextTargetComponent, nextTargetInterface);
        }
    }

    private static void b(ArchitectureDiagramRepresentation representation, Map<Artifact, UmlComponent> artifactToUmlComponent) {
        assert (representation != null) : "Parameter 'representation' of method 'processPassThroughConnectors' must not be null";
        assert (artifactToUmlComponent != null) : "Parameter 'artifactToUmlComponent' of method 'processPassThroughConnectors' must not be null";
        List<UmlComponentConnector> allUmlComponentConnectors = representation.getChildrenRecursively(UmlComponentConnector.class, new Class[0]);
        for (UmlComponentConnector nextUmlComponentConnector : allUmlComponentConnectors) {
            if (!nextUmlComponentConnector.isPassThrough()) continue;
            UmlComponent nextUmlComponent = nextUmlComponentConnector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextUmlComponent != null) : "'nextUmlComponent' of method 'processPassThroughConnectors' must not be null";
            b.debug("Pass-through connector: [" + nextUmlComponent.getName() + "] " + nextUmlComponentConnector.getName());
            for (UmlComponent.Uses nextUses : nextUmlComponent.getOutgoingUses()) {
                if (nextUses.getSourceConnector() != nextUmlComponentConnector) continue;
                b.debug("Uses: " + nextUses);
                com.hello2morrow.sonargraph.core.controller.system.a.a.b(representation, nextUmlComponent, nextUmlComponentConnector, nextUses.getTargetComponent(), nextUses.getTargetInterface());
            }
        }
    }

    public static boolean a(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'isCreatePossible' must not be null";
        if (architectureFile.isChecked() && architectureFile.modelLoaded()) {
            for (Artifact next : architectureFile.getChildren(Artifact.class)) {
                if (next.isDeprecated()) continue;
                return true;
            }
        }
        return false;
    }

    public static ArchitectureDiagramRepresentation a(IWorkerContext workerContext, NamedElement parent, ArchitectureFile architectureFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'create' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'create' must not be null";
        assert (com.hello2morrow.sonargraph.core.controller.system.a.a.a(architectureFile)) : "Create not possible for: " + architectureFile.getAbsolutePath();
        b.debug("Create architecture diagram representation from '" + architectureFile.getIdentifyingPath() + "'");
        ArchitectureDiagramRepresentation representation = new ArchitectureDiagramRepresentation(parent, new e(), architectureFile);
        parent.addChild(representation);
        THashMap artifactToUmlComponent = new THashMap();
        com.hello2morrow.sonargraph.core.controller.system.a.a.a((NamedElement)representation, architectureFile.getChildren(Artifact.class), (Map<Artifact, UmlComponent>)artifactToUmlComponent, 1);
        com.hello2morrow.sonargraph.core.controller.system.a.a.a(representation, (Map<Artifact, UmlComponent>)artifactToUmlComponent);
        com.hello2morrow.sonargraph.core.controller.system.a.a.b(representation, (Map<Artifact, UmlComponent>)artifactToUmlComponent);
        representation.accept(new b());
        representation.accept(new a());
        b.debug("Create architecture diagram representation from '" + architectureFile.getIdentifyingPath() + "' - done");
        return representation;
    }

    static final class a
    extends com.hello2morrow.sonargraph.core.controller.system.a.b {
        private final c c = new c();
        private final d d = new d();

        a() {
        }

        @Override
        public void visitArchitectureDiagramRepresentation(ArchitectureDiagramRepresentation element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitectureDiagramRepresentation' must not be null";
            element.sortComponents(this.c);
            super.visitArchitectureDiagramRepresentation(element);
        }

        @Override
        public void visitUmlComponent(UmlComponent element) {
            assert (element != null) : "Parameter 'element' of method 'visitUmlComponent' must not be null";
            element.sortComponents(this.c);
            element.sortUses(this.d);
            block4: for (UmlComponent.AnchorBased next : element.getAnchorBased()) {
                switch (next.getType()) {
                    case EXPORTED_BY: {
                        UmlComponent.ExportedBy nextExportedBy = (UmlComponent.ExportedBy)next;
                        nextExportedBy.getSourceAnchor().addExportedByInfo(nextExportedBy.getTargetAnchor());
                        nextExportedBy.getTargetAnchor().addExportesInfo(nextExportedBy.getSourceAnchor());
                        break;
                    }
                    case INCLUDED_BY: {
                        UmlComponent.IncludedBy nextIncludedBy = (UmlComponent.IncludedBy)next;
                        nextIncludedBy.getSourceAnchor().addIncludedByInfo(nextIncludedBy.getTargetAnchor());
                        nextIncludedBy.getTargetAnchor().addIncludesInfo(nextIncludedBy.getSourceAnchor());
                        break;
                    }
                    default: {
                        assert (false) : "Unexpected dependency type: " + (Object)((Object)next.getType());
                        continue block4;
                    }
                }
            }
            super.visitUmlComponent(element);
        }
    }

    static final class b
    extends com.hello2morrow.sonargraph.core.controller.system.a.b {
        b() {
        }

        @Override
        public void visitArchitectureDiagramRepresentation(ArchitectureDiagramRepresentation element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitectureDiagramRepresentation' must not be null";
            List<UmlComponent> umlComponentChildren = element.getChildren(UmlComponent.class);
            if (!umlComponentChildren.isEmpty()) {
                com.hello2morrow.sonargraph.core.controller.system.a.c.a(umlComponentChildren);
            }
            super.visitArchitectureDiagramRepresentation(element);
        }

        @Override
        public void visitUmlComponent(UmlComponent element) {
            assert (element != null) : "Parameter 'element' of method 'visitUmlComponent' must not be null";
            List<UmlComponent> umlComponentChildren = element.getChildren(UmlComponent.class);
            if (!umlComponentChildren.isEmpty()) {
                com.hello2morrow.sonargraph.core.controller.system.a.c.a(umlComponentChildren);
            }
            super.visitUmlComponent(element);
        }
    }

    static final class c
    implements Comparator<IUmlComponent> {
        c() {
        }

        public int a(IUmlComponent c1, IUmlComponent c2) {
            assert (c1 != null) : "Parameter 'c1' of method 'compare' must not be null";
            assert (c2 != null) : "Parameter 'c2' of method 'compare' must not be null";
            int levelDelta = c2.getLevel() - c1.getLevel();
            if (levelDelta != 0) {
                return levelDelta;
            }
            int incDepDelta = c1.getNumberOfIncomingUses() - c2.getNumberOfIncomingUses();
            if (incDepDelta != 0) {
                return incDepDelta;
            }
            int outDepDelta = c1.getNumberOfOutgoingUses() - c2.getNumberOfOutgoingUses();
            if (outDepDelta != 0) {
                return outDepDelta;
            }
            return c1.getName().compareTo(c2.getName());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((IUmlComponent)object, (IUmlComponent)object2);
        }
    }

    static final class d
    implements Comparator<UmlComponent.Uses> {
        d() {
        }

        public int a(UmlComponent.Uses u1, UmlComponent.Uses u2) {
            assert (u1 != null) : "Parameter 'u1' of method 'compare' must not be null";
            assert (u2 != null) : "Parameter 'u2' of method 'compare' must not be null";
            UmlComponent s1 = u1.getSourceComponent();
            UmlComponent s2 = u2.getSourceComponent();
            int levelDelta = s2.getLevel() - s1.getLevel();
            if (levelDelta != 0) {
                return levelDelta;
            }
            int incDepDelta = s1.getNumberOfIncomingUses() - s2.getNumberOfIncomingUses();
            if (incDepDelta != 0) {
                return incDepDelta;
            }
            UmlComponent t1 = u1.getTargetComponent();
            UmlComponent t2 = u2.getTargetComponent();
            levelDelta = t2.getLevel() - t1.getLevel();
            if (levelDelta != 0) {
                return levelDelta;
            }
            incDepDelta = t1.getNumberOfIncomingUses() - t2.getNumberOfIncomingUses();
            if (incDepDelta != 0) {
                return incDepDelta;
            }
            int nameDelta = s1.getName().compareTo(s2.getName());
            if (nameDelta != 0) {
                return nameDelta;
            }
            return u1.toString().compareTo(u2.toString());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((UmlComponent.Uses)object, (UmlComponent.Uses)object2);
        }
    }

    static final class e
    implements Comparator<UmlComponentAnchor<?>> {
        e() {
        }

        public int a(UmlComponentAnchor<?> a1, UmlComponentAnchor<?> a2) {
            assert (a1 != null) : "Parameter 'a1' of method 'compare' must not be null";
            assert (a2 != null) : "Parameter 'a2' of method 'compare' must not be null";
            List<UmlComponent> parents1 = a1.getParents(UmlComponent.class, ArchitectureDiagramRepresentation.class);
            assert (parents1 != null && !parents1.isEmpty()) : "'parents1' of method 'compare' must not be empty";
            List<UmlComponent> parents2 = a2.getParents(UmlComponent.class, ArchitectureDiagramRepresentation.class);
            assert (parents2 != null && !parents2.isEmpty()) : "'parents2' of method 'compare' must not be empty";
            int nesting = parents1.size() - parents2.size();
            if (nesting != 0) {
                return nesting;
            }
            String fullName1 = String.valueOf(parents1.get(0).getName()) + ":" + a1.getName();
            String fullName2 = String.valueOf(parents2.get(0).getName()) + ":" + a2.getName();
            return fullName1.compareTo(fullName2);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((UmlComponentAnchor)object, (UmlComponentAnchor)object2);
        }
    }
}

