/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.collections.MultipleValueMap;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.k;
import com.hello2morrow.sonargraph.core.controller.system.base.i;
import com.hello2morrow.sonargraph.core.controller.system.n;
import com.hello2morrow.sonargraph.core.model.analysis.ConfigurableAnalyzerIdComparator;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.LanguageBasedMetricProvider;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class a {
    private static final Logger b = LoggerFactory.getLogger(a.class);

    private a() {
    }

    private static boolean a(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'discardPersistedAnalyzerResults' must not be null";
        Files files = softwareSystem.getUniqueExistingChild(Files.class);
        n architectureExtension = softwareSystem.getExtension(n.class);
        for (IModifiableFile next : files.getModifiableFilesNeedingSave()) {
            if (next instanceof TreeMapFile || next instanceof ArchitecturalViewFile || next instanceof WorkspaceProfile || next instanceof SoftwareSystemFile || next instanceof FileBasedRunConfiguration && !((FileBasedRunConfiguration)next).isAutomated()) continue;
            if (next instanceof ArchitectureFile) {
                ArchitectureFile archFile = (ArchitectureFile)next;
                if (!archFile.isChecked() && !archFile.usedInApplyOrRequire()) continue;
                if (archFile.isChecked()) {
                    b.debug("Architecture file '{}' is modified - analyzer results will be discarded.", (Object)archFile.getIdentifyingPath());
                    return true;
                }
                THashSet applyingOrRequiringFiles = new THashSet();
                architectureExtension.a(archFile, (Set<ArchitectureFile>)applyingOrRequiringFiles);
                for (ArchitectureFile nextArchFile : applyingOrRequiringFiles) {
                    if (!nextArchFile.isChecked()) continue;
                    b.debug("Architecture file '{}' is modified and referenced by checked '{}' architecture file - analyzer results will be discarded.", (Object)archFile.getIdentifyingPath(), (Object)nextArchFile.getIdentifyingPath());
                    return true;
                }
                continue;
            }
            b.debug("File '{}' is modified - analyzer results will be discarded.", (Object)next.getIdentifyingPath());
            return true;
        }
        return false;
    }

    static final void a(Installation installation, i languageProvider) {
        assert (installation != null) : "Parameter 'installation' of method 'finishLanguageRemoved' must not be null";
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'finishLanguageRemoved' must not be null";
        for (LanguageBasedMetricProvider next : installation.getMetricProviders().getChildren(LanguageBasedMetricProvider.class)) {
            if (next.getLanguage() != languageProvider.getLanguage()) continue;
            next.forgetChildren(true);
            installation.metricDescriptorsChanged();
            break;
        }
    }

    static final void a(Installation installation, SoftwareSystem softwareSystem, IAnalyzerProvider analyzerProvider) {
        assert (installation != null) : "Parameter 'installation' of method 'finishSoftwareSystemClose' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSoftwareSystemClose' must not be null";
        assert (analyzerProvider != null) : "Parameter 'analyzerProvider' of method 'finishSoftwareSystemClose' must not be null";
        if (com.hello2morrow.sonargraph.core.controller.system.a.a(softwareSystem)) {
            b.debug("Deleting persisted analyzer results");
            TFile storageDir = analyzerProvider.getAnalyzerResultStorageDirectory();
            TrueZipFacade.clear();
            if (storageDir.exists() && storageDir.isDirectory()) {
                try {
                    FileUtility.deleteRecursively((String)storageDir.getNormalizedAbsolutePath());
                }
                catch (IOException e2) {
                    b.error("Failed to delete persisted analyzer results", (Throwable)e2);
                }
            }
        }
        installation.getMetricProviders().getChildren(LanguageBasedMetricProvider.class).forEach(mp -> {
            List<NamedElement> list = mp.forgetChildren(true);
        });
        installation.metricDescriptorsChanged();
    }

    static void a(Collection<com.hello2morrow.sonargraph.core.controller.system.analysis.base.a> adapters, MultipleValueMap<AnalyzerGroup, com.hello2morrow.sonargraph.core.controller.system.analysis.base.a> groups) {
        assert (adapters != null) : "Parameter 'adapters' of method 'calculateAndSetAdapterDependencies' must not be null";
        assert (groups != null) : "Parameter 'groups' of method 'calculateAndSetAdapterDependencies' must not be null";
        if (!adapters.isEmpty()) {
            b.debug("Calculate and set analyzer adapter dependencies");
            adapters.forEach(a2 -> a2.f());
            ArrayList<k> pluginAnalyzerAdapters = new ArrayList<k>();
            ArrayList<com.hello2morrow.sonargraph.core.controller.system.analysis.base.a> dependOnPluginAnalyzerAadpters = new ArrayList<com.hello2morrow.sonargraph.core.controller.system.analysis.base.a>();
            for (com.hello2morrow.sonargraph.core.controller.system.analysis.base.a nextAdapter : adapters) {
                IConfigurableAnalyzerId nextIdToCheck;
                IConfigurableAnalyzerId nextId = nextAdapter.n();
                AnalyzerGroup nextGroup = nextId.getGroup();
                if (nextAdapter instanceof k) {
                    pluginAnalyzerAdapters.add((k)nextAdapter);
                }
                for (AnalyzerGroup nextGroupToCheck : nextId.getAffectedGroups()) {
                    if (nextGroupToCheck == nextGroup) continue;
                    for (com.hello2morrow.sonargraph.core.controller.system.analysis.base.a nextAdapterToCheck : groups.get((Object)nextGroupToCheck)) {
                        assert (!(nextAdapter instanceof k)) : "Dependency to plugin: " + nextAdapterToCheck.n() + " -> " + nextId;
                        nextAdapterToCheck.a(nextAdapter);
                    }
                }
                if (nextId == CoreAnalyzerId.SCRIPT_RUNNER) {
                    for (com.hello2morrow.sonargraph.core.controller.system.analysis.base.a nextAdapterToCheck : adapters) {
                        nextIdToCheck = nextAdapterToCheck.n();
                        if (nextIdToCheck == CoreAnalyzerId.ISSUE_DENSITY || nextIdToCheck == CoreAnalyzerId.QUALITY_GATES || nextIdToCheck == CoreAnalyzerId.SYSTEM_DIFF || nextIdToCheck == CoreAnalyzerId.ISSUE_RANKING || nextAdapterToCheck instanceof k) continue;
                        nextAdapter.a(nextAdapterToCheck);
                    }
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId == CoreAnalyzerId.ISSUE_DENSITY) {
                    for (com.hello2morrow.sonargraph.core.controller.system.analysis.base.a nextAdapterToCheck : adapters) {
                        nextIdToCheck = nextAdapterToCheck.n();
                        if (nextIdToCheck == CoreAnalyzerId.QUALITY_GATES || nextIdToCheck == CoreAnalyzerId.SYSTEM_DIFF || nextIdToCheck == CoreAnalyzerId.ISSUE_RANKING || nextAdapterToCheck instanceof k) continue;
                        nextAdapter.a(nextAdapterToCheck);
                    }
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId == CoreAnalyzerId.ISSUE_RANKING) {
                    for (com.hello2morrow.sonargraph.core.controller.system.analysis.base.a nextAdapterToCheck : adapters) {
                        nextIdToCheck = nextAdapterToCheck.n();
                        if (nextIdToCheck == CoreAnalyzerId.QUALITY_GATES || nextAdapterToCheck instanceof k) continue;
                        nextAdapter.a(nextAdapterToCheck);
                    }
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId == CoreAnalyzerId.SYSTEM_DIFF) {
                    dependOnPluginAnalyzerAadpters.add(nextAdapter);
                    continue;
                }
                if (nextId != CoreAnalyzerId.QUALITY_GATES) continue;
                dependOnPluginAnalyzerAadpters.add(nextAdapter);
            }
            if (!pluginAnalyzerAdapters.isEmpty() && !dependOnPluginAnalyzerAadpters.isEmpty()) {
                for (com.hello2morrow.sonargraph.core.controller.system.analysis.base.a next : dependOnPluginAnalyzerAadpters) {
                    for (k nextPluginAnalyzerAdapter : pluginAnalyzerAdapters) {
                        next.a(nextPluginAnalyzerAdapter);
                    }
                }
            }
            if (b.isDebugEnabled()) {
                for (com.hello2morrow.sonargraph.core.controller.system.analysis.base.a next : adapters) {
                    Set<com.hello2morrow.sonargraph.core.controller.system.analysis.base.a> nextDependsUponAdapters = next.e();
                    b.debug("[" + (Object)((Object)next.p()) + "] " + next.n());
                    if (!nextDependsUponAdapters.isEmpty()) {
                        TreeSet<IConfigurableAnalyzerId> dependsUpon = new TreeSet<IConfigurableAnalyzerId>(new ConfigurableAnalyzerIdComparator());
                        nextDependsUponAdapters.forEach(d2 -> {
                            boolean bl2 = dependsUpon.add(d2.n());
                        });
                        for (IConfigurableAnalyzerId nextDependsUpon : dependsUpon) {
                            b.debug(" -> " + nextDependsUpon);
                        }
                        continue;
                    }
                    b.debug(" <no dependencies>");
                }
            }
            b.debug("Calculate and set analyzer adapter dependencies - done");
        }
    }
}

