/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.file.PersistentRecentlyUsedList;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.controller.system.ReportExtension;
import com.hello2morrow.sonargraph.core.controller.system.aX;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.j;
import com.hello2morrow.sonargraph.core.controller.system.base.m;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.controllerinterface.system.B;
import com.hello2morrow.sonargraph.core.controllerinterface.system.u;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.SystemDiffConfigChangedEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.BaselinesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.Baseline;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfigurationIssue;
import com.hello2morrow.sonargraph.core.persistence.diff.BaselineReader;
import com.hello2morrow.sonargraph.core.persistence.diff.SystemDiffHtmlWriter;
import com.hello2morrow.sonargraph.core.persistence.system.SystemPropertiesPersistenceProvider;
import com.hello2morrow.sonargraph.integration.access.controller.b;
import com.hello2morrow.sonargraph.integration.access.controller.f;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemDiffExtension
extends aX
implements j,
m,
B,
IModifiableFileDeltaKey {
    private static final Logger e = LoggerFactory.getLogger(SystemDiffExtension.class);
    private static final Version f = Version.create((String)"9.13.0");
    private static final String g = "baselines.rud";
    private static final String h = "localBaselines.rud";
    private final g i;
    private final AtomicBoolean j = new AtomicBoolean(false);
    private final PersistentRecentlyUsedList k;
    private final PersistentRecentlyUsedList l;
    private a m = null;

    SystemDiffExtension(SoftwareSystem softwareSystem, g finishModelProcessor) {
        super(softwareSystem);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'SystemDiffExtension' must not be null";
        this.i = finishModelProcessor;
        TFile hiddenDataDirectory = this.b().getUniqueExistingChild(Files.class).getHiddenDataDirectory();
        TFile baselinesDirectory = new TFile((File)hiddenDataDirectory, "baselines");
        baselinesDirectory.mkdir();
        this.k = this.a(baselinesDirectory, g);
        this.l = this.a(baselinesDirectory, h);
        this.i.a(this);
    }

    @Override
    public void a(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        if (configuration.getClass().equals(SystemDiffAnalyzerConfiguration.class)) {
            this.e();
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new SystemDiffConfigChangedEvent(this.b().getExtension(ISoftwareSystemProvider.class)));
    }

    @Override
    public void clear() {
        this.j.set(false);
    }

    @Override
    public void a(Set<IAnalyzerId> analyzerIds) {
        this.j.set(false);
    }

    @Override
    public void a(SoftwareSystem softwareSystem) {
        this.j.set(true);
    }

    @Override
    public boolean a() {
        return this.j.get();
    }

    @Override
    public TFile getActiveBaseline() {
        return this.m != null ? this.m.a() : null;
    }

    @Override
    public void a(IWorkerContext workerContext, AnalyzerResult analyzerResult) {
        com.hello2morrow.sonargraph.integration.access.controller.g baselineSystemInfoProcessor;
        ISoftwareSystem baselineSystem;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateDelta' must not be null";
        assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'computeDiff' must not be null";
        e.info("Compute baseline diff");
        long start = System.currentTimeMillis();
        workerContext.setNumberOfSteps(4, new int[]{40, 10, 25, 25});
        workerContext.working("Reading baseline report", true);
        StrictPair<TFile, BaselineType> baselineReportAndType = this.d();
        if (baselineReportAndType == null) {
            return;
        }
        TFile baselineReport = (TFile)baselineReportAndType.getFirst();
        BaselineType baselineType = (BaselineType)((Object)baselineReportAndType.getSecond());
        e.info("Use baseline: " + baselineReport.getNormalizedAbsolutePath() + " [" + (Object)((Object)baselineType) + "]");
        if (this.m != null && baselineReport.lastModified() == this.m.b() && FileUtility.areEqual((TFile)baselineReport, (TFile)this.m.a())) {
            baselineSystem = this.m.c();
            baselineSystemInfoProcessor = this.m.d();
        } else {
            f controller = com.hello2morrow.sonargraph.integration.access.controller.b.a();
            AnalyzerConfigurationFile analyzerConfigurationFile = this.g();
            try {
                Throwable throwable = null;
                Object var13_14 = null;
                try (TFileInputStream in = new TFileInputStream((File)baselineReport);){
                    Result loadBaselineSystemResult = controller.a((InputStream)in, (File)this.b().getDirectoryFile());
                    if (loadBaselineSystemResult.c()) {
                        this.m = null;
                        e.error("Failed to read baseline report '" + baselineReport.getAbsolutePath() + "': " + loadBaselineSystemResult.toString());
                        analyzerConfigurationFile.addIssue(new SystemDiffConfigurationIssue(analyzerConfigurationFile, "Failed to read baseline report!"));
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                this.m = null;
                e.error("Failed to read baseline report: ", (Throwable)e2);
                String description = "Failed to read baseline report '" + baselineReport.getAbsolutePath() + "': " + e2.getMessage();
                analyzerConfigurationFile.addIssue(new SystemDiffConfigurationIssue(analyzerConfigurationFile, description));
                return;
            }
            baselineSystem = controller.b();
            Version baselineReportVersion = Version.create((String)baselineSystem.getVersion());
            if (baselineReportVersion.isBefore(f)) {
                this.m = null;
                String description = "Baseline report has been created with version '" + baselineReportVersion + "' which is not suitable for system diff. " + "At least version '" + f.toString(3) + "' is required";
                analyzerConfigurationFile.addIssue(new SystemDiffConfigurationIssue(analyzerConfigurationFile, description));
                return;
            }
            baselineSystemInfoProcessor = controller.c();
            e.debug("Needed {} ms to load baseline report", (Object)(System.currentTimeMillis() - start));
            if (baselineType == BaselineType.SYSTEM) {
                this.k.lastRecentlyUsed(baselineReport.getNormalizedAbsolutePath());
            } else {
                this.l.lastRecentlyUsed(baselineReport.getNormalizedAbsolutePath());
            }
        }
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        com.hello2morrow.sonargraph.core.controller.system.diff.m diffProcess = new com.hello2morrow.sonargraph.core.controller.system.diff.m(this.b(), this.i.b().s());
        diffProcess.a(workerContext, analyzerResult, baselineSystem, baselineSystemInfoProcessor, baselineType, baselineReport);
        this.m = new a(baselineReport, baselineSystem, baselineSystemInfoProcessor, baselineType);
        e.info("Compute baseline diff - done [" + (System.currentTimeMillis() - start) + " ms]");
    }

    @Override
    public OperationResultWithOutcome<Map<IFileType, TFile>> a(IWorkerContext workerContext, IReport report, TFile targetDirectory, String targetFileName, Set<IFileType> requestedFileTypes, TFile baselineXmlReport, String mainReportName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createSystemDiffReports' must not be null";
        assert (report != null) : "Parameter 'report' of method 'createSystemDiffReports' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create system diff report");
        workerContext.beginSubTask("Create system diff report");
        workerContext.setNumberOfSteps(4, new int[]{40, 10, 25, 25});
        SoftwareSystemDiff systemDiff = this.getSoftwareSystemDiff();
        if (systemDiff != null && requestedFileTypes.contains((Object)CoreFileType.REPORT_HTML)) {
            SystemDiffHtmlWriter htmlWriter = new SystemDiffHtmlWriter(systemDiff, report);
            Map<CoreFileType, TFile> targetFiles = this.a(targetDirectory, targetFileName, requestedFileTypes, new Date(report.getTimestamp()));
            OperationResultWithOutcome<TFile> htmlReportResult = htmlWriter.writeReport(targetFiles.get((Object)CoreFileType.REPORT_HTML), mainReportName);
            result.addMessagesFrom(htmlReportResult);
            if (htmlReportResult.isSuccess()) {
                HashMap<CoreFileType, TFile> outcome = new HashMap<CoreFileType, TFile>();
                outcome.put(CoreFileType.REPORT_HTML, (TFile)htmlReportResult.getOutcome());
                result.setOutcome(outcome);
            }
        }
        workerContext.endSubTask();
        return result;
    }

    private Map<CoreFileType, TFile> a(TFile targetDirectory, String reportFileName, Set<IFileType> requestedFileTypes, Date timestamp) {
        assert (targetDirectory != null && targetDirectory.isDirectory() && targetDirectory.exists()) : "Parameter 'targetDirectory' of method 'createSystemDiffTargetFiles' must be an existing directory";
        assert (reportFileName != null) : "Parameter 'reportFileName' of method 'createSystemDiffTargetFiles' must not be null";
        assert (requestedFileTypes != null && !requestedFileTypes.isEmpty()) : "Parameter 'reportFormats' of method 'createSystemDiffTargetFiles' must not be empty";
        assert (timestamp != null) : "Parameter 'timestamp' of method 'createSystemDiffTargetFiles' must not be null";
        HashMap<CoreFileType, TFile> targetFiles = new HashMap<CoreFileType, TFile>(requestedFileTypes.size());
        this.a(targetDirectory, requestedFileTypes, reportFileName, targetFiles, CoreFileType.REPORT_HTML);
        this.a(targetDirectory, requestedFileTypes, reportFileName, targetFiles, CoreFileType.REPORT_XML);
        return targetFiles;
    }

    private void a(TFile targetDirectory, Set<IFileType> requestedFileTypes, String reportFileName, Map<CoreFileType, TFile> targetFiles, CoreFileType fileType) {
        if (requestedFileTypes.contains((Object)fileType)) {
            TFile targetFile = new TFile((File)targetDirectory, String.valueOf(reportFileName) + fileType.getDefaultExtension());
            targetFiles.put(fileType, targetFile);
        }
    }

    @Override
    public List<BaselineInfo> getRecentlyUsedBaselineReports(BaselineType type) {
        BaselineReader reader;
        assert (type != null) : "Parameter 'type' of method 'getRecentlyUsedBaselineReports' must not be null";
        ArrayList<BaselineInfo> recentlyUsedEntries = new ArrayList<BaselineInfo>();
        PersistentRecentlyUsedList baselinePaths = type == BaselineType.SYSTEM ? this.k : this.l;
        if (baselinePaths.isEmpty()) {
            return recentlyUsedEntries;
        }
        try {
            reader = new BaselineReader();
        }
        catch (Exception e2) {
            e.error("Failed to load recently used baselines", (Throwable)e2);
            return recentlyUsedEntries;
        }
        for (String nextPath : baselinePaths.getAll()) {
            OperationResultWithOutcome<BaselineInfo> readResult = reader.read(new TFile(nextPath));
            if (readResult.isSuccess()) {
                recentlyUsedEntries.add((BaselineInfo)readResult.getOutcome());
                continue;
            }
            e.info("Removing path '{}' from {} recently used baselines list.", (Object)nextPath, (Object)type.getPresentationName());
            baselinePaths.remove(nextPath);
        }
        return recentlyUsedEntries;
    }

    @Override
    public TFile getDefaultLocalBaselineDirectory() {
        String path = this.l.getAbsolutePath();
        return new TFile(path).getParentFile();
    }

    private PersistentRecentlyUsedList a(TFile baselinesDirectory, String fileName) {
        assert (baselinesDirectory != null) : "Parameter 'baselinesDirectory' of method 'initRecentlyUsedList' must not be null";
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'initRecentlyUsedList' must not be empty";
        PersistentRecentlyUsedList recentlyUsedList = new PersistentRecentlyUsedList(new TFile((File)baselinesDirectory, fileName).getAbsolutePath(), 20);
        if (recentlyUsedList.size() > 0) {
            List allEntries = recentlyUsedList.getAll();
            ArrayList<String> toBeRemoved = new ArrayList<String>(allEntries.size());
            ArrayList<TFile> allValidPathsAsFiles = new ArrayList<TFile>(allEntries.size());
            for (String nextPath : allEntries) {
                if (!nextPath.endsWith(CoreFileType.REPORT_XML.getDefaultExtension())) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                boolean isDuplicate = false;
                TFile nextPathAsFile = new TFile(nextPath);
                for (TFile nextAlreadyAddedPathAsFile : allValidPathsAsFiles) {
                    if (!FileUtility.areEqual((TFile)nextPathAsFile, (TFile)nextAlreadyAddedPathAsFile)) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                allValidPathsAsFiles.add(nextPathAsFile);
            }
            toBeRemoved.forEach(r2 -> recentlyUsedList.remove(r2));
        }
        return recentlyUsedList;
    }

    @Override
    public OperationResultWithOutcome<Map<IReport.Format, TFile>> a(IWorkerContext workerContext, TFile outputDirectory, Set<IReport.Format> reportFormats, String targetFileName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createReport' must not be null";
        assert (outputDirectory != null) : "Parameter 'outputDirectory' of method 'createReport' must not be null";
        assert (reportFormats != null && !reportFormats.isEmpty()) : "Parameter 'reportFormats' of method 'createReport' must not be empty";
        if (targetFileName == null) {
            targetFileName = this.a(new Date());
        }
        workerContext.setNumberOfSteps(6, new int[]{10, 20, 10, 25, 25, 10});
        workerContext.beginSubTask("Waiting for analyzers to complete");
        com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.b().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
        analyzerExtension.a(workerContext);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        u reportExtension = this.b().getExtension(u.class);
        IReport currentReport = reportExtension.a(workerContext);
        OperationResultWithOutcome createReportResult = new OperationResultWithOutcome("Creating report for system diff");
        List issues = this.getSystemDiffErrorIssues();
        if (!issues.isEmpty()) {
            String message = issues.stream().map(i2 -> i2.getDescription()).collect(Collectors.joining(" "));
            createReportResult.addError((OperationResult.IMessageCause)ReportExtension.MessageCause.FAILED_TO_LOAD_BASELINE_SYSTEM_XML_REPORT, message, new Object[0]);
            return createReportResult;
        }
        SoftwareSystemDiff softwareSystemDiff = this.getSoftwareSystemDiff();
        assert (softwareSystemDiff != null) : "Missing systemDiff";
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        HashMap<IReport.Format, TFile> outputFiles = new HashMap<IReport.Format, TFile>(2);
        if (reportFormats.contains((Object)IReport.Format.HTML)) {
            SystemDiffHtmlWriter htmlWriter = new SystemDiffHtmlWriter(softwareSystemDiff, currentReport);
            OperationResultWithOutcome<TFile> htmlReportResult = htmlWriter.writeReport(new TFile((File)outputDirectory, String.valueOf(targetFileName) + CoreFileType.REPORT_HTML.getDefaultExtension()), null);
            createReportResult.addMessagesFrom(htmlReportResult);
            TFile outcome = (TFile)htmlReportResult.getOutcome();
            outputFiles.put(IReport.Format.HTML, outcome);
            createReportResult.setOutcome(outputFiles);
        }
        return createReportResult;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext) {
        return this.a(workerContext, false);
    }

    private OperationResult a(IWorkerContext workerContext, boolean isDeleted) {
        TFile baselineReport;
        BaselineType type;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detachFromBaseline' must not be null";
        this.clear();
        if (this.m != null) {
            type = this.m.e();
            baselineReport = this.m.a();
            this.m = null;
        } else {
            ISystemDiffProvider.DiffConfiguration configuration = this.getDiffConfiguration();
            type = configuration.getType();
            baselineReport = type == BaselineType.SYSTEM ? configuration.getSystemBaseline() : configuration.getLocalBaseline();
        }
        OperationResult detachBaselineResult = new OperationResult("Detach Baseline");
        if (type == BaselineType.LOCAL) {
            this.a(workerContext, isDeleted ? null : baselineReport, false, type, false, detachBaselineResult);
            SystemDiffAnalyzerConfiguration analyzerConfiguration = this.c();
            if (analyzerConfiguration.isEnabled()) {
                this.a(workerContext, new TFile(analyzerConfiguration.getBaselinePath()), false, BaselineType.SYSTEM, false, detachBaselineResult);
            }
            com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.b().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
            Set<AnalyzerGroup> toRestart = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
            analyzerExtension.a(toRestart);
        } else {
            this.a(workerContext, isDeleted ? null : baselineReport, false, type, true, detachBaselineResult);
        }
        return detachBaselineResult;
    }

    @Override
    public OperationResultWithOutcome<TFile> a(IWorkerContext workerContext, String fileName, TFile baselineReportDirectory, String reportDescription, BaselineType baselineType) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateDelta' must not be null";
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'computeAndSetBaseline' must not be empty";
        assert (baselineReportDirectory != null) : "Parameter 'baselineReportDirectory' of method 'computeDiff' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'computeAndSetBaseline' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Creating baseline report and trigger computation of system diff");
        u reportExtension = this.b().getExtension(u.class);
        u.a createReportRequest = new u.a();
        createReportRequest.a(fileName);
        createReportRequest.a(baselineReportDirectory);
        createReportRequest.a(EnumSet.of(IReport.Format.XML));
        if (reportDescription != null) {
            createReportRequest.b(reportDescription);
        }
        createReportRequest.a(u.a.b);
        workerContext.working("Create baseline report", true);
        OperationResultWithOutcome<CreateReportResult> createReportResult = reportExtension.a(workerContext, createReportRequest);
        result.addMessagesFrom(createReportResult);
        if (result.isFailure()) {
            this.m = null;
            return result;
        }
        TFile baselineReport = ((CreateReportResult)createReportResult.getOutcome()).getTargetFile(IReport.Format.XML);
        assert (baselineReport != null) : "baselineReport must not be null!";
        result.setOutcome((Object)baselineReport);
        if (baselineType == BaselineType.SYSTEM) {
            BaselinesDirectory baselinesDirectory = this.getBaselinesDirectory();
            Baseline existingBaseline = this.a(baselineReport, baselinesDirectory);
            if (existingBaseline != null) {
                existingBaseline.remove();
            }
            try {
                BaselineReader reader = new BaselineReader();
                OperationResultWithOutcome<BaselineInfo> infoResult = reader.read(baselineReport);
                if (infoResult.isFailure()) {
                    result.addMessagesFrom(infoResult);
                    return result;
                }
                Baseline baseline = new Baseline(baselinesDirectory, baselineReport, ((BaselineInfo)infoResult.getOutcome()).getCreationTime(), reportDescription != null ? reportDescription : "", this.b().getUniqueExistingChild(Files.class));
                baselinesDirectory.addChild(baseline);
            }
            catch (Exception e2) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, "Failed to process report file '" + baselineReport + "'", new Object[]{e2});
            }
        }
        this.a(workerContext, baselineReport, true, baselineType);
        this.i.a(workerContext, this.b(), EnumSet.of(Modification.BASELINE_MODIFIED), (OperationResult)result);
        return result;
    }

    private Baseline a(TFile baselineReport, BaselinesDirectory baselinesDirectory) {
        Baseline existingBaseline = baselinesDirectory.getUniqueChild(namedElement -> {
            if (namedElement instanceof Baseline) {
                return FileUtility.areEqual((TFile)baselineReport, (TFile)((Baseline)namedElement).getFile());
            }
            return false;
        }, Baseline.class);
        return existingBaseline;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, TFile baselineReport, boolean enabled, BaselineType type) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'setBaseline' must not be null";
        assert (baselineReport != null) : "Parameter 'baselineReport' of method 'setBaseline' must not be null";
        assert (type != null) : "Parameter 'type' of method 'setBaseline' must not be null";
        OperationResult result = new OperationResult("Set baseline");
        if (!baselineReport.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, String.valueOf(type.getPresentationName()) + " baseline '" + baselineReport.getNormalizedAbsolutePath() + "' not found.", new Object[0]);
        } else if (!baselineReport.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION, "No permission to read " + type.getPresentationName() + " baseline '" + baselineReport.getNormalizedAbsolutePath() + "'.", new Object[0]);
        }
        if (!enabled) {
            this.clear();
            this.m = null;
        }
        this.a(workerContext, baselineReport, enabled, type, this.b().isClearable() && this.f(), result);
        return result;
    }

    private void a(IWorkerContext workerContext, TFile baselineReport, boolean enabled, BaselineType type, boolean runAnalyzers, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyChangedConfiguration' must not be null";
        assert (result != null) : "Parameter 'result' of method 'applyChangedConfiguration' must not be null";
        if (type == BaselineType.SYSTEM) {
            com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.b().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
            AnalyzerConfiguration config = analyzerExtension.b(CoreAnalyzerId.SYSTEM_DIFF);
            assert (config != null && config instanceof SystemDiffAnalyzerConfiguration) : "Unexpected class in method 'setBaseline': " + config;
            SystemDiffAnalyzerConfiguration original = (SystemDiffAnalyzerConfiguration)config;
            SystemDiffAnalyzerConfiguration diffConfig = original.copy();
            if (baselineReport != null) {
                diffConfig.setBaselinePath(FileUtility.calculateRelativePath((TFile)baselineReport, (TFile)this.b().getSystemDirectoryFile()));
            } else {
                diffConfig.setBaselinePath(null);
            }
            diffConfig.setEnabled(enabled);
            if (enabled) {
                this.b().setSystemProperty("useLocalBaseline", Boolean.toString(false));
                SystemPropertiesPersistenceProvider.storeProperties(this.b(), result);
            }
            if (runAnalyzers) {
                analyzerExtension.a(workerContext, diffConfig);
            } else {
                this.k.lastRecentlyUsed(baselineReport.getNormalizedAbsolutePath());
                this.e();
            }
        } else {
            this.b().setSystemProperty("useLocalBaseline", Boolean.toString(enabled));
            if (baselineReport != null) {
                this.b().setSystemProperty("localBaselinePath", baselineReport.getNormalizedAbsolutePath());
            }
            SystemPropertiesPersistenceProvider.storeProperties(this.b(), result);
            com.hello2morrow.sonargraph.core.controller.system.analysis.base.g analyzerExtension = this.b().getExtension(com.hello2morrow.sonargraph.core.controller.system.analysis.base.g.class);
            if (runAnalyzers) {
                Set<AnalyzerGroup> toRestart = analyzerExtension.a(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
                analyzerExtension.a(toRestart);
            } else {
                this.l.lastRecentlyUsed(baselineReport.getNormalizedAbsolutePath());
            }
        }
        this.i.a(this.b(), EnumSet.of(Modification.BASELINE_MODIFIED));
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        this.getBaselinesDirectory().checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return SystemDiffExtension.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!a && modifiableFile == null) {
                    throw new AssertionError((Object)"Parameter 'modifiableFile' of method 'exists' must not be null");
                }
                return modifiableFile instanceof Baseline;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return SystemDiffExtension.this.getBaselinesDirectory();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.BASELINE);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return "Baseline";
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return SystemDiffExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!(a || modified != null && modified instanceof Baseline)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + modified));
                }
                SystemDiffExtension.this.a(modified.getFile(), (Baseline)modified);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!(a || deleted != null && deleted instanceof Baseline)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + deleted));
                }
                Baseline toBeRemoved = (Baseline)deleted;
                toBeRemoved.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!a && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                result.addMessagesFrom(SystemDiffExtension.this.a(file, (Baseline)null));
            }
        }, true);
    }

    @Override
    public OperationResultWithOutcome<Baseline> a(IWorkerContext workerContext, TFile file) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addBaseline' must not be null";
        assert (file != null) : "Parameter 'file' of method 'addBaseline' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Adding file as baseline");
        BaselinesDirectory baselines = this.getBaselinesDirectory();
        try {
            if (!FileUtility.areEqual((TFile)baselines.getFile(), (TFile)file.getParentFile())) {
                result.addWarning((OperationResult.IMessageCause)BaselineMessageCause.NO_CHILD_OF_BASELINES_DIRECTORY, "Baseline has not been added to 'Baselines' directory.", new Object[0]);
                OperationResultWithOutcome operationResultWithOutcome = result;
                return operationResultWithOutcome;
            }
            Baseline existing = baselines.getChildren(Baseline.class).stream().filter(b2 -> FileUtility.areEqual((TFile)file, (TFile)b2.getFile())).findFirst().orElse(null);
            result.addMessagesFrom(this.a(file, existing));
            OperationResultWithOutcome operationResultWithOutcome = result;
            return operationResultWithOutcome;
        }
        finally {
            this.i.a(workerContext, this.b(), EnumSet.of(Modification.BASELINE_MODIFIED), (OperationResult)result);
        }
    }

    private OperationResult a(TFile file, Baseline baseline) {
        assert (file != null) : "Parameter 'contentFile' of method 'addBaseline' must not be null";
        OperationResultWithOutcome loadResult = new OperationResultWithOutcome("Adding baseline to model");
        BaselinesDirectory baselines = this.getBaselinesDirectory();
        if (baseline == null) {
            try {
                OperationResultWithOutcome<BaselineInfo> infoResult = new BaselineReader().read(file);
                if (!infoResult.isSuccess()) {
                    return loadResult;
                }
                BaselineInfo info = (BaselineInfo)infoResult.getOutcome();
                baseline = new Baseline(baselines, file, info.getCreationTime(), info.getDescription(), this.b().getUniqueExistingChild(Files.class));
                baselines.addChild(baseline);
            }
            catch (Exception exception) {}
        } else {
            baseline.reloaded(file.lastModified(), false);
        }
        baseline.setExistsOnDisk(true);
        baseline.resetTimestamp();
        TrueZipFacade.clear((TFile)file);
        loadResult.setOutcome((Object)baseline);
        return loadResult;
    }

    @Override
    public ISystemDiffProvider.DiffConfiguration getDiffConfiguration() {
        Properties systemProperties = this.b().getSystemProperties();
        String enabledLocalBaselineValue = this.b().getSystemProperty("useLocalBaseline");
        boolean localBaselineEnabled = Boolean.valueOf(enabledLocalBaselineValue);
        BaselineType baselineType = localBaselineEnabled ? BaselineType.LOCAL : BaselineType.SYSTEM;
        String localBaselineValue = systemProperties.getProperty("localBaselinePath");
        TFile localBaseline = localBaselineValue == null || localBaselineValue.trim().isEmpty() ? null : new TFile(localBaselineValue);
        SystemDiffAnalyzerConfiguration analyzerConfiguration = this.c();
        String baselinePath = analyzerConfiguration.getBaselinePath();
        TFile systemBaseline = baselinePath != null && !baselinePath.trim().isEmpty() ? (FileUtility.isRelativePath((String)baselinePath) ? new TFile((File)this.b().getSystemDirectoryFile(), baselinePath) : new TFile(baselinePath)) : null;
        boolean systemBaselineEnabled = analyzerConfiguration.isEnabled();
        return new ISystemDiffProvider.DiffConfiguration(baselineType, localBaseline, systemBaseline, localBaselineEnabled || systemBaselineEnabled);
    }

    @Override
    public void a(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, TFile oldSystemDirectory, OperationResult result, boolean baseDirectoryChanged) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'savedAs' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'savedAs' must not be null";
        assert (oldSystemDirectory != null) : "Parameter 'oldSystemDirectory' of method 'savedAs' must not be null";
        assert (result != null) : "Parameter 'result' of method 'savedAs' must not be null";
        if (!this.isSystemDiffActive()) {
            return;
        }
        SystemDiffAnalyzerConfiguration analyzerConfiguration = this.c();
        String baselinePath = analyzerConfiguration.getBaselinePath();
        if (baselinePath != null && !baselinePath.trim().isEmpty() && FileUtility.isRelativePath((String)baselinePath)) {
            TFile systemBaseline = new TFile((File)oldSystemDirectory, baselinePath);
            TFile currentSystemDirectory = softwareSystem.getUniqueChild(Files.class).getSystemDirectory().getFile();
            String newBaselinePath = FileUtility.calculateRelativePath((TFile)systemBaseline, (TFile)currentSystemDirectory);
            analyzerConfiguration.setBaselinePath(newBaselinePath);
            c analyzerExtension = this.b().getExtension(c.class);
            analyzerExtension.a((IWorkerContext)DefaultWorkerContext.INSTANCE, analyzerConfiguration);
        }
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, List<Baseline> baselines) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteBaseline' must not be null";
        assert (baselines != null && !baselines.isEmpty()) : "Parameter 'baselines' of method 'deleteBaseline' must not be empty";
        OperationResult result = new OperationResult("Delete baseline(s)");
        TFile activeBaseline = this.getActiveBaseline();
        IBaseDirectory systemBaseDirectory = this.getBaselinesDirectory().getParent(IBaseDirectory.class, new Class[0]);
        for (Baseline next : baselines) {
            if (activeBaseline != null && FileUtility.areEqual((TFile)activeBaseline, (TFile)next.getFile())) {
                this.a(workerContext, true);
            } else {
                SystemDiffAnalyzerConfiguration configuration = this.c();
                if (next.calculateRelativePath(systemBaseDirectory).equals(configuration.getBaselinePath())) {
                    configuration.setBaselinePath(null);
                    this.g().setNeedsSave(true);
                }
            }
            String entry = next.getFile().getNormalizedAbsolutePath();
            if (this.l.contains(entry)) {
                this.l.remove(entry);
            }
            if (this.k.contains(entry)) {
                this.k.remove(entry);
            }
            SoftwareSystemFilesDirectory.removeFile(next.getFile(), false, result);
            next.remove();
        }
        this.i.a(workerContext, this.b(), EnumSet.of(Modification.BASELINE_MODIFIED), result);
        return result;
    }

    private static enum BaselineMessageCause implements OperationResult.IMessageCause
    {
        NO_CHILD_OF_BASELINES_DIRECTORY;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static class a {
        private final TFile b;
        private final long c;
        private final ISoftwareSystem d;
        private final com.hello2morrow.sonargraph.integration.access.controller.g e;
        private final BaselineType f;

        public a(TFile reportFile, ISoftwareSystem baselineSystem, com.hello2morrow.sonargraph.integration.access.controller.g systemInfoProcessor, BaselineType type) {
            assert (reportFile != null) : "Parameter 'reportFile' of method 'LastBaselineReportProcessing' must not be null";
            assert (baselineSystem != null) : "Parameter 'baselineSystem' of method 'LastBaselineReportProcessing' must not be null";
            assert (systemInfoProcessor != null) : "Parameter 'systemInfoProcessor' of method 'LastBaselineReportProcessing' must not be null";
            assert (type != null) : "Parameter 'type' of method 'LastBaselineReportProcessing' must not be null";
            this.b = reportFile;
            this.c = reportFile.lastModified();
            this.d = baselineSystem;
            this.e = systemInfoProcessor;
            this.f = type;
        }

        public TFile a() {
            return this.b;
        }

        public long b() {
            return this.c;
        }

        public ISoftwareSystem c() {
            return this.d;
        }

        public com.hello2morrow.sonargraph.integration.access.controller.g d() {
            return this.e;
        }

        public BaselineType e() {
            return this.f;
        }
    }
}

