/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.PersistentRecentlyUsedList;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.controller.system.A;
import com.hello2morrow.sonargraph.core.controller.system.B;
import com.hello2morrow.sonargraph.core.controller.system.D;
import com.hello2morrow.sonargraph.core.controller.system.F;
import com.hello2morrow.sonargraph.core.controller.system.G;
import com.hello2morrow.sonargraph.core.controller.system.H;
import com.hello2morrow.sonargraph.core.controller.system.I;
import com.hello2morrow.sonargraph.core.controller.system.J;
import com.hello2morrow.sonargraph.core.controller.system.K;
import com.hello2morrow.sonargraph.core.controller.system.M;
import com.hello2morrow.sonargraph.core.controller.system.PluginExtension;
import com.hello2morrow.sonargraph.core.controller.system.RefreshProcessor;
import com.hello2morrow.sonargraph.core.controller.system.ReportExtension;
import com.hello2morrow.sonargraph.core.controller.system.S;
import com.hello2morrow.sonargraph.core.controller.system.SearchExtension;
import com.hello2morrow.sonargraph.core.controller.system.SystemDiffExtension;
import com.hello2morrow.sonargraph.core.controller.system.ThresholdExtension;
import com.hello2morrow.sonargraph.core.controller.system.VirtualModelExtension;
import com.hello2morrow.sonargraph.core.controller.system.W;
import com.hello2morrow.sonargraph.core.controller.system.Y;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aA;
import com.hello2morrow.sonargraph.core.controller.system.aD;
import com.hello2morrow.sonargraph.core.controller.system.aF;
import com.hello2morrow.sonargraph.core.controller.system.aK;
import com.hello2morrow.sonargraph.core.controller.system.aM;
import com.hello2morrow.sonargraph.core.controller.system.aR;
import com.hello2morrow.sonargraph.core.controller.system.aS;
import com.hello2morrow.sonargraph.core.controller.system.aT;
import com.hello2morrow.sonargraph.core.controller.system.aU;
import com.hello2morrow.sonargraph.core.controller.system.aV;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.ai;
import com.hello2morrow.sonargraph.core.controller.system.aj;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.ao;
import com.hello2morrow.sonargraph.core.controller.system.ar;
import com.hello2morrow.sonargraph.core.controller.system.as;
import com.hello2morrow.sonargraph.core.controller.system.at;
import com.hello2morrow.sonargraph.core.controller.system.au;
import com.hello2morrow.sonargraph.core.controller.system.av;
import com.hello2morrow.sonargraph.core.controller.system.ax;
import com.hello2morrow.sonargraph.core.controller.system.ay;
import com.hello2morrow.sonargraph.core.controller.system.az;
import com.hello2morrow.sonargraph.core.controller.system.b;
import com.hello2morrow.sonargraph.core.controller.system.b.a;
import com.hello2morrow.sonargraph.core.controller.system.ba;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.bd;
import com.hello2morrow.sonargraph.core.controller.system.bf;
import com.hello2morrow.sonargraph.core.controller.system.bi;
import com.hello2morrow.sonargraph.core.controller.system.bj;
import com.hello2morrow.sonargraph.core.controller.system.bk;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.controller.system.h;
import com.hello2morrow.sonargraph.core.controller.system.l;
import com.hello2morrow.sonargraph.core.controller.system.m;
import com.hello2morrow.sonargraph.core.controller.system.n;
import com.hello2morrow.sonargraph.core.controller.system.o;
import com.hello2morrow.sonargraph.core.controller.system.q;
import com.hello2morrow.sonargraph.core.controller.system.r;
import com.hello2morrow.sonargraph.core.controller.system.u;
import com.hello2morrow.sonargraph.core.controller.system.x;
import com.hello2morrow.sonargraph.core.controller.system.y;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureDeprecationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.IIssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerExecutionLevelChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.InstallationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.path.TreeMapsDirectory;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.programming.IssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.IRelevantSourceFileIterator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemCreator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemFromSnapshotCreator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistry;
import com.hello2morrow.sonargraph.core.model.system.SystemDirectoryLocationInfo;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.settings.SoftwareSystemSettingsFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystemPropertiesReader;
import com.hello2morrow.sonargraph.core.persistence.system.SystemPropertiesPersistenceProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XmlSystemPersistenceProvider;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SoftwareSystemController
extends Extension
implements M,
com.hello2morrow.sonargraph.core.controllerinterface.system.y,
ISoftwareSystemCreator,
ISoftwareSystemFromSnapshotCreator {
    private final EnumSet<OptionalExtensionId> b;
    private final aa c;
    private final ar d;
    private final D e;
    private final Installation f;
    private final A g;
    private final ISoftwareSystemProvider.BackgroundTaskExecutionMode h;
    private final com.hello2morrow.sonargraph.core.controllerinterface.common.a i;
    private IContext j;
    private AnalyzerExecutionLevel k;
    private PersistentRecentlyUsedList l;
    private SoftwareSystem m;
    private RefreshProcessor n;

    static {
        TrueZipFacade.initialize();
    }

    public SoftwareSystemController(com.hello2morrow.sonargraph.core.controllerinterface.common.a licenseProvider, Set<Z> languageProviders, ScriptOutputStreamProvider scriptOutputStreamProvider, ISoftwareSystemProvider.BackgroundTaskExecutionMode backgroundTaskExecutionMode, AnalyzerExecutionLevel level, EnumSet<OptionalExtensionId> disabledExtensions) {
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'SoftwareSystemController' must not be null";
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'SoftwareSystemController' must not be null";
        assert (scriptOutputStreamProvider != null) : "Parameter 'scriptOutputStreamProvider' of method 'SoftwareSystemController' must not be null";
        assert (backgroundTaskExecutionMode != null) : "Parameter 'backgroundTaskExecutionMode' of method 'SoftwareSystemController' must not be null";
        assert (level != null) : "Parameter 'level' of method 'SoftwareSystemController' must not be null";
        assert (disabledExtensions != null) : "Parameter 'disabledExtensions' of method 'SoftwareSystemController' must not be null";
        this.i = licenseProvider;
        this.c = new aa(languageProviders);
        this.h = backgroundTaskExecutionMode;
        this.k = level;
        this.b = EnumSet.copyOf(disabledExtensions);
        this.f = new Installation(licenseProvider.e());
        this.f.addProviderIds(Collections.singleton(CoreProviderId.INSTANCE));
        THashSet issueIds = new THashSet(Arrays.asList(CoreIssueId.values()));
        issueIds.add(ArchitectureViolationIssueId.INSTANCE);
        issueIds.add(ArchitectureDeprecationIssueId.INSTANCE);
        this.f.addIssueIds((Set<? extends IIssueId>)issueIds);
        this.f.addAvailableIssueTypes((Set<IIssueAffectedElementType>)new THashSet(Arrays.asList(IssueAffectedElementType.values())));
        this.f.addExtension(this);
        this.f.addExtension(new ai(this.c, this.f));
        this.f.addExtension(new az(this.c));
        au propertiesExtension = this.f.addExtension(new au());
        this.f.addExtension(new B(this.f, propertiesExtension, this.h));
        this.f.addExtension(new com.hello2morrow.sonargraph.core.controller.a.a());
        ao notificationExtension = this.f.addExtension(new ao(this.f));
        this.g = new A(this.f);
        for (Z nextLanguageProvider : this.c.d()) {
            if (!licenseProvider.a(nextLanguageProvider.getLanguage()) || licenseProvider.b(nextLanguageProvider.getLanguage()) == -1) {
                assert (false) : "Unavailable/unlicensed language: " + nextLanguageProvider.getLanguage();
                throw new IllegalArgumentException("Unavailable/unlicensed language: " + nextLanguageProvider.getLanguage());
            }
            this.f.addProviderIds(Collections.singleton(nextLanguageProvider.m()));
            this.f.addIssueIds(nextLanguageProvider.f());
        }
        this.e = new D(this.c, licenseProvider, notificationExtension, scriptOutputStreamProvider);
        this.c.d().forEach(lp -> lp.a(this.f, (g)this.e));
        this.d = new ar(this, this.f, this.c);
        this.f.addExtension(new y(this, this.c, this.d));
        this.f.addExtension(new PluginExtension(this, this.c, this.e));
        this.f.addExtension(new K(this.f, this.e));
        if (this.i.c() != SonargraphProduct.SONARGRAPH_BUILD && this.i.a(SonargraphFeature.ARCHITECTURE)) {
            this.f.addExtension(new aF(this.f, licenseProvider.c(), this.g, this.e, !this.b.contains((Object)OptionalExtensionId.REMOTE_SELECTION)));
        }
        this.f.getExtensions().forEach(e2 -> e2.finishInstallationInitialization());
        this.f.finishInitialization();
    }

    @Override
    public void shutdown() {
        this.f.getExtensions().stream().filter(e2 -> e2 != this).forEach(e2 -> e2.shutdown());
    }

    @Override
    public com.hello2morrow.sonargraph.core.controllerinterface.system.D b() {
        return this.e;
    }

    @Override
    public INamedElementResolver getElementResolver() {
        return this.g;
    }

    @Override
    public boolean isLanguageAvailable(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isLanguageAvailable' must not be null";
        return this.i.a(language);
    }

    @Override
    public int getUsedSize(Language language) {
        return this.c.a(language);
    }

    public Z a(Language language) {
        return this.c.b(language);
    }

    @Override
    public Installation getInstallation() {
        return this.f;
    }

    @Override
    public ISoftwareSystemProvider.BackgroundTaskExecutionMode a() {
        return this.h;
    }

    @Override
    public AnalyzerExecutionLevel getAnalyzerExecutionLevel() {
        return this.k;
    }

    @Override
    public AnalyzerExecutionLevel getLastAppliedAnalyzerExecutionLevel() {
        return this.m != null ? this.m.getExtension(c.class).c() : null;
    }

    @Override
    public IContext getDefaultContext() {
        if (this.j == null) {
            this.j = new a(this);
        }
        return this.j;
    }

    @Override
    public void a(AnalyzerExecutionLevel level) {
        assert (level != null) : "Parameter 'level' of method 'setAnalyzerExecutionLevel' must not be null";
        if (!this.k.equals((Object)level)) {
            if (this.m != null) {
                AnalyzerExecutionLevel from = this.k;
                this.k = level;
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerExecutionLevelChangedEvent(this));
                this.m.getExtension(c.class).a(from, level);
            } else {
                this.k = level;
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerExecutionLevelChangedEvent(this));
            }
        }
    }

    @Override
    public boolean hasSoftwareSystem() {
        return this.m != null && this.m.isValid();
    }

    @Override
    public SoftwareSystem getSoftwareSystem() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        return this.m;
    }

    @Override
    public ISoftwareSystemProvider.PathType getPathType(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'getPathType' must not be empty";
        if (this.e().isValid(null, new TFile(path)).isSuccess()) {
            return ISoftwareSystemProvider.PathType.SOFTWARE_SYSTEM;
        }
        if (this.f().isValid(null, new TFile(path)).isSuccess()) {
            return ISoftwareSystemProvider.PathType.SNAPSHOT;
        }
        return null;
    }

    @Override
    public PersistentRecentlyUsedList getRecentlyUsedList() {
        if (this.l == null) {
            this.l = new PersistentRecentlyUsedList(String.valueOf(CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir().getAbsolutePath()) + "/" + this.e.b().c().getDirectoryName() + "/" + "softwaresystem.rud", 20);
        }
        if (this.l.size() > 0) {
            List allEntries = this.l.getAll();
            ArrayList<String> toBeRemoved = new ArrayList<String>(allEntries.size());
            ArrayList<TFile> allValidPathsAsFiles = new ArrayList<TFile>(allEntries.size());
            for (String nextPath : allEntries) {
                if (this.getPathType(nextPath) == null) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                boolean isDuplicate = false;
                TFile nextPathAsFile = new TFile(nextPath);
                for (TFile nextAlreadyAddedPathAsFile : allValidPathsAsFiles) {
                    if (!FileUtility.areEqual((TFile)nextPathAsFile, (TFile)nextAlreadyAddedPathAsFile)) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                allValidPathsAsFiles.add(nextPathAsFile);
            }
            toBeRemoved.forEach(r2 -> this.l.remove(r2));
        }
        return this.l;
    }

    @Override
    public ITextValidator c() {
        return new aS();
    }

    @Override
    public IPathValidator d() {
        return SoftwareSystemBaseDirectory.getValidator();
    }

    @Override
    public IPathValidator e() {
        return SoftwareSystemDirectory.getValidator();
    }

    @Override
    public IPathValidator f() {
        return aM.a();
    }

    @Override
    public String a(TFile baseDirectory, String systemName) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'validateOverwrite' must not be null";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'validateOverwrite' must not be empty";
        return Files.validateSystemOverwrite(baseDirectory, systemName);
    }

    private void a(SoftwareSystem system, boolean enableWorkspaceFilter, OperationResult result) {
        assert (system != null) : "Parameter 'system' of method 'initializeSoftwareSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'initializeSoftwareSystem' must not be null";
        system.getUniqueExistingChild(Workspace.class).getWorkspaceFilter().setEnabled(enableWorkspaceFilter);
        system.setClassLoader(this.c.a());
        this.g.a(system);
        aA refactoringProcessor = new aA(this.c, system, this.g);
        system.addExtension(this);
        system.addExtension(new aR(this.c));
        W issueExtension = new W(this.c, system, refactoringProcessor, this.e);
        system.addExtension(issueExtension);
        system.addExtension(new x(system));
        system.addExtension(new SearchExtension(system));
        system.addExtension(new F(system, this.e, this.g));
        StructureItemRegistry structureItemRegistry = new StructureItemRegistry();
        this.c.d().forEach(lp -> structureItemRegistry.createStructure(lp.getLanguage(), lp.n()));
        system.addExtension(new G(this.c, system, this.e, this.g, structureItemRegistry));
        system.addExtension(new r(this.c, system, this.e, this.g, structureItemRegistry));
        system.addExtension(new ay(this.c, system, this.e));
        system.addExtension(new ReportExtension(this.f, system, this.e.b().s(), this.e.b().t()));
        aM snapshotExtension = new aM(this.c, this, system, this.h, this.e);
        system.addExtension(snapshotExtension);
        system.addExtension(new bi(this.c, this.f, system, this.e));
        system.addExtension(new bj(this.f, system, this.e));
        c analyzerExtension = new c(this.c, this.f, system, this.e, this, this.g, this.i.c());
        system.addExtension(analyzerExtension);
        system.addExtension(new SystemDiffExtension(system, this.e));
        system.addExtension(new ThresholdExtension(system, this.f.getExtension(IMetricsProvider.class), issueExtension, this.e));
        VirtualModelExtension virtualModelExtension = system.addExtension(new VirtualModelExtension(this.f, system, refactoringProcessor, this.e, this.g, this.f.getExtension(PluginExtension.class)));
        com.hello2morrow.sonargraph.core.controller.system.g architecturalViewExtension = new com.hello2morrow.sonargraph.core.controller.system.g(this.c, this.f, system, this.g, this.e, !this.b.contains((Object)OptionalExtensionId.ARCHITECTURAL_VIEW));
        system.addExtension(architecturalViewExtension);
        system.addExtension(new h(this.c, this.f, system, this.g, this.e, !this.b.contains((Object)OptionalExtensionId.ARCHITECTURAL_VIEW)));
        system.addExtension(new av(this.f, this.m, this.e));
        ba treeMapExtension = new ba(this.f, system, this.e, !this.b.contains((Object)OptionalExtensionId.TREEMAP));
        system.addExtension(treeMapExtension);
        ArrayList<IAssignableAttributeRetriever> lpRetrievers = new ArrayList<IAssignableAttributeRetriever>();
        this.c.d().forEach(lp -> {
            boolean bl2 = lpRetrievers.addAll(lp.c());
        });
        system.addExtension(new n(this.f, system, lpRetrievers, this.e));
        m architectureDiagramExtension = new m(system, this.e, !this.b.contains((Object)OptionalExtensionId.ARCHITECTURE_DIAGRAM));
        system.addExtension(architectureDiagramExtension);
        as pluginConfigurationExtension = new as(this.f.getVersion(), system, this.e, this.f.getExtension(PluginExtension.class));
        system.addExtension(pluginConfigurationExtension);
        system.addExtension(new aK(this.c, system, this.e));
        system.addExtension(new q(system));
        system.addExtension(new H(this.c, this.f, system, this.e.a(), this.e));
        system.addExtension(new u(this.f, system, this.e, this.c, !this.b.contains((Object)OptionalExtensionId.DASHBOARD)));
        system.addExtension(new Y(system));
        bd undoRedoExtension = new bd(this.f, system, snapshotExtension, analyzerExtension, this.e, system.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT && !this.b.contains((Object)OptionalExtensionId.UNDO_REDO));
        if (undoRedoExtension.isEnabled()) {
            undoRedoExtension.a(new aV(system, this.c, this.d));
            undoRedoExtension.a(new bf(virtualModelExtension));
            undoRedoExtension.a(new l(architecturalViewExtension));
            undoRedoExtension.a(new com.hello2morrow.sonargraph.core.controller.system.base.o<TreeMapsDirectory, TreeMapFile>(treeMapExtension));
            undoRedoExtension.a(new J(system));
            undoRedoExtension.a(new I(system));
            undoRedoExtension.a(new b(this.f, system));
            undoRedoExtension.a(new at(pluginConfigurationExtension));
            undoRedoExtension.a(new o(system));
            undoRedoExtension.a(new bk(system));
            undoRedoExtension.a(new ax(system));
            undoRedoExtension.a(new aU(system, this.c));
        }
        system.addExtension(undoRedoExtension);
        this.c.d().forEach(lp -> lp.a(system, (g)this.e));
        system.getExtensions().forEach(e2 -> e2.finishSoftwareSystemInitialization(result));
        system.setState(SoftwareSystemState.OPENED);
        system.finishInitialization();
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, TFile directory, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions, String systemName, String description, ImportQualityModel qualityModel) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createSoftwareSystem' must not be null";
        assert (directory != null) : "Parameter 'directory' of method 'createSoftwareSystem' must not be null";
        assert (this.c().isValid(null, systemName).isSuccess()) : "Not a valid name: " + systemName;
        assert (openOptions != null) : "Parameter 'openOptions' of method 'createSoftwareSystem' must not be null";
        assert (description != null) : "Parameter 'description' of method 'createSoftwareSystem' must not be null";
        OperationResult result = new OperationResult("Create software system");
        if (directory.exists() && !directory.isDirectory()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_DIRECTORY, "'" + directory.getAbsolutePath() + "' is not a directory.", new Object[0]);
            return result;
        }
        TFile systemDirectory = new TFile((File)directory, Files.getSystemDirectoryRelPath(systemName)).getNormalizedAbsoluteFile();
        workerContext.working("Create system", true);
        if (FileUtility.removeRecursively((TFile)systemDirectory, (OperationResult)result).isFailure()) {
            return result;
        }
        systemDirectory = FileUtility.getOrCreateDirectory((TFile)systemDirectory, (OperationResult)result);
        if (result.isSuccess()) {
            TFile systemFile = FileUtility.getOrCreateFile((TFile)new TFile((File)systemDirectory, "system.sonargraph"), (OperationResult)result);
            if (result.isSuccess()) {
                SoftwareSystem softwareSystem = this.createSoftwareSystem(systemName, StringUtility.createTimebasedId((String)systemName), systemFile, new Properties(), false);
                if (result.isSuccess()) {
                    assert (softwareSystem != null) : "'softwareSystem' of method 'createSoftwareSystem' must not be null";
                    this.m = softwareSystem;
                    this.m.setDescription(description);
                    workerContext.working("Initialize system", true);
                    this.a(softwareSystem, !openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.DISABLE_WORKSPACE_FILTER), result);
                    if (result.isSuccess()) {
                        result.addMessagesFrom(this.d.a(null).save(this.m, this.c.a()));
                        if (result.isSuccess()) {
                            TrueZipFacade.clear((TFile)systemFile);
                            this.m.getUniqueExistingChild(Files.class).getSoftwareSystemFile().resetTimestamp();
                            this.n = new RefreshProcessor(this.c, this.e, this.f, softwareSystem, this.h);
                            OperationResult loadQualityModelResult = null;
                            if (qualityModel != null) {
                                loadQualityModelResult = this.m.getExtension(ay.class).a(workerContext, qualityModel, null);
                            }
                            this.m.getUniqueExistingChild(Files.class).writeNameTag(this.m.getName(), result);
                            if (loadQualityModelResult != null) {
                                boolean isFailure = result.isFailure();
                                result.addMessagesFrom(loadQualityModelResult);
                                if (!isFailure) {
                                    result.setIsSuccess(true);
                                }
                            }
                            if (openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.SWITCH_TO_DEFAULT_MODEL)) {
                                this.m.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                            }
                            this.f.getExtension(PluginExtension.class).a(workerContext, this.m, false, result);
                            this.e.b(workerContext, this.m, result);
                        }
                    }
                    if (result.isFailure()) {
                        this.k();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void initializeFromSnapshot(SoftwareSystem softwareSystem, TFile systemBaseDirectory) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initializeFromSnapshot' must not be null";
        assert (systemBaseDirectory != null) : "Parameter 'systemBaseDirectory' of method 'initializeFromSnapshot' must not be null";
        softwareSystem.addChild(new Files(softwareSystem, this.e.b().c(), systemBaseDirectory));
        softwareSystem.setModel(softwareSystem.getParserModel());
        softwareSystem.addChild(new LogicalSystemNamespaces(softwareSystem));
        softwareSystem.addChild(new LogicalModuleNamespaces(softwareSystem));
        softwareSystem.addChild(new Representations(softwareSystem));
    }

    @Override
    public void finishInitializationFromSnapshot(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishInitializationFromSnapshot' must not be null";
        softwareSystem.getUniqueExistingChild(Files.class).finishInitializationFromSnapshot(softwareSystem.getId(), softwareSystem.getName());
    }

    @Override
    public SoftwareSystem createSoftwareSystem(String name, String id, TFile systemFile, Properties systemProperties, boolean isTemporary) {
        assert (systemFile != null) : "Parameter 'systemFile' of method 'createSoftwareSystem' must not be null";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'createSoftwareSystem' must not be empty";
        SoftwareSystem softwareSystem = new SoftwareSystem(id, name, this.f.getVersion(), systemProperties);
        TFile normalizedSystemFile = systemFile.getNormalizedAbsoluteFile();
        TFile systemDirectory = normalizedSystemFile.getParentFile();
        assert (systemDirectory != null) : "'systemDirectory' of method 'initializeSoftwareSystem' must not be null";
        TFile systemBaseDirectory = systemDirectory.getParentFile();
        assert (systemBaseDirectory != null) : "'systemBaseDirectory' of method 'initializeSoftwareSystem' must not be null";
        softwareSystem.addChild(new Files(softwareSystem, this.e.b().c(), systemBaseDirectory, softwareSystem.getId(), softwareSystem.getName(), isTemporary));
        softwareSystem.setModel(softwareSystem.getParserModel());
        assert (softwareSystem.getUniqueChild(Workspace.class) == null) : "Workspace already added";
        softwareSystem.addChild(new Workspace(softwareSystem));
        softwareSystem.addChild(new LogicalSystemNamespaces(softwareSystem));
        softwareSystem.addChild(new LogicalModuleNamespaces(softwareSystem));
        softwareSystem.addChild(new Representations(softwareSystem));
        return softwareSystem;
    }

    @Override
    public OperationResultWithOutcome<WorkspaceDependency> createWorkspaceDependency(SoftwareSystem softwareSystem, String language, String from, String toId, String toName, String type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        return bi.a(this.c, softwareSystem, language, from, toId, toName, type, dependencyData);
    }

    @Override
    public OperationResultWithOutcome<Module> createModule(SoftwareSystem softwareSystem, String languageStandardName, String moduleTypeStandardName, String id, String moduleName, String description) {
        return bi.a(this.c, softwareSystem, languageStandardName, moduleTypeStandardName, id, moduleName, description);
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, TFile snapshotFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'openSoftwareSystemFromSnapshot' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'openSoftwareSystemFromSnapshot' must not be null";
        OperationResult result = new OperationResult("Open system from snapshot");
        OperationResultWithOutcome<SoftwareSystem> loadSnapshotResult = aM.a(workerContext, this, snapshotFile, this.c);
        result.addMessagesFrom(loadSnapshotResult);
        if (result.isSuccess()) {
            this.m = (SoftwareSystem)loadSnapshotResult.getOutcome();
            this.m.setLoadedFromSnapshot(snapshotFile);
            this.n = new RefreshProcessor(this.c, this.e, this.f, this.m, this.h);
            this.a(this.m, true, result);
            if (result.isSuccess()) {
                aM.a(this.m, snapshotFile);
                this.m.setState(SoftwareSystemState.MODEL_LOADED);
                PrepareRefreshResult prepareRefreshResult = new PrepareRefreshResult(this.m.getUsedLanguages(), Collections.emptySet());
                this.n.a(workerContext, true, prepareRefreshResult);
                this.n.a(workerContext, null, result, prepareRefreshResult);
                this.c.a(this.m.getUsedLanguages()).forEach(lp -> lp.a(workerContext, this.m, (IFilePathListener)null));
                if (this.e.b().a(SonargraphFeature.VIRTUAL_MODELS)) {
                    workerContext.working("Switch to default virtual model", true);
                    this.m.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                }
                this.f.getExtension(PluginExtension.class).a(workerContext, this.m, true, result);
                this.e.a(workerContext, this.m, null, true, result);
                this.e.a(this.m);
                this.m.getExtension(c.class).a(workerContext, true);
            } else {
                this.k();
            }
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<List<TFile>> a(IWorkerContext workerContext, TFile snapshotFile, TFile targetDirectory) {
        return aM.a(workerContext, snapshotFile, targetDirectory);
    }

    @Override
    public OperationResult b(IWorkerContext workerContext, TFile snapshotFile, TFile targetDirectory) {
        aM.a extractionInfo;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'openSnapshotAttached' must not be null";
        assert (snapshotFile != null) : "Parameter 'snapshotFile' of method 'openSnapshotAttached' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'openSnapshotAttached' must not be null";
        OperationResult result = new OperationResult("Open snapshot attached '" + snapshotFile.getAbsolutePath() + "'");
        try {
            extractionInfo = aM.b(workerContext, snapshotFile, targetDirectory);
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_EXTRACT, (Throwable)e2);
            return result;
        }
        assert (extractionInfo != null) : "'extractionInfo' of method 'openSnapshotAttached' must not be null";
        TFile softwareSystemDirectory = extractionInfo.a();
        assert (softwareSystemDirectory != null) : "Parameter 'softwareSystemDirectory' of method 'openSnapshotAttached' must not be null";
        TrueZipFacade.clear();
        workerContext.working("Load system", true);
        this.m = this.loadSoftwareSystem(softwareSystemDirectory, true, result, EnumSet.noneOf(ISoftwareSystemProvider.OpenOption.class));
        if (result.isSuccess()) {
            assert (this.m != null) : "'m_softwareSystem' of method 'openSnapshotAttached' must not be null";
            this.n = new RefreshProcessor(this.c, this.e, this.f, this.m, this.h);
            this.c.a(this.m.getUsedLanguages()).forEach(lp -> lp.a(this.f, this.m, result, true));
            this.a(this.m, true, result);
            if (result.isSuccess()) {
                PrepareRefreshResult prepareRefreshResult = new PrepareRefreshResult(this.m.getUsedLanguages(), Collections.emptySet());
                this.n.a(workerContext, true, prepareRefreshResult);
                this.n.a(workerContext, null, result, prepareRefreshResult);
                result.addMessagesFromMaintainingCurrentOutcome((OperationResult)prepareRefreshResult);
                if (result.isSuccess()) {
                    assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'openSoftwareSystem' must not be null";
                    this.m.getExtension(bi.class).a(prepareRefreshResult, null);
                    if (this.e.b().a(SonargraphFeature.VIRTUAL_MODELS)) {
                        workerContext.working("Switch to default virtual model", true);
                        this.m.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                    }
                    OperationResultWithOutcome<SoftwareSystem> loadFromSnaphotResult = this.m.getExtension(aM.class).a(workerContext, snapshotFile);
                    result.addMessagesFromAffectingCurrentOutcome(loadFromSnaphotResult);
                    if (result.isSuccess()) {
                        this.m.getExtension(aM.class).a(workerContext, (SoftwareSystem)loadFromSnaphotResult.getOutcome(), result);
                        workerContext.working("Finish software system open", true);
                        this.f.getExtension(PluginExtension.class).a(workerContext, this.m, true, result);
                        this.e.a(workerContext, this.m, null, true, result);
                        result.setIsSuccess(true);
                        this.m.getUniqueExistingChild(Files.class).writeNameTag(this.m.getName(), result);
                        this.e.a(this.m);
                        this.m.getExtension(c.class).a(workerContext, true);
                    }
                }
            }
            if (result.isFailure()) {
                aM.a(extractionInfo, result);
                this.k();
            } else {
                this.m.getExtension(aM.class).b(extractionInfo, result);
            }
        } else assert (this.m == null) : "'m_softwareSystem' of method 'openSnapshotAttached' must be null";
        TrueZipFacade.clear();
        return result;
    }

    private void a(TFile qualityModel, OperationResult result) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'initializeExternalQualityModel' must not be null";
        assert (result != null) : "Parameter 'result' of method 'initializeExternalQualityModel' must not be null";
        if (!(qualityModel.exists() && qualityModel.isArchive() && qualityModel.canRead())) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_FILE, "Specified quality model '" + qualityModel.getNormalizedAbsolutePath() + "' does not exist or is not accessible.", new Object[0]);
            return;
        }
        String extension = FileUtility.getExtension((String)qualityModel.getName());
        if (!CoreFileType.QUALITY_MODEL.hasExtension(extension)) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.UNEXPECTED_FILE_EXTENSION, "qualityModel has an invalid file extension '" + extension + "'. Must be one of '" + StringUtility.concat((char)',', (String[])CoreFileType.QUALITY_MODEL.getExtensions()) + "'", new Object[0]);
            return;
        }
        if (qualityModel.listFiles().length == 0) {
            result.addWarning((OperationResult.IMessageCause)IOMessageCause.EMPTY, "Specified quality model '" + qualityModel.getNormalizedAbsolutePath() + "' is empty.", new Object[0]);
        }
        TFile qualityModelAbsolute = qualityModel.getAbsoluteFile();
        this.m.getExtensions(S.class).forEach(qmp -> qmp.a(qualityModelAbsolute));
        this.m.setExternalQualityModel(qualityModelAbsolute);
    }

    @Override
    public SoftwareSystem loadSoftwareSystem(TFile file, boolean isTemporary, OperationResult result, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions) {
        assert (file != null) : "Parameter 'file' of method 'loadSoftwareSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'loadSoftwareSystem' must not be null";
        SoftwareSystemDirectory.checkDirectory(file, result);
        if (result.isFailure()) {
            return null;
        }
        TFile systemFile = new TFile((File)file, "system.sonargraph");
        SoftwareSystemFile.checkSoftwareSystemFile(systemFile, result);
        if (result.isFailure()) {
            return null;
        }
        OperationResultWithOutcome<SoftwareSystemPropertiesReader.SoftwareSystemProperties> readPropertiesResult = SoftwareSystemPropertiesReader.read(systemFile);
        result.addMessagesFrom(readPropertiesResult);
        if (result.isFailure()) {
            return null;
        }
        SoftwareSystemPropertiesReader.SoftwareSystemProperties properties = (SoftwareSystemPropertiesReader.SoftwareSystemProperties)readPropertiesResult.getOutcome();
        Set<Language> detectedLanguages = this.c.a(properties.getLanguages(), result);
        if (result.isFailure()) {
            return null;
        }
        Properties systemProperties = SystemPropertiesPersistenceProvider.readProperties(new TFile((File)Files.getHiddenSystemsDirectory(this.i.c()), properties.getId()));
        this.c.a(detectedLanguages).forEach(lp -> lp.a(systemProperties, result));
        if (result.isFailure()) {
            return null;
        }
        XmlSystemPersistenceProvider persistenceProvider = this.d.a(detectedLanguages);
        OperationResultWithOutcome<SoftwareSystem> loadXmlResult = persistenceProvider.load(systemFile, SoftwareSystemDirectory.getSoftwareSystemName(file), this.c.a(), systemProperties, isTemporary);
        result.addMessagesFrom(loadXmlResult);
        if (result.isFailure()) {
            return null;
        }
        boolean saveIt = false;
        if (!persistenceProvider.systemCanBeLoaded()) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.CANNOT_LOAD_SYSTEM, "System cannot be loaded and must be re-imported", new Object[0]);
            return null;
        }
        if (!persistenceProvider.canLoadSnapshot()) {
            openOptions.remove((Object)ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT);
            saveIt = true;
        } else if (persistenceProvider.systemWasMigratedAndNeedsSave()) {
            saveIt = true;
        }
        if (saveIt) {
            OperationResult saveResult = persistenceProvider.save((SoftwareSystem)loadXmlResult.getOutcome(), this.c.a());
            if (saveResult.isFailure()) {
                result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.SYSTEM_MIGRATED, "Unable to save auto-migrated system", new Object[0]);
                result.addMessagesFrom(saveResult);
                ((SoftwareSystem)loadXmlResult.getOutcome()).setNeedsSave(true);
            } else {
                result.addInfo((OperationResult.IMessageCause)SoftwareSystemMessageCause.SYSTEM_MIGRATED, "Your system has been migrated to the newest version of Sonargraph");
            }
        }
        return (SoftwareSystem)loadXmlResult.getOutcome();
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, TFile location, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions, IFilePathListener filePathListener, DynamicSystemInfo dynamicSystemInfo, String workspaceProfileName, TFile qualityModel) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'openSoftwareSystem' must not be null";
        assert (location != null) : "Parameter 'location' of method 'openSoftwareSystem' must not be null";
        assert (openOptions != null) : "Parameter 'openOptions' of method 'openSoftwareSystem' must not be null";
        assert (this.m == null) : "Software system already opened: " + this.m;
        assert (this.n == null) : "'m_refreshProcessor' of method 'openSoftwareSystem' must be null";
        TrueZipFacade.clear();
        workerContext.working("Open system", true);
        OperationResult result = new OperationResult("Opening system");
        int[] weights = new int[5];
        int i2 = 0;
        weights[i2++] = 2;
        weights[i2++] = 2;
        weights[i2++] = openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT) ? 10 : 1;
        weights[i2++] = 2;
        weights[i2++] = openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH) ? 120 : 1;
        workerContext.setNumberOfSteps(weights.length, weights);
        workerContext.beginSubTask("Loading software system");
        this.m = this.loadSoftwareSystem(location, false, result, openOptions);
        workerContext.endSubTask();
        if (result.isFailure()) {
            assert (this.m == null) : "'m_softwareSystem' of method 'test' must be null";
            return result;
        }
        assert (this.m != null) : "'m_softwareSystem' of method 'openSoftwareSystem' must not be null";
        this.n = new RefreshProcessor(this.c, this.e, this.f, this.m, this.h);
        this.c.a(this.m.getUsedLanguages()).forEach(lp -> lp.a(this.f, this.m, result, false));
        if (result.isSuccess()) {
            workerContext.beginSubTask("Initializing system");
            this.a(this.m, !openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.DISABLE_WORKSPACE_FILTER), result);
            workerContext.endSubTask();
            if (result.isSuccess()) {
                if (qualityModel != null) {
                    this.a(qualityModel, result);
                }
                PrepareRefreshResult prepareRefreshResult = null;
                if (result.isSuccess()) {
                    prepareRefreshResult = new PrepareRefreshResult(this.m.getUsedLanguages(), (Set<ISoftwareSystemProvider.IRefreshOption>)(openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH) ? new THashSet(Arrays.asList(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL, ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) : Collections.emptySet()));
                    this.n.a(workerContext, true, prepareRefreshResult);
                    this.n.a(workerContext, null, result, prepareRefreshResult);
                    assert (dynamicSystemInfo == null || workspaceProfileName == null || workspaceProfileName.isEmpty()) : "Either 'dynamicSystemInfo' or 'workspaceProfileName' specified but not both (or none)";
                    if (dynamicSystemInfo != null) {
                        prepareRefreshResult.addMessagesFrom(this.f.getExtension(y.class).a(workerContext, dynamicSystemInfo.getModules(), this.m));
                    } else if (workspaceProfileName != null && !workspaceProfileName.isEmpty()) {
                        WorkspaceProfile profile = this.m.getExtension(bj.class).a(workerContext, workspaceProfileName, result);
                        if (result.isSuccess()) {
                            assert (profile != null) : "Parameter 'profile' of method 'openSoftwareSystem' must not be null";
                            this.m.getExtension(VirtualModelExtension.class).mapResolutionPatterns(profile.getResolutionMappings(), null, true, false, null);
                        }
                    }
                }
                if (result.isSuccess()) {
                    boolean snapshotApplied;
                    workerContext.beginSubTask("Applying snapshot");
                    assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'openSoftwareSystem' must not be null";
                    boolean bl2 = snapshotApplied = openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.READ_SNAPSHOT) && this.m.getExtension(aM.class).a(workerContext, result);
                    if (snapshotApplied) {
                        for (Z nextLanguageProvider : this.c.a(this.m.getUsedLanguages())) {
                            nextLanguageProvider.a(workerContext, this.m, filePathListener);
                        }
                    }
                    workerContext.endSubTask();
                    if (!openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH)) {
                        this.m.getExtension(bi.class).a(prepareRefreshResult, null);
                    }
                    if (openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.SWITCH_TO_DEFAULT_MODEL)) {
                        workerContext.working("Switch to default virtual model", true);
                        this.m.getExtension(VirtualModelExtension.class).switchFromFactsModelToDefaultModel();
                    }
                    workerContext.beginSubTask("Finish software system open");
                    this.f.getExtension(PluginExtension.class).a(workerContext, this.m, snapshotApplied, result);
                    this.e.a(workerContext, this.m, filePathListener, snapshotApplied, result);
                    result.setIsSuccess(true);
                    workerContext.endSubTask();
                    boolean runAnalyzers = true;
                    boolean refreshed = false;
                    if (openOptions.contains((Object)ISoftwareSystemProvider.OpenOption.REFRESH)) {
                        workerContext.beginSubTask("Refresh");
                        RefreshProcessor.a refreshInfo = this.n.a(workerContext, prepareRefreshResult, snapshotApplied, result);
                        runAnalyzers = refreshInfo.a();
                        refreshed = refreshInfo.b();
                        workerContext.endSubTask();
                    } else {
                        workerContext.endStep();
                    }
                    this.m.getUniqueExistingChild(Files.class).writeNameTag(this.m.getName(), result);
                    if (!refreshed && snapshotApplied) {
                        this.e.a(this.m);
                    }
                    if (runAnalyzers) {
                        this.m.getExtension(c.class).a(workerContext, snapshotApplied);
                    }
                }
                if (prepareRefreshResult != null) {
                    result.addMessagesFromMaintainingCurrentOutcome(prepareRefreshResult);
                }
            }
        }
        if (result.isFailure()) {
            this.k();
        }
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, TFile location, EnumSet<ISoftwareSystemProvider.OpenOption> openOptions) {
        return this.a(workerContext, location, openOptions, null, null, null, null);
    }

    @Override
    public OperationResult g() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        OperationResult result = this.d.a(this.m.getUsedLanguages()).save(this.m, this.c.a());
        if (result.isSuccess()) {
            TFile systemFile = this.m.getUniqueExistingChild(Files.class).getSoftwareSystemFile().getFile();
            TrueZipFacade.clear((TFile)systemFile);
            this.m.getUniqueExistingChild(Files.class).getSoftwareSystemFile().resetTimestamp();
            this.m.setNeedsSave(false);
            this.m.getUniqueExistingChild(Files.class).writeNameTag(this.m.getName(), result);
            this.m.getUniqueExistingChild(Workspace.class).setExternalConfigurationChanged(false);
        }
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext) {
        assert (this.hasSoftwareSystem()) : "No software system available";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'saveSoftwareSystem' must not be null";
        OperationResult result = this.g();
        if (result.isSuccess()) {
            this.e.a(workerContext, this.m, EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, List<IModifiableFile> modifiableFiles, Map<IModifiableFile, IModificationOnSave> modificationsOnSave) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'save' must not be null";
        assert (this.hasSoftwareSystem()) : "No system available";
        assert (modifiableFiles != null && !modifiableFiles.isEmpty()) : "Parameter 'modifiableFiles' of method 'save' must not be empty";
        assert (modificationsOnSave != null) : "Parameter 'modificationsOnSave' of method 'save' must not be null";
        workerContext.working("Save system", true);
        OperationResult result = new OperationResult("Save");
        for (IModifiableFile nextModifiableFile : modificationsOnSave.keySet()) {
            assert (modifiableFiles.contains(nextModifiableFile)) : "Modifiable file (modification on save) not found: " + nextModifiableFile;
        }
        ArrayList<ArchitectureFile> architectureFiles = new ArrayList<ArchitectureFile>();
        for (IModifiableFile nextModifiableFile : modifiableFiles) {
            assert (nextModifiableFile.needsSave()) : "Does not need save: " + nextModifiableFile;
            if (nextModifiableFile instanceof SoftwareSystemFile) {
                result.addMessagesFrom(this.g());
                continue;
            }
            if (nextModifiableFile instanceof GroovyScript) {
                result.addMessagesFrom(this.m.getExtension(H.class).a((GroovyScript)nextModifiableFile, modificationsOnSave.get(nextModifiableFile)));
                continue;
            }
            if (nextModifiableFile instanceof FileBasedRunConfiguration) {
                result.addMessagesFrom(this.m.getExtension(H.class).a((FileBasedRunConfiguration)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof ModifiableModel) {
                result.addMessagesFrom(this.m.getExtension(VirtualModelExtension.class).saveModifiableModel((ModifiableModel)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof AnalyzerConfigurationFile) {
                result.addMessagesFrom(this.m.getExtension(c.class).a((AnalyzerConfigurationFile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof ArchitectureFile) {
                architectureFiles.add((ArchitectureFile)nextModifiableFile);
                continue;
            }
            if (nextModifiableFile instanceof WorkspaceProfile) {
                result.addMessagesFrom(this.m.getExtension(bj.class).a((WorkspaceProfile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof QualityGate) {
                result.addMessagesFrom(this.m.getExtension(av.class).a((QualityGate)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof ArchitecturalViewFile) {
                result.addMessagesFrom(this.m.getExtension(com.hello2morrow.sonargraph.core.controller.system.g.class).a((ArchitecturalViewFile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof PluginConfigurationFile) {
                result.addMessagesFrom(this.m.getExtension(as.class).a((PluginConfigurationFile)nextModifiableFile));
                continue;
            }
            if (nextModifiableFile instanceof SoftwareSystemSettingsFile) {
                SoftwareSystemSettingsFile nextSoftwareSystemConfigurationFile = (SoftwareSystemSettingsFile)nextModifiableFile;
                Language language = nextSoftwareSystemConfigurationFile.getLanguage();
                for (aT nextExtension : this.m.getExtensions(aT.class)) {
                    if (!nextExtension.c().equals(language)) continue;
                    result.addMessagesFrom(nextExtension.a(nextSoftwareSystemConfigurationFile));
                }
                continue;
            }
            if (nextModifiableFile instanceof TreeMapFile) {
                result.addMessagesFrom(this.m.getExtension(ba.class).a((TreeMapFile)nextModifiableFile));
                continue;
            }
            assert (false) : "Unhandled file type '" + nextModifiableFile.getClass().getName() + "' in save system";
        }
        Set<IAnalyzerId> analyzerIds = null;
        if (!architectureFiles.isEmpty()) {
            analyzerIds = this.m.getExtension(c.class).a(AnalyzerGroup.ARCHITECTURE, AnalyzerGroup.ARCHITECTURE_METRICS);
            this.m.getExtension(c.class).a_(analyzerIds);
            result.addMessagesFrom(this.m.getExtension(n.class).a(workerContext, architectureFiles, modificationsOnSave));
        }
        this.e.a(workerContext, this.m, EnumSet.noneOf(Modification.class), result);
        if (analyzerIds != null) {
            this.m.getExtension(c.class).b(workerContext);
        }
        return result;
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, String name, TFile newBaseDirectory) {
        assert (this.hasSoftwareSystem()) : "No software system available";
        assert (this.c().isValid(this.m.getName(), name).isSuccess()) : "Not a valid name: " + name;
        assert (this.d().isValid(this.m.getDirectoryFile(), newBaseDirectory).isSuccess()) : "Not a valid path: " + newBaseDirectory;
        assert (!this.m.getName().equals(name) || !FileUtility.areEqual((TFile)this.m.getDirectoryFile(), (TFile)newBaseDirectory)) : "Neither name nor directory changed";
        OperationResult result = new OperationResult("Save system as");
        SystemDirectoryLocationInfo info = this.m.getUniqueExistingChild(Files.class).getSystemDirectoryLocationInfo(result, name, newBaseDirectory);
        assert (info.locationIsDifferent()) : "Locations not different";
        if (result.isSuccess()) {
            List<Module> modules = this.m.getUniqueExistingChild(Workspace.class).getChildren(Module.class);
            modules.forEach(m2 -> m2.getChildren(RootDirectoryPath.class).forEach(r2 -> {
                TFile tFile = r2.getFile();
            }));
            this.m.getUniqueExistingChild(Files.class).copy(result, info);
            if (result.isSuccess()) {
                this.m.getExtension(c.class).a(ResetMode.ALL);
                this.m.getExtension(aM.class).c();
                THashMap fqNameMappings = new THashMap();
                String oldSystemFqName = this.m.getFullyQualifiedName();
                this.m.setName(name);
                String newSystemFqName = this.m.getFullyQualifiedName();
                if (!oldSystemFqName.equals(newSystemFqName)) {
                    fqNameMappings.put(oldSystemFqName, newSystemFqName);
                }
                this.m.setId(StringUtility.createTimebasedId((String)name));
                for (Module nextModule : modules) {
                    for (RootDirectoryPath nextRootDirectoryPath : nextModule.getChildren(RootDirectoryPath.class)) {
                        String nextOldFqName = nextRootDirectoryPath.getFullyQualifiedName();
                        nextRootDirectoryPath.rebase();
                        String nextNewFqName = nextRootDirectoryPath.getFullyQualifiedName();
                        if (nextOldFqName.equals(nextNewFqName)) continue;
                        fqNameMappings.put(nextOldFqName, nextNewFqName);
                    }
                }
                this.c.a(this.m.getUsedLanguages()).forEach(lp -> lp.a(this.f, this.m));
                OperationResult saveResult = this.g();
                if (saveResult.isFailure()) {
                    this.m.setNeedsSave(true);
                    this.m.getUniqueExistingChild(Files.class).writeNameTag(this.m.getName(), result);
                }
                result.addMessagesFrom(saveResult);
                EnumSet<Modification> modifications = EnumSet.of(Modification.SYSTEM_MODIFIED, Modification.SYSTEM_LOCATION_CHANGED);
                if (!fqNameMappings.isEmpty()) {
                    this.m.getExtension(VirtualModelExtension.class).mapResolutionPatterns((Map<String, String>)fqNameMappings, modifications, true, false, result);
                }
                result.setIsSuccess(true);
                this.e.a(workerContext, this.m, modifications, result, info.getCurrentDirectory());
                this.m.getExtension(aM.class).b();
                this.m.getExtension(c.class).b(workerContext);
            }
        }
        return result;
    }

    @Override
    public boolean a(String name, String description) {
        assert (this.hasSoftwareSystem()) : "No system available";
        return this.m.getUniqueExistingChild(Files.class).getSystemDirectoryLocationInfo(name).locationIsDifferent();
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, String name, String description, Map<String, String> metaData) {
        assert (this.hasSoftwareSystem()) : "No software system loaded";
        assert (name != null) : "Parameter 'name' of method 'editSoftwareSystem' must not be null";
        assert (this.c().isValid(this.m.getName(), name).isSuccess()) : "Not a valid name: " + name;
        assert (description != null) : "Parameter 'description' of method 'editSoftwareSystem' must not be null";
        assert (metaData != null) : "Parameter 'metaData' of method 'editSoftwareSystem' must not be null";
        OperationResult result = new OperationResult("Edit system");
        SystemDirectoryLocationInfo info = this.m.getUniqueExistingChild(Files.class).getSystemDirectoryLocationInfo(name);
        if (info.locationIsDifferent()) {
            this.m.getUniqueExistingChild(Files.class).move(result, info);
        }
        if (result.isSuccess()) {
            EnumSet<Modification> modifications = EnumSet.of(Modification.SYSTEM_MODIFIED);
            this.m.getExtension(aM.class).c();
            if (!description.equals(this.m.getDescription())) {
                this.m.setDescription(description);
                this.m.setNeedsSave(true);
            }
            if (!metaData.isEmpty()) {
                for (Map.Entry<String, String> entry : metaData.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue() == null ? "" : entry.getValue();
                    String oldValue = this.m.getMetaData(key);
                    if (oldValue == null) {
                        oldValue = "";
                    }
                    if (oldValue.equals(value)) continue;
                    this.m.setMetaData(key, value);
                    this.m.setNeedsSave(true);
                }
            }
            if (info.locationIsDifferent()) {
                assert (!this.m.getName().equals(name)) : "Name must be different";
                modifications.add(Modification.SYSTEM_LOCATION_CHANGED);
                String oldFqName = this.m.getFullyQualifiedName();
                this.m.setName(name);
                String newFqName = this.m.getFullyQualifiedName();
                OperationResult saveResult = this.d.a(this.m.getUsedLanguages()).save(this.m, this.c.a());
                this.m.setNeedsSave(!saveResult.isSuccess());
                this.m.getUniqueExistingChild(Files.class).writeNameTag(this.m.getName(), result);
                this.m.getExtension(VirtualModelExtension.class).mapResolutionPatterns(Collections.singletonMap(oldFqName, newFqName), modifications, false, false, saveResult);
                result.addMessagesFrom(saveResult);
                result.setIsSuccess(true);
                this.m.getUniqueExistingChild(Files.class).getSoftwareSystemFile().resetTimestamp();
            } else assert (this.m.getName().equals(name)) : "Name must be the same";
            this.e.a(workerContext, this.m, modifications, result);
            this.m.getExtension(aM.class).b();
        }
        return result;
    }

    private void k() {
        assert (this.m != null) : "Parameter 'm_softwareSystem' of method 'release' must not be null";
        this.e.a(this.f, this.m);
        this.m.getUniqueExistingChild(Files.class).release();
        this.g.b(this.m);
        this.m.accept(new aj());
        this.m = null;
        this.n = null;
        EventManager.getInstance().dispatch((Object)this, (Event)new InstallationModifiedEvent(this));
        TrueZipFacade.clear();
        Introspector.flushCaches();
        System.gc();
    }

    @Override
    public IPathValidator h() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        return this.m.getExtension(aM.class).f();
    }

    @Override
    public boolean i() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        return this.m.getExtension(aM.class).e();
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, TFile saveTo, boolean delete) {
        assert (this.hasSoftwareSystem()) : "No software system available";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareExtractedAndAttachedSoftwareSystemClose' must not be null";
        return this.m.getExtension(aM.class).a(workerContext, saveTo, delete);
    }

    @Override
    public OperationResult j() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        OperationResult result = new OperationResult("Close software system");
        SystemPropertiesPersistenceProvider.storeProperties(this.m, result);
        this.m.getExtension(aM.class).d();
        this.m.getExtension(c.class).a_(this.m);
        this.e.a(this.m, result);
        this.k();
        return result;
    }

    @Override
    public PrepareRefreshResult a(IWorkerContext workerContext, Set<ISoftwareSystemProvider.IRefreshOption> options, Set<Language> limitTo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (options != null) : "Parameter 'options' of method 'prepareRefresh' must not be null";
        assert (limitTo != null) : "Parameter 'limitTo' of method 'prepareRefresh' must not be null";
        assert (this.m != null) : "No system available";
        assert (this.n != null) : "'m_refreshProcessor' of method 'prepareRefresh' must not be null";
        return this.n.a(workerContext, options, limitTo);
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        assert (this.m != null) : "No system available";
        assert (this.n != null) : "'m_refreshProcessor' of method 'refresh' must not be null";
        return this.n.a(workerContext, prepareRefreshResult);
    }

    @Override
    public OperationResult a(IWorkerContext workerContext, List<ModuleDelta> moduleDeltas, Set<ISoftwareSystemProvider.IRefreshOption> options, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshWithDelta' must not be null";
        assert (moduleDeltas != null && !moduleDeltas.isEmpty()) : "Parameter 'moduleDeltas' of method 'refreshWithDelta' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'refreshWithDelta' must not be null";
        assert (this.n != null) : "'m_refreshProcessor' of method 'refresh' must not be null";
        return this.n.a(workerContext, moduleDeltas, options, listener);
    }

    @Override
    public OperationResult b(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'clear' must not be null";
        assert (this.n != null) : "'m_refreshProcessor' of method 'clear' must not be null";
        return this.n.a(workerContext);
    }

    @Override
    public IRelevantSourceFileIterator getRelevantSourceFileIterator() {
        assert (this.hasSoftwareSystem()) : "No software system available";
        ArrayList<IRelevantSourceFileIterator> iterators = new ArrayList<IRelevantSourceFileIterator>(this.m.getUsedLanguages().size());
        this.c.a(this.m.getUsedLanguages()).forEach(lp -> {
            boolean bl2 = iterators.add(lp.e(this.m));
        });
        return new aD(iterators);
    }

    @Override
    public void visitPresentFilePaths(IFilePathListener listener, IModule ... modules) {
        assert (listener != null) : "Parameter 'listener' of method 'visitPresentFilePaths' must not be null";
        assert (modules != null && modules.length > 0) : "Parameter 'modules' of method 'visitPresentFilePaths' must not be empty";
        this.c.a(this.m.getUsedLanguages()).forEach(lp -> lp.a(listener, modules));
    }

    @Override
    public OperationResult a(Map<String, String> parameters) {
        assert (parameters != null && !parameters.isEmpty()) : "Parameter 'parameters' of method 'applyInstallationSpecificParameters' must not be empty";
        OperationResult result = new OperationResult("Apply installation specific parameters");
        this.c.d().forEach(lp -> lp.a(parameters, result));
        return result;
    }

    @Override
    public boolean canAddModuleForLanguage(Language language) {
        assert (language != null) : "Parameter 'language' of method 'canAddModuleForLanguage' must not be null";
        if (!this.hasSoftwareSystem()) {
            return false;
        }
        Set<Language> usedLanguages = this.getSoftwareSystem().getUsedLanguages();
        return usedLanguages.isEmpty() || usedLanguages.size() == 1 && usedLanguages.contains(language);
    }

    @Override
    public /* synthetic */ ILanguageProvider getLanguageProvider(Language language) {
        return this.a(language);
    }

    public static enum OptionalExtensionId {
        UNDO_REDO,
        DASHBOARD,
        ARCHITECTURAL_VIEW,
        TREEMAP,
        ARCHITECTURE_DIAGRAM,
        REMOTE_SELECTION;

    }
}

