/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.CustomPattern;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.IssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.refactoring.LanguageSpecificRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.VirtualModelPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResolutionPatternMigration {
    private static final Logger b = LoggerFactory.getLogger(ResolutionPatternMigration.class);

    ResolutionPatternMigration() {
    }

    public static boolean a(a provider, ModifiableModel modifiableModel, OperationResult result) {
        assert (provider != null) : "Parameter 'provider' of method 'migrateIfNecessary' must not be null";
        assert (modifiableModel != null) : "Parameter 'modifiableModel' of method 'migrateIfNecessary' must not be null";
        boolean migrated = false;
        Version versionWithMigratedFieldDescriptors = Version.create((int)11, (int)2, (int)0, (int)0);
        if (!modifiableModel.needsSave() && modifiableModel.getVersion().isBefore(versionWithMigratedFieldDescriptors)) {
            b.info("Migrate modifiable model: " + modifiableModel.getAbsolutePath() + " [" + modifiableModel.getVersion() + "]");
            INamedElementResolver resolver = provider.getResolver();
            Root root = provider.getRootForResolver();
            for (Resolution nextResolution : modifiableModel.getChildren(Resolution.class)) {
                if (nextResolution instanceof LanguageSpecificRefactoringDefinition || nextResolution.getUniqueChild(Matching.class) != null) continue;
                b.debug("Migrate patterns of resolution: " + nextResolution.getIssueType());
                for (IssuePattern nextIssuePattern : nextResolution.getChildren(IssuePattern.class)) {
                    IField field;
                    NamedElement resolved;
                    String toPattern;
                    IField field2;
                    NamedElement resolved2;
                    if (nextIssuePattern instanceof NamedElementIssuePattern) {
                        String pattern = ((NamedElementIssuePattern)nextIssuePattern).getPattern();
                        if (CustomPattern.containsWildcardPatternCharacter((String)pattern) || (resolved2 = resolver.resolve(root, pattern)) != null || (field2 = resolver.resolve(root, String.valueOf(pattern) + IField.DESCRIPTOR_NAME_PART_SUFFIX, IField.class)) == null) continue;
                        b.debug("Matched field: " + field2);
                        ((NamedElementIssuePattern)nextIssuePattern).setPattern(String.valueOf(pattern) + IField.DESCRIPTOR_NAME_PART_SUFFIX);
                        migrated = true;
                        continue;
                    }
                    assert (nextIssuePattern instanceof DependencyIssuePattern) : "Unexpected class in method 'migrateIfNecessary': " + nextIssuePattern;
                    String fromPattern = ((DependencyIssuePattern)nextIssuePattern).getFromPattern();
                    if (!CustomPattern.containsWildcardPatternCharacter((String)fromPattern) && (resolved2 = resolver.resolve(root, fromPattern)) == null && (field2 = resolver.resolve(root, String.valueOf(fromPattern) + IField.DESCRIPTOR_NAME_PART_SUFFIX, IField.class)) != null) {
                        b.debug("'From' pattern matched field: " + field2);
                        ((DependencyIssuePattern)nextIssuePattern).setFromPattern(String.valueOf(fromPattern) + IField.DESCRIPTOR_NAME_PART_SUFFIX);
                        migrated = true;
                    }
                    if (CustomPattern.containsWildcardPatternCharacter((String)(toPattern = ((DependencyIssuePattern)nextIssuePattern).getToPattern())) || (resolved = resolver.resolve(root, toPattern)) != null || (field = resolver.resolve(root, String.valueOf(toPattern) + IField.DESCRIPTOR_NAME_PART_SUFFIX, IField.class)) == null) continue;
                    b.debug("'To' pattern matched field: " + field);
                    ((DependencyIssuePattern)nextIssuePattern).setToPattern(String.valueOf(toPattern) + IField.DESCRIPTOR_NAME_PART_SUFFIX);
                    migrated = true;
                }
            }
            if (migrated) {
                OperationResult saveResult;
                if (!modifiableModel.needsApplication()) {
                    modifiableModel.setNeedsApplication();
                }
                if ((saveResult = provider.getPersistence().save(modifiableModel)).isSuccess()) {
                    modifiableModel.setVersion(provider.getVersion());
                    if (result != null) {
                        result.addInfo((OperationResult.IMessageCause)MigrationMessageCause.SUCCESSFULLY_MIGRATED_AND_SAVED_MODIFIABLE_MODEL, "Modifiable model '" + modifiableModel.getAbsolutePath() + "'.");
                    }
                } else if (result != null) {
                    result.addMessagesFromMaintainingCurrentOutcome(saveResult);
                    result.addInfo((OperationResult.IMessageCause)MigrationMessageCause.SUCCESSFULLY_MIGRATED_MODIFIABLE_MODEL, "The modifiable model '" + modifiableModel.getAbsolutePath() + "' has been migrated but could not be saved.");
                }
            }
            b.info("Migrate modifiable model: " + modifiableModel.getAbsolutePath() + " [" + modifiableModel.getVersion() + "] - done");
        }
        return migrated;
    }

    public static interface a {
        public INamedElementResolver getResolver();

        public Root getRootForResolver();

        public VirtualModelPersistence getPersistence();

        public Version getVersion();
    }

    static enum MigrationMessageCause implements OperationResult.IMessageCause
    {
        SUCCESSFULLY_MIGRATED_AND_SAVED_MODIFIABLE_MODEL,
        SUCCESSFULLY_MIGRATED_MODIFIABLE_MODEL;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

