/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.HashSupport;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.controller.system.PluginExtension;
import com.hello2morrow.sonargraph.core.controller.system.ai;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.av;
import com.hello2morrow.sonargraph.core.controller.system.e.a;
import com.hello2morrow.sonargraph.core.controller.system.e.b;
import com.hello2morrow.sonargraph.core.controllerinterface.system.B;
import com.hello2morrow.sonargraph.core.controllerinterface.system.C;
import com.hello2morrow.sonargraph.core.controllerinterface.system.u;
import com.hello2morrow.sonargraph.core.controllerinterface.system.y;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.LastScriptRunnerExecutionStatus;
import com.hello2morrow.sonargraph.core.model.analysis.QualityGateCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.plugin.IPluginConfigurationProvider;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IBasicReport;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.report.ModuleReport;
import com.hello2morrow.sonargraph.core.model.report.Report;
import com.hello2morrow.sonargraph.core.model.report.SystemReport;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateIssueId;
import com.hello2morrow.sonargraph.core.model.system.ranking.IIssueRankingProvider;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.persistence.report.ArchitectureFileSerializer;
import com.hello2morrow.sonargraph.core.persistence.report.ExportMetaDataXmlWriter;
import com.hello2morrow.sonargraph.core.persistence.report.ReportHtmlWriter;
import com.hello2morrow.sonargraph.core.persistence.report.ReportXmlWriter;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginConfiguration;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportExtension
extends Extension
implements u {
    private static final int e = 100;
    private static final Logger f = LoggerFactory.getLogger(ReportExtension.class);
    private static final String g = "system-previous";
    private static final String h = "system-current";
    private final Installation i;
    private final SoftwareSystem j;
    private final Set<SonargraphFeature> k;
    private final Set<SonargraphFeature> l;

    ReportExtension(Installation installation, SoftwareSystem softwareSystem, Set<SonargraphFeature> availableFeatures, Set<SonargraphFeature> unavailableFeatures) {
        assert (installation != null) : "Parameter 'installation' of method 'ReportExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ReportExtension' must not be null";
        assert (availableFeatures != null && availableFeatures.size() > 0) : "Parameter 'availableFeatures' of method 'ReportExtension' must not be empty";
        assert (unavailableFeatures != null) : "Parameter 'unavailableFeatures' of method 'ReportExtension' must not be null";
        this.j = softwareSystem;
        this.i = installation;
        this.l = availableFeatures;
        this.k = unavailableFeatures;
    }

    @Override
    public OperationResultWithOutcome<CreateReportResult> a(IWorkerContext workerContext, u.a request) {
        String diffReportFileName;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createReport' must not be null";
        assert (request != null) : "Parameter 'request' of method 'createReport' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create report for system");
        if (this.j.getState() != SoftwareSystemState.MODEL_LOADED) {
            f.warn("Model of software system is currently not loaded! Current state: " + (Object)((Object)this.j.getState()));
        }
        List<IMetricLevel> metricLevels = request.e();
        Set<IReport.Format> formats = request.f();
        if (formats.size() == 1) {
            workerContext.setNumberOfSteps(6, new int[]{20, 10, 5, 5, 40, 20});
        } else {
            workerContext.setNumberOfSteps(7, new int[]{20, 10, 5, 5, 20, 20, 20});
        }
        Date timestamp = request.n() != null ? request.n() : new Date();
        Report report = this.a(workerContext, metricLevels, request.l(), timestamp.getTime());
        if (workerContext.hasBeenCanceled()) {
            return result;
        }
        assert (report != null) : "report object must not be null, if workerContext has not been cancelled";
        IReport mainReport = request.k() ? new SystemReport(report) : report;
        CreateReportResult createReportResult = new CreateReportResult(mainReport);
        TFile targetDirectory = request.c();
        boolean targetDirectoryAlreadyExists = targetDirectory.exists();
        HashSet<IFileType> requestedFileTypes = new HashSet<IFileType>();
        String mainReportFileName = this.a(request.d(), timestamp);
        String string = diffReportFileName = request.g() != null && request.m() ? this.j.getExtension(B.class).createDiffFileName(request.d(), timestamp) : null;
        if (formats.contains((Object)IReport.Format.XML)) {
            requestedFileTypes.add(CoreFileType.REPORT_XML);
            workerContext.beginSubTask("Writing XML report file");
            TFile xmlTargetFile = this.a(targetDirectory, mainReportFileName, report, (OperationResult)result, CoreFileType.REPORT_XML, timestamp);
            if (result.isSuccess()) {
                assert (xmlTargetFile != null) : "'xmlTargetFile' of method 'createReport' must not be null";
                createReportResult.addTargetFile(IReport.Format.XML, xmlTargetFile);
                new ReportXmlWriter(this.i.getVersion(), report).storeReportToFile(workerContext, xmlTargetFile, (OperationResult)result);
            }
            workerContext.endSubTask();
        }
        if (formats.contains((Object)IReport.Format.HTML)) {
            requestedFileTypes.add(CoreFileType.REPORT_HTML);
            workerContext.beginSubTask("Writing HTML report files");
            TFile mainHtmlTargetFile = this.a(targetDirectory, mainReportFileName, mainReport, (OperationResult)result, CoreFileType.REPORT_HTML, timestamp);
            if (result.isSuccess()) {
                assert (mainHtmlTargetFile != null) : "'mainHtmlTargetFile' of method 'createReport' must not be null";
                createReportResult.addTargetFile(IReport.Format.HTML, mainHtmlTargetFile);
                report.setTargetFile(mainHtmlTargetFile);
                if (request.k()) {
                    SystemReport systemReport = (SystemReport)mainReport;
                    List<Module> modules = mainReport.getModules();
                    workerContext.beginBlockOfWork(modules.size() + 1);
                    for (Module module : modules) {
                        workerContext.working("Writing report for module '" + module.getName() + "'", true);
                        if (result.isSuccess()) {
                            ModuleReport moduleReport = com.hello2morrow.sonargraph.core.controller.system.e.a.a(report, module, 100);
                            moduleReport.performCalculations();
                            this.a(workerContext, moduleReport, request, null, (OperationResult)result);
                            systemReport.addModuleReport(moduleReport);
                        }
                        workerContext.workItemCompleted();
                    }
                } else {
                    workerContext.beginBlockOfWork(1);
                }
            }
            if (result.isSuccess()) {
                workerContext.working("Writing system report", true);
                this.a(workerContext, mainReport, request, diffReportFileName, (OperationResult)result);
                workerContext.workItemCompleted();
            }
            workerContext.endSubTask();
        }
        TrueZipFacade.clear((TFile)targetDirectory);
        if (workerContext.hasBeenCanceled()) {
            this.a(mainReport, targetDirectory, (OperationResult)result, targetDirectoryAlreadyExists);
            result.setIsSuccess(false);
        } else if (result.isSuccess()) {
            TFile baselineXmlReportFile = request.g();
            workerContext.working("Create system diff report", true);
            if (baselineXmlReportFile != null) {
                if (request.m()) {
                    OperationResultWithOutcome<Map<IFileType, TFile>> diffReportResult = this.j.getExtension(B.class).a(workerContext, report, request.c(), diffReportFileName, requestedFileTypes, baselineXmlReportFile, mainReportFileName);
                    result.addMessagesFrom(diffReportResult);
                    if (result.isSuccess() && diffReportResult.getOutcome() != null) {
                        for (Map.Entry nextDiffFileEntry : ((Map)diffReportResult.getOutcome()).entrySet()) {
                            IFileType fileType = (IFileType)nextDiffFileEntry.getKey();
                            TFile diffReport = (TFile)nextDiffFileEntry.getValue();
                            if (fileType == CoreFileType.REPORT_HTML) {
                                createReportResult.addSystemDiffReport(IReport.Format.HTML, diffReport);
                                continue;
                            }
                            if (fileType != CoreFileType.REPORT_XML) continue;
                            createReportResult.addSystemDiffReport(IReport.Format.XML, diffReport);
                        }
                    }
                }
                result.setIsSuccess(true);
            }
            result.setOutcome((Object)createReportResult);
        }
        return result;
    }

    @Override
    public IReport a(IWorkerContext workerContext) {
        g analyzerController = this.j.getExtension(g.class);
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        AnalyzerExecutionLevel analyzerExecutionLevel = analyzerController.b();
        Report report = new Report(this.i.getVersion(), this.j, new ArrayList<SonargraphFeature>(this.l), new ArrayList<SonargraphFeature>(this.k), analyzerExecutionLevel, null, System.currentTimeMillis());
        f.debug("Creating report with active analyzer execution level " + analyzerExecutionLevel.getPresentationName());
        this.d(report);
        this.b(report);
        this.c(report);
        this.a(report);
        this.a(workerContext, report, Collections.singletonList(CoreMetricLevel.SYSTEM), analyzerExecutionLevel);
        return report;
    }

    private Report a(IWorkerContext workerContext, List<IMetricLevel> metricLevels, String reportContextInfo, long timestamp) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internCreateReportObject' must not be null";
        assert (metricLevels != null) : "Parameter 'metricLevels' of method 'internCreateReportObject' must not be null";
        workerContext.beginSubTask("Waiting for analyzers to complete");
        g analyzerController = this.j.getExtension(g.class);
        analyzerController.a(workerContext);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        AnalyzerExecutionLevel analyzerExecutionLevel = analyzerController.b();
        Report report = new Report(this.i.getVersion(), this.j, new ArrayList<SonargraphFeature>(this.l), new ArrayList<SonargraphFeature>(this.k), analyzerExecutionLevel, reportContextInfo, timestamp);
        f.debug("Creating report with active analyzer execution level " + analyzerExecutionLevel.getPresentationName());
        this.d(report);
        this.b(report);
        this.c(report);
        this.a(report);
        workerContext.beginSubTask("Adding metrics to report");
        this.a(workerContext, report, metricLevels, analyzerExecutionLevel);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.beginSubTask("Adding issues to report");
        this.a(workerContext, report);
        this.b(workerContext, report);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.beginSubTask("Adding resolutions to report");
        this.c(workerContext, report);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        report.performCalculations();
        return report;
    }

    private void a(Report report) {
        assert (report != null) : "Parameter 'report' of method 'addQualityGateInfo' must not be null";
        if (this.l.contains((Object)SonargraphFeature.ARCHITECTURE)) {
            HashSet<Element> issuesAffectingQualityGateConditions = new HashSet<Element>();
            HashSet<Element> metricValuesAffectingQualityGateConditions = new HashSet<Element>();
            av qualityGateExtension = this.j.getExtension(av.class);
            for (QualityGate next : qualityGateExtension.getAvailableQualityGates()) {
                if (!next.isChecked()) continue;
                if (next.getResultElement() != null) {
                    QualityGateResult qualityGateResult = (QualityGateResult)next.getResultElement();
                    report.addQualityGateResult(next, qualityGateResult);
                    b.a(qualityGateResult, issuesAffectingQualityGateConditions, metricValuesAffectingQualityGateConditions);
                    continue;
                }
                report.addQualityGateResult(next, null);
            }
            report.setIssuesAffectingQualityGates(issuesAffectingQualityGateConditions);
            report.setMetricValuesAffectingQualityGates(metricValuesAffectingQualityGateConditions);
        }
    }

    private void b(Report report) {
        assert (report != null) : "Parameter 'report' of method 'addPluginInfo' must not be null";
        PluginExtension pluginExtension = this.i.getExtension(PluginExtension.class);
        List<SonargraphPlugin> plugins = pluginExtension.getPlugins();
        IPluginConfigurationProvider pluginConfigurationProvider = this.j.getExtension(IPluginConfigurationProvider.class);
        for (SonargraphPlugin next : plugins) {
            if (next.getAnalyzerContributor() != null) {
                IConfigurableAnalyzerId pluginAnalyzerId = pluginExtension.a(this.j, next);
                if (pluginAnalyzerId != null) {
                    report.addAnalyzerPlugin(next, pluginAnalyzerId);
                } else {
                    f.debug("Disabled analyzer plugin '" + next.getId() + "'");
                    report.addAnalyzerPlugin(next, null);
                }
            }
            if (next.getModelContributor() != null) {
                report.addModelPlugin(next);
            }
            SonargraphPluginConfiguration nextConfiguration = next.getConfiguration();
            ArrayList<Pair<SonargraphPluginAttribute, String>> configurationsAndValues = new ArrayList<Pair<SonargraphPluginAttribute, String>>();
            for (SonargraphPluginAttribute nextAttribute : nextConfiguration.getAttributes().values()) {
                configurationsAndValues.add((Pair<SonargraphPluginAttribute, String>)new Pair((Object)nextAttribute, (Object)nextConfiguration.getValue((ISonargraphPluginAttribute)nextAttribute).toString()));
            }
            report.addPluginConfiguration(next, pluginConfigurationProvider.getPluginConfigurationFile(next.getId()), configurationsAndValues);
        }
    }

    private void c(Report report) {
        assert (report != null) : "Parameter 'report' of method 'addArchitectureInfo' must not be null";
        Architecture architecture = this.j.getUniqueExistingChild(Files.class).getArchitecture();
        List<ArchitectureFile> architectures = architecture.getChildren(ArchitectureFile.class);
        ArchitectureFileSerializer serializer = new ArchitectureFileSerializer();
        for (ArchitectureFile next : architectures) {
            if (!next.isChecked()) continue;
            String content = serializer.serialize(next);
            String hash = content.isEmpty() ? HashSupport.MD5.getHexString(next.getName()) : HashSupport.MD5.getHexString(content);
            report.addCheckedArchitecture(next, hash);
        }
    }

    private void d(Report report) {
        SystemDiffAnalyzerConfiguration systemDiffAnalyzerConfig;
        String baselinePath;
        AnalyzerConfiguration systemDiffConfiguration;
        Map<String, Object> valueMap;
        AnalyzerConfiguration duplicateCodeConfiguration;
        assert (report != null) : "Parameter 'report' of method 'addAnalyzerInfo' must not be null";
        g analyzerController = this.j.getExtension(g.class);
        HashSet<IAnalyzerId> licensedAnalyzerIds = new HashSet<IAnalyzerId>(analyzerController.i());
        licensedAnalyzerIds.addAll(analyzerController.h());
        licensedAnalyzerIds.stream().forEach(id -> report.addLicensedAnalyzer((IAnalyzerId)id));
        analyzerController.j().stream().forEach(id -> report.addUnlicensedAnalyzer((IAnalyzerId)id));
        AnalyzerConfiguration architectureConfiguration = analyzerController.b(CoreAnalyzerId.ARCHITECTURE_CHECK);
        if (architectureConfiguration != null) {
            assert (architectureConfiguration instanceof ArchitectureCheckConfiguration) : "Unexpected class in method 'addAnalyzerInfo': " + architectureConfiguration;
            report.setArchitectureCheckConfigurationEntries(((ArchitectureCheckConfiguration)architectureConfiguration).getIdentifyingPaths());
        }
        if ((duplicateCodeConfiguration = analyzerController.b(CoreAnalyzerId.DUPLICATE_CODE)) != null && !(valueMap = duplicateCodeConfiguration.getValueMap()).isEmpty()) {
            ArrayList<String> duplicateCodeConfigurationEntries = new ArrayList<String>(valueMap.size());
            for (Map.Entry<String, Object> nextEntry : valueMap.entrySet()) {
                String nextName = nextEntry.getKey();
                Object nextValue = nextEntry.getValue();
                assert (nextValue != null && nextValue instanceof Integer) : "Unexpected class in method 'addDuplicateCodeConfigurationToXml': " + nextValue;
                duplicateCodeConfigurationEntries.add(String.valueOf(nextName) + ":" + nextValue);
            }
            report.setDuplicateCodeConfigurationEntries(duplicateCodeConfigurationEntries);
        }
        Analyzers analyzers = this.j.getUniqueExistingChild(Files.class).getAnalyzers();
        if (!report.getUnavailableFeatures().contains((Object)SonargraphFeature.SCRIPTS_AUTOMATED)) {
            AnalyzerConfiguration scriptRunnerConfiguration = analyzerController.b(CoreAnalyzerId.SCRIPT_RUNNER);
            assert (scriptRunnerConfiguration != null) : "ScriptRunner configuration must not be null";
            assert (scriptRunnerConfiguration instanceof ScriptRunnerConfiguration) : "Unexpected class in method 'addAnalyzerInfo': " + scriptRunnerConfiguration;
            report.setScriptRunnerConfiguration((ScriptRunnerConfiguration)scriptRunnerConfiguration);
            Analyzer scriptRunner = analyzers.getUniqueChild(new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement analyzer) {
                    if (!(analyzer instanceof Analyzer)) {
                        return false;
                    }
                    return ((Analyzer)analyzer).getId() == CoreAnalyzerId.SCRIPT_RUNNER;
                }
            }, Analyzer.class);
            if (scriptRunner == null) {
                return;
            }
            AnalyzerResult result = scriptRunner.getResult();
            if (result != null) {
                report.addScriptRunnerStatus(result.getUniqueChild(LastScriptRunnerExecutionStatus.class));
            }
        }
        if ((systemDiffConfiguration = analyzerController.b(CoreAnalyzerId.SYSTEM_DIFF)) != null && (baselinePath = (systemDiffAnalyzerConfig = (SystemDiffAnalyzerConfiguration)systemDiffConfiguration).getBaselinePath()) != null) {
            report.setBaseline(baselinePath);
        }
        for (Analyzer analyzer : analyzers.getChildren(Analyzer.class)) {
            List<CycleAnalyzerConfiguration> cycleConfigs = analyzer.getChildren(CycleAnalyzerConfiguration.class);
            if (cycleConfigs.size() != 1) continue;
            report.addCycleAnalyzerConfiguration(cycleConfigs.get(0));
        }
        AnalyzerConfiguration qualityGateConfiguration = analyzerController.b(CoreAnalyzerId.QUALITY_GATES);
        if (qualityGateConfiguration != null) {
            assert (qualityGateConfiguration instanceof QualityGateCheckConfiguration) : "Unexpected class in method 'addAnalyzerInfo': " + qualityGateConfiguration;
            report.setQualityGateCheckConfigurationEntries(((QualityGateCheckConfiguration)qualityGateConfiguration).getIdentifyingPaths());
        }
    }

    private void a(IWorkerContext context, IReport report, u.a request, String diffReportName, OperationResult result) {
        assert (context != null) : "Parameter 'context' of method 'saveReport' must not be null";
        assert (report != null) : "Parameter 'report' of method 'saveHtmlReport' must not be null";
        assert (request != null) : "Parameter 'request' of method 'saveHtmlReport' must not be null";
        assert (result != null) : "Parameter 'result' of method 'saveReport' must not be null";
        ReportHtmlWriter persistence = new ReportHtmlWriter(report);
        int maxMetricValueRowCount = request.h();
        int metricValueRowCount = maxMetricValueRowCount > 0 ? maxMetricValueRowCount : 25;
        persistence.storeReportToFile(context, report.getTargetFile(), metricValueRowCount, request.i(), request.j(), report.getFocus(), diffReportName, result);
    }

    private void a(IReport report, TFile targetDirectory, OperationResult result, boolean targetDirectoryAlreadyExists) {
        assert (report != null) : "Parameter 'report' of method 'cleanUpTargetDirectory' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'cleanUpTargetDirectory' must not be null";
        assert (result != null) : "Parameter 'result' of method 'cleanUpTargetDirectory' must not be null";
        try {
            try {
                if (!targetDirectoryAlreadyExists) {
                    targetDirectory.rm_r();
                } else {
                    for (IBasicReport moduleReport : report.getModuleReports()) {
                        String fileName = FileUtility.getFileNameWithoutExtension((TFile)moduleReport.getTargetFile());
                        TFile[] tFileArray = FileUtility.listFilesInDir((TFile)targetDirectory, (String)(String.valueOf(fileName) + ".*"));
                        int n2 = tFileArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            TFile next = tFileArray[n3];
                            next.rm();
                            ++n3;
                        }
                    }
                }
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex);
                report.setTargetFile(null);
                report.getModuleReports().forEach(r2 -> r2.setTargetFile(null));
            }
        }
        finally {
            report.setTargetFile(null);
            report.getModuleReports().forEach(r2 -> r2.setTargetFile(null));
        }
    }

    private TFile a(TFile targetDirectory, String reportFileName, IReport mainReport, OperationResult result, IFileType type, Date timestamp) {
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'createTargetFile' must not be null";
        assert (mainReport != null) : "Parameter 'mainReport' of method 'createTargetFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createTargetFile' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createTargetFile' must not be null";
        assert (timestamp != null) : "Parameter 'timestamp' of method 'createTargetFile' must not be null";
        boolean targetDirectoryExists = targetDirectory.exists();
        if (!targetDirectoryExists) {
            try {
                targetDirectory.mkdir(true);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
                return null;
            }
        }
        TFile targetFile = new TFile((File)targetDirectory, String.valueOf(reportFileName) + type.getDefaultExtension());
        mainReport.setTargetFile(targetFile);
        return targetFile;
    }

    private String a(String targetFileName, Date timestamp) {
        String reportFileName = targetFileName != null && targetFileName.trim().length() > 0 ? targetFileName : String.valueOf(this.j.getName()) + "_" + Iso8601DateFormat.formatDateAndTimeForFileName((Date)timestamp);
        return reportFileName;
    }

    @Override
    public List<IMetricLevel> a() {
        ArrayList<CoreMetricLevel> metricLevels = new ArrayList<CoreMetricLevel>(2);
        metricLevels.add(CoreMetricLevel.SYSTEM);
        metricLevels.add(CoreMetricLevel.MODULE);
        return Collections.unmodifiableList(metricLevels);
    }

    private void a(IWorkerContext context, Report report, List<IMetricLevel> metricLevels, AnalyzerExecutionLevel analyzerExecutionLevel) {
        assert (context != null) : "Parameter 'context' of method 'addMetrics' must not be null";
        assert (report != null) : "Parameter 'report' of method 'createReport' must not be null";
        assert (metricLevels != null) : "Parameter 'metricLevels' of method 'createReport' must not be null";
        assert (analyzerExecutionLevel != null) : "Parameter 'analyzerExecutionLevel' of method 'addMetrics' must not be null";
        C thresholdExtension = this.j.getExtension(C.class);
        thresholdExtension.getThresholds(true).forEach(th -> report.addThreshold((IMetricThreshold)th));
        ai metricsExtension = this.j.getExtension(y.class).getInstallation().getExtension(ai.class);
        context.beginBlockOfWork(metricLevels.size());
        for (IMetricLevel level : metricLevels) {
            for (IMetricDescriptor metric : metricsExtension.getAvailableMetricDescriptorsForLevel(level, true)) {
                IMetricDescriptor descriptor = metricsExtension.findMetricByIdAndLevel(metric.getMetricId(), level);
                if (descriptor == null) continue;
                for (IMetricValue iMetricValue : metricsExtension.getMetricValues(this.j, descriptor, true)) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    NamedElement associatedElement = iMetricValue.getAssociatedElement();
                    assert (associatedElement != null) : "Associated element must not be null";
                    if (level == CoreMetricLevel.SYSTEM) {
                        report.addSystemLevelMetricAndValue(descriptor, iMetricValue);
                        continue;
                    }
                    if (this.a(associatedElement)) {
                        report.addSystemElementMetricAndValue(descriptor, level, iMetricValue, associatedElement);
                        continue;
                    }
                    Module module = this.b(associatedElement);
                    if (associatedElement == module) assert (level == CoreMetricLevel.MODULE) : "Unexpected level: " + level.getStandardName();
                    if (module != null) {
                        report.addModuleLevelMetricAndValue(module, level, metric, iMetricValue, associatedElement);
                        continue;
                    }
                    report.addSystemElementMetricAndValue(descriptor, level, iMetricValue, associatedElement);
                }
            }
            context.workItemCompleted();
        }
    }

    private boolean a(NamedElement associatedElement) {
        return associatedElement instanceof LogicalSystemNamespace || associatedElement.getParent(LogicalSystemNamespace.class, new Class[0]) != null;
    }

    private Module b(NamedElement associatedElement) {
        Module module = null;
        if (associatedElement instanceof Module) {
            module = (Module)associatedElement;
        } else {
            ModuleBasedLogicalNamespaceRoot root;
            module = associatedElement.getParent(Module.class, new Class[0]);
            if (module == null && (root = associatedElement.getParent(ModuleBasedLogicalNamespaceRoot.class, new Class[0])) != null) {
                module = root.getPhysicalElement();
            }
        }
        return module;
    }

    private void a(IWorkerContext context, Report report) {
        assert (context != null) : "Parameter 'context' of method 'addIssues' must not be null";
        assert (report != null) : "Parameter 'report' of method 'addIssues' must not be null";
        context.beginBlockOfWork(1);
        report.setIssueCategories(Arrays.asList(IssueCategory.values()));
        VirtualModel currentModel = this.j.getCurrentModel();
        IssueFilter filter = new IssueFilter(new IStandardEnumeration[0]);
        for (Issue next : currentModel.getIssueList(filter).getIssues()) {
            if (context.hasBeenCanceled()) {
                return;
            }
            if (next instanceof NamedElementIssue) {
                report.addElementIssue((NamedElementIssue)next);
                continue;
            }
            if (next instanceof DependencyIssue) {
                report.addDependencyIssue((DependencyIssue)next);
                continue;
            }
            f.error("Unsupported issue type '" + next.getClass().getName() + "'");
        }
        context.workItemCompleted();
    }

    private void b(IWorkerContext context, Report report) {
        assert (context != null) : "Parameter 'context' of method 'addIssueRankings' must not be null";
        assert (report != null) : "Parameter 'report' of method 'addIssueRankings' must not be null";
        if (context.hasBeenCanceled()) {
            return;
        }
        IIssueRankingProvider rankingProvider = this.j.getExtension(IIssueRankingProvider.class);
        List<IssueRank> rankings = rankingProvider.getRankings();
        if (rankings != null) {
            if (rankings.size() > 100) {
                report.setIssueRankings(rankings.subList(0, 100));
            } else {
                report.setIssueRankings(rankings);
            }
        }
    }

    private void c(IWorkerContext context, Report report) {
        assert (context != null) : "Parameter 'context' of method 'addResolutions' must not be null";
        assert (report != null) : "Parameter 'report' of method 'addResolutions' must not be null";
        context.beginBlockOfWork(1);
        VirtualModel currentModel = this.j.getCurrentModel();
        for (Resolution next : currentModel.getChildren(Resolution.class)) {
            if (context.hasBeenCanceled()) {
                return;
            }
            report.addResolution(next);
        }
        context.workItemCompleted();
    }

    @Override
    public OperationResultWithOutcome<TFile> a(IWorkerContext workerContext, List<IMetricId> metricIds, List<IProviderId> issueProviderIds, List<IIssueId> issueIds, TFile targetFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'exportMetaData' must not be null";
        assert (metricIds != null) : "Parameter 'metricIds' of method 'exportMetaData' must not be null";
        assert (issueProviderIds != null && !issueProviderIds.isEmpty()) : "Parameter 'issueProviderIds' of method 'exportMetaData' must not be empty";
        assert (issueIds != null && !issueIds.isEmpty()) : "Parameter 'issueIds' of method 'exportMetaData' must not be empty";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportMetaData' must not be null";
        Map<IMetricId, List<IMetricLevel>> metricIdToLevelMap = this.a(metricIds);
        ExportMetaDataXmlWriter xmlWriter = new ExportMetaDataXmlWriter(this.i.getVersion(), this.j.getUniqueExistingChild(Files.class).getSystemDirectory().getFile().getNormalizedAbsolutePath(), this.j.getId(), metricIdToLevelMap, Arrays.asList(IssueCategory.values()), issueProviderIds, issueIds);
        OperationResultWithOutcome result = new OperationResultWithOutcome("Exporting Metric Meta-Data");
        xmlWriter.writeToFile(targetFile, (OperationResult)result);
        if (result.isSuccess()) {
            result.setOutcome((Object)targetFile);
        }
        return result;
    }

    private Map<IMetricId, List<IMetricLevel>> a(List<IMetricId> relevantMetricIds) {
        assert (relevantMetricIds != null) : "Parameter 'relevantMetricIds' of method 'getMetricIdToLevelMap' must not be null";
        TreeMap<IMetricId, ArrayList<IMetricLevel>> metricIdToLevelMap = new TreeMap<IMetricId, ArrayList<IMetricLevel>>(Comparator.comparing(IStandardEnumeration::getStandardName));
        IMetricsProvider metricsProvider = this.j.getExtension(ISoftwareSystemProvider.class).getInstallation().getExtension(IMetricsProvider.class);
        for (IMetricLevel nextLevel : metricsProvider.getAvailableElementMetricLevels(true, true)) {
            for (IMetricDescriptor nextDescriptor : metricsProvider.getAvailableMetricDescriptorsForLevel(nextLevel, true)) {
                if (!relevantMetricIds.contains(nextDescriptor.getMetricId())) continue;
                ArrayList<IMetricLevel> levels = (ArrayList<IMetricLevel>)metricIdToLevelMap.get(nextDescriptor.getMetricId());
                if (levels == null) {
                    levels = new ArrayList<IMetricLevel>();
                    metricIdToLevelMap.put(nextDescriptor.getMetricId(), levels);
                }
                levels.add(nextLevel);
            }
        }
        return Collections.unmodifiableMap(metricIdToLevelMap);
    }

    @Override
    public Map<IMetricCategory, List<IMetricId>> b(IWorkerContext context) {
        assert (context != null) : "Parameter 'context' of method 'getAvailableMetricIds' must not be null";
        g analyzerController = this.j.getExtension(g.class);
        analyzerController.a(context);
        HashMap<IMetricCategory, TreeSet<IMetricId>> metricIdsMap = new HashMap<IMetricCategory, TreeSet<IMetricId>>();
        for (IMetricId next : this.j.getExtension(ISoftwareSystemProvider.class).getInstallation().getExtension(IMetricsProvider.class).getAvailableMetricIds()) {
            TreeSet<IMetricId> metricsOfCategory;
            IMetricCategory mainCategory = next.getCategories().get(0);
            if (!metricIdsMap.containsKey(mainCategory)) {
                metricsOfCategory = new TreeSet<IMetricId>(new IMetricId.IdComparator());
                metricIdsMap.put(mainCategory, metricsOfCategory);
            } else {
                metricsOfCategory = (TreeSet<IMetricId>)metricIdsMap.get(mainCategory);
            }
            metricsOfCategory.add(next);
        }
        TreeMap<IMetricCategory, List<IMetricId>> result = new TreeMap<IMetricCategory, List<IMetricId>>(new IMetricCategory.CategoryComparator());
        for (Map.Entry next : metricIdsMap.entrySet()) {
            result.put((IMetricCategory)next.getKey(), new ArrayList((Collection)next.getValue()));
        }
        return result;
    }

    @Override
    public List<IProviderId> c(IWorkerContext context) {
        assert (context != null) : "Parameter 'context' of method 'getIssueProviderIds' must not be null";
        g analyzerController = this.j.getExtension(g.class);
        analyzerController.a(context);
        return this.i.getAvailableIssueProviderIds().stream().sorted((p1, p2) -> p1.getStandardName().compareTo(p2.getStandardName())).collect(Collectors.toList());
    }

    @Override
    public List<IIssueId> d(IWorkerContext context) {
        assert (context != null) : "Parameter 'context' of method 'getIssueIds' must not be null";
        g analyzerController = this.j.getExtension(g.class);
        analyzerController.a(context);
        List filtered = this.i.getAvailableIssueIds().stream().filter(id -> !id.previewOnly()).sorted((id1, id2) -> id1.getStandardName().compareTo(id2.getStandardName())).collect(Collectors.toCollection(() -> new ArrayList()));
        if (!filtered.contains(ArchitectureViolationIssueId.INSTANCE)) {
            filtered.add(ArchitectureViolationIssueId.INSTANCE);
        }
        if (!filtered.contains(QualityGateIssueId.INSTANCE)) {
            filtered.add(QualityGateIssueId.INSTANCE);
        }
        return filtered;
    }

    public TFile a(boolean onlyIfExists) {
        TFile file = new TFile((File)this.j.getUniqueExistingChild(Files.class).getHiddenDataDirectory(), "system-previous.xml");
        if (onlyIfExists) {
            return file.exists() ? file : null;
        }
        return file;
    }

    public TFile b(boolean onlyIfExists) {
        TFile file = new TFile((File)this.j.getUniqueExistingChild(Files.class).getHiddenDataDirectory(), "system-current.xml");
        if (onlyIfExists) {
            return file.exists() ? file : null;
        }
        return file;
    }

    public static enum MessageCause implements OperationResult.IMessageCause
    {
        WRONG_SYSTEM_STATE,
        FAILED_TO_LOAD_XML_REPORT,
        FAILED_TO_LOAD_BASELINE_SYSTEM_XML_REPORT,
        FAILED_TO_LOAD_CURRENT_SYSTEM_XML_REPORT,
        NO_PREVIOUS_SYSTEM_REPORT_FOUND,
        UNSUPPORTED_VERSION;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

