/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.O;
import com.hello2morrow.sonargraph.core.controller.system.P;
import com.hello2morrow.sonargraph.core.controller.system.PluginExtension;
import com.hello2morrow.sonargraph.core.controller.system.VirtualModelExtension;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.h;
import com.hello2morrow.sonargraph.core.controller.system.base.j;
import com.hello2morrow.sonargraph.core.controller.system.base.l;
import com.hello2morrow.sonargraph.core.controller.system.bi;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.controller.system.plugin.b;
import com.hello2morrow.sonargraph.core.controller.system.v;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefreshProcessor {
    private static final Logger b = LoggerFactory.getLogger(RefreshProcessor.class);
    private final P c;
    private final Installation d;
    private final SoftwareSystem e;
    private final aa f;
    private final ISoftwareSystemProvider.BackgroundTaskExecutionMode g;
    private static volatile /* synthetic */ int[] h;

    RefreshProcessor(aa languageProviderAccessor, P finishModelProcessor, Installation installation, SoftwareSystem softwareSystem, ISoftwareSystemProvider.BackgroundTaskExecutionMode backgroundTaskExecutionMode) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'RefreshProcessor' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'RefreshProcessor' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'RefreshProcessor' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'RefreshProcessor' must not be null";
        assert (backgroundTaskExecutionMode != null) : "Parameter 'backgroundTaskExecutionMode' of method 'RefreshProcessor' must not be null";
        this.f = languageProviderAccessor;
        this.c = finishModelProcessor;
        this.d = installation;
        this.e = softwareSystem;
        this.g = backgroundTaskExecutionMode;
    }

    private void b(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'checkSystemFileModification' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'checkSystemFileModification' must not be null";
        SoftwareSystemFile softwareSystemFile = this.e.getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        TFile file = softwareSystemFile.getFile();
        if (file.exists()) {
            if (softwareSystemFile.getTimestamp() != file.lastModified()) {
                if (softwareSystemFile.needsSave()) {
                    prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.MODIFIED_CONFLICT);
                } else {
                    prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.MODIFIED);
                }
            }
        } else if (softwareSystemFile.needsSave()) {
            prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.DELETED_CONFLICT);
        } else {
            prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.DELETED);
        }
    }

    private void c(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'prepareRefresh' must not be null";
        if (this.e.getUniqueExistingChild(Workspace.class).hasChildren(false, Module.class)) {
            boolean forceSilentFullReparse = false;
            for (Z nextLanguageProvider : this.f.a(prepareRefreshResult.getLanguages())) {
                if (!nextLanguageProvider.a(workerContext, this.e, prepareRefreshResult)) continue;
                forceSilentFullReparse = true;
            }
            EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
            this.e.getExtension(bi.class).a(prepareRefreshResult, modifications);
            prepareRefreshResult.setIsSuccess(prepareRefreshResult.isParserRefreshPossible());
            boolean isSilent = false;
            if (!this.e.needsReparse() && forceSilentFullReparse) {
                this.e.setNeedsReparse(true);
                isSilent = true;
            }
            if (prepareRefreshResult.isSuccess() && this.e.needsReparse() && this.e.isClearable() && this.e.getState() == SoftwareSystemState.MODEL_LOADED && !isSilent) {
                prepareRefreshResult.addInfo("A full reparse of the system is needed.");
            }
            this.c.a(this.e, modifications);
        } else {
            prepareRefreshResult.addWarning(SoftwareSystemMessageCause.NO_MODULES_DEFINED, "Refresh not possible.", new Object[0]);
            prepareRefreshResult.setIsSuccess(false);
        }
    }

    PrepareRefreshResult a(IWorkerContext workerContext, Set<ISoftwareSystemProvider.IRefreshOption> options, Set<Language> limitTo) {
        Set<Language> languagesToUse;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (options != null) : "Parameter 'options' of method 'prepareRefresh' must not be null";
        assert (limitTo != null) : "Parameter 'limitTo' of method 'prepareRefresh' must not be null";
        if (limitTo.isEmpty()) {
            languagesToUse = this.e.getUsedLanguages();
        } else {
            for (Language nextLanguage : limitTo) {
                assert (this.e.getUsedLanguages().contains(nextLanguage)) : "Language not used: " + nextLanguage;
            }
            languagesToUse = limitTo;
        }
        PrepareRefreshResult prepareRefreshResult = new PrepareRefreshResult(languagesToUse, options);
        if (this.e.getMode() == SoftwareSystemMode.SYSTEM) {
            this.b(workerContext, prepareRefreshResult);
        }
        if (prepareRefreshResult.getSoftwareSystemFileModification() == PrepareRefreshResult.SoftwareSystemFileModification.NONE) {
            this.a(workerContext, false, prepareRefreshResult);
        }
        if (options.contains(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL)) {
            this.c(workerContext, prepareRefreshResult);
        }
        return prepareRefreshResult;
    }

    private void a(IWorkerContext workerContext, boolean onSystemRefresh, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'clear' must not be null";
        assert (result != null) : "Parameter 'result' of method 'clear' must not be null";
        assert (this.e.getMode() == SoftwareSystemMode.SYSTEM) : "'clearSoftwareSystem' is not possible in mode: " + (Object)((Object)this.e.getMode());
        this.c.a(workerContext, this.e, onSystemRefresh, result, () -> {
            this.f.a(this.e.getUsedLanguages()).forEach(lp -> lp.c(this.e, onSystemRefresh));
            assert (!this.e.getExtension(bi.class).g()) : "Still clearable";
            this.e.setIsClearable(false);
            this.e.setNeedsReparse(true);
            this.e.setState(SoftwareSystemState.OPENED);
        });
        TrueZipFacade.clear();
        System.gc();
    }

    OperationResult a(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'clear' must not be null";
        assert (this.e.getState() == SoftwareSystemState.MODEL_LOADED) : "No model loaded for: " + this.e;
        OperationResult result = new OperationResult("Clear software system");
        this.e.getExtension(l.class).c();
        this.e.getExtension(h.class).a(ResetMode.ALL);
        this.a(workerContext, false, result);
        return result;
    }

    private ParserModelRefreshResult a(IWorkerContext workerContext, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener filePathListener, boolean notifyFinishSystemFilesRefresh, OperationResult result) {
        assert (this.e.getMode() == SoftwareSystemMode.SYSTEM) : "'performParserModelRefresh' is not possible in mode: " + (Object)((Object)this.e.getMode());
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performParserModelRefresh' must not be null";
        assert (moduleDeltas != null && !moduleDeltas.isEmpty()) : "Parameter 'moduleDeltas' of method 'performParserModelRefresh' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'performParserModelRefresh' must not be null";
        workerContext.beginSubTask("Refresh");
        VirtualModel resetTo = this.c.a(workerContext, this.e);
        b.debug("Perform refresh");
        long start = System.currentTimeMillis();
        boolean systemWillBeCleared = false;
        THashSet involvedLanguageProviders = new THashSet();
        for (ModuleDelta delta : moduleDeltas) {
            try {
                Z lp = (Z)delta.getLanguageProvider();
                if (!involvedLanguageProviders.add(lp)) continue;
                workerContext.working("Prepare refresh", false);
                lp.a(workerContext, this.e, result, refreshOptions, moduleDeltas, filePathListener);
            }
            catch (Throwable t2) {
                systemWillBeCleared = true;
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, t2);
                break;
            }
        }
        if (!systemWillBeCleared) {
            boolean delayedParsing;
            boolean bl2 = delayedParsing = involvedLanguageProviders.size() == 1 && ((Z)involvedLanguageProviders.iterator().next()).t();
            if (delayedParsing) {
                workerContext.setNumberOfSteps(3, new int[]{4, 96, 2});
                workerContext.beginSubTask("Initialize parsing");
            } else {
                workerContext.setNumberOfSteps(3, new int[]{96, 2, 2});
                workerContext.beginSubTask("Parsing");
            }
            int[] moduleWeights = new int[moduleDeltas.size()];
            int i2 = 0;
            while (i2 < moduleWeights.length) {
                moduleWeights[i2] = moduleDeltas.get(i2).getNumberOfAddedAndModifiedFiles() + 1;
                ++i2;
            }
            workerContext.setNumberOfSteps(moduleWeights.length, moduleWeights);
            for (ModuleDelta delta : moduleDeltas) {
                try {
                    Z lp = (Z)delta.getLanguageProvider();
                    workerContext.beginSubTask(String.format(delayedParsing ? "Initializing module '%s'" : "Parsing module '%s'", delta.getModule().getShortName()));
                    delta.sortAddedFiles();
                    lp.a(workerContext, delta, filePathListener, result);
                    workerContext.endSubTask();
                    if (!workerContext.hasBeenCanceled() && !result.isFailure()) continue;
                    systemWillBeCleared = true;
                }
                catch (Throwable t3) {
                    systemWillBeCleared = true;
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, t3);
                }
                break;
            }
        }
        workerContext.endSubTask();
        workerContext.beginSubTask("Finish refresh");
        for (Z nextInvolvedLanguageProvider : involvedLanguageProviders) {
            try {
                if (nextInvolvedLanguageProvider.a(workerContext, this.e, result, systemWillBeCleared)) continue;
                systemWillBeCleared = true;
                break;
            }
            catch (Throwable t4) {
                systemWillBeCleared = true;
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, t4);
            }
        }
        workerContext.endSubTask();
        b.info("Perform refresh - done in {} ms", (Object)(System.currentTimeMillis() - start));
        ParserModelRefreshResult res = this.a(workerContext, filePathListener, notifyFinishSystemFilesRefresh, result, systemWillBeCleared, resetTo);
        workerContext.endSubTask();
        workerContext.endSubTask();
        return res;
    }

    private ParserModelRefreshResult a(IWorkerContext workerContext, IFilePathListener filePathListener, boolean notifyFinishSystemFilesRefresh, OperationResult result, boolean systemWillBeCleared, VirtualModel resetTo) {
        ParserModelRefreshResult refreshResult;
        workerContext.beginSubTask("Finish model modification");
        this.e.setLastAppliedSnapshot(null);
        if (systemWillBeCleared) {
            this.a(workerContext, true, result);
            if (filePathListener != null) {
                filePathListener.filesCleared(this.e.getUsedLanguages());
            }
            refreshResult = ParserModelRefreshResult.CLEARED;
        } else {
            this.c.a(workerContext, this.e, resetTo, result);
            this.e.getExtension(bi.class).c_(null);
            this.e.setIsClearable(this.e.getExtension(bi.class).g());
            this.e.setNeedsReparse(false);
            this.e.setState(SoftwareSystemState.MODEL_LOADED);
            if (notifyFinishSystemFilesRefresh) {
                this.f.a(this.e.getUsedLanguages()).forEach(lp -> lp.a(workerContext, this.e, (EnumSet<Modification>)null));
            }
            this.c.a(workerContext, this.e, filePathListener, result, false);
            refreshResult = ParserModelRefreshResult.REFRESHED;
            TrueZipFacade.clear();
            System.gc();
        }
        return refreshResult;
    }

    private boolean a(EnumSet<Modification> modifications, PrepareRefreshResult prepareRefreshResult, OperationResult result) {
        ModifiableModel currentModel;
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'processVirtualModelModification' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processVirtualModelModification' must not be null";
        boolean virtualModelChanged = false;
        if (prepareRefreshResult.switchModel()) {
            this.e.getExtension(VirtualModelExtension.class).switchToModel(prepareRefreshResult.switchToModel(), result);
            if (modifications != null) {
                modifications.add(Modification.VIRTUAL_MODEL_CHANGED);
            }
            virtualModelChanged = true;
        } else if (prepareRefreshResult.getActiveVirtualModelModification() != PrepareRefreshResult.AdditionalFileModification.NONE && (currentModel = this.e.getCurrentModel(ModifiableModel.class)) != null) {
            currentModel.setNeedsApplication();
            if (modifications != null) {
                modifications.add(Modification.VIRTUAL_MODEL_CHANGED);
            }
            virtualModelChanged = true;
        }
        return virtualModelChanged;
    }

    private boolean a(IWorkerContext workerContext, EnumSet<Modification> modifications, PrepareRefreshResult prepareRefreshResult, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        assert (prepareRefreshResult.isParserRefreshPossible()) : "'prepareRefreshResult' of method 'refresh': refresh not possible";
        assert (result != null) : "Parameter 'result' of method 'refresh' must not be null";
        Workspace workspace = this.e.getUniqueExistingChild(Workspace.class);
        List<Module> modules = workspace.getChildren(Module.class);
        assert (modules != null && !modules.isEmpty()) : "'modules' of method 'refresh' must not be empty";
        THashSet involvedLps = new THashSet();
        for (Module nextModule : modules) {
            Language language = nextModule.getType().getLanguage();
            if (!prepareRefreshResult.isParserRefreshPossible(language)) continue;
            Z lp2 = this.f.b(language);
            involvedLps.add(lp2);
        }
        boolean refreshControlledByLanguageProvider = false;
        Z refreshController = null;
        if (involvedLps.stream().anyMatch(lp -> lp.u())) {
            refreshController = involvedLps.stream().filter(lp -> lp.u()).findFirst().get();
            if (involvedLps.size() > 1) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, "Language " + refreshController.getLanguage().getPresentationName() + " does not support multi-language systems.", new Object[0]);
            } else {
                refreshControlledByLanguageProvider = true;
            }
        }
        boolean cancelledSnapshot = this.e.getExtension(l.class).c();
        if (this.e.needsReparse() && this.e.isClearable()) {
            this.e.getExtension(h.class).a(ResetMode.ALL);
            this.a(workerContext, true, result);
        } else {
            this.e.getExtension(h.class).a(ResetMode.CURRENTLY_RUNNING);
        }
        if (this.g == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            workerContext.setNumberOfSteps(3, new int[]{3, 72, 20});
        } else {
            workerContext.setNumberOfSteps(2, new int[]{3, 97});
        }
        if (refreshControlledByLanguageProvider) {
            workerContext.beginSubTask("Initializing refresh");
            this.e.getExtension(h.class).a(ResetMode.ALL);
            refreshController.a(workerContext, this.e, result, null, null, null);
            this.a(modifications, prepareRefreshResult, result);
            refreshController.a(workerContext, this.e, result);
            workerContext.endSubTask();
            if (result.isFailure()) {
                return false;
            }
            long start = System.currentTimeMillis();
            VirtualModel resetTo = this.c.a(workerContext, this.e);
            boolean refreshed = refreshController.b(workerContext, this.e, result);
            b.info("Perform refresh - done in {} ms", (Object)(System.currentTimeMillis() - start));
            if (refreshed) {
                this.a(workerContext, null, true, result, false, resetTo);
                if (prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                    this.e.getExtension(l.class).b();
                }
            }
            this.e.getExtension(h.class).b(workerContext);
            return refreshed;
        }
        return this.a(workerContext, workspace, modules, cancelledSnapshot, modifications, prepareRefreshResult, snapshotApplied, result);
    }

    private boolean a(IWorkerContext workerContext, Workspace workspace, List<Module> modules, boolean cancelledSnapshot, EnumSet<Modification> modifications, PrepareRefreshResult prepareRefreshResult, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performDeltaRefresh' must not be null";
        assert (workspace != null) : "Parameter 'workspace' of method 'performDeltaRefresh' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'performDeltaRefresh' must not be empty";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'performDeltaRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'performDeltaRefresh' must not be null";
        workerContext.beginSubTask("Detect delta");
        LinkedHashMap<Module, O> moduleToDeltaDetector = new LinkedHashMap<Module, O>();
        WorkspaceFilter filter = workspace.getWorkspaceFilter();
        filter.initialize();
        for (Module nextModule : modules) {
            O detector;
            Language language = nextModule.getType().getLanguage();
            if (!prepareRefreshResult.isParserRefreshPossible(language) || (detector = this.f.b(language).a(workerContext, filter, nextModule, prepareRefreshResult)) == null) continue;
            moduleToDeltaDetector.put(nextModule, detector);
        }
        if (prepareRefreshResult.isFailure()) {
            this.f.a(this.e.getUsedLanguages()).forEach(lp -> lp.a(workerContext, this.e, modifications));
            this.c.a(workerContext, this.e, modifications, result);
            if (cancelledSnapshot && prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                this.e.getExtension(l.class).b();
            }
            this.e.getExtension(h.class).a(workerContext, snapshotApplied);
            return false;
        }
        Map<String, List<String>> workspaceDependenciesBeforeRefresh = this.e.getExtension(bi.class).h();
        List<ModuleDelta> moduleDeltas = v.a(workerContext, moduleToDeltaDetector, result);
        if (result.isFailure() || moduleDeltas.isEmpty()) {
            if (!result.isFailure()) {
                this.e.setState(SoftwareSystemState.MODEL_LOADED);
                this.e.setNeedsReparse(false);
                boolean virtualModelChanged = this.a(modifications, prepareRefreshResult, result);
                Set<IAnalyzerId> analyzerIdsWithModifiedConfiguration = prepareRefreshResult.getAnalyzersNeedingExecution();
                if (virtualModelChanged) {
                    this.e.getExtension(h.class).a(ResetMode.ALL);
                } else if (!analyzerIdsWithModifiedConfiguration.isEmpty()) {
                    this.e.getExtension(h.class).a_(analyzerIdsWithModifiedConfiguration);
                }
            } else {
                this.e.setNeedsReparse(true);
            }
            this.f.a(this.e.getUsedLanguages()).forEach(lp -> lp.a(workerContext, this.e, modifications));
            this.c.a(workerContext, this.e, modifications, result);
            if (cancelledSnapshot && prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                this.e.getExtension(l.class).b();
            }
            this.e.getExtension(h.class).a(workerContext, snapshotApplied);
            return false;
        }
        Map<String, List<String>> workspaceDependenciesAfterRefresh = this.e.getExtension(bi.class).h();
        if (!workspaceDependenciesBeforeRefresh.keySet().equals(workspaceDependenciesAfterRefresh.keySet())) {
            this.e.setNeedsSave(true);
        } else {
            for (Map.Entry<String, List<String>> beforeEntry : workspaceDependenciesBeforeRefresh.entrySet()) {
                if (beforeEntry.getValue().equals(workspaceDependenciesAfterRefresh.get(beforeEntry.getKey()))) continue;
                this.e.setNeedsSave(true);
                break;
            }
        }
        this.a(modifications, prepareRefreshResult, result);
        this.e.getExtension(h.class).a(ResetMode.ALL);
        workerContext.endSubTask();
        ParserModelRefreshResult refreshResult = this.a(workerContext, prepareRefreshResult.getRefreshOptions(), moduleDeltas, null, true, result);
        switch (RefreshProcessor.a()[refreshResult.ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                if (prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                    this.e.getExtension(l.class).b();
                }
                this.e.getExtension(h.class).b(workerContext);
                return true;
            }
        }
        assert (false) : "Unhandled refresh result: " + (Object)((Object)refreshResult);
        return false;
    }

    void a(IWorkerContext workerContext, boolean onSystemOpen, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareAdditionalSystemFilesRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'prepareAdditionalSystemFilesRefresh' must not be null";
        workerContext.working("Synchronize system files", true);
        ModifiableFileDeltaDetector deltaDetector = new ModifiableFileDeltaDetector(workerContext, prepareRefreshResult, Z.e(), prepareRefreshResult.getSystemFilesDelta());
        for (j next : this.e.getExtensions(j.class)) {
            next.prepareRefresh(deltaDetector, onSystemOpen, prepareRefreshResult);
        }
        for (SonargraphPlugin nextPlugin : this.d.getExtension(PluginExtension.class).getPlugins()) {
            IPluginAnalyzerContributor nextAnalyzerContributor;
            if (!nextPlugin.isEnabled() || (nextAnalyzerContributor = nextPlugin.getAnalyzerContributor()) == null || !nextAnalyzerContributor.analyzerNeedsToRun((IPluginCoreAccess)new b(this.d, this.e, false))) continue;
            prepareRefreshResult.addAnalyzerNeedingExecution(new com.hello2morrow.sonargraph.core.controller.system.plugin.a(nextPlugin));
            this.e.getExtension(c.class).g().forEach(a2 -> prepareRefreshResult.addAnalyzerNeedingExecution((IAnalyzerId)a2));
        }
    }

    void a(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processAdditionalSystemFilesPrepareRefreshResult' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processAdditionalSystemFilesPrepareRefreshResult' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'processAdditionalSystemFilesPrepareRefreshResult' must not be null";
        ModifiableFileDelta delta = prepareRefreshResult.getSystemFilesDelta();
        if (!delta.isEmpty()) {
            this.e.getExtensions(j.class).forEach(p2 -> p2.refreshFiles(workerContext, delta, modifications, result));
        }
    }

    private void a(IWorkerContext workerContext, OperationResult result, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processSoftwareSystemFileModification' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processSoftwareSystemFileModification' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'processSoftwareSystemFileModification' must not be null";
        if (!prepareRefreshResult.ignoreSoftwareSystemFileModification() && prepareRefreshResult.getSoftwareSystemFileModification() != PrepareRefreshResult.SoftwareSystemFileModification.NONE) {
            this.e.getUniqueExistingChild(Files.class).getSoftwareSystemFile().setNeedsSave(true);
        }
    }

    private void b(IWorkerContext workerContext, OperationResult result, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
        assert (result != null) : "Parameter 'result' of method 'process' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'process' must not be null";
        if (prepareRefreshResult.isElementDeletionNecessary()) {
            result.addMessagesFrom(this.e.getExtension(bi.class).a(workerContext, prepareRefreshResult.getAboutToBeDeletedElements(), true));
        }
    }

    OperationResult a(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (this.e.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT) : "'refresh' not possible in mode: " + (Object)((Object)this.e.getMode());
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        OperationResult result = new OperationResult("Refresh");
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        prepareRefreshResult.getQuestions().forEach(q2 -> q2.executePendingAction());
        this.a(workerContext, result, prepareRefreshResult);
        this.a(workerContext, modifications, result, prepareRefreshResult);
        this.b(workerContext, result, prepareRefreshResult);
        if (result.isSuccess()) {
            if (modifications.remove((Object)Modification.SYSTEM_NEEDS_REPARSE)) {
                this.e.setNeedsReparse(true);
            }
            if (prepareRefreshResult.isParserRefreshPossible()) {
                assert (prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL)) : "The parser model is not to be refreshed";
                this.a(workerContext, modifications, prepareRefreshResult, false, result);
            } else if (prepareRefreshResult.getSoftwareSystemFileModification() != PrepareRefreshResult.SoftwareSystemFileModification.NONE && !prepareRefreshResult.ignoreSoftwareSystemFileModification() || !prepareRefreshResult.getSystemFilesDelta().isEmpty()) {
                this.a(modifications, prepareRefreshResult, result);
                this.e.getExtension(h.class).a(ResetMode.ALL);
                this.f.a(this.e.getUsedLanguages()).forEach(lp -> lp.a(workerContext, this.e, modifications));
                this.c.a(workerContext, this.e, modifications, result);
                this.e.getExtension(h.class).b(workerContext);
                if (this.e.needsReparse()) {
                    result.addInfo((OperationResult.IMessageCause)SoftwareSystemMessageCause.SYSTEM_NEEDS_REPARSE);
                }
            }
        }
        return result;
    }

    OperationResult a(IWorkerContext workerContext, List<ModuleDelta> moduleDeltas, Set<ISoftwareSystemProvider.IRefreshOption> options, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshWithDelta' must not be null";
        assert (moduleDeltas != null && !moduleDeltas.isEmpty()) : "Parameter 'moduleDeltas' of method 'refreshWithDelta' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'refreshWithDelta' must not be null";
        OperationResult result = new OperationResult("Refresh with delta");
        this.e.getExtension(l.class).c();
        this.e.getExtension(h.class).a(ResetMode.ALL);
        if (this.e.needsReparse() && this.e.isClearable()) {
            this.a(workerContext, true, result);
        }
        ParserModelRefreshResult refreshResult = this.a(workerContext, options, moduleDeltas, listener, false, result);
        switch (RefreshProcessor.a()[refreshResult.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (options.contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                    this.e.getExtension(l.class).b();
                }
                this.e.getExtension(h.class).b(workerContext);
                break;
            }
            default: {
                assert (false) : "Unhandled refresh result: " + (Object)((Object)refreshResult);
                break;
            }
        }
        return result;
    }

    a a(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refresh' must not be null";
        workerContext.working("Perform refresh", true);
        this.c(workerContext, prepareRefreshResult);
        this.b(workerContext, result, prepareRefreshResult);
        if (prepareRefreshResult.isParserRefreshPossible()) {
            boolean refreshed = this.a(workerContext, EnumSet.noneOf(Modification.class), prepareRefreshResult, snapshotApplied, result);
            return new a(false, refreshed);
        }
        return new a(true, false);
    }

    static /* synthetic */ int[] a() {
        if (h != null) {
            return h;
        }
        int[] nArray = new int[ParserModelRefreshResult.values().length];
        try {
            nArray[ParserModelRefreshResult.CLEARED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ParserModelRefreshResult.REFRESHED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        h = nArray;
        return nArray;
    }

    private static enum ParserModelRefreshResult {
        CLEARED,
        REFRESHED;

    }

    static final class a {
        private final boolean a;
        private final boolean b;

        a(boolean runAnalyzers, boolean refreshed) {
            this.a = runAnalyzers;
            this.b = refreshed;
        }

        boolean a() {
            return this.a;
        }

        boolean b() {
            return this.b;
        }
    }
}

